/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing.structhandlers;

import chemaxon.jchem.cartridge.rmi.impl.RmiTunnelImpl;
import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.CalculateInsertHandler;
import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.IndexDataQueueProcessor;
import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.StructHandler;
import chemaxon.jchem.cartridge.tunnel.index.IndexingInfo;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.util.ConnectionHandler;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CalculateOnlyHandler
implements StructHandler {
    private static Logger logger = Logger.getLogger(CalculateInsertHandler.class.getName());
    private IndexingInfo ii;
    private UpdateHandler uh;
    private BlockingQueue<IndexDataQueueProcessor.IndexData> rowDataQueue;

    public CalculateOnlyHandler(IndexingInfo ii, BlockingQueue<IndexDataQueueProcessor.IndexData> rowDataQueue) throws Exception {
        this.ii = ii;
        this.rowDataQueue = rowDataQueue;
        this.setupUpdateHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupUpdateHandler() throws Exception {
        ConnectionHandler ch = RmiTunnelImpl.getConnectionHandler(this.ii);
        try {
            int uhMode = 2;
            this.uh = new UpdateHandler(ch, uhMode, this.ii.getIndexTableQName(), "", this.ii.getBaseSchemaName() + "." + this.ii.getBaseTableName(), this.ii.getIndexedColumn());
            this.uh.setEmptyStructuresAllowed(true);
            this.uh.setIgnoreChemicalTermsExceptions(this.ii.isSkipAutoCalcCt());
        }
        finally {
            ch.close();
        }
    }

    @Override
    public boolean index(String rowid, byte[] structure) throws Exception {
        try {
            UpdateHandler.RowData rd = this.uh.createRowData(structure);
            this.rowDataQueue.put(new IndexDataQueueProcessor.IndexData(rowid, rd));
            return true;
        }
        catch (Exception exception) {
            this.handleException(exception, structure, rowid);
            return false;
        }
    }

    protected void handleException(Exception exception, byte[] structure, String rowid) throws Exception {
        String message = exception.getMessage() + ": ROWID=" + rowid + ", " + new String(structure);
        if (this.ii.getErrorHandlingMode().equals("true")) {
            throw new Exception(exception);
        }
        if (logger.isLoggable(Level.SEVERE)) {
            logger.severe(message);
        }
    }

    @Override
    public void close(boolean commit) throws SQLException {
        this.uh.close();
    }
}

