/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing.structhandlers;

import chemaxon.jchem.cartridge.JCartDml;
import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.CalculateInsertHandler;
import chemaxon.jchem.cartridge.tunnel.index.IndexingInfo;
import chemaxon.jchem.db.UpdateHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;

public class IndexDataInserter
extends CalculateInsertHandler {
    public IndexDataInserter(IndexingInfo ii, AtomicInteger cdIdCounter) throws Exception {
        super(ii, cdIdCounter);
    }

    public boolean insert(String rowid, UpdateHandler.RowData rowData) throws Exception {
        if (this.uh == null) {
            this.setUpUpdateHandler();
            this.uh.setDuplicateFiltering(this.ii.isDuplicateFiltering());
        }
        try {
            if (this.cdIdCounter != null) {
                this.commitMayBe();
                this.uh.setID(this.cdIdCounter.incrementAndGet());
            }
            this.uh.setROWID(rowid);
            this.uh.setRowData(rowData);
            int cdId = this.uh.execute(false);
            if (cdId < 0) {
                String firstRowid = this.getRowidForCdId(-1 * cdId);
                throw JCartDml.createDupStructExceptionRowid(firstRowid);
            }
            return true;
        }
        catch (Exception exception) {
            IndexDataInserter.handleException(rowid, rowData.molString, exception, this.ii.getErrorHandlingMode());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRowidForCdId(int cdId) throws SQLException {
        String sql = "select rid from " + this.ii.getIndexTableQName() + " where cd_id = " + cdId;
        ResultSet rs = null;
        Statement stmt = this.ch.getConnection().createStatement();
        try {
            rs = stmt.executeQuery(sql);
            rs.next();
            String string = rs.getString(1);
            return string;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
    }
}

