/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing.structhandlers;

import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.IndexDataInserter;
import chemaxon.jchem.cartridge.tunnel.index.IndexingInfo;
import chemaxon.jchem.cartridge.util.JccConfig;
import chemaxon.jchem.db.UpdateHandler;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IndexDataQueueProcessor
implements Callable<Integer> {
    private static final Logger logger = Logger.getLogger(IndexDataQueueProcessor.class.getName());
    public static final IndexData POISON = new IndexData(null, null);
    private BlockingQueue<IndexData> indexDataQueue;
    private IndexDataInserter indexDataInserter;
    private int deferredErrorCount;

    public IndexDataQueueProcessor(IndexingInfo ii, AtomicInteger cdIdCounter) throws Exception {
        if (ii.isDuplicateFiltering() || ii.getInsertSessionCount() == 1) {
            int indexQueueCapacity = JccConfig.getInstance().getIndexQueueCapacity();
            this.indexDataQueue = new ArrayBlockingQueue<IndexData>(indexQueueCapacity);
            this.indexDataInserter = new IndexDataInserter(ii, cdIdCounter);
        }
    }

    public void closeQueue() {
        if (this.indexDataQueue != null) {
            while (true) {
                try {
                    this.indexDataQueue.put(POISON);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public Integer call() throws Exception {
        boolean commit = false;
        try {
            long insertCount = 0L;
            IndexData rqDataUnit = this.indexDataQueue.take();
            while (rqDataUnit != POISON) {
                if (!this.indexDataInserter.insert(rqDataUnit.rowid, rqDataUnit.rowData)) {
                    ++this.deferredErrorCount;
                } else if (insertCount++ % 10000L == 0L && logger.isLoggable(Level.FINEST)) {
                    logger.finest("insertCount=" + insertCount + ", queue size=" + this.indexDataQueue.size());
                }
                rqDataUnit = this.indexDataQueue.take();
            }
            if (this.deferredErrorCount == 0) {
                commit = true;
            }
            Integer n = new Integer(this.deferredErrorCount);
            return n;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        finally {
            this.indexDataInserter.close(commit);
        }
    }

    public BlockingQueue<IndexData> getIndexDataQueue() {
        return this.indexDataQueue;
    }

    public static class IndexData {
        String rowid;
        UpdateHandler.RowData rowData;

        public IndexData(String rowid, UpdateHandler.RowData rowData) {
            this.rowid = rowid;
            this.rowData = rowData;
        }
    }
}

