/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.indexing.structhandlers;

import chemaxon.jchem.cartridge.servlets.indexing.structhandlers.StructHandler;
import chemaxon.util.DatabaseTools;
import chemaxon.util.concurrent.worker.Worker;
import java.sql.ResultSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IndexingWorker
extends Worker<Integer> {
    private static Logger logger = Logger.getLogger(IndexingWorker.class.getName());
    protected ResultSet rs;
    protected StructHandler iHandler;
    protected Throwable exception;
    private int deferredErrorCount;
    private AtomicLong indexCounter;
    private int processedCount;

    public IndexingWorker(StructHandler iHandler, ResultSet rs, AtomicLong indexCounter) throws Exception {
        this.rs = rs;
        this.iHandler = iHandler;
        this.indexCounter = indexCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer work() throws Exception {
        boolean commit = false;
        try {
            this.work0();
            commit = true;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Returning " + this.deferredErrorCount + "...");
            }
            Integer n = new Integer(this.deferredErrorCount);
            return n;
        }
        catch (Throwable tbl) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "error", tbl);
            }
            if (tbl instanceof Exception) {
                throw (Exception)tbl;
            }
            throw new RuntimeException(tbl);
        }
        finally {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Finishing...");
            }
            try {
                this.iHandler.close(commit);
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (this.exception == null) {
                    this.exception = e;
                }
            }
            finally {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Finished");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work0() throws Exception {
        String rowid = null;
        byte[] structure = null;
        while (!Thread.currentThread().isInterrupted() && !this.isCancelled()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Processed: " + this.processedCount);
            }
            ResultSet resultSet = this.rs;
            synchronized (resultSet) {
                if (!this.rs.next()) {
                    break;
                }
                rowid = this.rs.getString(1);
                structure = DatabaseTools.readBytes(this.rs, 2);
            }
            if (!this.iHandler.index(rowid, structure)) {
                ++this.deferredErrorCount;
            }
            ++this.processedCount;
            long count = this.indexCounter.incrementAndGet();
            if (count % 100L != 0L || !logger.isLoggable(Level.FINE) || this.indexCounter == null) continue;
            logger.fine(count + " structure(s) indexed");
        }
    }
}

