/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.react;

import chemaxon.jchem.cartridge.servlets.JCartConnectionManager;
import chemaxon.jchem.cartridge.servlets.react.prod_consumer.JChemTableProductInserter;
import chemaxon.jchem.cartridge.servlets.react.prod_consumer.PlainTableProductInserter;
import chemaxon.jchem.cartridge.servlets.react.prod_consumer.ProductConsumer;
import chemaxon.jchem.cartridge.servlets.react.prod_consumer.StreamingConsumer;
import chemaxon.jchem.cartridge.servlets.react.tant_producer.ReactantSetProducer;
import chemaxon.jchem.cartridge.servlets.react.tant_producer.SqlReactantProducer;
import chemaxon.jchem.cartridge.tunnel.SessionInfo;
import chemaxon.jchem.cartridge.util.JccConfig;
import chemaxon.jchem.interop.InteropUtil;
import chemaxon.jchem.interop.reactor.CachedReactData;
import chemaxon.jchem.interop.reactor.InteropReactOption;
import chemaxon.jchem.interop.reactor.InteropReactor;
import chemaxon.jchem.interop.reactor.InteropReactorConsts;
import chemaxon.jchem.interop.reactor.ReactDataCache;
import chemaxon.jchem.interop.reactor.Reactant;
import chemaxon.jchem.interop.reactor.SimpleReactantProducer;
import chemaxon.jchem.interop.reactor.SynthCodeInfo;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.Standardizer;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.CxOptions;
import chemaxon.util.DatabaseTools;
import chemaxon.util.concurrent.workunitmgmt.WorkUnitManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JCartReactor
implements InteropReactorConsts,
ReactDataCache.StandardizerFactory {
    private static Logger logger = Logger.getLogger(JCartReactor.class.getName());
    public static String POISON = new String("POISON");
    private String[] reactantIds;
    private SessionInfo userInfo;
    private ReactantSetProducer reactantSetProducer;
    private ReactProcessor[] processors;
    private volatile boolean cancel = false;
    private LinkedBlockingQueue<String> outputQueue;

    public JCartReactor(String reactionString, String[] reactantArray, CxOptions options, boolean separateOutMols, SessionInfo userInfo, LinkedBlockingQueue<String> lbq, boolean oldJcReact) throws Exception {
        ArrayList<String> rtantListFromParams = new ArrayList<String>();
        for (int i = 0; i < reactantArray.length; ++i) {
            String reactant = reactantArray[i];
            if (reactant == null) continue;
            rtantListFromParams.add(reactant);
        }
        CachedReactData rData = ReactDataCache.getInstance().popReactData(reactionString, options, this);
        this.defuseReactantsMaybe(rtantListFromParams, rData, oldJcReact);
        String reactantIdList = InteropReactOption.REACTANT_IDS.getStringValue(options);
        this.reactantIds = InteropUtil.parseStringList(reactantIdList, ",");
        this.userInfo = userInfo;
        this.outputQueue = lbq;
        this.initReactantSetProducer(rData, options, rtantListFromParams);
        this.createProcessors(reactionString, rData, options, separateOutMols, lbq, oldJcReact);
    }

    @Override
    public Standardizer createStandardizer(InteropReactOption standardizerOption, CxOptions options) throws Exception {
        String stdrString = standardizerOption.getStringValue(options);
        if (stdrString == null) {
            return null;
        }
        String sqlCfg = "sql:";
        if (stdrString.toLowerCase().startsWith("sql:")) {
            String sql = stdrString.substring("sql:".length());
            return new Standardizer(this.resolveSqlConfig(this.userInfo, stdrString.substring("sql:".length())));
        }
        return new ReactDataCache.DefaultStandardizerFactory().createStandardizer(standardizerOption, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String resolveSqlConfig(SessionInfo userInfo, String sql) throws Exception {
        String config = null;
        ConnectionHandler ch = JCartConnectionManager.getInstance().createConnectionHandler(userInfo, null, true);
        Connection conn = ch.getConnection();
        try {
            PreparedStatement ps = conn.prepareStatement(sql);
            try {
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) {
                    throw new IllegalArgumentException(sql + " for " + InteropReactOption.STANDARDIZER.getName() + ":config: returned no result");
                }
                config = new String(DatabaseTools.readBytes(rs, 1), "US-ASCII");
            }
            finally {
                ps.close();
            }
        }
        finally {
            conn.close();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Connection closed");
            }
        }
        return config;
    }

    private void defuseReactantsMaybe(ArrayList<String> rtantListFromParams, CachedReactData rData, boolean oldJcReact) {
        if (oldJcReact && rData.getMethod() != 1 && rData.getMethod() != 2) {
            String reactants = rtantListFromParams.get(0);
            rtantListFromParams.clear();
            StringTokenizer st = new StringTokenizer(reactants, ".");
            while (st.hasMoreTokens()) {
                rtantListFromParams.add(st.nextToken());
            }
        }
    }

    private void initReactantSetProducer(CachedReactData rData, CxOptions options, ArrayList<String> rtantParamList) throws Exception {
        int matchingMethod = 0;
        String matchingMethodString = InteropReactOption.REACTANT_MATCHING.getStringValue(options);
        if (matchingMethodString != null && matchingMethodString.equalsIgnoreCase("seq")) {
            matchingMethod = 1;
        }
        this.reactantSetProducer = new ReactantSetProducer(matchingMethod, rData.isIgnoreErrors());
        for (int ix = 0; ix < rtantParamList.size(); ++ix) {
            String reactant = rtantParamList.get(ix);
            this.addReactantProducer(rData, ix, reactant);
        }
    }

    private void addReactantProducer(CachedReactData rData, int indexInReaction, String reactantString) throws Exception {
        if (reactantString.toUpperCase().startsWith("SELECT ")) {
            this.addSqlReactantProducer(rData, indexInReaction, reactantString);
        } else {
            this.reactantSetProducer.addProducer(new SimpleReactantProducer(reactantString));
        }
    }

    private void addSqlReactantProducer(CachedReactData rData, int indexInReaction, String reactantString) throws Exception {
        ConnectionHandler ch = JCartConnectionManager.getInstance().createConnectionHandler(this.userInfo, null, true);
        Connection conn = ch.getConnection();
        try {
            SqlReactantProducer rp = new SqlReactantProducer(conn, reactantString);
            this.reactantSetProducer.addProducer(rp);
        }
        catch (Throwable tbl) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "error", tbl);
            }
            conn.close();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Connection closed");
            }
            throw new RuntimeException(tbl);
        }
    }

    private void createProcessors(String reactionString, CachedReactData rData, CxOptions options, boolean separateOutMols, LinkedBlockingQueue<String> outputDevice, boolean oldJcReact) throws Exception {
        int threadCount = 1;
        if (this.reactantSetProducer.hasSqlProducer()) {
            threadCount = JccConfig.getInstance().getJcReactThreadsPerCall();
        }
        this.processors = new ReactProcessor[threadCount];
        if (threadCount == 1) {
            this.createProcessor(rData, options, separateOutMols, outputDevice, oldJcReact);
        } else {
            for (int ix = 0; ix < this.processors.length; ++ix) {
                this.createProcessor(ix, reactionString, options, separateOutMols, outputDevice, oldJcReact);
            }
        }
    }

    private void createProcessor(CachedReactData rData, CxOptions options, boolean separateOutMols, LinkedBlockingQueue<String> outputDevice, boolean oldJcReact) throws Exception {
        this.processors[0] = new ReactProcessor(rData, options, separateOutMols, outputDevice, oldJcReact);
    }

    private void createProcessor(int idx, String reactionString, CxOptions options, boolean separateOutMols, LinkedBlockingQueue<String> outputDevice, boolean oldJcReact) throws Exception {
        this.processors[idx] = new ReactProcessor(reactionString, options, separateOutMols, outputDevice, oldJcReact);
    }

    public void start() throws Exception {
        WorkUnitManager.getInstance().submit(new ReactProcessorManager());
    }

    public void stop() throws Exception {
        this.cancel = true;
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() throws Exception {
        try {
            for (int i = 0; this.processors != null && i < this.processors.length; ++i) {
                ReactProcessor p = this.processors[i];
                p.cleanup();
            }
        }
        finally {
            if (this.reactantSetProducer != null) {
                this.reactantSetProducer.cleanup();
            }
        }
    }

    private class ReactProcessorManager
    implements Runnable {
        private ExecutorCompletionService<Object> ecs;
        private ArrayList<Future<Object>> processorFutures = new ArrayList();

        private ReactProcessorManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block5: {
                try {
                    try {
                        this.startTasks();
                    }
                    finally {
                        this.reapTasks();
                    }
                }
                catch (Throwable throwable) {
                    if (!logger.isLoggable(Level.SEVERE)) break block5;
                    logger.log(Level.SEVERE, "error", throwable);
                }
            }
        }

        private void startTasks() throws Exception {
            WorkUnitManager es = WorkUnitManager.getInstance();
            this.ecs = new ExecutorCompletionService(es);
            for (int i = 0; i < JCartReactor.this.processors.length; ++i) {
                ReactProcessor proc = JCartReactor.this.processors[i];
                try {
                    this.processorFutures.add(this.ecs.submit(proc));
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.SEVERE)) continue;
                    logger.log(Level.SEVERE, "error", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reapTasks() throws Exception {
            for (int taskCount = this.processorFutures.size(); taskCount > 0 && !JCartReactor.this.cancel; --taskCount) {
                try {
                    Future<Object> f = this.ecs.take();
                    f.get();
                    continue;
                }
                catch (Throwable throwable) {
                    JCartReactor.this.cancel = true;
                    this.putForced(throwable.getMessage());
                }
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest("Reactor processor reaped. Left " + taskCount + " more processor(s)");
            }
            try {
                try {
                    for (Future<Object> f : this.processorFutures) {
                        f.cancel(false);
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("No more reactor processor left.");
                    }
                }
                finally {
                    JCartReactor.this.cleanup();
                }
            }
            finally {
                this.putForced(POISON);
            }
        }

        private void putForced(String obj) {
            boolean interrupted = false;
            while (true) {
                try {
                    JCartReactor.this.outputQueue.put(obj);
                    if (!logger.isLoggable(Level.FINEST)) break;
                    logger.finest("lbq poisoned.");
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class ReactProcessor
    implements Callable<Object> {
        private CachedReactData rData;
        private boolean cleanupRData;
        private ProductConsumer productConsumer;
        private volatile boolean running;

        public ReactProcessor(String reactionString, CxOptions options, boolean separateOutMols, LinkedBlockingQueue<String> outputDevice, boolean oldJcReact) throws Exception {
            this.rData = ReactDataCache.getInstance().popReactData(reactionString, options, JCartReactor.this);
            this.cleanupRData = true;
            this.initProductsConsumer(options, separateOutMols, outputDevice, oldJcReact);
        }

        public ReactProcessor(CachedReactData rData, CxOptions options, boolean separateOutMols, LinkedBlockingQueue<String> outputDevice, boolean oldJcReact) throws Exception {
            this.rData = rData;
            this.initProductsConsumer(options, separateOutMols, outputDevice, oldJcReact);
        }

        private void initProductsConsumer(CxOptions options, boolean separateOutMols, LinkedBlockingQueue<String> outputDevice, boolean oldJcReact) throws Exception {
            String productTableName = InteropReactOption.PRODUCT_TABLE.getStringValue(options);
            String jcpTableName = InteropReactOption.PRODUCT_TABLE_JCPT.getStringValue(options);
            String outFormat = InteropReactOption.OUTFORMAT.getStringValue(options);
            boolean dotSeparatedSmilesProducts = false;
            if (outFormat == null) {
                outFormat = "smiles";
                if (oldJcReact) {
                    dotSeparatedSmilesProducts = true;
                }
            }
            SynthCodeInfo synthCodeInfo = this.rData.getSynthCodeInfo();
            if (productTableName == null) {
                this.productConsumer = new StreamingConsumer(JCartReactor.this.outputQueue, synthCodeInfo, separateOutMols, outFormat, dotSeparatedSmilesProducts);
            } else if (jcpTableName != null) {
                String productIdCol = InteropReactOption.PRODUCT_ID_COLNAME.getStringValue(options);
                this.productConsumer = new JChemTableProductInserter(JCartReactor.this.userInfo, productTableName, outFormat, jcpTableName, productIdCol, synthCodeInfo);
            } else {
                String productCol = InteropReactOption.PRODUCT_COLNAME.getStringValue(options);
                String productIdCol = InteropReactOption.PRODUCT_ID_COLNAME.getStringValue(options);
                this.productConsumer = new PlainTableProductInserter(JCartReactor.this.userInfo, productTableName, outFormat, productCol, productIdCol, synthCodeInfo);
            }
        }

        @Override
        public Object call() throws Exception {
            try {
                this.running = true;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Call starting...");
                }
                this.run0();
                Object var1_1 = null;
                return var1_1;
            }
            catch (Throwable tbl) {
                throw new Exception(tbl);
            }
            finally {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Call ending...");
                }
                this.running = false;
                this.cleanup();
            }
        }

        public void run0() throws Exception {
            InteropReactor interopReactor = new InteropReactor();
            Reactant[] reactants = JCartReactor.this.reactantSetProducer.nextSet();
            while (reactants != null && !JCartReactor.this.cancel && !Thread.currentThread().isInterrupted()) {
                block7: {
                    try {
                        String debugString = null;
                        if (logger.isLoggable(Level.FINEST)) {
                            StringBuffer sbReactants = new StringBuffer();
                            for (int i = 0; i < reactants.length; ++i) {
                                Reactant reactant = reactants[i];
                                if (i > 0) {
                                    sbReactants.append(";");
                                }
                                sbReactants.append(reactant.getMolecule().toFormat("cxsmarts"));
                            }
                            debugString = "reaction=" + this.rData.getReaction() + ", reactants=" + sbReactants.toString();
                            logger.finest("About to process: " + debugString);
                        }
                        Molecule[] products = interopReactor.reactCore(this.rData, reactants, JCartReactor.this.reactantIds);
                        this.productConsumer.consume(products);
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(debugString + " successfully consumed");
                        }
                    }
                    catch (ReactionException reactionException) {
                        if (this.rData.isIgnoreErrors()) break block7;
                        throw reactionException;
                    }
                }
                reactants = JCartReactor.this.reactantSetProducer.nextSet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void cleanup() throws Exception {
            if (this.running) {
                this.wait();
                return;
            }
            Exception error = null;
            try {
                if (this.productConsumer != null) {
                    try {
                        this.productConsumer.cleanup();
                    }
                    catch (Exception e) {
                        if (logger.isLoggable(Level.SEVERE)) {
                            logger.log(Level.SEVERE, "error", e);
                        }
                        error = e;
                    }
                }
                if (this.cleanupRData && this.rData != null) {
                    ReactDataCache.getInstance().pushReactData(this.rData);
                    this.rData = null;
                }
            }
            finally {
                this.notifyAll();
                if (error != null) {
                    throw error;
                }
            }
        }
    }
}

