/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.react.prod_consumer;

import chemaxon.jchem.cartridge.servlets.react.prod_consumer.ProductConsumer;
import chemaxon.jchem.cartridge.tunnel.SessionInfo;
import chemaxon.jchem.interop.reactor.SynthCodeInfo;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;

public abstract class DbInsertConsumer
implements ProductConsumer {
    protected SessionInfo userInfo;
    protected String tableName;
    protected String outFormat;
    protected SynthCodeInfo synthCodeInfo;
    protected String productIdColName;
    protected ConnectionHandler ch;

    public DbInsertConsumer(SessionInfo userInfo, String tableName, String outFormat, String productIdColName, SynthCodeInfo synthCodeInfo) throws Exception {
        this.userInfo = userInfo;
        this.tableName = tableName;
        this.outFormat = outFormat;
        this.productIdColName = productIdColName;
        this.synthCodeInfo = synthCodeInfo;
    }

    @Override
    public void consume(Molecule[] products) throws Exception {
        String[] productIds = this.synthCodeInfo.getProductIds(products);
        for (int i = 0; i < products.length; ++i) {
            this.insertProduct(products[i], productIds[i]);
        }
    }

    public abstract void insertProduct(Molecule var1, String var2) throws Exception;
}

