/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.react.tant_producer;

import chemaxon.jchem.cartridge.servlets.react.tant_producer.SqlReactantProducer;
import chemaxon.jchem.interop.reactor.Reactant;
import chemaxon.jchem.interop.reactor.ReactantProducer;
import java.io.IOException;

public class ReactantSetProducer {
    public static final int MATCHING_COMBINATORIAL = 0;
    public static final int MATCHING_SEQUENTIAL = 1;
    private int matchingMethod = 0;
    private ReactantProducer[] reactantProducers;
    private Reactant[] nextSet;
    private boolean ignoreErrors;
    public boolean initialized;
    protected boolean hasSqlProducer;

    public ReactantSetProducer(int matchingMethod, boolean ignoreErrors) {
        this.matchingMethod = matchingMethod;
        this.ignoreErrors = ignoreErrors;
    }

    public void addProducer(ReactantProducer reactantProducer) {
        if (this.initialized) {
            throw new IllegalStateException("This " + ReactantSetProducer.class.getName() + "is already initialized, accepts no more producers");
        }
        if (this.reactantProducers == null) {
            this.reactantProducers = new ReactantProducer[1];
            this.reactantProducers[0] = reactantProducer;
        } else {
            int len = this.reactantProducers.length;
            ReactantProducer[] tmp = new ReactantProducer[len + 1];
            System.arraycopy(this.reactantProducers, 0, tmp, 0, len);
            tmp[len] = reactantProducer;
            this.reactantProducers = tmp;
        }
        if (reactantProducer instanceof SqlReactantProducer) {
            this.hasSqlProducer = true;
        }
    }

    public boolean hasSqlProducer() {
        return this.hasSqlProducer;
    }

    private void initCurrentSet() throws Exception {
        this.nextSet = new Reactant[this.reactantProducers.length];
        for (int i = 0; i < this.reactantProducers.length; ++i) {
            ReactantProducer rtantProducer = this.reactantProducers[i];
            this.nextSet[i] = this.getNextReactant(rtantProducer);
        }
        this.initialized = true;
    }

    private Reactant getNextReactant(ReactantProducer rtantProducer) throws Exception {
        while (true) {
            try {
                return rtantProducer.nextReactant();
            }
            catch (IOException ioException) {
                if (this.ignoreErrors) continue;
                throw ioException;
            }
            break;
        }
    }

    public synchronized Reactant[] nextSet() throws Exception {
        if (!this.initialized) {
            this.initCurrentSet();
        }
        if (this.nextSet == null) {
            return null;
        }
        Reactant[] currentSet = this.cloneSet(this.nextSet);
        this.calcNextSet();
        return currentSet;
    }

    private Reactant[] cloneSet(Reactant[] set) {
        Reactant[] clone = new Reactant[set.length];
        for (int i = 0; i < set.length; ++i) {
            clone[i] = (Reactant)set[i].clone();
        }
        return clone;
    }

    private void calcNextSet() throws Exception {
        switch (this.matchingMethod) {
            case 0: {
                int currentProducerIdx = this.reactantProducers.length - 1;
                this.roll(currentProducerIdx);
                break;
            }
            case 1: {
                this.roll();
                break;
            }
            default: {
                new IllegalArgumentException("Unkown matching method: " + this.matchingMethod);
            }
        }
    }

    private void roll() throws Exception {
        int exhaustedCount = 0;
        for (int i = 0; i < this.reactantProducers.length; ++i) {
            ReactantProducer reactantProducer = this.reactantProducers[i];
            Reactant rtant = this.getNextReactant(reactantProducer);
            if (rtant == null) {
                ++exhaustedCount;
                continue;
            }
            this.nextSet[i] = rtant;
        }
        if (exhaustedCount == this.reactantProducers.length) {
            this.nextSet = null;
        }
    }

    private void roll(int currentProducerIdx) throws Exception {
        ReactantProducer currentProducer = this.reactantProducers[currentProducerIdx];
        if (this.setNextReactant(currentProducer, currentProducerIdx)) {
            return;
        }
        if (currentProducerIdx == 0) {
            this.nextSet = null;
            return;
        }
        this.roll(currentProducerIdx - 1);
        if (this.nextSet == null) {
            return;
        }
        currentProducer.restart();
        this.setNextReactant(currentProducer, currentProducerIdx);
    }

    private boolean setNextReactant(ReactantProducer currentProducer, int currentProducerIdx) throws Exception {
        Reactant nextRtant = this.getNextReactant(currentProducer);
        if (nextRtant == null) {
            return false;
        }
        this.nextSet[currentProducerIdx] = nextRtant;
        return true;
    }

    public synchronized void cleanup() {
        if (this.reactantProducers != null) {
            for (int i = 0; i < this.reactantProducers.length; ++i) {
                ReactantProducer rp = this.reactantProducers[i];
                rp.cleanup();
            }
            this.reactantProducers = null;
        }
    }
}

