/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.react.tant_producer;

import chemaxon.jchem.interop.reactor.Reactant;
import chemaxon.jchem.interop.reactor.ReactantProducer;
import chemaxon.util.DatabaseTools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqlReactantProducer
implements ReactantProducer {
    private static final Log log = LogFactory.getLog(SqlReactantProducer.class);
    private Connection conn;
    private PreparedStatement ps;
    private ResultSet rs;
    private boolean hasReactantIdCol;

    public SqlReactantProducer(Connection conn, String sql) throws Exception {
        this.conn = conn;
        this.ps = conn.prepareStatement(sql);
        this.restart();
    }

    @Override
    public Reactant nextReactant() throws Exception {
        if (this.rs == null) {
            return null;
        }
        if (!this.rs.next()) {
            this.rs.close();
            this.rs = null;
            return null;
        }
        byte[] struct = DatabaseTools.readBytes(this.rs, 1);
        Reactant reactant = Reactant.createReactant(struct);
        if (this.hasReactantIdCol) {
            reactant.setReactantId(new String(DatabaseTools.readBytes(this.rs, 2), "US-ASCII"));
        }
        return reactant;
    }

    @Override
    public void restart() throws Exception {
        if (this.rs != null) {
            this.rs.close();
            this.rs = null;
        }
        this.rs = this.ps.executeQuery();
        ResultSetMetaData rsMetaData = this.rs.getMetaData();
        this.hasReactantIdCol = rsMetaData.getColumnCount() > 1;
    }

    @Override
    public void cleanup() {
        Throwable error;
        block14: {
            block13: {
                block12: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Starting cleanup on " + this));
                    }
                    error = null;
                    try {
                        if (this.rs != null) {
                            this.rs.close();
                            this.rs = null;
                        }
                    }
                    catch (Throwable tbl) {
                        if (error != null) break block12;
                        error = tbl;
                    }
                }
                try {
                    if (this.ps != null) {
                        this.ps.close();
                        this.ps = null;
                    }
                }
                catch (Throwable tbl) {
                    if (error != null) break block13;
                    error = tbl;
                }
            }
            try {
                if (this.conn != null) {
                    this.conn.close();
                    this.conn = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Connection closed");
                    }
                }
            }
            catch (Throwable tbl) {
                if (error != null) break block14;
                error = tbl;
            }
        }
        if (error != null) {
            throw new RuntimeException(error);
        }
    }
}

