/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.search;

import chemaxon.jchem.cartridge.tunnel.search.PredicateInfo;
import chemaxon.sss.search.MatchCountOptions;

public class IntegerValuedPredicate {
    private PredicateInfo predInfo;

    public IntegerValuedPredicate(PredicateInfo predicateInfo) {
        this.predInfo = predicateInfo;
    }

    public MatchCountOptions getMatchCountOptions() {
        if (this.predInfo == null) {
            return new MatchCountOptions(0, false, 0, false);
        }
        int op = this.predInfo.getOpFlag();
        if (Double.isNaN(this.predInfo.getStart())) {
            int stop = (int)this.predInfo.getStop();
            if (op == 8) {
                return new MatchCountOptions("<=", stop);
            }
            return new MatchCountOptions("<", stop);
        }
        if (Double.isNaN(this.predInfo.getStop())) {
            int strt = (int)this.predInfo.getStart();
            if (op == 4) {
                return new MatchCountOptions(">=", strt);
            }
            return new MatchCountOptions(">", strt);
        }
        int strt = (int)this.predInfo.getStart();
        int stop = (int)this.predInfo.getStop();
        switch (op) {
            case 13: {
                return new MatchCountOptions("=", strt);
            }
            case 12: {
                return new MatchCountOptions(strt, true, stop, true);
            }
            case 8: {
                return new MatchCountOptions(strt, false, stop, true);
            }
            case 4: {
                return new MatchCountOptions(strt, true, stop, false);
            }
        }
        return new MatchCountOptions(strt, false, stop, false);
    }

    public boolean getReturnNonHits() {
        int stop;
        int strt;
        if (this.predInfo == null) {
            return false;
        }
        int op = this.predInfo.getOpFlag();
        String errMessage = null;
        if ((op & 1) != 1) {
            errMessage = "Not indexExactMatch";
        }
        if ((op & 4) == 4 && (op & 8) != 8) {
            errMessage = "include start, but not include stop";
        }
        if ((op & 4) != 4 && (op & 8) == 8) {
            errMessage = "include stop, but not include start";
        }
        if ((op & 4) == 4 && (op & 8) == 8 && (strt = (int)this.predInfo.getStart()) != (stop = (int)this.predInfo.getStop())) {
            errMessage = "include stop and include start, but start and stop differ.";
        }
        if (errMessage != null) {
            throw new IllegalArgumentException("Invalid predicate information: " + errMessage + " (" + this.predInfo.toString() + ")");
        }
        strt = (int)this.predInfo.getStart();
        return strt == 0;
    }
}

