/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.search;

import chemaxon.formats.MolFormatException;
import chemaxon.jchem.cartridge.rmi.StructureFormatException;
import chemaxon.jchem.cartridge.rmi.impl.scanresult.SearchExInfo;
import chemaxon.jchem.cartridge.server.task.Task;
import chemaxon.jchem.cartridge.servlets.search.DeferredErrorHandler;
import chemaxon.jchem.cartridge.servlets.search.QueryHandler;
import chemaxon.jchem.cartridge.util.JccConfig;
import chemaxon.jchem.db.JChemSearch;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.concurrent.workunitmgmt.WorkUnitManager;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class QueryHandlerBase
implements QueryHandler {
    private static Logger logger = Logger.getLogger(QueryHandlerBase.class.getName());
    protected ConnectionHandler connectionHandler;
    protected JChemSearch jcSearch;
    protected DeferredErrorHandler deferredErrorHandler;
    protected int desiredArraySize;
    protected Long profileId;
    protected volatile int status = 0;
    private Future<Object> jcSearchRunnerTask;
    protected CountDownLatch latch = new CountDownLatch(1);

    public QueryHandlerBase(ConnectionHandler connectionHandler, JChemSearch jcSearch, DeferredErrorHandler deferredErrorHandler, int desiredArraySize, Long profilerId) {
        this.deferredErrorHandler = deferredErrorHandler;
        this.connectionHandler = connectionHandler;
        this.jcSearch = jcSearch;
        if (desiredArraySize <= 0) {
            throw new IllegalArgumentException("desiredArraySize must be greater than 0");
        }
        this.desiredArraySize = desiredArraySize;
        this.profileId = profilerId;
    }

    protected static void setRuntimeProperties(JChemSearch jcSearch) throws IOException {
        JccConfig serverProperties = JccConfig.getInstance();
        String minNonCachedMemoryStr = serverProperties.getReservedMemory();
        if (minNonCachedMemoryStr != null) {
            int minNonCachedMemory = Integer.parseInt(minNonCachedMemoryStr);
            jcSearch.setMinNonCachedMemory(minNonCachedMemory);
        }
        jcSearch.setInfoToStdError(serverProperties.isJcSearchInfoToStdError());
    }

    @Override
    public void start() throws Exception {
        this.status = 1;
        if (this.isInProgressiveMode()) {
            this.executeAsynch();
        } else {
            this.execute();
        }
    }

    @Override
    public void stop() throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("[" + this + "]: stop called");
        }
        this.jcSearch.setRunning(false);
        if (this.status != 2) {
            this.status = 3;
        }
        if (this.jcSearchRunnerTask != null) {
            this.jcSearchRunnerTask.get();
        }
    }

    private void executeAsynch() {
        this.jcSearchRunnerTask = WorkUnitManager.getInstance().submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    QueryHandlerBase.this.execute();
                    return null;
                }
                catch (MolFormatException mfe) {
                    throw new StructureFormatException(mfe);
                }
            }
        });
    }

    protected void unblockHitReturn() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("[" + this + "]: unblockHitReturn called");
        }
        this.latch.countDown();
    }

    protected void checkAsynchResult() throws InterruptedException, ExecutionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("[" + this + "]: checkAsynchResult called");
        }
        this.latch.await();
        if (this.status != 1) {
            this.jcSearchRunnerTask.get();
        }
    }

    @Override
    public int[] getNextHits() throws Exception {
        int[] nextHits = null;
        if (this.getStatus() == 3) {
            return null;
        }
        try {
            nextHits = this.getMoreHits();
            if (nextHits.length == 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("End of story, returning null...");
                }
                return null;
            }
        }
        catch (MolFormatException mfe) {
            throw new StructureFormatException(mfe);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Returning " + nextHits.length + " hit(s)...");
        }
        return nextHits;
    }

    protected abstract void execute() throws Exception;

    protected abstract int[] getMoreHits() throws Exception;

    public boolean isInProgressiveMode() {
        return this.jcSearch.getRunMode() == 2;
    }

    public boolean isRunning() {
        boolean running;
        boolean bl = running = this.status == 1;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("[" + this + "]: returning " + running);
        }
        return running;
    }

    @Override
    public int getStatus() {
        int s = this.status;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("[" + this + "]: returning " + s);
        }
        return s;
    }

    @Override
    public synchronized Long getMemoryUsage() {
        if (this.jcSearch.isRunning()) {
            return null;
        }
        return Task.intArrayMemory(this.jcSearch.getResultCount()) * (long)(this.isInProgressiveMode() ? 2 : 1);
    }

    @Override
    public SearchExInfo createSearchExInfo() throws Exception {
        int screenedCountUnique = 0;
        int screenedCountTotal = 0;
        try {
            screenedCountUnique = this.jcSearch.getScreenedCountUnique();
            screenedCountTotal = this.jcSearch.getScreenedCountTotal();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("screenedCountUnique=" + screenedCountUnique + ", screenedCountTotal=" + screenedCountTotal);
        }
        return new SearchExInfo(screenedCountUnique, screenedCountTotal);
    }

    @Override
    public synchronized void dispose() throws Exception {
        this.stop();
    }
}

