/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.servlets.search;

import chemaxon.descriptors.InHouseDefaultParser;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.profiling.ComputeSearchProfile;
import chemaxon.jchem.cartridge.rmi.IllegalOptionException;
import chemaxon.jchem.cartridge.rmi.impl.JCartProfilerImpl;
import chemaxon.jchem.cartridge.rmi.impl.scanresult.TableScanBaseImpl;
import chemaxon.jchem.cartridge.servlets.JCartConnectionManager;
import chemaxon.jchem.cartridge.servlets.search.DeferredErrorHandler;
import chemaxon.jchem.cartridge.servlets.search.IntegerValuedPredicate;
import chemaxon.jchem.cartridge.servlets.search.MultiQueryHandler;
import chemaxon.jchem.cartridge.servlets.search.QueryHandler;
import chemaxon.jchem.cartridge.servlets.search.QueryHandlerBase;
import chemaxon.jchem.cartridge.servlets.search.SingleQueryHandler;
import chemaxon.jchem.cartridge.tunnel.TableScanInfo;
import chemaxon.jchem.cartridge.tunnel.search.DissimilaritySearchInfo;
import chemaxon.jchem.cartridge.tunnel.search.PredicateInfo;
import chemaxon.jchem.cartridge.tunnel.search.SearchInfo;
import chemaxon.jchem.cartridge.util.CardinalPredicat;
import chemaxon.jchem.cartridge.util.JccConfig;
import chemaxon.jchem.db.JChemSearch;
import chemaxon.jchem.db.MDTableHandler;
import chemaxon.jchem.db.status.IncidentsObserver;
import chemaxon.jchem.db.status.incidentsets.JCSIncidents;
import chemaxon.jchem.db.status.observers.JCSObserver;
import chemaxon.jchem.interop.JChemSearchOptionsAdapter;
import chemaxon.license.LicenseHandler;
import chemaxon.sss.SearchConstants;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.sss.search.SearchOptions;
import chemaxon.sss.search.options.MarkushScreeningType;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.CxOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QueryHandlerFactory
implements SearchConstants {
    private static Logger logger = Logger.getLogger(QueryHandlerFactory.class.getName());
    private SearchInfo searchInfo;
    private PredicateInfo predicateInfo;
    private CxOptions cxOptions;

    public QueryHandlerFactory(SearchInfo searchInfo) {
        this.searchInfo = searchInfo;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("searchInfo=" + searchInfo);
        }
    }

    public QueryHandler create() throws Exception {
        if (JCartProfilerImpl.isProfiling(this.searchInfo)) {
            ComputeSearchProfile sp = JCartProfilerImpl.getSearchProfileLocal((long)this.searchInfo.getProfileId().longValue()).computeSearchProfile;
            sp.receivedFromOracle = System.currentTimeMillis();
        }
        this.checkLicense(this.searchInfo);
        JChemSearchOptions searchOptions = this.createSearchOptions();
        if (JCartProfilerImpl.isProfiling(this.searchInfo)) {
            ComputeSearchProfile sp = JCartProfilerImpl.getSearchProfileLocal((long)this.searchInfo.getProfileId().longValue()).computeSearchProfile;
            sp.tableName = this.searchInfo.getTableQName();
            sp.opType = this.searchInfo.getJccOperator();
            sp.queryStructure = this.searchInfo.getQuery();
            if (sp.opType.equals("generic")) {
                sp.queryParams = this.searchInfo.getOptions();
            } else if (this.predicateInfo != null) {
                sp.queryParams = this.predicateInfo.toString();
            }
        }
        JChemSearch jcSearch = null;
        JCSObserver observer = JChemSearch.createJCSObserver();
        if (this.searchInfo.isJchemTable()) {
            jcSearch = new JChemSearch((IncidentsObserver<JCSIncidents>)observer);
            jcSearch.setStructureTable(this.searchInfo.getTableQName());
        } else {
            jcSearch = new JChemSearch(this.searchInfo.getTableQName(), this.searchInfo.getIndexedColumn(), (IncidentsObserver<JCSIncidents>)observer);
            jcSearch.setStructureTable(this.searchInfo.getIndexTableQName());
        }
        int threadCount = TableScanBaseImpl.getThreadCount((TableScanInfo)this.searchInfo, JccConfig.getInstance().getJcSearchThreadsPerCall());
        jcSearch.setNumberOfProcessingThreads(threadCount);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Searcher thread count set: " + threadCount);
        }
        int resultChunkSize = this.getResultChunkSize(searchOptions, jcSearch);
        jcSearch.setSearchOptions(searchOptions);
        return this.setQueries(this.searchInfo, resultChunkSize, jcSearch, new DeferredErrorHandler(this.searchInfo.getSessionInfo().getSessionId(), this.searchInfo.getScanId(), observer));
    }

    public JChemSearchOptions createSearchOptions() throws Exception {
        try {
            JChemSearchOptionsAdapter searchOptions;
            this.cxOptions = new CxOptions(this.searchInfo.getOptions());
            char[] carr = this.cxOptions.getValue("queryType");
            if (carr != null) {
                throw new IllegalArgumentException("Invalid option: queryType");
            }
            boolean jcSimilarity = this.searchInfo instanceof DissimilaritySearchInfo;
            if (jcSimilarity) {
                searchOptions = new JChemSearchOptionsAdapter(3);
                searchOptions.setOptions(this.searchInfo.getOptions());
            } else if (!this.isGenericSearch(this.searchInfo)) {
                searchOptions = new JChemSearchOptionsAdapter(this.getSearchType(this.searchInfo));
                searchOptions.setOptions(this.searchInfo.getOptions());
            } else {
                searchOptions = new JChemSearchOptionsAdapter(this.searchInfo.getOptions());
            }
            this.setScreenConfig(this.searchInfo, searchOptions);
            if (jcSimilarity) {
                this.setSimilarityProperties((DissimilaritySearchInfo)this.searchInfo, searchOptions);
            } else {
                IntegerValuedPredicate ivPredicate = new IntegerValuedPredicate(this.searchInfo.getPredicateInfo());
                if (this.searchInfo.getJccOperator().equals("JC_MATCHCOUNT")) {
                    searchOptions.setMatchCountOptions(ivPredicate.getMatchCountOptions());
                } else {
                    searchOptions.setReturnsNonHits(ivPredicate.getReturnNonHits());
                }
            }
            this.setFilterQuery(this.searchInfo, this.cxOptions, searchOptions);
            this.checkRequireCommt(this.cxOptions, searchOptions);
            this.setMarkushScreening(searchOptions);
            this.debug(searchOptions);
            return searchOptions;
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalOptionException("Invalid search option: " + iae.getMessage());
        }
    }

    private void setMarkushScreening(JChemSearchOptions searchOptions) throws IOException {
        boolean configuredDefault = JccConfig.getInstance().getBoolean("markush.screening.enabled", true);
        boolean on = this.cxOptions.getBoolValue("markushScreening", configuredDefault);
        searchOptions.setMarkushScreeningEnabled(on);
        configuredDefault = JccConfig.getInstance().getBoolean("markush.fp.screening.enabled", true);
        on = this.cxOptions.getBoolValue("markushFPScreening", configuredDefault);
        searchOptions.setMarkushScreeningType(MarkushScreeningType.FINGERPRINT, on);
    }

    private void debug(JChemSearchOptions jcso) {
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer();
            ArrayList<String> l = jcso.toList();
            for (Object e : l) {
                sb.append("[").append(e).append("]");
            }
            logger.fine(sb.toString());
        }
    }

    private int getSearchType(SearchInfo searchInfo) {
        int searchType = 2;
        String jccOperator = searchInfo.getJccOperator();
        if (jccOperator.startsWith("JC_CONTAINS") || jccOperator.startsWith("JC_MATCHCOUNT")) {
            searchType = 2;
        } else if (jccOperator.startsWith("JC_EQUALS")) {
            searchType = 5;
        } else if (!this.isGenericSearch(searchInfo)) {
            if (searchInfo instanceof DissimilaritySearchInfo) {
                searchType = 3;
            } else {
                throw new UnsupportedOperationException("Operation '" + jccOperator + "' is not supported.");
            }
        }
        return searchType;
    }

    private boolean isGenericSearch(SearchInfo searchInfo) {
        return searchInfo.getJccOperator().startsWith("JC_COMPARE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setScreenConfig(TableScanInfo searchInfo, JChemSearchOptions searchOptions) throws Exception {
        String descriptorName = this.cxOptions.getStringValue("descriptorName");
        String screenConfigOpt = this.cxOptions.getStringValue("screenConfig");
        if (screenConfigOpt != null) {
            if (descriptorName == null) {
                throw new IllegalArgumentException("No screen config name accepted without a descriptor name");
            }
            this.cxOptions.removeOption("screenConfig");
            ConnectionHandler conh = JCartConnectionManager.getInstance().createConnectionHandler(searchInfo.getSessionInfo(), searchInfo.getJcpropTableName(), true);
            try {
                String screenConfig = null;
                if (screenConfigOpt.toLowerCase().startsWith("select ")) {
                    screenConfig = JFunctions.getStringResult(conh.getConnection(), screenConfigOpt);
                } else {
                    MDTableHandler mdTableHandler = new MDTableHandler(conh, searchInfo.getIndexTableQName(), !searchInfo.isJchemTable());
                    screenConfig = mdTableHandler.getMDConfig(descriptorName, screenConfigOpt);
                    if (screenConfig == null) {
                        throw new IllegalArgumentException("Screen configuration definition '" + screenConfigOpt + "' not found for '" + descriptorName + "'");
                    }
                }
                searchOptions.setDescriptorConfig(screenConfig);
            }
            finally {
                conh.close();
            }
        }
    }

    private void setFilterQuery(TableScanInfo searchInfo, CxOptions cxOptions, JChemSearchOptions searchOptions) {
        String filterQuery = searchOptions.getFilterQuery();
        if (filterQuery != null && filterQuery.length() > 0 && !searchInfo.isJchemTable()) {
            String stmt = "SELECT cd_id FROM " + searchInfo.getIndexTableQName() + " WHERE rid IN (" + filterQuery + ")";
            searchOptions.setFilterQuery(stmt);
        }
    }

    private void checkRequireCommt(CxOptions cxOptions, JChemSearchOptions searchOptions) {
        if (cxOptions.getStringValue("requireCommit") != null && searchOptions.getSearchType() != 5) {
            throw new IllegalArgumentException("The option \"requireCommit\" currently only supported with DUPLICATE search");
        }
    }

    private void checkLicense(SearchInfo searchInfo) {
        String errorMessage = "No valid license for JChem Cartridge";
        String oldVsn = searchInfo.getOldVsn();
        if (!(oldVsn != null && oldVsn.equals("fs56OC") || LicenseHandler.getInstance().isLicensed("JChem Cartridge"))) {
            throw new RuntimeException(errorMessage);
        }
    }

    private int getResultChunkSize(JChemSearchOptions searchOptions, JChemSearch jcSearch) {
        int resultChunkSize = Integer.MAX_VALUE;
        if (this.searchInfo.isEarlyResults() && searchOptions.getSearchType() != 3 && searchOptions.getSearchType() != 1) {
            jcSearch.setOrder(0);
            jcSearch.setRunMode(2);
            resultChunkSize = 100;
            resultChunkSize = this.getCustomResultChunkSize(this.cxOptions);
        }
        return resultChunkSize;
    }

    private int getCustomResultChunkSize(CxOptions jcOptions) {
        int resultChunkSize = 100;
        String resultChunkSizeStr = jcOptions.getStringValue("earlyResults");
        if (resultChunkSizeStr != null) {
            try {
                int tmp = Integer.parseInt(resultChunkSizeStr);
                if (tmp > 0) {
                    resultChunkSize = tmp;
                }
            }
            catch (NumberFormatException ne) {
                throw new IllegalArgumentException("Invalid block size for 'earlyResults': " + resultChunkSizeStr);
            }
        }
        return resultChunkSize;
    }

    private Molecule[] extractQueryMols(JChemSearch jChemSearch, String queryStructure) throws Exception {
        Molecule[] queries = null;
        ArrayList<Molecule> l = new ArrayList<Molecule>();
        MolImporter molimp = null;
        ByteArrayInputStream bis = new ByteArrayInputStream(queryStructure.getBytes());
        try {
            molimp = new MolImporter(bis);
        }
        catch (IOException io) {
            throw new Exception("Error while unmarshalling query structure " + queryStructure + ": " + io.getMessage(), io);
        }
        molimp.setQueryMode(this.getImportQueryMode(jChemSearch.getSearchOptions()));
        Molecule mol = molimp.read();
        while (mol != null) {
            if (logger.isLoggable(Level.FINER)) {
                String structure = molimp.getGrabbedMoleculeString();
                logger.finer("query=" + structure);
            }
            l.add(mol);
            mol = molimp.read();
        }
        queries = new Molecule[l.size()];
        l.toArray(queries);
        return queries;
    }

    private int[][] extractQueryFingerprints(String queryFingerprints) throws Exception {
        ArrayList<int[]> l = new ArrayList<int[]>();
        StringTokenizer t = new StringTokenizer(queryFingerprints, "\r\n");
        while (t.hasMoreTokens()) {
            l.add(InHouseDefaultParser.string2IntArray(t.nextToken()));
        }
        int[][] queryFpArray = new int[l.size()][];
        l.toArray((T[])queryFpArray);
        return queryFpArray;
    }

    public boolean getImportQueryMode(SearchOptions so) {
        boolean importQueryMode = true;
        int searchType = so.getSearchType();
        if (searchType == 5 || searchType == 3 || searchType == 6 || so.getTautomerSearch() == 1) {
            importQueryMode = false;
        }
        return importQueryMode;
    }

    private void setSimilarityProperties(DissimilaritySearchInfo info, JChemSearchOptions searchOptions) throws Exception {
        CardinalPredicat cp = new CardinalPredicat(this.searchInfo.getPredicateInfo());
        double start = cp.start;
        double stop = cp.stop;
        boolean isDissimilarity = info.getJccOperator().startsWith("JC_DISSIMILARITY");
        if (new Double(start).isNaN()) {
            searchOptions.setDissimilarityThreshold(this.getDissimilarityThreshold(isDissimilarity, stop));
            searchOptions.setDissimilarityThresholdExcluded(!cp.includeStop);
            searchOptions.setReturnsNonHits(!isDissimilarity);
        } else if (new Double(stop).isNaN()) {
            searchOptions.setDissimilarityThreshold(this.getDissimilarityThreshold(isDissimilarity, start));
            searchOptions.setDissimilarityThresholdExcluded(!cp.includeStart);
            searchOptions.setReturnsNonHits(isDissimilarity);
        } else {
            throw new Exception("Equality (jc_tanimoto/jc_tversky(...) = x) and double conditions (jc_tanimoto/jc_tversky(...) < x AND jc_tanimoto/jc_tversky(...) > x) are currently not supported for (dis)similarity search");
        }
    }

    private String getMetric(CxOptions cxOptions) {
        String metric = cxOptions.getStringValue("dissimilarityMetric");
        if (metric == null) {
            return "tanimoto";
        }
        return metric;
    }

    private float getDissimilarityThreshold(boolean isDissimilarity, double stopStart) {
        return (float)(isDissimilarity ? stopStart : 1.0 - stopStart);
    }

    private QueryHandler setQueries(SearchInfo searchInfo, int resultChunkSize, JChemSearch jcSearch, DeferredErrorHandler deferredErrorHandler) throws Exception {
        QueryHandlerBase queryHandler = null;
        JCartConnectionManager cm = JCartConnectionManager.getInstance();
        ConnectionHandler ch = cm.createConnectionHandler(searchInfo.getSessionInfo(), searchInfo.getJcpropTableName(), false);
        if (searchInfo.getIndexSubType() == 1) {
            if (jcSearch.getSearchOptions().getSearchType() != 3) {
                throw new IllegalArgumentException("Only similarity search is supported with the fingerprint index subtype.");
            }
            int[][] queryFps = this.extractQueryFingerprints(searchInfo.getQuery());
            queryHandler = queryFps.length == 1 ? new SingleQueryHandler(ch, jcSearch, deferredErrorHandler, queryFps[0], resultChunkSize, searchInfo.getProfileId()) : new MultiQueryHandler(jcSearch, deferredErrorHandler, queryFps, resultChunkSize, ch, searchInfo.getProfileId());
        } else {
            Molecule[] queries = this.extractQueryMols(jcSearch, searchInfo.getQuery());
            queryHandler = queries.length == 1 ? new SingleQueryHandler(ch, jcSearch, deferredErrorHandler, queries[0], resultChunkSize, searchInfo.getProfileId()) : new MultiQueryHandler(jcSearch, deferredErrorHandler, queries, resultChunkSize, ch, searchInfo.getProfileId());
        }
        return queryHandler;
    }

    public static void main(String[] args) {
        String s = "aa\r\nbb\r\n";
        int idx = 0;
        StringTokenizer t = new StringTokenizer(s, "\r\n");
        while (t.hasMoreTokens()) {
            System.err.println(idx++ + ": " + t.nextToken());
        }
    }
}

