/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.structs;

import chemaxon.jchem.cartridge.JcMetaDataFunctions;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.oresident.JccConfigConstants;
import chemaxon.jchem.cartridge.oresident.util.CxOptions;
import chemaxon.jchem.cartridge.structs.JChemProperties;
import chemaxon.jchem.cartridge.tunnel.MdMetaData;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class JCartDefaultProperties
implements JChemProperties,
JccConfigConstants {
    private static final JCartLogger logger = JCartLogger.getLogger(JCartDefaultProperties.class);
    public static final String UNSET_PROPERTY = "NOTSET";
    protected static final MdMetaData[] UNINITIALIZED_MDDATA = new MdMetaData[0];
    private static JCartDefaultProperties instance;
    private Boolean hasCustomDp;
    protected DbSession dbSession;
    protected JcMetaDataFunctions metaData;
    protected Boolean absoluteStereo;
    protected String standardizerConfig = JccConfigConstants.UNINITIALIZED_STRING;
    protected Boolean tautomerDuplicateFiltering;
    protected Boolean protectTautomerChirality;
    protected Boolean switchOffAllProtectionsTdf;
    protected int[] fingerPrintProps;
    protected Integer structuralFpColCount;
    protected MdMetaData[] mdMetaData = UNINITIALIZED_MDDATA;
    protected Properties jcp = new Properties();
    protected String validityTimestamp;

    protected JCartDefaultProperties(DbSession dbSession) throws Exception {
        this.dbSession = dbSession;
        this.metaData = new JcMetaDataFunctions(dbSession);
    }

    public void reset() {
        this.hasCustomDp = null;
        this.mdMetaData = UNINITIALIZED_MDDATA;
        this.absoluteStereo = null;
        this.standardizerConfig = JccConfigConstants.UNINITIALIZED_STRING;
        this.fingerPrintProps = null;
        this.structuralFpColCount = null;
        this.protectTautomerChirality = null;
        this.switchOffAllProtectionsTdf = null;
    }

    public DbSession getDbSession() {
        return this.dbSession;
    }

    protected String initStandardizerConfig() throws Exception {
        String propertyName = "standardizerConfig";
        return this.metaData.getDefaultProperty("standardizerConfig");
    }

    protected String initAbsoluteStereo() throws Exception {
        return this.metaData.getDefaultProperty("absoluteStereo");
    }

    protected Boolean initTautomerDuplicateFiltering() throws Exception {
        String s = this.metaData.getDefaultProperty("tautomerDuplicateFiltering");
        return new Boolean(s != null && s.equals("true"));
    }

    protected Boolean initProtectTautomerChirality() throws Exception {
        String s = this.metaData.getDefaultProperty("genericTautomerProtectsChirality");
        if (s == null) {
            return new Boolean(PROTECT_TAUTOMER_CHIRALITY_DEFAULT);
        }
        return new Boolean(s.equals("true"));
    }

    protected Boolean initSwitchOffAllTautomerProtections() throws Exception {
        String s = this.metaData.getDefaultProperty("switchOffAllProtections");
        if (s == null) {
            return new Boolean(SWITCH_OFF_ALL_TAUTOMER_PROTECTIONS_DEFAULT);
        }
        return new Boolean(s.equals("true"));
    }

    protected String initJChemProperty(String name) throws Exception {
        return this.metaData.getDefaultProperty(name);
    }

    protected int[] initFingerPrintProps() throws Exception {
        String tmpStr = null;
        int[] r = new int[3];
        tmpStr = this.metaData.getDefaultProperty("fingerprint.numberOfBits");
        if (tmpStr == null) {
            return null;
        }
        r[0] = Integer.parseInt(tmpStr);
        tmpStr = this.metaData.getDefaultProperty("fingerprint.numberOfOnes");
        r[1] = Integer.parseInt(tmpStr);
        tmpStr = this.metaData.getDefaultProperty("fingerprint.numberOfEdges");
        r[2] = Integer.parseInt(tmpStr);
        return r;
    }

    protected Integer initStructuralFpColCount() throws Exception {
        String numColStr = this.metaData.getDefaultProperty("fingerprint.numberOfStrucFPCols");
        return new Integer(Integer.parseInt(numColStr));
    }

    protected MdMetaData[] initMdMetaData() throws Exception {
        return null;
    }

    @Override
    public String getStandardizerConfig() throws Exception {
        if (this.standardizerConfig == JccConfigConstants.UNINITIALIZED_STRING) {
            this.standardizerConfig = this.initStandardizerConfig();
        }
        return this.standardizerConfig;
    }

    public String getJChemProperty(String name) throws Exception {
        String value = this.jcp.getProperty(name);
        if (value == null) {
            value = this.initJChemProperty(name);
            if (value == null) {
                this.jcp.setProperty(name, UNSET_PROPERTY);
            } else {
                this.jcp.setProperty(name, value);
            }
        } else if (value == UNSET_PROPERTY) {
            value = null;
        }
        return value;
    }

    public boolean getBooleanJChemProperty(String name) throws Exception {
        String value = this.getJChemProperty(name);
        return value != null && value.equals("true");
    }

    @Override
    public boolean isAbsoluteStereo(CxOptions cxOptions) throws Exception {
        if (this.absoluteStereo == null) {
            String v = this.initAbsoluteStereo();
            this.absoluteStereo = v == null ? ABSOLUTE_STEREO_DEFAULT : new Boolean(v);
        }
        if (cxOptions == null || cxOptions.getStringValue("absoluteStereo") == null) {
            return this.absoluteStereo;
        }
        char opt = cxOptions.getValue("absoluteStereo")[0];
        switch (opt) {
            case 'C': 
            case 'c': {
                return false;
            }
            case 'A': 
            case 'a': {
                return true;
            }
        }
        char[] carr = new char[]{opt};
        throw new IllegalArgumentException("Invalid option value for absoluteStereo: " + new String(carr));
    }

    @Override
    public boolean isTautomerDuplicateFiltering() throws Exception {
        if (this.tautomerDuplicateFiltering == null) {
            this.tautomerDuplicateFiltering = this.initTautomerDuplicateFiltering();
        }
        return this.tautomerDuplicateFiltering;
    }

    @Override
    public boolean isProtectTautomerChirality() throws Exception {
        if (this.protectTautomerChirality == null) {
            this.protectTautomerChirality = this.initProtectTautomerChirality();
        }
        return this.protectTautomerChirality;
    }

    @Override
    public boolean isSwitchOffAllProtectionsTdf() throws Exception {
        if (this.switchOffAllProtectionsTdf == null) {
            this.switchOffAllProtectionsTdf = this.initSwitchOffAllTautomerProtections();
        }
        return this.switchOffAllProtectionsTdf;
    }

    @Override
    public int[] getFingerPrintProps() throws Exception {
        if (this.fingerPrintProps == null) {
            this.fingerPrintProps = this.initFingerPrintProps();
        }
        return this.fingerPrintProps;
    }

    public Integer getStructuralFpColCount() throws Exception {
        if (this.structuralFpColCount == null) {
            this.structuralFpColCount = this.initStructuralFpColCount();
        }
        return this.structuralFpColCount;
    }

    public MdMetaData[] getAllMdMetaData() throws Exception {
        if (this.mdMetaData == UNINITIALIZED_MDDATA) {
            this.mdMetaData = this.initMdMetaData();
        }
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.mdMetaData.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                MdMetaData mmd = this.mdMetaData[i];
                sb.append(mmd.name);
            }
            logger.debug("initMdMetaData: returning " + sb);
        }
        return this.mdMetaData;
    }

    public String getValidityTimestamp() {
        return this.validityTimestamp;
    }

    public String toString() {
        return this.getClass().getName() + "[absoluteStereo = " + this.absoluteStereo + ", standardizerConfig = " + this.standardizerConfig + ", mdNames = " + this.mdMetaData + ", fingerPrintProps  = " + this.fingerPrintProps + "]";
    }

    public static JCartDefaultProperties getInstance(DbSession dbSession) throws Exception {
        JcMetaDataFunctions metaData = new JcMetaDataFunctions(dbSession);
        if (logger.isDebugEnabled()) {
            logger.debug("About to read default property validity timestamp");
        }
        if (instance == null) {
            instance = new JCartDefaultProperties(dbSession);
        }
        instance.checkValidityTimestamp();
        return instance;
    }

    public void checkValidityTimestamp() throws Exception {
        if (this.hasCustomDp == null) {
            this.hasCustomDp = new Boolean(false);
            if (logger.isDebugEnabled()) {
                logger.debug("Checking custom dp table...");
            }
            if (this.metaData.tableExists(this.metaData.getMasterIdxTableName(null))) {
                String vt = this.getRealValidityTimeStamp(true);
                this.hasCustomDp = new Boolean(vt != null);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("hasCustomDpTable=" + this.hasCustomDp);
            }
        }
        String realVTimestamp = this.getRealValidityTimeStamp(this.hasCustomDp);
        if (this.validityTimestamp != null && !this.validityTimestamp.equals(realVTimestamp)) {
            this.reset();
        }
        this.validityTimestamp = realVTimestamp;
    }

    private String getRealValidityTimeStamp(boolean lookForCustomTimeStamp) throws SQLException {
        PreparedStatement ps;
        String realVTimestamp;
        ResultSet rset;
        block14: {
            rset = null;
            StringBuffer buffer = new StringBuffer("SELECT g.prop_value ");
            if (lookForCustomTimeStamp) {
                buffer.append(" || u.prop_value ");
            }
            buffer.append("as prop_value FROM ");
            buffer.append(this.metaData.getMasterIdxTableName(this.dbSession.getJccOwner())).append(" g ");
            if (lookForCustomTimeStamp) {
                buffer.append(", ").append(this.metaData.getMasterIdxTableName(null)).append(" u ");
            }
            buffer.append("WHERE g.prop_name = ?");
            if (lookForCustomTimeStamp) {
                buffer.append(" AND u.prop_name = ?");
            }
            realVTimestamp = null;
            String sql = buffer.toString();
            ps = this.dbSession.prepareStatement(sql);
            try {
                ps.setString(1, "defaultProperties.validityTimestamp");
                if (lookForCustomTimeStamp) {
                    ps.setString(2, "defaultProperties.validityTimestamp");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing: " + sql);
                }
                if ((rset = ps.executeQuery()).next()) {
                    String propValue = rset.getString("prop_value");
                    if (propValue != null) {
                        realVTimestamp = propValue.trim();
                    }
                    break block14;
                }
                realVTimestamp = null;
            }
            catch (SQLException sqlE) {
                try {
                    if (sqlE.getErrorCode() == 942) {
                        this.dbSession.invalidate(sql);
                        throw new RuntimeException("checkValidityTimestamp() failed with " + sqlE.getMessage());
                    }
                    if (logger.isErrorEnabled()) {
                        logger.error("Statement \"" + sql + "\" failed with " + sqlE.getMessage());
                    }
                    throw sqlE;
                }
                catch (Throwable throwable) {
                    this.dbSession.close(rset, ps);
                    throw throwable;
                }
            }
        }
        this.dbSession.close(rset, ps);
        if (logger.isDebugEnabled()) {
            logger.debug("getInstance(): instance.validityTimestamp=" + JCartDefaultProperties.instance.validityTimestamp + ", realVt=" + realVTimestamp);
        }
        return realVTimestamp;
    }
}

