/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.structs;

import chemaxon.jchem.cartridge.Indexing;
import chemaxon.jchem.cartridge.JcMetaDataFunctions;
import chemaxon.jchem.cartridge.ctcol.ChemTermColSupport;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.oresident.JccConfigConstants;
import chemaxon.jchem.cartridge.oresident.util.CxOptions;
import chemaxon.jchem.cartridge.rmi.Miscellanious;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import chemaxon.jchem.cartridge.structs.JCartDefaultProperties;
import chemaxon.jchem.cartridge.tunnel.MdMetaData;
import chemaxon.jchem.cartridge.tunnel.TableOpInfo;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class JCartIndexDescriptor
extends JCartDefaultProperties {
    private static final JCartLogger logger = JCartLogger.getLogger(JCartIndexDescriptor.class);
    private static final Map byTableName = new HashMap();
    private static final Map byIndexName = new HashMap();
    private JcMetaDataFunctions metaData;
    private RmiDirectory rmiDirectory;
    private Integer idxCompatibility;
    private int idxSubType;
    private Map chemTermsMap;
    private Integer idxTableType;
    private String baseTableSchema;
    private String baseTableName;
    private String indexSchemaName;
    private String indexName;
    private String indexPartitionName;
    private String idxTableQName;
    private String idxTableName;
    private String colName;
    private String jcptName;
    private boolean isJChemTable;
    private ChemTermColSupport ctColSupp;

    private JCartIndexDescriptor(DbSession dbSession, String jchemTableName, String jcptName) throws Exception {
        super(dbSession);
        this.metaData = new JcMetaDataFunctions(dbSession);
        this.rmiDirectory = RmiDirectory.instance(dbSession);
        this.isJChemTable = true;
        this.jcptName = jcptName == null || jcptName.equals("") ? "JChemProperties" : jcptName;
        int dotPos = jchemTableName.indexOf(46);
        if (dotPos == -1) {
            this.baseTableSchema = dbSession.getRealUser();
        } else {
            this.baseTableSchema = jchemTableName.substring(0, dotPos);
            jchemTableName = jchemTableName.substring(dotPos + 1);
        }
        this.baseTableName = jchemTableName;
        this.idxTableQName = this.baseTableSchema + "." + jchemTableName;
        this.validityTimestamp = this.metaData.getJChemPropertyForIndex(this.jcptName, this.idxTableQName, this.isJChemTable, "validityTimestamp");
    }

    private JCartIndexDescriptor(DbSession dbSession, String idxSchema, String idxName, String idxPartition, String baseTableSchema, String baseTableName, String colName) throws Exception {
        super(dbSession);
        this.init0(dbSession, idxSchema, idxName, idxPartition, baseTableSchema, baseTableName, colName);
    }

    private JCartIndexDescriptor(DbSession dbSession, TableOpInfo tableInfo) throws Exception {
        this(dbSession, tableInfo.getIndexSchemaName(), tableInfo.getIndexName(), tableInfo.getIndexPartition(), tableInfo.getBaseSchemaName(), tableInfo.getBaseTableName(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init0(DbSession dbSession, String idxSchema, String idxName, String idxPartition, String baseTableSchema, String baseTableName, String colName) throws Exception {
        block11: {
            block10: {
                this.dbSession = dbSession;
                this.metaData = new JcMetaDataFunctions(dbSession);
                this.rmiDirectory = RmiDirectory.instance(dbSession);
                this.indexSchemaName = idxSchema.toUpperCase();
                this.indexName = idxName.toUpperCase();
                this.indexPartitionName = idxPartition;
                this.idxTableQName = this.metaData.getIdxTableQName(this.indexSchemaName, this.indexName, idxPartition, false);
                boolean bl = this.isJChemTable = this.idxTableQName == null;
                if (this.isJChemTable) {
                    if (baseTableName == null) {
                        this.idxTableQName = this.metaData.getIdxTableQNameForJcTable(this.indexSchemaName, this.indexName, idxPartition);
                    } else {
                        String schema = baseTableSchema;
                        if (baseTableSchema == null) {
                            schema = dbSession.getImpersonatedUser();
                        }
                        this.idxTableQName = schema + "." + baseTableName;
                    }
                }
                this.idxTableQName = this.idxTableQName.toUpperCase();
                int dotPos = this.idxTableQName.indexOf(46);
                this.idxTableName = this.idxTableQName.substring(dotPos + 1);
                this.jcptName = this.metaData.getPropertyTableName(this.indexSchemaName, this.indexName, idxPartition);
                if (this.jcptName == null) {
                    if (logger.isWarningEnabled()) {
                        logger.warning("jcptName=null for " + idxSchema + "." + idxName + "." + idxPartition + " (" + this.idxTableQName + ")");
                    }
                    this.checkIdxStatus(idxSchema, idxName);
                }
                this.baseTableSchema = baseTableSchema;
                this.baseTableName = baseTableName;
                if (colName != null) break block10;
                if (logger.isDebugEnabled()) {
                    logger.debug("JCartIndexDescriptor: TODO: column name is not recieved as arugment, obtaining it from the dictionary...\n" + JCartLogger.stackTrace(new Exception()));
                }
                String sql = "select column_name from all_ind_columns where index_owner = ? and index_name = ?";
                PreparedStatement pstmt = dbSession.prepareStatement(sql);
                ResultSet rs = null;
                try {
                    pstmt.setString(1, this.indexSchemaName);
                    pstmt.setString(2, this.indexName);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        throw new RuntimeException("Statement returned no result: " + sql + " [index_owner=" + this.indexSchemaName + ", index_name=" + this.indexName + "]");
                    }
                    this.colName = rs.getString(1);
                }
                catch (Throwable throwable) {
                    dbSession.close(rs, pstmt);
                    throw throwable;
                }
                dbSession.close(rs, pstmt);
                break block11;
            }
            this.colName = colName.replace('\"', ' ').trim();
        }
        this.idxSubType = this.metaData.getIdxSubType(this.jcptName, this.idxTableQName, this.isJChemTable);
        this.validityTimestamp = this.metaData.getJChemPropertyForIndex(this.jcptName, this.idxTableQName, this.isJChemTable, "validityTimestamp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIdxStatus(String idxSchema, String idxName) throws Exception {
        String[] stati = new String[]{"status", "domidx_status", "domidx_opstatus"};
        StringBuffer buffer = new StringBuffer("select ");
        for (int i = 0; i < stati.length; ++i) {
            String statusName = stati[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(statusName);
        }
        buffer.append(" from all_indexes ");
        buffer.append("where ityp_owner = ? and ityp_name = 'JC_IDXTYPE' ");
        buffer.append("and owner = ? and index_name = ?");
        PreparedStatement pstmt = this.dbSession.prepareStatement(buffer.toString());
        ResultSet rs = null;
        try {
            int paramIdx = 1;
            pstmt.setString(paramIdx++, this.dbSession.getJccOwner());
            pstmt.setString(paramIdx++, idxSchema);
            pstmt.setString(paramIdx++, idxName);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new IllegalArgumentException("No such index: " + idxSchema + "." + idxName);
            }
            for (int i = 0; i < stati.length; ++i) {
                String statusName = stati[i];
                String statusValue = this.checkStatus(rs, statusName);
                if (statusValue == null) continue;
                throw new RuntimeException(statusName + " is " + statusValue + " for " + idxSchema + "." + idxName);
            }
            String status = rs.getString("status");
            String domidx_status = rs.getString("domidx_status");
            String domidx_opstatus = rs.getString("domidx_opstatus");
        }
        catch (Throwable throwable) {
            this.dbSession.close(rs, pstmt);
            throw throwable;
        }
        this.dbSession.close(rs, pstmt);
    }

    private void setBaseTableSchemaAndName() {
        try {
            if (this.indexSchemaName == null || this.indexName == null) {
                throw new IllegalStateException("baseTableSchema and indexSchemaName and indexName are all null");
            }
            String[] baseTableSchemaAndName = this.metaData.getBaseTableSchemaAndName(this.indexSchemaName, this.indexName);
            this.baseTableSchema = baseTableSchemaAndName[0];
            this.baseTableName = baseTableSchemaAndName[1];
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error(e);
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    private String checkStatus(ResultSet rs, String statusName) throws SQLException {
        String status = rs.getString(statusName);
        if (status == null) {
            return "NULL";
        }
        if (status.equals("VALID")) {
            return null;
        }
        return status;
    }

    @Override
    public void reset() {
        this.absoluteStereo = null;
        this.standardizerConfig = JccConfigConstants.UNINITIALIZED_STRING;
        this.mdMetaData = UNINITIALIZED_MDDATA;
        this.fingerPrintProps = null;
        this.validityTimestamp = null;
        this.jcptName = null;
        this.isJChemTable = false;
        this.baseTableSchema = null;
        this.baseTableName = null;
        this.indexSchemaName = null;
        this.indexName = null;
        this.indexPartitionName = null;
        this.colName = null;
        this.idxTableType = null;
        this.idxCompatibility = null;
        if (this.chemTermsMap != null) {
            this.chemTermsMap.clear();
            this.chemTermsMap = null;
        }
    }

    public String getBaseTableSchema() {
        if (this.baseTableSchema == null) {
            this.setBaseTableSchemaAndName();
        }
        return this.baseTableSchema;
    }

    public String getBaseTableName() {
        if (this.baseTableName == null) {
            this.setBaseTableSchemaAndName();
        }
        return this.baseTableName;
    }

    public String getIndexSchemaName() {
        return this.indexSchemaName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getIndexPartitionName() {
        return this.indexPartitionName;
    }

    public String getIdxTableQName() {
        return this.idxTableQName;
    }

    public String getIdxTableName() {
        return this.idxTableName;
    }

    public String getColName() {
        return this.colName;
    }

    public String getJcptName() {
        return this.jcptName;
    }

    public int getIdxSubType() {
        return this.idxSubType;
    }

    public boolean isJChemTable() {
        return this.isJChemTable;
    }

    public int getTableType() throws Exception {
        if (this.idxTableType == null) {
            this.idxTableType = new Integer(this.metaData.getTableType(this.jcptName, this.idxTableQName, this.isJChemTable));
        }
        return this.idxTableType;
    }

    public int getIdxCompatibility() throws Exception {
        if (this.idxCompatibility == null) {
            Miscellanious misc = (Miscellanious)this.rmiDirectory.getServer("MiscellaniousServer");
            this.idxCompatibility = new Integer(misc.idxCompatibility(this.createTableOpInfo(), this.isJChemTable));
        }
        return this.idxCompatibility;
    }

    @Override
    protected String initStandardizerConfig() throws Exception {
        String propertyName = "standardizerConfig";
        return this.metaData.getJChemPropertyForIndex(this.jcptName, this.idxTableQName, this.isJChemTable, "standardizerConfig");
    }

    @Override
    protected String initJChemProperty(String name) throws Exception {
        return this.metaData.getJChemPropertyForIndex(this.jcptName, this.idxTableQName, this.isJChemTable, name);
    }

    @Override
    protected Boolean initProtectTautomerChirality() throws Exception {
        boolean b = PROTECT_TAUTOMER_CHIRALITY_DEFAULT;
        String propertyName = "genericTautomerProtectsChirality";
        String s = this.metaData.getJChemPropertyForIndex(this.jcptName, this.idxTableQName, this.isJChemTable, propertyName);
        if (s != null) {
            b = s.equals("true");
        }
        return new Boolean(b);
    }

    @Override
    protected Boolean initSwitchOffAllTautomerProtections() throws Exception {
        boolean b = false;
        String propertyName = "switchOffAllProtections";
        String s = this.metaData.getJChemPropertyForIndex(this.jcptName, this.idxTableQName, this.isJChemTable, propertyName);
        if (s != null) {
            b = s.equals("true");
        }
        return new Boolean(b);
    }

    @Override
    public Boolean initTautomerDuplicateFiltering() throws Exception {
        int tableType = this.getTableType();
        if (tableType == 4 || tableType == 3) {
            return new Boolean(false);
        }
        if (this.tautomerDuplicateFiltering == null) {
            boolean b = true;
            String propertyName = "tautomerDuplicateFiltering";
            String s = this.metaData.getJChemPropertyForIndex(this.jcptName, this.idxTableQName, this.isJChemTable, propertyName);
            if (s != null) {
                b = s.equals("true");
            }
            this.tautomerDuplicateFiltering = new Boolean(b);
        }
        return this.tautomerDuplicateFiltering;
    }

    @Override
    public boolean isAbsoluteStereo(CxOptions cxOptions) throws Exception {
        if (this.absoluteStereo == null) {
            String v = this.initAbsoluteStereo();
            this.absoluteStereo = v == null ? ABSOLUTE_STEREO_DEFAULT : new Boolean(v);
        }
        if (cxOptions != null && cxOptions.getStringValue("absoluteStereo") != null) {
            char opt = cxOptions.getValue("absoluteStereo")[0];
            switch (opt) {
                case 'T': 
                case 't': {
                    return this.metaData.getJChemPropertyAsBoolean(this.jcptName, this.idxTableQName, this.isJChemTable, "absoluteStereo", this.absoluteStereo);
                }
            }
            return super.isAbsoluteStereo(cxOptions);
        }
        return super.isAbsoluteStereo(cxOptions);
    }

    @Override
    protected String initAbsoluteStereo() throws Exception {
        return this.metaData.getJChemPropertyForIndex(this.jcptName, this.idxTableQName, this.isJChemTable, "absoluteStereo");
    }

    @Override
    protected int[] initFingerPrintProps() throws Exception {
        String tmpStr = null;
        int[] r = new int[3];
        tmpStr = this.metaData.getJChemPropertyForIndex(this.jcptName, this.idxTableQName, this.isJChemTable, "fingerprint.numberOfBits");
        if (tmpStr == null) {
            System.err.println("No property 'fingerprint.numberOfBits' in table " + this.jcptName + " for index table " + this.idxTableQName);
        }
        r[0] = Integer.parseInt(tmpStr);
        tmpStr = this.metaData.getJChemPropertyForIndex(this.jcptName, this.idxTableQName, this.isJChemTable, "fingerprint.numberOfOnes");
        r[1] = Integer.parseInt(tmpStr);
        tmpStr = this.metaData.getJChemPropertyForIndex(this.jcptName, this.idxTableQName, this.isJChemTable, "fingerprint.numberOfEdges");
        r[2] = Integer.parseInt(tmpStr);
        return r;
    }

    @Override
    protected Integer initStructuralFpColCount() throws Exception {
        return new Integer(this.metaData.getJChemPropertyForIndex(this.jcptName, this.idxTableQName, this.isJChemTable, "fingerprint.numberOfStrucFPCols"));
    }

    @Override
    protected MdMetaData[] initMdMetaData() throws Exception {
        Miscellanious misc = (Miscellanious)this.rmiDirectory.getServer("MiscellaniousServer");
        MdMetaData[] mmd = misc.getMdMetaData(this.createTableOpInfo(), this.isJChemTable);
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < mmd.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                MdMetaData mdMetaData = mmd[i];
                sb.append(mdMetaData.name);
            }
            logger.debug("initMdMetaData: returning " + sb + " for " + this.idxTableQName);
        }
        return mmd;
    }

    public TableOpInfo createTableOpInfo() throws SQLException {
        return new TableOpInfo(this, this.dbSession.getSessionInfo(), null, 0);
    }

    public String getChemTermColumn(String expression) throws Exception {
        if (this.chemTermsMap == null) {
            if (this.ctColSupp == null) {
                this.ctColSupp = new ChemTermColSupport(this.dbSession);
            }
            String[] cts = this.ctColSupp.getAutoCalcCts(this.jcptName, this.idxTableQName, this.isJChemTable);
            this.chemTermsMap = new HashMap();
            for (int i = 0; i < cts.length; ++i) {
                String ct = cts[i];
                String colName = this.ctColSupp.getChemTermColumn(this.jcptName, this.idxTableQName.toUpperCase(), this.isJChemTable, ct);
                this.chemTermsMap.put(ct, colName);
            }
        }
        return (String)this.chemTermsMap.get(expression);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[super = " + super.toString() + ", jcptName = " + this.jcptName + ", isJChemTable = " + this.isJChemTable + ", tableSchemaName = " + this.baseTableSchema + ", tableName = " + this.baseTableName + ", indexSchemaName = " + this.indexSchemaName + ", indexName = " + this.indexName + ", " + "indexPartitionName = " + this.indexPartitionName + ", colName = " + this.colName + ", idxTableType = " + this.idxTableType + ", chemTermsMap=" + this.chemTermsMap + ", idxSubType=" + this.idxSubType + ", validityTimestamp=" + this.validityTimestamp + "]";
    }

    public static JCartIndexDescriptor get(DbSession dbSession, String jchemTableName, String jcptName) throws Exception {
        JCartIndexDescriptor newDesc = new JCartIndexDescriptor(dbSession, jchemTableName, jcptName);
        String key = jchemTableName + "." + jcptName;
        return JCartIndexDescriptor.getCachedOrNew(dbSession, byTableName, key, newDesc);
    }

    private static JCartIndexDescriptor getCachedOrNew(DbSession dbSession, Map cache, String key, JCartIndexDescriptor newDesc) throws Exception {
        if (!(dbSession instanceof JavaStoredProcSession)) {
            return newDesc;
        }
        JCartIndexDescriptor cached = (JCartIndexDescriptor)cache.get(key);
        if (cached != null) {
            if (cached.validityTimestamp != null && cached.validityTimestamp.equals(newDesc.validityTimestamp)) {
                return cached;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getCachedOrNew: different validity timestamp: cached descriptor=" + cached + ", new descriptor=" + newDesc);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("getCachedOrNew: descriptor is not cached in " + cache + ": " + newDesc);
        }
        cache.put(key, newDesc);
        return newDesc;
    }

    public static JCartIndexDescriptor get(DbSession dbSession, String idxSchema, String idxName, String idxPartition) throws Exception {
        return JCartIndexDescriptor.get(dbSession, idxSchema, idxName, idxPartition, null, null, null);
    }

    public static JCartIndexDescriptor get(DbSession dbSession, String idxQName) throws Exception {
        int dotPos = idxQName.indexOf(46);
        if (dotPos == -1) {
            return JCartIndexDescriptor.get(dbSession, dbSession.getRealUser(), idxQName, null);
        }
        String idxSchema = idxQName.substring(0, dotPos);
        String idxName = idxQName.substring(dotPos + 1);
        return JCartIndexDescriptor.get(dbSession, idxSchema, idxName, null);
    }

    public static JCartIndexDescriptor get(DbSession dbSession, String idxSchema, String idxName, String idxPartition, String baseTableSchema, String baseTableName, String colName) throws Exception {
        JCartIndexDescriptor newDesc = new JCartIndexDescriptor(dbSession, idxSchema, idxName, idxPartition, baseTableSchema, baseTableName, colName);
        String key = idxSchema + "." + idxName + "." + idxPartition;
        return JCartIndexDescriptor.getCachedOrNew(dbSession, byIndexName, key, newDesc);
    }

    public static JCartIndexDescriptor get(DbSession dbSession, TableOpInfo tableInfo) throws Exception {
        return JCartIndexDescriptor.get(dbSession, tableInfo.getIndexSchemaName(), tableInfo.getIndexName(), tableInfo.getIndexPartition(), null, null, null);
    }

    public static void clearCache() {
        byTableName.clear();
        byIndexName.clear();
    }

    public String getUpdateLogTableName() {
        return Indexing.generateUpdateLogTableName(this.idxTableQName);
    }

    public String getUpdateLogSeqName() {
        return Indexing.generateUpdateLogSeqName(this.idxTableQName);
    }

    public JcMetaDataFunctions getMetaDataFunctions() {
        return this.metaData;
    }

    public boolean isMarkushIndex() throws Exception {
        return this.getTableType() == 3;
    }

    public boolean isQueryIndex() throws Exception {
        return this.getTableType() == 4;
    }
}

