/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.tunnel.codec;

import chemaxon.jchem.cartridge.tunnel.codec.ExactByteCountReader;
import chemaxon.jchem.cartridge.tunnel.codec.TransportStreamClosedException;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;

public class ChunkwiseReader
implements ExactByteCountReader {
    private static final JCartLogger logger = JCartLogger.getLogger(ChunkwiseReader.class);
    private static final int CTRLSTR_SIZE = 4;
    private final ByteArrayOutputStream rxBuffer = new ByteArrayOutputStream(102400);
    private InputStream in;
    private byte[] tmpBuffer = new byte[4096000];
    private long lastReadTime;

    public ChunkwiseReader(InputStream in) {
        if (logger.isDebugEnabled()) {
            logger.debug("constructor called");
        }
        this.in = in;
    }

    public byte[] readMessage() throws IOException {
        byte[] msg = this.read();
        this.readVerifyMessageEnd();
        return msg;
    }

    public byte[] read() throws IOException {
        int nextChunkSize = this.getNextChunkSize();
        if (nextChunkSize == -1) {
            int errMessageLength = this.getNextChunkSize();
            this.readExact(errMessageLength);
            String errMessage = new String(this.rxBuffer.toByteArray(), "UTF-16");
            throw new RemoteException(errMessage);
        }
        this.rxBuffer.reset();
        if (nextChunkSize == 0) {
            this.lastReadTime = System.currentTimeMillis();
            return null;
        }
        this.readExact(nextChunkSize);
        return this.rxBuffer.toByteArray();
    }

    public void readVerifyMessageEnd() throws IOException {
        byte[] buffer = this.read();
        if (buffer != null) {
            throw new IOException("No end marker found");
        }
        this.lastReadTime = System.currentTimeMillis();
    }

    public void fastForwardToResponseEnd() throws IOException {
        while (this.read() != null) {
        }
    }

    private int getNextChunkSize() throws IOException {
        this.readExact(4);
        return this.decodeInt(this.rxBuffer.toByteArray());
    }

    @Override
    public byte[] readExact(int byteCount) throws IOException {
        this.readExact0(byteCount);
        return this.rxBuffer.toByteArray();
    }

    private void readExact0(int byteCount) throws IOException {
        this.rxBuffer.reset();
        while (this.rxBuffer.size() < byteCount) {
            int toBuffer = Math.min(this.tmpBuffer.length, byteCount - this.rxBuffer.size());
            int r = this.in.read(this.tmpBuffer, 0, toBuffer);
            if (logger.isDebugEnabled()) {
                logger.debug("read count=" + r);
            }
            if (r == 0) continue;
            if (r == -1) {
                throw new TransportStreamClosedException();
            }
            this.rxBuffer.write(this.tmpBuffer, 0, r);
        }
    }

    private int decodeInt(byte[] bytes) {
        int part = 0;
        int m = 1;
        for (int j = 3; j >= 0; --j) {
            int b = bytes[j];
            int i = b < 0 && j > 0 ? b + 256 : b;
            part += i * m;
            m *= 256;
        }
        return part;
    }

    public void cleanup() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public long getLastReadTime() {
        return this.lastReadTime;
    }
}

