/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.tunnel.codec;

import java.io.IOException;
import java.io.OutputStream;

public class ChunkwiseWriter {
    private OutputStream out;

    public ChunkwiseWriter(OutputStream out) {
        this.out = out;
    }

    public void writeMessage(byte[] buffer) throws IOException {
        this.writeInt(buffer.length);
        this.writeExact(buffer);
        this.closeMessage();
    }

    public void writeChunk(byte[] buffer) throws IOException {
        this.writeInt(buffer.length);
        this.writeExact(buffer);
        this.flush();
    }

    public void closeMessage() throws IOException {
        this.writeInt(0);
        this.flush();
    }

    public void writeError(String error) throws IOException {
        byte[] ebytes = error.getBytes("UTF-16");
        this.writeInt(-1);
        this.writeInt(ebytes.length);
        this.writeExact(ebytes);
        this.flush();
    }

    public void writeExact(byte[] buffer) throws IOException {
        this.out.write(buffer);
    }

    protected void flush() throws IOException {
        this.out.flush();
    }

    private void writeInt(int i) throws IOException {
        byte[] iBuffer = new byte[4];
        int j = 0;
        iBuffer[j++] = (byte)(i >>> 24 & 0xFF);
        iBuffer[j++] = (byte)(i >>> 16 & 0xFF);
        iBuffer[j++] = (byte)(i >>> 8 & 0xFF);
        iBuffer[j++] = (byte)(i & 0xFF);
        this.writeExact(iBuffer);
    }
}

