/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.tunnel.codec;

import chemaxon.jchem.cartridge.tunnel.codec.ExactByteCountReader;
import chemaxon.jchem.cartridge.tunnel.codec.ValueObject;
import java.io.IOException;
import java.io.OutputStream;

public abstract class CodecBase {
    public static int INT_LEN = 10;
    public static int LONG_LEN = 20;
    public static int DBL_LEN = 26;
    private static final String[] intPadTable = new String[INT_LEN];
    private static final String[] longPadTable;
    private static final String[] doublePadTable;
    private ExactByteCountReader reader;
    private OutputStream outputStream;

    private static void initPadTable(String[] padTable) {
        for (int ix = 0; ix < padTable.length; ++ix) {
            padTable[ix] = CodecBase.createPadString(padTable.length, ix);
        }
    }

    private static String createPadString(int maxLength, int len) {
        StringBuffer pad = new StringBuffer("");
        for (int i = maxLength - len; i > 0; --i) {
            pad.append(" ");
        }
        return pad.toString();
    }

    public void write(int i) throws IOException {
        String s = String.valueOf(i);
        s = s + intPadTable[s.length()];
        this.writeStringWoLen(s);
    }

    public void write(long i) throws IOException {
        String s = String.valueOf(i);
        s = s + longPadTable[s.length()];
        this.writeStringWoLen(s);
    }

    public void write(double d) throws IOException {
        String s = String.valueOf(d);
        s = s + doublePadTable[s.length()];
        this.writeStringWoLen(s);
    }

    public void write(boolean b) throws IOException {
        if (b) {
            this.outputStream.write("t".getBytes("US-ASCII"));
        } else {
            this.outputStream.write("f".getBytes("US-ASCII"));
        }
    }

    public void writeStringWoLen(String s) throws IOException {
        this.outputStream.write(s.getBytes("US-ASCII"));
    }

    public void write(String s) throws IOException {
        if (s == null) {
            this.write(-1);
            return;
        }
        this.write(s.length());
        this.writeStringWoLen(s);
    }

    public void write(String[] stringArray) throws IOException {
        if (stringArray == null) {
            this.write(-1);
            return;
        }
        this.write(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.write(string);
        }
    }

    public void write(String[][] ddStringArray) throws IOException {
        if (ddStringArray == null) {
            this.write(-1);
            return;
        }
        for (int i = 0; i < ddStringArray.length; ++i) {
            String[] strings = ddStringArray[i];
            this.write(strings);
        }
    }

    public int readInt() throws IOException {
        byte[] buffer = this.reader.readExact(INT_LEN);
        String s = new String(buffer, "US-ASCII");
        return Integer.parseInt(s.trim());
    }

    public int[] readIntArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        int[] intArray = new int[len];
        for (int i = 0; i < len; ++i) {
            intArray[i] = this.readInt();
        }
        return intArray;
    }

    public long readLong() throws IOException {
        byte[] buffer = this.reader.readExact(LONG_LEN);
        String s = new String(buffer, "US-ASCII");
        return Long.parseLong(s.trim());
    }

    public double readDouble() throws IOException {
        byte[] buffer = this.reader.readExact(DBL_LEN);
        String s = new String(buffer, "US-ASCII");
        return Double.parseDouble(s.trim());
    }

    public String readString() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        byte[] buffer = this.reader.readExact(len);
        return new String(buffer, "US-ASCII");
    }

    public String[] readStringArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        String[] result = new String[len];
        for (int ix = 0; ix < len; ++ix) {
            result[ix] = this.readString();
        }
        return result;
    }

    public String[][] read2dStringArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        String[][] result = new String[len][];
        for (int ix = 0; ix < len; ++ix) {
            result[ix] = this.readStringArray();
        }
        return result;
    }

    public boolean readBoolean() throws IOException {
        byte[] buffer = this.reader.readExact(1);
        return buffer[0] == 116;
    }

    public void write(int[] ia) throws IOException {
        if (ia == null) {
            this.write(-1);
            return;
        }
        int len = ia.length;
        this.write(len);
        for (int i = 0; i < ia.length; ++i) {
            int j = ia[i];
            this.write(j);
        }
    }

    public int[] read() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        int[] ia = new int[len];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = this.readInt();
        }
        return ia;
    }

    public static byte[] getFingerprintInBytes(int[] ints) {
        byte[] bytes = new byte[ints.length * 4];
        int j = 0;
        for (int i = 0; i < ints.length; ++i) {
            int x = ints[i];
            bytes[j++] = (byte)(x >>> 24 & 0xFF);
            bytes[j++] = (byte)(x >>> 16 & 0xFF);
            bytes[j++] = (byte)(x >>> 8 & 0xFF);
            bytes[j++] = (byte)(x & 0xFF);
        }
        return bytes;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void setReader(ExactByteCountReader reader) {
        this.reader = reader;
    }

    public abstract void marshall(ValueObject var1);

    public abstract void unmarshall(ValueObject var1);

    static {
        CodecBase.initPadTable(intPadTable);
        longPadTable = new String[LONG_LEN];
        CodecBase.initPadTable(longPadTable);
        doublePadTable = new String[DBL_LEN];
        CodecBase.initPadTable(doublePadTable);
    }
}

