/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.tunnel.codec;

import chemaxon.jchem.cartridge.tunnel.codec.ExactByteCountReader;
import java.io.IOException;
import java.io.InputStream;

public class ExactReaderAdapter
implements ExactByteCountReader {
    private InputStream inputStream;

    public ExactReaderAdapter(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public byte[] readExact(int nrBytesRequested) throws IOException {
        byte[] result = new byte[nrBytesRequested];
        int totalReadCount = 0;
        int remainingCount = nrBytesRequested - totalReadCount;
        int readCount = this.inputStream.read(result, totalReadCount, remainingCount);
        while (readCount != -1 && totalReadCount != nrBytesRequested) {
            remainingCount = nrBytesRequested - (totalReadCount += readCount);
            readCount = this.inputStream.read(result, totalReadCount, remainingCount);
        }
        if (totalReadCount > nrBytesRequested) {
            throw new IllegalStateException("more read than requested");
        }
        if (totalReadCount < nrBytesRequested) {
            byte[] tmp = new byte[totalReadCount];
            System.arraycopy(result, 0, tmp, 0, totalReadCount);
            return tmp;
        }
        return result;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }
}

