/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.tunnel.index;

import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.tunnel.SessionInfo;
import chemaxon.jchem.cartridge.tunnel.TableOpInfo;

public class IndexingInfo
extends TableOpInfo {
    public static final int DUPLICATE_FILTERING_NONE = 0;
    public static final int DUPLICATE_FILTERING_ON = 1;
    public static final int DUPLICATE_FILTERING_EXCLUSIVE = 2;
    public static final int DUPLICATE_FILTERING_TAUTOMER = 4;
    public static final String ON_ERROR_FAIL_IMMEDIATELY = "true";
    public static final String ON_ERROR_FAIL_AT_COMPLETION = "false";
    public static final String ON_ERROR_FAIL_NEVER = "never";
    public static final String ERRMSG_INVALID_INSERT_SESSION_COUNT = "Currently the only valid value for insSessCnt is 1";
    private String tablePartition;
    private String errorHandlingMode;
    private String tableType;
    private int duplicateFiltering;
    private boolean switchOffAllProtectionsTdf;
    private int insertSessionCount;
    private int refreshPeriod;
    protected boolean skipAutoCalcCt;

    public IndexingInfo(String baseSchemaName, String baseTableName, String indexSchemaName, String indexName, String indexPartion, String indexTblName, int idxSubType, String jcpropTableName, SessionInfo userInfo, String userAssignedId, int threadCount, String indexedColumnName, String tablePartition, String haltOnBadFormat, String subtype, int duplicateFiltering, boolean swoffAllProtTdf, int insertSessionCount, int refreshPeriod) {
        super(baseSchemaName, baseTableName, indexSchemaName, indexName, indexPartion, indexedColumnName, indexTblName, idxSubType, jcpropTableName, userInfo, userAssignedId, threadCount);
        this.errorHandlingMode = IndexingInfo.parseErrorHandlingOption(haltOnBadFormat);
        this.tablePartition = tablePartition;
        this.tableType = subtype;
        this.duplicateFiltering = duplicateFiltering;
        this.switchOffAllProtectionsTdf = swoffAllProtTdf;
        this.insertSessionCount = insertSessionCount;
        this.refreshPeriod = refreshPeriod;
        if (insertSessionCount > 1 || insertSessionCount < 0) {
            throw new IllegalArgumentException("Currently the only valid value for insSessCnt is 1 (was " + insertSessionCount + ")");
        }
    }

    public IndexingInfo(JCartIndexDescriptor idesc, SessionInfo userInfo, String userAssignedId, int threadCount, String haltOnBadFormat, String subtype, int insertSessionCount) {
        super(idesc, userInfo, userAssignedId, threadCount);
        this.errorHandlingMode = IndexingInfo.parseErrorHandlingOption(haltOnBadFormat);
        this.tableType = subtype;
        this.insertSessionCount = insertSessionCount;
    }

    public static String parseErrorHandlingOption(String haltOnBadFormat) {
        if (haltOnBadFormat == null) {
            return ON_ERROR_FAIL_IMMEDIATELY;
        }
        String userInputLc = haltOnBadFormat.toLowerCase();
        if (userInputLc.equals("y") || userInputLc.equals(ON_ERROR_FAIL_IMMEDIATELY) || userInputLc.equals("i")) {
            return ON_ERROR_FAIL_IMMEDIATELY;
        }
        if (userInputLc.equals("n") || userInputLc.equals(ON_ERROR_FAIL_AT_COMPLETION) || userInputLc.equals("c")) {
            return ON_ERROR_FAIL_AT_COMPLETION;
        }
        if (userInputLc.equals("nf") || userInputLc.equals(ON_ERROR_FAIL_NEVER)) {
            return ON_ERROR_FAIL_NEVER;
        }
        throw new IllegalArgumentException("Invalid option for haltOnBadFormat/haltOnError: " + haltOnBadFormat);
    }

    public String getTablePartition() {
        return this.tablePartition;
    }

    public String getErrorHandlingMode() {
        return this.errorHandlingMode;
    }

    public String getTableType() {
        return this.tableType;
    }

    public int getDuplicateFiltering() {
        return this.duplicateFiltering;
    }

    public boolean isDuplicateFiltering() {
        return (this.duplicateFiltering & 1) == 1;
    }

    public boolean isTautomerDuplicateFiltering() {
        return (this.duplicateFiltering & 4) == 4;
    }

    public boolean isSwitchOffAllProtectionsTdf() {
        return this.switchOffAllProtectionsTdf;
    }

    public boolean isUniqueLikeDuplicateFiltering() {
        if (this.isDuplicateFiltering()) {
            return (this.duplicateFiltering & 2) == 2;
        }
        return false;
    }

    public boolean isSkipAutoCalcCt() {
        return this.skipAutoCalcCt;
    }

    public int getInsertSessionCount() {
        return this.insertSessionCount;
    }

    @Override
    public String toString() {
        return "IndexingInfo[" + super.toString() + ",tablePartition=" + this.tablePartition + ",errorHandlingMode=" + this.errorHandlingMode + ", tableType=" + this.tableType + ", duplicateFiltering=" + this.duplicateFiltering + ", insertSessionCount=" + this.insertSessionCount + ", skipAutoCalcCt=" + this.skipAutoCalcCt + ",refreshPeriod=" + this.refreshPeriod + "]";
    }

    public int getRefreshPeriod() {
        return this.refreshPeriod;
    }
}

