/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.tunnel.search;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.tunnel.search.ScreenParams;
import chemaxon.jchem.cartridge.tunnel.search.SearchStandardizationParams;
import chemaxon.jchem.cartridge.tunnel.search.TautomerSearchParams;
import chemaxon.jchem.interop.InteropOptions;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class MolSearchParams
implements Serializable {
    private int structureType;
    private byte[] query;
    private byte[] target;
    private int searchType;
    private String options;
    private boolean absoluteStereo;
    private SearchStandardizationParams standardizationInfo;
    private TautomerSearchParams tautomerGenInfo;
    private ScreenParams screenInfo;

    public MolSearchParams(int structureType, byte[] query, byte[] target, int searchType, String options, boolean absStereo, SearchStandardizationParams standardizationInfo, TautomerSearchParams tautomerGenInfo, ScreenParams screenInfo) {
        this.structureType = structureType;
        this.query = query;
        this.target = target;
        this.searchType = searchType;
        this.options = options;
        this.absoluteStereo = absStereo;
        this.standardizationInfo = standardizationInfo;
        this.tautomerGenInfo = tautomerGenInfo;
        this.screenInfo = screenInfo;
    }

    public int getStructureType() {
        return this.structureType;
    }

    public byte[] getQuery() {
        return this.query;
    }

    public byte[] getTarget() {
        return this.target;
    }

    public int getSearchType() {
        return this.searchType;
    }

    public String getOptions() {
        return this.options;
    }

    public boolean isAbsoluteStereo() {
        return this.absoluteStereo;
    }

    public SearchStandardizationParams getStandardizationInfo() {
        return this.standardizationInfo;
    }

    public TautomerSearchParams getTautomerGenInfo() {
        return this.tautomerGenInfo;
    }

    public ScreenParams getScreenInfo() {
        return this.screenInfo;
    }

    public String toString() {
        try {
            return "MolSearchInfo [structureType=" + InteropOptions.tableTypeToString(this.structureType) + ", query=" + JFunctions.decodeDbString(this.query) + ", target=" + JFunctions.decodeDbString(this.target) + ", searchType=" + this.searchType + ", options=" + this.options + ", absStereo=" + this.absoluteStereo + ", standardizationInfo=" + this.standardizationInfo + ", tautomerGenInfo=" + this.tautomerGenInfo + ", screenInfo=" + this.screenInfo + "]";
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

