/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.util;

import chemaxon.jchem.cartridge.tunnel.search.PredicateInfo;

public class CardinalPredicat {
    public final double start;
    public final double stop;
    public final boolean includeStart;
    public final boolean includeStop;
    public int operator;

    public CardinalPredicat(PredicateInfo predInfo) {
        try {
            this.start = predInfo.getStart();
            this.stop = predInfo.getStop();
            this.operator = predInfo.getOpFlag();
            this.includeStart = (this.operator & 4) == 4;
            this.includeStop = (this.operator & 8) == 8;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isMatching(double value) {
        boolean matches = false;
        matches = new Double(this.start).isNaN() ? (this.operator == 8 ? value <= this.stop : value < this.stop) : (new Double(this.stop).isNaN() ? (this.operator == 4 ? value >= this.start : value > this.start) : (this.operator == 13 ? value == this.start : (this.operator == 12 ? value <= this.stop && value >= this.start : (this.operator == 8 ? value <= this.stop && value > this.start : (this.operator == 4 ? value < this.stop && value >= this.start : value < this.stop && value > this.start)))));
        return matches;
    }

    public String toString() {
        return "CardinalPredicat [start=" + this.start + ", stop=" + this.stop + ", includeStart=" + this.includeStart + ", includeStop=" + this.includeStop + ", operator=" + this.operator + "]";
    }
}

