/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.util;

import chemaxon.jchem.cartridge.rmi.impl.scanresult.TableScanBaseImpl;
import chemaxon.jchem.cartridge.servlets.JCartConnectionManager;
import chemaxon.jchem.cartridge.tunnel.GlobalMemoryInfo;
import chemaxon.jchem.cartridge.tunnel.UserInfo;
import chemaxon.jchem.db.JChemSearch;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Environment {
    private static Logger logger = Logger.getLogger(Environment.class.getName());
    public static final String[] SUPPORTED_JAVAVM_VENDORS = new String[]{"Sun Microsystems Inc.", "Hewlett-Packard Company"};
    public static final String REQUIRED_JAVAVM_VERSION = "1.4.2";
    private static Environment instance;
    private String vmVersion;
    private String javaVersion;
    private String vmVendor;
    private String jchemVersion;
    private int jchemIndexVersion;
    private String jdbcDriverVersion;

    public static synchronized Environment getInstance() {
        if (instance == null) {
            instance = new Environment();
        }
        return instance;
    }

    public Environment() {
        this.identifyHostJvm();
        this.identifyJChemVersion();
    }

    private void identifyHostJvm() {
        this.vmVendor = System.getProperty("java.vm.vendor");
        this.javaVersion = System.getProperty("java.version");
        this.vmVersion = System.getProperty("java.vm.version");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("java.vm.vendor=" + this.vmVendor + ", java.version=" + this.javaVersion + ", java.vm.version=" + this.vmVersion);
        }
    }

    private void identifyJChemVersion() {
        try {
            Class<?> vinfo = Class.forName("chemaxon.jchem.version.VersionInfo");
            Field jcVersionField = vinfo.getField("JCHEM_VERSION");
            Object jcVersion = jcVersionField.get(null);
            this.jchemVersion = (String)jcVersion;
            Field jcTableVersionField = vinfo.getField("JCHEM_TABLE_VERSION");
            this.jchemIndexVersion = jcTableVersionField.getInt(null);
        }
        catch (Throwable throwable) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "error", throwable);
            }
            throw new RuntimeException("Problem identifying versions", throwable);
        }
    }

    private void checkJavaVmVendor() {
        StringBuffer unMatchedVendor = new StringBuffer();
        for (int ix = 0; ix < SUPPORTED_JAVAVM_VENDORS.length; ++ix) {
            String supportedVmVendor = SUPPORTED_JAVAVM_VENDORS[ix];
            if (this.vmVendor.startsWith(supportedVmVendor)) {
                return;
            }
            if (unMatchedVendor.length() > 0) {
                unMatchedVendor.append(", ");
            }
            unMatchedVendor.append(supportedVmVendor);
        }
        throw new RuntimeException("Java VM vendor " + this.vmVendor + " does not match any of " + unMatchedVendor.toString());
    }

    private void checkJavaVmVersion() {
        if (this.vmVersion.compareTo(REQUIRED_JAVAVM_VERSION) < 0) {
            String s = this.vmVersion + ", required Java VM version: " + REQUIRED_JAVAVM_VERSION + " or newer";
            throw new RuntimeException(s);
        }
    }

    public synchronized String getDescription(UserInfo userInfo) throws Exception {
        if (this.jdbcDriverVersion == null) {
            this.identifyJdbcDriverVersion(userInfo);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Java VM vendor: ").append(this.vmVendor).append("\n");
        sb.append("Java version: ").append(this.javaVersion).append("\n");
        sb.append("Java VM version: ").append(this.vmVersion).append("\n");
        sb.append("JChem version: ").append(this.jchemVersion).append("\n");
        sb.append("JChem Index version: ").append(this.jchemIndexVersion).append("\n");
        sb.append("JDBC driver version: ").append(this.jdbcDriverVersion).append("\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void identifyJdbcDriverVersion(UserInfo userInfo) throws Exception {
        Connection conn = JCartConnectionManager.getInstance().getConnection(userInfo);
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            this.jdbcDriverVersion = metaData.getDriverVersion();
            if (logger.isLoggable(Level.INFO)) {
                logger.info("JDBC driver version: " + this.jdbcDriverVersion);
            }
        }
        finally {
            conn.close();
        }
    }

    public String getVmVersion() {
        return this.vmVersion;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getVmVendor() {
        return this.vmVendor;
    }

    public String getJchemVersion() {
        return this.jchemVersion;
    }

    public int getJchemIndexVersion() {
        return this.jchemIndexVersion;
    }

    public String getJdbcDriverVersion() {
        return this.jdbcDriverVersion;
    }

    public GlobalMemoryInfo getGlobalMemoryInfo() {
        long d = 0x100000L;
        GlobalMemoryInfo ginfo = new GlobalMemoryInfo();
        ginfo.totalJvmMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
        ginfo.freeJvmMemory = Runtime.getRuntime().freeMemory() / 0x100000L;
        ginfo.maxJvmMemory = Runtime.getRuntime().maxMemory() / 0x100000L;
        Hashtable<String, Long> ctables = JChemSearch.getCachedTables();
        String[][] ctableArray = new String[ctables.size()][];
        Enumeration<String> iterTableNames = ctables.keys();
        int ix = 0;
        while (iterTableNames.hasMoreElements()) {
            String name = iterTableNames.nextElement();
            Long value = ctables.get(name);
            String idxName = TableScanBaseImpl.getIndexNameByIdxTableQName(name);
            if (idxName == null) {
                idxName = "~" + name;
            }
            String[] pair = new String[]{idxName, String.valueOf(value / 0x100000L)};
            ctableArray[ix] = pair;
            ++ix;
        }
        ginfo.cachedTables = ctableArray;
        return ginfo;
    }
}

