/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.util;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class JCartLogger {
    private String name;
    private int level = 1;
    private static final Map loggers = new HashMap();
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;

    public static JCartLogger getLogger(Class clazz) {
        String name = clazz.getName();
        return JCartLogger.getLogger(name);
    }

    public static JCartLogger getLogger(String name) {
        JCartLogger logger = (JCartLogger)loggers.get(name);
        if (logger == null) {
            if (JavaStoredProcSession.getJspConnectionReflect() == null) {
                return JCartLogger.createJdkLogger(name);
            }
            logger = new JCartLogger(name);
            String parentName = "";
            for (JCartLogger parent : loggers.values()) {
                if (!name.startsWith(parent.name) || parent.name.length() <= parentName.length()) continue;
                parentName = parent.name;
            }
            if (parentName.length() > 0) {
                JCartLogger parent;
                parent = (JCartLogger)loggers.get(parentName);
                logger.setLevel(parent.getLevel());
            }
            loggers.put(name, logger);
        }
        return logger;
    }

    private static JCartLogger createJdkLogger(String name) {
        try {
            Class<?> clazz = Class.forName("chemaxon.jchem.cartridge.util.JCartLoggerJdkAdapter");
            Method m = clazz.getMethod("getLogger", String.class);
            return (JCartLogger)m.invoke(null, name);
        }
        catch (Throwable throwable) {
            System.err.println(JCartLogger.stackTrace(throwable));
            throw new RuntimeException(throwable.getMessage());
        }
    }

    public static void setLevel(String loggerName, int level) {
        JCartLogger.getLogger(loggerName).setLevel(level);
        for (JCartLogger logger : loggers.values()) {
            if (!logger.name.startsWith(loggerName)) continue;
            logger.setLevel(level);
        }
    }

    protected JCartLogger(String name) {
        this.name = name;
    }

    public boolean isInfoEnabled() {
        return this.level >= 2;
    }

    public void info(String msg) {
        JCartLogger.log("INFO - " + this.name + ": " + msg);
    }

    public boolean isWarningEnabled() {
        return this.level >= 1;
    }

    public void warning(String msg) {
        JCartLogger.log("WARNING - " + this.name + ": " + msg);
    }

    public boolean isErrorEnabled() {
        return this.level >= 0;
    }

    public void error(String msg) {
        JCartLogger.log("ERROR - " + this.name + ": " + msg);
    }

    public void error(Throwable throwable) {
        JCartLogger.log("ERROR - " + this.name + ": " + JCartLogger.stackTrace(throwable));
    }

    public static String stackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public boolean isDebugEnabled() {
        return this.level >= 3;
    }

    public void debug(String msg) {
        JCartLogger.log("DEBUG - " + this.name + ": " + msg);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public static void log(String message) {
        try {
            JFunctions.trace(message);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JCartLogger logger = JCartLogger.getLogger("zazika");
        logger.setLevel(2);
        logger.debug("No output");
        logger.warning("Do output");
    }
}

