/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.util;

import chemaxon.jchem.cartridge.util.JCartLogger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JCartLoggerJdkAdapter
extends JCartLogger {
    private Logger jdkLogger;

    public JCartLoggerJdkAdapter(String name, Logger logger) {
        super(name);
        this.jdkLogger = logger;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.jdkLogger.isLoggable(Level.INFO);
    }

    @Override
    public void info(String msg) {
        this.jdkLogger.info(msg);
    }

    @Override
    public boolean isWarningEnabled() {
        return this.jdkLogger.isLoggable(Level.WARNING);
    }

    @Override
    public void warning(String msg) {
        this.jdkLogger.warning(msg);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.jdkLogger.isLoggable(Level.SEVERE);
    }

    @Override
    public void error(String msg) {
        this.jdkLogger.severe(msg);
    }

    @Override
    public void error(Throwable throwable) {
        this.jdkLogger.log(Level.SEVERE, "error", throwable);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.jdkLogger.isLoggable(Level.FINER);
    }

    @Override
    public void debug(String msg) {
        this.jdkLogger.finer(msg);
    }

    @Override
    public int getLevel() {
        Level l = this.jdkLogger.getLevel();
        if (l == Level.ALL || l == Level.FINEST || l == Level.FINER || l == Level.FINE) {
            return 3;
        }
        if (l == Level.INFO) {
            return 2;
        }
        if (l == Level.WARNING) {
            return 1;
        }
        if (l == Level.SEVERE) {
            return 0;
        }
        throw new IllegalStateException("Unknown level: " + l);
    }

    @Override
    public void setLevel(int level) {
        switch (level) {
            case 3: {
                this.jdkLogger.setLevel(Level.FINER);
                break;
            }
            case 2: {
                this.jdkLogger.setLevel(Level.INFO);
                break;
            }
            case 1: {
                this.jdkLogger.setLevel(Level.WARNING);
                break;
            }
            case 0: {
                this.jdkLogger.setLevel(Level.SEVERE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown level: " + level);
            }
        }
    }

    public static JCartLoggerJdkAdapter getLogger(String className) {
        return new JCartLoggerJdkAdapter(className, Logger.getLogger(className));
    }
}

