/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.util;

import chemaxon.jchem.interop.JChemServerProperties;
import chemaxon.util.DotfileUtil;
import java.io.File;
import java.io.IOException;

public class JccConfig
extends JChemServerProperties {
    public static final String CONFIG_FILE_KEY = "chemaxon.jchem.cartridge.config.file";
    public static final String ALLOW_SPEC_CREDENTIALS_KEY = "allowed.to.specify.credentials";
    public static final String ALLOW_SPEC_CREDENTIALS_SEP = ",";
    public static final String PASSW_ALWAYS_REQD_KEY = "password.always.required";
    public static final String SKIP_CONN_CONFIG_SANITY_CHECK_KEY = "skip.conn.config.sanity.check";
    public static final String JCHEM_SERVER_PORT = "jchem.server.port";
    public static final String IDX_COMMIT_INTERVAL_KEY = "idx.commit.interval";
    public static final String LOGGING_CONFIG_FILE_KEY = "logging.config.file";
    public static final String ZOMBIE_TASK_TIMEOUT_KEY = "chemaxon.jchem.cartridge.zombie.task.timeout";
    public static final int DEFAULT_ZOMBIE_TASK_TIMEOUT = 86400;
    private static JccConfig instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JccConfig getInstance() throws IOException {
        Class<JccConfig> clazz = JccConfig.class;
        synchronized (JccConfig.class) {
            if (instance == null) {
                instance = new JccConfig();
                instance.load();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private JccConfig() {
        super(JccConfig.getPropsFileName());
    }

    public void setPropsFileName(String propsFileName) throws IOException {
        this.propsFileName = propsFileName;
        this.clear();
        this.load();
    }

    private static String getPropsFileName() {
        String configFilePath = System.getProperty(CONFIG_FILE_KEY);
        if (configFilePath != null) {
            File f = new File(configFilePath);
            if (!f.exists()) {
                throw new IllegalArgumentException("Config file cannot be found: " + configFilePath);
            }
            return configFilePath;
        }
        String fileSep = System.getProperty("file.separator");
        String chemDir = DotfileUtil.getDotDir().getAbsolutePath();
        if (chemDir.endsWith(fileSep)) {
            chemDir = chemDir.substring(0, chemDir.length() - 1);
        }
        File d = new File(chemDir);
        d.mkdirs();
        return chemDir + fileSep + ".cartridge";
    }
}

