/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.util;

import chemaxon.jchem.cartridge.util.JccConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LoggingConfigurator {
    public LoggingConfigurator() {
        try {
            Properties logProps = this.readLoggingConfigFile();
            this.injectLoggingOutputDir(logProps);
            this.setLevels(logProps);
            this.setLoggingProperties(logProps);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readLoggingConfigFile() throws IOException {
        Properties logProps = new Properties();
        String loggingConfigFile = System.getProperty("logging.config.file");
        if (loggingConfigFile == null) {
            loggingConfigFile = JccConfig.getInstance().getProperty("logging.config.file");
        }
        FileInputStream fin = new FileInputStream(loggingConfigFile);
        try {
            logProps.load(fin);
        }
        finally {
            fin.close();
        }
        return logProps;
    }

    private void injectLoggingOutputDir(Properties logProps) throws IOException {
        String patternKey = "java.util.logging.FileHandler.pattern";
        String loggingOutputDir = JccConfig.getInstance().getProperty("logging.output.dir");
        File f = new File(loggingOutputDir);
        if (f.exists()) {
            if (!f.isDirectory()) {
                throw new IllegalArgumentException(loggingOutputDir + " exists but it is not a directory");
            }
        } else {
            f.mkdirs();
        }
        String pattern = logProps.getProperty("java.util.logging.FileHandler.pattern");
        pattern = loggingOutputDir + File.separator + pattern;
        logProps.setProperty("java.util.logging.FileHandler.pattern", pattern);
    }

    public void setLevels(Properties logProps) {
        for (Object key : logProps.keySet()) {
            String propName;
            if (!(key instanceof String) || !(propName = (String)key).endsWith(".level") || propName.length() <= ".level".length()) continue;
            String loggerName = propName.substring(0, propName.length() - ".level".length());
            String propValue = logProps.getProperty(propName);
            Level l = Level.parse(propValue);
            Logger.getLogger(loggerName).setLevel(l);
        }
    }

    private void setLoggingProperties(Properties logProps) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        logProps.store(bout, "JChem Cartridge logging configuration");
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        LogManager.getLogManager().readConfiguration(bin);
    }
}

