/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class OptUtil {
    private OptUtil() {
    }

    public static boolean isChiralFlagSet(String flags) {
        if (flags == null) {
            return false;
        }
        return flags.indexOf(67) != -1 || flags.indexOf(99) != -1;
    }

    public static String[][] createField2ColNameMap(String optionString) {
        if (optionString == null || optionString.length() == 0 || optionString.equals("null")) {
            return null;
        }
        String[][] result = null;
        ArrayList<String[]> l = new ArrayList<String[]>();
        StringTokenizer tokenizer = new StringTokenizer(optionString, ";");
        while (tokenizer.hasMoreTokens()) {
            String f2c = tokenizer.nextToken();
            int eqSignPos = f2c.indexOf(61);
            String field = f2c.substring(0, eqSignPos);
            String column = f2c.substring(eqSignPos + 1);
            l.add(new String[]{field, column});
        }
        result = new String[l.size()][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String[])l.get(i);
        }
        return result;
    }

    public static boolean equals(String[][] a, String[][] b) {
        for (int i = 0; i < b.length; ++i) {
            String[] sa = a[i];
            String[] sb = b[i];
            if (OptUtil.equals(sa, sb)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(String[] a, String[] b) {
        for (int i = 0; i < b.length; ++i) {
            String sa = a[i];
            String sb = b[i];
            if (sa.equals(sb)) continue;
            return false;
        }
        return true;
    }
}

