/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.util;

import chemaxon.jchem.cartridge.tunnel.TaskInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskUtil {
    private static final Logger logger = Logger.getLogger(TaskUtil.class.getName());

    private TaskUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TaskInfo> getTaskInfoList(Connection conn) throws SQLException {
        String sql = "select * from table(jcf.t_get_taskinfo())";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        try {
            ArrayList<TaskInfo> taskList = new ArrayList<TaskInfo>();
            ResultSet rs = pstmt.executeQuery();
            try {
                while (rs.next()) {
                    TaskInfo taskInfo = new TaskInfo();
                    taskInfo.id = rs.getInt("id");
                    taskInfo.userName = rs.getString("user_name");
                    taskInfo.description = rs.getString("description");
                    taskInfo.startTime = rs.getTimestamp("start_time");
                    taskInfo.memoryUsed = rs.getLong("estim_memory_use");
                    taskInfo.timeout = rs.getInt("timeout");
                    taskInfo.lastRescheduled = rs.getTimestamp("last_rescheduled");
                    taskInfo.jccSessionId = rs.getString("jcc_session_id");
                    taskInfo.userAssignedOpId = rs.getString("user_assigned_op_id");
                    taskList.add(taskInfo);
                }
            }
            finally {
                rs.close();
            }
            ArrayList<TaskInfo> arrayList = taskList;
            return arrayList;
        }
        finally {
            pstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJccSessionId(Connection conn) throws SQLException, TaskManagementException {
        String sql = "select jchem_core_pkg.get_jcc_session_id from dual";
        Statement stmt = conn.createStatement();
        try {
            String string;
            ResultSet rs = stmt.executeQuery(sql);
            try {
                if (!rs.next()) {
                    throw new TaskManagementException("No JCC session ID returned");
                }
                string = rs.getString(1);
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return string;
        }
        finally {
            stmt.close();
        }
    }

    public static boolean killTaskByOpId(Connection conn, String jccSessionId, String userAssignedOpId) throws SQLException, TaskManagementException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("jccSessionId=" + jccSessionId + ", userAssignedOpId=" + userAssignedOpId);
        }
        List<TaskInfo> taskList = TaskUtil.getTaskInfoList(conn);
        for (TaskInfo taskInfo : taskList) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Processing " + taskInfo + "...");
            }
            if (!taskInfo.jccSessionId.equals(jccSessionId) || !taskInfo.userAssignedOpId.equals(userAssignedOpId)) continue;
            return TaskUtil.killTask(conn, taskInfo.id);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Couldn't find task: jccSessionId=" + jccSessionId + ", userAssignedOpId=" + userAssignedOpId, new Exception());
        }
        return false;
    }

    public static boolean killTaskByDescFragm(Connection conn, String jccSessionId, String descFragment) throws SQLException, TaskManagementException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("jccSessionId=" + jccSessionId + ", descFragment=" + descFragment);
        }
        List<TaskInfo> taskList = TaskUtil.getTaskInfoList(conn);
        for (TaskInfo taskInfo : taskList) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Processing " + taskInfo + "...");
            }
            if (!taskInfo.jccSessionId.equals(jccSessionId) || !taskInfo.description.contains(descFragment)) continue;
            return TaskUtil.killTask(conn, taskInfo.id);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Couldn't find task: jccSessionId=" + jccSessionId + ", descFragment=" + descFragment, new Exception());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean killTask(Connection conn, long taskId) throws SQLException, TaskManagementException {
        String sql = "select jcc_admin.kill_task(?) from dual";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        try {
            pstmt.setLong(1, taskId);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new TaskManagementException("No result set for " + sql);
            }
            boolean bl = rs.getInt(1) == 1;
            return bl;
        }
        finally {
            pstmt.close();
        }
    }

    public static boolean checkTaskKilledException(Connection conn, SQLException sqlException) throws SQLException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "checking exception", sqlException);
        }
        int majVer = conn.getMetaData().getDatabaseMajorVersion();
        int minVer = conn.getMetaData().getDatabaseMinorVersion();
        if (majVer == 10 && sqlException.getMessage().contains("ORA-00600")) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("ORA-00600 for " + majVer + "." + minVer);
            }
            return false;
        }
        if (sqlException.getErrorCode() == 29902 && sqlException.getMessage().contains("ORA-20107")) {
            return true;
        }
        if (sqlException.getErrorCode() == 29903 && sqlException.getMessage().contains("ORA-20107")) {
            return true;
        }
        if (sqlException.getErrorCode() == 29904 && sqlException.getMessage().contains("ORA-20107")) {
            return true;
        }
        throw sqlException;
    }

    public static class TaskManagementException
    extends Exception {
        public TaskManagementException(String msg) {
            super(msg);
        }
    }
}

