/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.util.cpool;

import chemaxon.jchem.cartridge.util.cpool.JCartDataSource;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;

public class Ora9iDataSource
implements JCartDataSource {
    private Object cache;
    private String url;
    private String login;
    private String password;

    public Ora9iDataSource(String url, String login, String password) throws SQLException {
        this.url = url;
        this.login = login;
        this.password = password;
        this.init();
    }

    private void init() {
        try {
            OracleConnectionPoolDataSource ocpds = new OracleConnectionPoolDataSource();
            ocpds.setDriverType("thin");
            ocpds.setURL(this.url);
            Class<?> c = Class.forName("oracle.jdbc.pool.OracleConnectionCacheImpl");
            Constructor<?> constructor = c.getConstructor(OracleConnectionPoolDataSource.class);
            this.cache = constructor.newInstance(ocpds);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            Method closeMethod = this.cache.getClass().getMethod("close", String.class, String.class);
            closeMethod.invoke(this.cache, (Object[])new String[]{this.login, this.password});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            Method closeMethod = this.cache.getClass().getMethod("getConnection", String.class, String.class);
            return (Connection)closeMethod.invoke(this.cache, this.login, this.password);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reinitialize() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetPassword(String password) throws SQLException {
        this.password = password;
    }

    @Override
    public String getLogin() {
        return this.login;
    }

    @Override
    public void purge(boolean all) throws SQLException {
        this.close();
        this.init();
    }
}

