/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.util.probe;

import chemaxon.jchem.cartridge.util.probe.Probe;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Probes {
    private static final ConcurrentMap<String, Probe> probes = new ConcurrentHashMap<String, Probe>();
    private static final Probes instance = new Probes();
    private static final Logger logger = Logger.getLogger(Probes.class.getName());

    void add(Probe p) {
        if (logger.isLoggable(Level.FINER)) {
            String msg = "Adding " + p;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, msg, new Exception("****** debug ******"));
            } else {
                logger.finer(msg);
            }
        }
        probes.put(p.getName(), p);
    }

    public Probe get(Class<?> enclosingClass, String name) {
        if (logger.isLoggable(Level.FINER)) {
            String msg = "getting " + Probes.getName(enclosingClass, name);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, msg, new Exception("****** debug ******"));
            } else {
                logger.finer(msg);
            }
        }
        try {
            Class.forName(enclosingClass.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Probe p = (Probe)probes.get(Probes.getName(enclosingClass, name));
        return p;
    }

    public static Probes getInstance() {
        return instance;
    }

    public static String getName(Class<?> enclosingClass, String name) {
        return enclosingClass.getName() + "-" + name;
    }
}

