/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cluster.monitor;

import chemaxon.jchem.cluster.JChemMasterNodeImpl;
import chemaxon.jchem.cluster.JChemNodeClient;
import chemaxon.jchem.cluster.NodeManager;
import chemaxon.jchem.cluster.monitor.HeartBeatMonitor;
import chemaxon.jchem.cluster.util.RmiUtil;
import chemaxon.jchem.cluster.util.Trace;
import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.util.LinkedList;
import java.util.List;

public class HeartBeatMonitorImpl
extends UnicastRemoteObject
implements HeartBeatMonitor,
Runnable {
    public static long DEFAULT_HEARTBEAT_INTERVAL = 5000L;
    private long heartBeatInterval;
    private JChemMasterNodeImpl masterNode;
    private List liveNodeList = new LinkedList();
    private List deadNodeList = new LinkedList();

    public HeartBeatMonitorImpl(JChemMasterNodeImpl masterNode, long heartBeatInterval) throws RemoteException {
        super(0, RmiUtil.getInterruptibleRMISocketFactory(), RmiUtil.getInterruptibleRMISocketFactory());
        this.masterNode = masterNode;
        this.setHeartBeatInterval(heartBeatInterval);
    }

    public void setHeartBeatInterval(long heartBeatInterval) {
        if (heartBeatInterval == -1L) {
            this.heartBeatInterval = DEFAULT_HEARTBEAT_INTERVAL;
        } else {
            if (heartBeatInterval <= 0L) {
                throw new IllegalArgumentException("heartBeatInterval must be greater than zero");
            }
            this.heartBeatInterval = heartBeatInterval;
        }
    }

    @Override
    public synchronized void run() {
        try {
            try {
                while (true) {
                    this.wait(this.heartBeatInterval);
                    this.checkExpired(this.heartBeatInterval);
                }
            }
            catch (RemoteException rme) {
                Trace.err(rme);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized JChemNodeClient[] getJChemNodeClients() {
        JChemNodeClient[] nodeClients = new JChemNodeClient[this.liveNodeList.size()];
        this.liveNodeList.toArray(nodeClients);
        return nodeClients;
    }

    private synchronized void checkExpired(long heartBeatInterval) throws RemoteException {
        long now = System.currentTimeMillis();
        for (JChemNodeClient nodeClient : this.liveNodeList) {
            if (now - nodeClient.getTimeStamp() <= heartBeatInterval * 2L) continue;
            nodeClient.reapNode();
            break;
        }
    }

    @Override
    public long beat(int slavePort) throws RemoteException {
        String slaveHost = null;
        try {
            slaveHost = HeartBeatMonitorImpl.getClientHost();
        }
        catch (ServerNotActiveException serverNotActiveException) {
            Trace.err(serverNotActiveException);
            throw new RemoteException("Problem with identifying slave host", serverNotActiveException);
        }
        if (this.masterNode != null) {
            this.beat(slaveHost, slavePort);
            return this.heartBeatInterval;
        }
        Trace.info("Heart beat from: " + slaveHost + ":" + slavePort);
        return 5000L;
    }

    private synchronized void beat(String host, int port) throws RemoteException {
        JChemNodeClient nodeClient = this.getClientNode(this.liveNodeList, host, port);
        if (nodeClient == null) {
            nodeClient = this.getClientNode(this.deadNodeList, host, port);
            if (nodeClient == null) {
                nodeClient = new JChemNodeClient(host, port);
                this.liveNodeList.add(nodeClient);
            } else {
                this.deadNodeList.remove(nodeClient);
                nodeClient.updateTimeStamp();
                this.liveNodeList.add(nodeClient);
            }
        } else {
            nodeClient.updateTimeStamp();
        }
    }

    private JChemNodeClient getClientNode(List list, String host, int port) {
        for (JChemNodeClient current : list) {
            if (!current.getHostname().equals(host) || current.getPort() != port) continue;
            return current;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        try {
            NodeManager.start(1099, new HeartBeatMonitorImpl(null, -1L));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

