/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cluster.search.client;

import chemaxon.jchem.cluster.JChemNodeFeatureClient;
import chemaxon.jchem.cluster.search.JcSearchNode;
import chemaxon.jchem.cluster.search.JcSearchNodeWorker;
import chemaxon.jchem.cluster.search.client.JcSearchNodeWorkerClient;
import chemaxon.struc.Molecule;
import chemaxon.util.MolHandler;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;

public class JcSearchNodeClient
extends JChemNodeFeatureClient {
    private JcSearchNode jcSearchNode;
    private List workerList = new LinkedList();

    public int getAvailableProcessors() throws IOException {
        return -1;
    }

    public JcSearchNodeWorker createJcSearchNodeWorker() throws RemoteException {
        return this.jcSearchNode.createWorker();
    }

    void remove(JcSearchNodeWorkerClient jcSearchNodeWorkerClient) {
        this.workerList.remove(jcSearchNodeWorkerClient);
    }

    public static void main(String[] args) throws Exception {
        Molecule m1 = new MolHandler("c1ccccc1").getMolecule();
        Molecule m2 = new MolHandler("Brc1ccccc1").getMolecule();
        final Molecule[] mols = new Molecule[]{m1, m2};
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        JcSearchNodeClient node = null;
        int cpuNr = node.getAvailableProcessors();
        final int[] hitCount = new int[1];
        for (int i = 0; i < cpuNr; ++i) {
            final JcSearchNodeWorker worker = node.createJcSearchNodeWorker();
            worker.setQuery(mols[i % mols.length]);
            worker.setSearchType(i % 5);
            Thread localThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    try {
                        int ix = 0;
                        while (ix < 1000) {
                            boolean hit = worker.isMatching(mols[ix % mols.length].toFormat("cxsmiles"));
                            int[] nArray = hitCount;
                            // MONITORENTER : hitCount
                            if (hit) {
                                hitCount[0] = hitCount[0] + 1;
                            }
                            // MONITOREXIT : nArray
                            ++ix;
                        }
                        return;
                    }
                    catch (Throwable tbl) {
                        tbl.printStackTrace();
                        return;
                    }
                    finally {
                        try {
                            worker.dispose();
                        }
                        catch (Throwable tbl) {
                            tbl.printStackTrace();
                        }
                    }
                }
            };
            localThread.start();
        }
    }
}

