/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cluster.search.server;

import chemaxon.jchem.cluster.NodeManager;
import chemaxon.jchem.cluster.search.JcSearchNodeWorker;
import chemaxon.jchem.cluster.search.server.JcSearchNodeImpl;
import chemaxon.jchem.cluster.search.server.LocalJcSearchWorker;
import chemaxon.jchem.cluster.search.server.TestLocalWorker;
import chemaxon.struc.Molecule;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class JcSearchNodeWorkerImpl
extends UnicastRemoteObject
implements JcSearchNodeWorker {
    public static final Class DEFAULT_LOCAL_WORKER_IMPL_CLASS = TestLocalWorker.class;
    private static int idCounter;
    private int id;
    private JcSearchNodeImpl node;
    private LocalJcSearchWorker local;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JcSearchNodeWorkerImpl(JcSearchNodeImpl node) throws Exception {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.id = ++idCounter;
        }
        this.node = node;
        this.local = this.createLocalWorkerImpl();
    }

    @Override
    public void dispose() throws RemoteException {
        this.node.remove(this);
    }

    @Override
    public boolean isMatching(String structure) throws RemoteException {
        return this.local.isMatching(structure);
    }

    @Override
    public void setQuery(Molecule query) throws RemoteException {
        this.local.setQuery(query);
    }

    @Override
    public void setSearchType(int searchType) throws RemoteException {
        this.local.setSearchType(searchType);
    }

    private String getWorkerName() {
        return this.getClass().getName() + " - " + this.id;
    }

    private LocalJcSearchWorker createLocalWorkerImpl() throws Exception {
        Class clazz = this.getLocalWorkerImplClass();
        return (LocalJcSearchWorker)clazz.newInstance();
    }

    private Class getLocalWorkerImplClass() throws Exception {
        String propKey = "chemaxon.jchem.cluster.search.local.worker.impl";
        String propValue = NodeManager.getProperty(propKey, DEFAULT_LOCAL_WORKER_IMPL_CLASS.getName());
        return Class.forName(propValue);
    }
}

