/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cluster.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Trace {
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;

    private Trace() {
    }

    private static String getContext(int kind) {
        StringBuffer sb = new StringBuffer("");
        String type = null;
        switch (kind) {
            case 0: {
                type = "ERROR  ";
                break;
            }
            case 1: {
                type = "WARNING";
                break;
            }
            case 2: {
                type = "INFO   ";
                break;
            }
            case 3: {
                type = "DEBUG  ";
                break;
            }
        }
        sb.append(sdf.format(new Date())).append(": ");
        sb.append(type).append(": ");
        sb.append("[").append(Thread.currentThread().getName()).append("]: ");
        return sb.toString();
    }

    public static void err(String msg) {
        Trace.println(Trace.getContext(0) + msg);
    }

    public static void err(Throwable error) {
        StringWriter swriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(swriter);
        error.printStackTrace(printWriter);
        Trace.err(swriter.toString());
    }

    public static void warn(String msg) {
        Trace.println(Trace.getContext(1) + msg);
    }

    public static void info(String msg) {
        Trace.println(Trace.getContext(2) + msg);
    }

    public static void debug(String msg) {
        Trace.println(Trace.getContext(3) + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(String msg) {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            System.err.println(msg);
        }
    }
}

