/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.enumeration.supergraph.MarkushAromata;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.jchem.db.DBUtil;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.PreRegeneration;
import chemaxon.jchem.db.PropertyNotSetException;
import chemaxon.jchem.db.RecalculationException;
import chemaxon.jchem.db.RegenerationChecker;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.TableTypeConstants;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.db.Updater;
import chemaxon.jchem.file.ProgressWriter;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.jep.ChemJEP;
import chemaxon.jep.context.MolContext;
import chemaxon.reaction.Standardizer;
import chemaxon.reaction.StandardizerException;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import chemaxon.util.IntArray;
import chemaxon.util.MolHandler;
import chemaxon.util.cache.ChemJepCacheMolContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class CTColumnRegenerator
implements TableTypeConstants {
    private String tableName = null;
    private String origStructTableName;
    private String structColName;
    private boolean indexTable;
    private int tableType = 0;
    private String[] ctColumns = null;
    private String[] expressions = null;
    private int[] fieldTypes = null;
    private int colCount = 0;
    private ProgressWriter pw = null;
    private ConnectionHandler ch = null;
    private Connection con = null;
    private static final int DEFAULT_THREADS = 2;
    private int threadCount = 2;
    private PreparedStatement readerStmt = null;
    private PreparedStatement updaterStmt = null;
    private volatile int counter = 0;
    private IntArray idList = null;
    private int pos;
    private int regenMode = 0;
    public boolean wasError = false;

    private synchronized void updateRow(int id, Object[] values) throws SQLException {
        for (int x = 0; x < this.colCount; ++x) {
            Object value = values[x];
            if (value == null) {
                this.updaterStmt.setNull(x + 1, this.fieldTypes[x]);
                continue;
            }
            this.updaterStmt.setObject(x + 1, value);
        }
        this.updaterStmt.setInt(this.colCount + 1, id);
        this.updaterStmt.execute();
        if (this.regenMode == 1) {
            UpdateHandler.setPreCalculated(this.ch, this.tableName, id, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized MolData getNextMolData() throws SQLException {
        MolData result = null;
        int id = -1;
        while (!this.pw.isCanceled() && (id = this.getNextID()) != -1) {
            byte[] molfile = null;
            this.readerStmt.setInt(1, id);
            ResultSet rs = this.readerStmt.executeQuery();
            try {
                if (rs.next()) {
                    molfile = DatabaseTools.readBytes(rs, 1);
                }
            }
            finally {
                rs.close();
            }
            if (molfile == null) continue;
            result = new MolData();
            result.molString = molfile;
            result.id = id;
            return result;
        }
        return result;
    }

    private synchronized int getNextID() {
        if (this.pos >= this.idList.size()) {
            return -1;
        }
        return this.idList.get(this.pos++);
    }

    public CTColumnRegenerator(ConnectionHandler ch, String tableName, String[] ctColumns, ProgressWriter pw, int threadCount) throws SQLException, RecalculationException {
        try {
            this.threadCount = Runtime.getRuntime().availableProcessors();
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        if (new Updater(ch).isUpdateNeededForTable(tableName)) {
            throw new RecalculationException("Table '" + tableName + "' needs an important structural change in the database. " + "Use 'jcman u' in command line, or JCman GUI to upgrade your JChem.");
        }
        this.tableName = tableName;
        this.ctColumns = ctColumns;
        this.pw = pw;
        if (threadCount > 0) {
            this.threadCount = threadCount;
        }
        this.ch = ch;
        this.con = ch.getConnection();
    }

    public CTColumnRegenerator(ConnectionHandler ch, String tableName, String[] ctColumns, ProgressWriter pw, int threadCount, int regenerationMode) throws SQLException, RecalculationException {
        this(ch, tableName, ctColumns, pw, threadCount);
        this.regenMode = regenerationMode;
    }

    public CTColumnRegenerator(ConnectionHandler ch, String tableName, String[] ctColumns, ProgressWriter pw, int threadCount, String origStructTableName, String structColName) throws SQLException, RecalculationException {
        this(ch, tableName, ctColumns, pw, threadCount);
        this.origStructTableName = origStructTableName;
        this.structColName = structColName;
        this.indexTable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws SQLException, PropertyNotSetException {
        DatabaseProperties dbProps = new DatabaseProperties(this.ch, this.indexTable);
        if (this.regenMode == 1) {
            PreRegeneration pr = new PreRegeneration(this.ch);
            try {
                pr.removeTempTable(this.tableName);
            }
            catch (Exception e) {
                // empty catch block
            }
            pr.createTempTable(this.tableName, 1);
            UpdateHandler.resetPreCalculatedValues(this.ch, this.tableName);
        }
        this.wasError = false;
        Connection con = this.ch.getConnection();
        this.tableName = TableInfo.getTableNameWithSchema(con, this.tableName);
        this.tableType = dbProps.getTableType(this.tableName);
        this.colCount = this.ctColumns.length;
        this.expressions = new String[this.colCount];
        for (int x = 0; x < this.colCount; ++x) {
            this.expressions[x] = dbProps.getChemTermForColumn(this.tableName, this.ctColumns[x]);
            if (this.expressions[x] != null) continue;
            throw new IllegalArgumentException("No chemical terms configured for " + this.ctColumns[x]);
        }
        this.getCTFieldTypes();
        if (this.pw != null) {
            int rowCount = DBUtil.getRowCount(con, this.tableName);
            this.pw.setMaximum(rowCount);
        } else {
            this.pw = new ProgressWriter("", 0L, 1L);
        }
        this.readIDValues();
        Standardizer[] standardizers = null;
        try {
            standardizers = TableInfo.getStandardizers(this.ch, this.tableName, this.indexTable, this.threadCount);
        }
        catch (StandardizerException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        if (this.tableType == 4) {
            for (int x = 0; x < standardizers.length; ++x) {
                standardizers[x].setActiveGroup("query");
                try {
                    standardizers[x].setInactiveTasks("removeexplicith");
                    continue;
                }
                catch (StandardizerException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.createStatements();
        try {
            this.createRunRegenThreads(standardizers);
        }
        finally {
            try {
                if (this.regenMode == 2) {
                    dbProps.setTableProperty(this.tableName, "version", Integer.toString(RegenerationChecker.deduceTableVersion(this.tableName, dbProps)));
                    dbProps.setTableProperty(this.tableName, "JChemVersion", VersionInfo.JCHEM_VERSION);
                    TableInfo.resetTableValidityTimestamp(dbProps, this.tableName);
                } else if (this.regenMode == 1) {
                    dbProps.setTableProperty(this.tableName, "preregen.status", "1");
                }
            }
            finally {
                try {
                    if (this.readerStmt != null) {
                        this.readerStmt.close();
                    }
                }
                finally {
                    if (this.updaterStmt != null) {
                        this.updaterStmt.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCTFieldTypes() throws SQLException {
        Statement stmt = this.con.createStatement();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT ");
            for (int x = 0; x < this.colCount; ++x) {
                if (x > 0) {
                    sql.append(",");
                }
                sql.append(this.ctColumns[x]);
            }
            sql.append(" FROM ");
            sql.append(this.tableName);
            sql.append(" WHERE cd_id=0");
            ResultSet rs = stmt.executeQuery(sql.toString());
            try {
                ResultSetMetaData rmd = rs.getMetaData();
                this.fieldTypes = new int[this.colCount];
                for (int i = 0; i < this.colCount; ++i) {
                    this.fieldTypes[i] = rmd.getColumnType(i + 1);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStatements() throws SQLException {
        String sql;
        if (this.indexTable) {
            sql = "SELECT " + this.origStructTableName + "." + this.structColName + " FROM " + this.origStructTableName + ", " + this.tableName + " where " + this.origStructTableName + ".ROWID = " + this.tableName + ".rid AND " + this.tableName + ".cd_id = ?";
            this.readerStmt = this.con.prepareStatement(sql);
        } else {
            String fieldName = "cd_structure";
            String sql2 = "SELECT " + fieldName + " FROM " + this.tableName + " where cd_id = ?";
            this.readerStmt = this.con.prepareStatement(sql2);
        }
        try {
            sql = "";
            if (this.regenMode == 1) {
                sql = "INSERT INTO " + PreRegeneration.getTempTableName(this.tableName) + "(";
                String values = "";
                for (String ctCol : this.ctColumns) {
                    sql = sql + ctCol + ",";
                    values = values + "?,";
                }
                sql = sql + "cd_id) VALUES (" + values + "?)";
            } else {
                sql = "UPDATE " + this.tableName + " SET ";
                for (int x = 0; x < this.colCount; ++x) {
                    if (x > 0) {
                        sql = sql + ", ";
                    }
                    sql = sql + this.ctColumns[x] + "=?";
                }
                sql = sql + " where cd_id = ?";
            }
            this.updaterStmt = this.con.prepareStatement(sql);
        }
        catch (Throwable tbl) {
            tbl.printStackTrace();
            try {
                this.readerStmt.close();
                this.readerStmt = null;
            }
            finally {
                if (this.updaterStmt != null) {
                    this.updaterStmt.close();
                    this.updaterStmt = null;
                }
            }
            throw new RuntimeException(tbl);
        }
    }

    private void createRunRegenThreads(Standardizer[] standardizers) {
        int x;
        RegenThread[] regenThreads = new RegenThread[this.threadCount];
        for (x = 0; x < this.threadCount; ++x) {
            regenThreads[x] = new RegenThread();
            regenThreads[x].standardizer = standardizers[x];
        }
        for (x = 0; x < this.threadCount; ++x) {
            regenThreads[x].isRunning = true;
            regenThreads[x].start();
        }
        Throwable firstError = null;
        String notePrefix = "Molecule count: ";
        while (true) {
            boolean finished = true;
            for (int x2 = 0; x2 < this.threadCount; ++x2) {
                if (regenThreads[x2].isRunning) {
                    finished = false;
                    break;
                }
                if (regenThreads[x2].error == null || firstError != null) continue;
                firstError = regenThreads[x2].error;
            }
            if (finished) {
                if (firstError != null) {
                    throw new RuntimeException(firstError);
                }
                if (this.pw.isCanceled()) break;
                try {
                    DatabaseProperties dbProp = new DatabaseProperties(this.ch, this.indexTable);
                    dbProp.setTableProperty(this.tableName, "JChemVersion", VersionInfo.JCHEM_VERSION);
                    dbProp.setTableProperty(this.tableName, "ctVersion", Integer.toString(RegenerationChecker.deduceTableVersion(this.tableName, dbProp, 1)));
                    TableInfo.resetTableValidityTimestamp(dbProp, this.tableName);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                break;
            }
            try {
                this.pw.setProgress(this.counter);
                this.pw.setNote(notePrefix + this.counter);
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIDValues() throws SQLException {
        String sql = "SELECT cd_id FROM " + this.tableName;
        if (this.regenMode == 2) {
            sql = sql + " WHERE cd_pre_calculated = 0";
        }
        ResultSet rs = null;
        Statement stmt = this.con.createStatement();
        try {
            rs = stmt.executeQuery(sql);
            this.idList = new IntArray();
            while (rs.next()) {
                this.idList.add(rs.getInt(1));
            }
            rs.close();
            stmt.close();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
    }

    private class MolData {
        public int id = 0;
        public byte[] molString = null;

        private MolData() {
        }
    }

    private class RegenThread
    extends Thread {
        public Throwable error = null;
        public volatile boolean canRun = true;
        public volatile boolean isRunning = false;
        public Standardizer standardizer = null;

        private RegenThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            MolData md;
            MolContext molContext;
            block18: {
                try {
                    molContext = new MolContext();
                    md = null;
                    if (CTColumnRegenerator.this.regenMode != 1 || new DatabaseProperties((ConnectionHandler)((CTColumnRegenerator)CTColumnRegenerator.this).ch).dbmsType != 2) break block18;
                    Statement stmt = CTColumnRegenerator.this.ch.getConnection().createStatement();
                    try {
                        String sql = "SET IDENTITY_INSERT " + PreRegeneration.getTempTableName(CTColumnRegenerator.this.tableName) + " ON";
                        stmt.execute(sql);
                    }
                    finally {
                        stmt.close();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.error = e;
                    CTColumnRegenerator.this.wasError = true;
                    return;
                }
            }
            while (this.canRun) {
                md = CTColumnRegenerator.this.getNextMolData();
                if (md == null) return;
                try {
                    boolean isMarkush;
                    Object[] values = new Object[CTColumnRegenerator.this.colCount];
                    Molecule mol = new MolHandler(md.molString).getMolecule();
                    boolean bl = isMarkush = CTColumnRegenerator.this.tableType == 3 && Supergraph.isMarkushMolecule(mol);
                    if (isMarkush) {
                        MarkushAromata ma = new MarkushAromata();
                        ma.aromatize(mol);
                    } else {
                        this.standardizer.standardize(mol);
                    }
                    molContext.setMolecule(mol);
                    for (int x = 0; x < CTColumnRegenerator.this.colCount; ++x) {
                        try {
                            String expression = CTColumnRegenerator.this.expressions[x];
                            ChemJEP chemJep = ChemJepCacheMolContext.getCreateChemJep(expression);
                            values[x] = UpdateHandler.checkChemTermColValue(chemJep.evaluate(molContext));
                            ChemJepCacheMolContext.recycleChemJep(expression, chemJep);
                            continue;
                        }
                        catch (Throwable e) {
                            String msg = "Error at molecule with cd_id: " + md.id;
                            CTColumnRegenerator.this.pw.log(0, msg, e);
                            CTColumnRegenerator.this.wasError = true;
                        }
                    }
                    CTColumnRegenerator.this.updateRow(md.id, values);
                }
                catch (Throwable e) {
                    String msg = "Error at molecule with cd_id: " + md.id;
                    CTColumnRegenerator.this.pw.log(0, msg, e);
                    CTColumnRegenerator.this.wasError = true;
                }
                ProgressWriter progressWriter = CTColumnRegenerator.this.pw;
                synchronized (progressWriter) {
                    CTColumnRegenerator.this.counter++;
                }
            }
            return;
            finally {
                this.canRun = false;
                this.isRunning = false;
            }
        }
    }
}

