/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.DatabaseOptions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DBUtil {
    public static final String INDEX_PREFIX = "idx_";
    public static final String MSSQL_NULL_CONSTRAINT_PREFIX = "null_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRowCount(Connection con, String tableName) throws SQLException {
        int count;
        Statement stmt = con.createStatement();
        try {
            String s = "SELECT COUNT(*) FROM " + tableName;
            ResultSet rs = stmt.executeQuery(s);
            try {
                rs.next();
                count = rs.getInt(1);
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropTable(Connection con, String tableName) throws SQLException {
        int dbmsType = DatabaseOptions.getDBMSType(con);
        if (dbmsType == 10) {
            throw new IllegalArgumentException("JChem does not support table dropping for Composite Databases.");
        }
        String sql = "DROP TABLE " + tableName;
        int dbms = DatabaseOptions.getDBMSType(con);
        if (dbms == 1) {
            sql = sql + " CASCADE CONSTRAINTS";
        } else if (dbms == 7) {
            sql = sql + " CASCADE";
        }
        Statement stmt = con.createStatement();
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addColumn(Connection con, String tableName, String columnName, String columnType) throws SQLException {
        int dbms = DatabaseOptions.getDBMSType(con);
        if (dbms == 10) {
            throw new IllegalArgumentException("JChem does not support altering table for Composite Databases.");
        }
        String sql = "ALTER TABLE " + tableName + " ADD " + columnName + " " + columnType + " DEFAULT NULL";
        if (dbms == 4) {
            sql = "ALTER TABLE " + tableName + " ADD COLUMN " + columnName + " " + columnType;
        } else if (dbms == 2) {
            sql = "ALTER TABLE " + tableName + " ADD " + columnName + " " + columnType + ", CONSTRAINT [" + DBUtil.getDefaultMssqlNullConstraintName(tableName, columnName) + "] DEFAULT NULL FOR [" + columnName + "]";
        }
        Statement stmt = con.createStatement();
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropColumn(Connection con, String tableName, String columnName) throws SQLException {
        String sql;
        int dbms = DatabaseOptions.getDBMSType(con);
        Statement stmt = con.createStatement();
        if (dbms == 10) {
            throw new IllegalArgumentException("JChem does not support altering table for Composite Databases.");
        }
        if (dbms == 2) {
            try {
                sql = "ALTER TABLE " + tableName + " DROP CONSTRAINT " + DBUtil.getDefaultMssqlNullConstraintName(tableName, columnName);
                stmt.executeUpdate(sql);
            }
            catch (SQLException e) {
            }
            finally {
                stmt.close();
            }
            stmt = con.createStatement();
        }
        if (dbms == 2 || dbms == 4) {
            try {
                sql = "DROP INDEX " + DBUtil.getDefaultIndexName(columnName) + " ON " + tableName;
                stmt.executeUpdate(sql);
            }
            catch (SQLException e) {
            }
            finally {
                stmt.close();
            }
            stmt = con.createStatement();
        }
        try {
            sql = "ALTER TABLE " + tableName + " DROP COLUMN " + columnName;
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIndex(Connection con, String tableName, String columnName, String indexName) throws SQLException {
        int dbms = DatabaseOptions.getDBMSType(con);
        if (dbms == 10) {
            throw new IllegalArgumentException("JChem does not support creating index for Composite Databases.");
        }
        Statement stmt = con.createStatement();
        try {
            String sql = "CREATE INDEX " + indexName + " ON " + tableName + "(" + columnName + ")";
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
    }

    public static void addIndex(Connection con, String tableName, String columnName) throws SQLException {
        DBUtil.addIndex(con, tableName, columnName, DBUtil.getDefaultIndexName(columnName));
    }

    public static String getDefaultMssqlNullConstraintName(String tableName, String columnName) {
        return MSSQL_NULL_CONSTRAINT_PREFIX + (tableName.replace(".", "_") + "_" + columnName).toLowerCase();
    }

    public static String getDefaultIndexName(String columnName) {
        return INDEX_PREFIX + columnName.toLowerCase();
    }
}

