/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import java.util.Properties;

public class DatabaseConstants {
    public static final int ORACLE = 0;
    public static final int MSSQL = 1;
    public static final int MSSQL2005 = 1;
    public static final int MYSQL = 2;
    public static final int ACCESS = 3;
    public static final int INTERBASE = 4;
    public static final int DB2 = 5;
    public static final int POSTGRESQL = 6;
    public static final int HSQLDB = 7;
    public static final int DERBY = 8;
    public static final int COMPOSITE = 9;
    public static final String MYSQL_DRIVER = "com.mysql.jdbc.Driver";
    public static final String DERBY_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String MSSQL_DRIVER = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
    public static final String MSSQL2005_DRIVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String ACCESS_DRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";
    public static final String INTERBASE_DRIVER = "interbase.interclient.Driver";
    public static final String DB2_DRIVER = "COM.ibm.db2.jdbc.net.DB2Driver";
    public static final String HSQLDB_DRIVER = "org.hsqldb.jdbcDriver";
    public static final String ORACLE_DRIVER = "oracle.jdbc.OracleDriver";
    public static final String POSGRESQL_DRIVER = "org.postgresql.Driver";
    public static final String COMPOSITE_DRIVER = "cs.jdbc.driver.CompositeDriver";
    public static final String ORACLE_URL_TEMPLATE = "jdbc:oracle:thin:@[host][:port]:<SID>";
    public static final String MSSQL_URL_TEMPLATE = "jdbc:microsoft:sqlserver://[host][:port][;databaseName=database][;options]";
    public static final String MSSQL2005_URL_TEMPLATE = "jdbc:sqlserver://[host][:port][;databaseName=database][;options]";
    public static final String MYSQL_URL_TEMPLATE = "jdbc:mysql://[host][:port]/<database>[?options]";
    public static final String ACCESS_URL_TEMPLATE = "jdbc:odbc[:odbc data source][;options]";
    public static final String INTERBASE_URL_TEMPLATE = "jdbc:interbase:<path to interbase data file (.gdb file)>";
    public static final String DB2_URL_TEMPLATE = "jdbc:db2://[host][:port]/<database>";
    public static final String POSGRESQL_URL_TEMPLATE = "jdbc:postgresql://[host][:port]/<database>";
    public static final String HSQLDB_URL_TEMPLATE = "jdbc:hsqldb:hsql://[host][:port]/[database]";
    public static final String DERBY_URL_TEMPLATE = "jdbc:derby:[subprotocol]:<database with path>[;create=true][;options]";
    public static final String COMPOSITE_URL_TEMPLATE = "jdbc:compositesw:dbapi@[host][:port]?domain=<domain name>&dataSource=<database>";
    public static final String ORACLE_URL_EXAMPLE = "jdbc:oracle:thin:@localhost:1521:XE";
    public static final String MSSQL_URL_EXAMPLE = "jdbc:microsoft:sqlserver://localhost:1433;DatabaseName=mydb;selectMethod=cursor";
    public static final String MSSQL2005_URL_EXAMPLE = "jdbc:sqlserver://localhost:1433;databaseName=mydb;selectMethod=cursor";
    public static final String MYSQL_URL_EXAMPLE = "jdbc:mysql://localhost:3306/mydb?useCursorFetch=true&defaultFetchSize=1000";
    public static final String ACCESS_URL_EXAMPLE = "jdbc:odbc:mydatasource";
    public static final String INTERBASE_URL_EXAMPLE = "jdbc:interbase://localhost/c:/interbase/interbasedb.gdb";
    public static final String DB2_URL_EXAMPLE = "jdbc:db2://localhost:6789/mydb";
    public static final String POSGRESQL_URL_EXAMPLE = "jdbc:postgresql://localhost:5432/mydb";
    public static final String HSQLDB_URL_EXAMPLE = "jdbc:hsqldb:hsql://localhost/";
    public static final String DERBY_URL_EXAMPLE = "jdbc:derby:/c:/databases/mydb;create=true";
    public static final String COMPOSITE_URL_EXAMPLE = "jdbc:compositesw:dbapi@10.0.0.100:9401?domain=composite&dataSource=virtualdb";
    public static final String[] DBMS_NAMES = new String[]{"Oracle", "MS SQL Server (2005 or newer)", "MySQL", "MS Access", "Interbase", "IBM DB2", "PostgreSQL", "HSQLDB", "Apache Derby Embedded", "Composite"};
    public static final String[] DBMS_DRIVERS = new String[]{"oracle.jdbc.OracleDriver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "com.mysql.jdbc.Driver", "sun.jdbc.odbc.JdbcOdbcDriver", "interbase.interclient.Driver", "COM.ibm.db2.jdbc.net.DB2Driver", "org.postgresql.Driver", "org.hsqldb.jdbcDriver", "org.apache.derby.jdbc.EmbeddedDriver", "cs.jdbc.driver.CompositeDriver"};
    public static final String[] DBMS_URL_TEMPLATES = new String[]{"jdbc:oracle:thin:@[host][:port]:<SID>", "jdbc:sqlserver://[host][:port][;databaseName=database][;options]", "jdbc:mysql://[host][:port]/<database>[?options]", "jdbc:odbc[:odbc data source][;options]", "jdbc:interbase:<path to interbase data file (.gdb file)>", "jdbc:db2://[host][:port]/<database>", "jdbc:postgresql://[host][:port]/<database>", "jdbc:hsqldb:hsql://[host][:port]/[database]", "jdbc:derby:[subprotocol]:<database with path>[;create=true][;options]", "jdbc:compositesw:dbapi@[host][:port]?domain=<domain name>&dataSource=<database>"};
    public static final String[] DBMS_URL_EXAMPLES = new String[]{"jdbc:oracle:thin:@localhost:1521:XE", "jdbc:sqlserver://localhost:1433;databaseName=mydb;selectMethod=cursor", "jdbc:mysql://localhost:3306/mydb?useCursorFetch=true&defaultFetchSize=1000", "jdbc:odbc:mydatasource", "jdbc:interbase://localhost/c:/interbase/interbasedb.gdb", "jdbc:db2://localhost:6789/mydb", "jdbc:postgresql://localhost:5432/mydb", "jdbc:hsqldb:hsql://localhost/", "jdbc:derby:/c:/databases/mydb;create=true", "jdbc:compositesw:dbapi@10.0.0.100:9401?domain=composite&dataSource=virtualdb"};

    public static Properties getDefaultDerbySettings() {
        Properties settings = new Properties();
        settings.put("connection.jdbcDriverName", DBMS_NAMES[8]);
        settings.put("connection.jdbcDriver", DERBY_DRIVER);
        settings.put("connection.jdbcUrl", "jdbc:derby:Database;create=true");
        settings.put("connection.login", "");
        settings.put("connection.password", "");
        settings.put("connection.propertyTable", "JChemProperties");
        return settings;
    }
}

