/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.CacheRegistrationUtil;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.ParallelStructTableUpdater;
import chemaxon.jchem.db.sql.DataType;
import chemaxon.jchem.db.sql.TypeConverter;
import chemaxon.util.ConnectionHandler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.TreeMap;

public class DatabaseOptions {
    private static final int BASE_PRIM_FOR_REGISTRATION_CODE = 997;
    private static final int BASE_PRIM_FOR_CLUSTER_REGISTRATION_CODE = 991;
    private static final int CURRENT_VERSION = 0;
    private static final int[] CODES_FOR_VERSIONS = new int[]{499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571};
    private static final int[] CODES_FOR_CATEGORIES = new int[]{0, 2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71};
    private static final int[] SEARCH_COUNTS_FOR_CATEGORIES = new int[]{1, 2, 3, 4, 6, 8, 10, 13, 16, 20, 25, 30, 35, 40, 50, 60, 80, 100, 125, 150, Integer.MAX_VALUE};
    public long registrationCode = 0L;
    public long clusterRegistrationCode = 0L;
    public String cartridgeRegistrationCode = "0";
    public boolean doNotCompressStructureField = true;
    public int commitInterval = 50;
    public static final int MAX_COUNT_CLUSTERING_DEMO = 1000;
    public static final int DEFAULT_COMMIT_INTERVAL = 50;
    public static final int UNKNOWN = 0;
    public static final int ORACLE = 1;
    public static final int MSSQLSERVER = 2;
    public static final int MYSQL = 3;
    public static final int ACCESS = 4;
    public static final int INTERBASE = 5;
    public static final int DB2 = 6;
    public static final int POSTGRESQL = 7;
    public static final int HSQLDB = 8;
    public static final int DERBY = 9;
    public static final int COMPOSITE = 10;
    public static final String[] DBMSNAMES = new String[]{"UNKNOWN", "ORACLE", "MICROSOFT SQL SERVER", "MYSQL", "ACCESS", "INTERBASE", "DB2", "POSTGRESQL", "HSQL", "APACHE DERBY", "COMPOSITE"};
    public static final String DUMMY_TRIGGER = "built-in value";
    public boolean isAutoIncrementProperty = false;
    public boolean isAutoIncrementByTrigger = false;
    public String autoIncrementPropertyName = null;
    public String autoIncrementTriggerCreation = null;
    public String autoIncrementTriggerCleanup = null;
    public boolean constraintNeededForPrimaryKey = false;
    public boolean existsBitwiseAND = false;
    public boolean existsBitwiseANDOperator = false;
    public String nameOfBitwiseANDFunction = "BITAND";
    public String propertyTableName;
    public static final String INTERBASE_TRIGGER_CREATION = "CREATE GENERATOR GEN_{TABLE}_{COLUMN}";
    public static final String INTERBASE_TRIGGER_CLEANUP = "DELETE FROM RDB$GENERATORS\n WHERE RDB$GENERATOR_NAME = 'GEN_{TABLE}_{COLUMN}'";
    public static final String ORACLE_TRIGGER_CREATION = "CREATE SEQUENCE {TABLE}_SQ\nINCREMENT BY 1 START WITH {START_VALUE};;\n\nCREATE TRIGGER {TABLE}_TR\n   BEFORE INSERT OR UPDATE ON {TABLE}\n   FOR EACH ROW\n   DECLARE\n       ICOUNTER {TABLE}.{COLUMN}%TYPE;\n       ICURRENT {TABLE}.{COLUMN}%TYPE;\n       CANNOT_CHANGE_VALUE EXCEPTION;\n   BEGIN\n       IF INSERTING THEN\n           IF :NEW.{COLUMN} IS NULL THEN\n               SELECT {TABLE}_SQ.NEXTVAL INTO ICOUNTER FROM DUAL;\n               :NEW.{COLUMN} := ICOUNTER;\n           ELSE\n               BEGIN\n                   SELECT {TABLE}_SQ.CURRVAL INTO ICURRENT FROM DUAL;\n               EXCEPTION\n                   WHEN OTHERS THEN      /* ON FIRST RUN NO CURRVAL AVAILABLE */\n                       SELECT {TABLE}_SQ.NEXTVAL INTO ICURRENT FROM DUAL;\n               END;\n               IF :NEW.{COLUMN} > ICURRENT THEN\n                   LOOP\n                       SELECT {TABLE}_SQ.NEXTVAL INTO ICOUNTER FROM DUAL;\n                       EXIT WHEN :NEW.{COLUMN} <= ICOUNTER;\n                   END LOOP;\n               END IF;\n           END IF;\n       END IF;\n       IF UPDATING THEN\n           IF NOT (:NEW.{COLUMN} = :OLD.{COLUMN}) THEN\n               RAISE CANNOT_CHANGE_VALUE;\n           END IF;\n       END IF;\n   EXCEPTION\n       WHEN CANNOT_CHANGE_VALUE THEN\n           RAISE_APPLICATION_ERROR(-20000, 'CANNOT CHANGE {TABLE}.{COLUMN} VALUE');\n   END;\n";
    public static final String ORACLE_TRIGGER_CLEANUP = "DROP TRIGGER {TABLE}_TR;;\nDROP SEQUENCE {TABLE}_SQ\n";
    public static final String OLD_ORACLE_TRIGGER_CLEANUP = "DROP TRIGGER {TABLE}_TR_{COLUMN};;\nDROP SEQUENCE {TABLE}_SEQ_{COLUMN}\n";

    public DatabaseOptions() {
    }

    public DatabaseOptions(ConnectionHandler conh) throws SQLException {
        this.setDefaultOptions(conh);
    }

    public static DatabaseOptions getFromDatabase(ConnectionHandler conh) throws SQLException {
        DatabaseOptions dbOptions = new DatabaseOptions(conh);
        DatabaseProperties prop = new DatabaseProperties(conh);
        dbOptions.registrationCode = DatabaseOptions.getRegistrationCode(prop);
        dbOptions.clusterRegistrationCode = DatabaseOptions.getClusterRegistrationCode(prop);
        dbOptions.cartridgeRegistrationCode = DatabaseOptions.getCartridgeRegistrationCode(prop);
        dbOptions.doNotCompressStructureField = DatabaseOptions.isStructureCompressionDisabled(prop);
        dbOptions.commitInterval = DatabaseOptions.getCommitInterval(prop);
        if (dbOptions.cartridgeRegistrationCode == null) {
            dbOptions.cartridgeRegistrationCode = "0";
        }
        return dbOptions;
    }

    private void setDefaultOptions(ConnectionHandler conh) throws SQLException {
        int dbmsType = DatabaseOptions.getDBMSType(conh.getConnection());
        if (dbmsType == 0) {
            return;
        }
        switch (dbmsType) {
            case 1: {
                this.isAutoIncrementProperty = true;
                this.isAutoIncrementByTrigger = true;
                this.autoIncrementPropertyName = null;
                this.autoIncrementTriggerCreation = null;
                this.autoIncrementTriggerCleanup = null;
                this.constraintNeededForPrimaryKey = false;
                break;
            }
            case 2: {
                this.isAutoIncrementProperty = true;
                this.isAutoIncrementByTrigger = false;
                this.autoIncrementPropertyName = "IDENTITY";
                this.autoIncrementTriggerCreation = null;
                this.autoIncrementTriggerCleanup = null;
                this.constraintNeededForPrimaryKey = false;
                break;
            }
            case 3: {
                this.isAutoIncrementProperty = true;
                this.isAutoIncrementByTrigger = false;
                this.autoIncrementPropertyName = "AUTO_INCREMENT";
                this.autoIncrementTriggerCreation = null;
                this.autoIncrementTriggerCleanup = null;
                this.constraintNeededForPrimaryKey = false;
                break;
            }
            case 4: {
                this.isAutoIncrementProperty = false;
                this.isAutoIncrementByTrigger = false;
                this.autoIncrementPropertyName = null;
                this.autoIncrementTriggerCreation = null;
                this.autoIncrementTriggerCleanup = null;
                this.constraintNeededForPrimaryKey = false;
                break;
            }
            case 5: {
                this.isAutoIncrementProperty = true;
                this.isAutoIncrementByTrigger = true;
                this.autoIncrementPropertyName = null;
                this.autoIncrementTriggerCreation = null;
                this.autoIncrementTriggerCleanup = null;
                this.constraintNeededForPrimaryKey = false;
                break;
            }
            case 6: {
                this.isAutoIncrementProperty = true;
                this.isAutoIncrementByTrigger = false;
                this.autoIncrementPropertyName = "GENERATED ALWAYS AS IDENTITY";
                this.autoIncrementTriggerCreation = null;
                this.autoIncrementTriggerCleanup = null;
                this.constraintNeededForPrimaryKey = false;
                break;
            }
            case 7: {
                this.isAutoIncrementProperty = true;
                this.isAutoIncrementByTrigger = false;
                this.autoIncrementPropertyName = "";
                this.autoIncrementTriggerCreation = null;
                this.autoIncrementTriggerCleanup = null;
                this.constraintNeededForPrimaryKey = false;
                break;
            }
            case 8: {
                this.isAutoIncrementProperty = true;
                this.isAutoIncrementByTrigger = false;
                this.autoIncrementPropertyName = "GENERATED BY DEFAULT AS IDENTITY (START WITH 1)";
                this.autoIncrementTriggerCreation = null;
                this.autoIncrementTriggerCleanup = null;
                this.constraintNeededForPrimaryKey = false;
                break;
            }
            case 9: {
                this.isAutoIncrementProperty = true;
                this.isAutoIncrementByTrigger = false;
                this.autoIncrementPropertyName = "GENERATED BY DEFAULT AS IDENTITY (START WITH 1)";
                this.autoIncrementTriggerCreation = null;
                this.autoIncrementTriggerCleanup = null;
                this.constraintNeededForPrimaryKey = false;
                break;
            }
            case 10: {
                this.isAutoIncrementProperty = true;
                this.isAutoIncrementByTrigger = true;
                this.autoIncrementPropertyName = null;
                this.autoIncrementTriggerCreation = null;
                this.autoIncrementTriggerCleanup = null;
                this.constraintNeededForPrimaryKey = false;
            }
        }
        switch (dbmsType) {
            case 1: {
                this.existsBitwiseAND = true;
                this.existsBitwiseANDOperator = false;
                this.nameOfBitwiseANDFunction = "BITAND";
                break;
            }
            case 2: {
                this.existsBitwiseAND = true;
                this.existsBitwiseANDOperator = true;
                this.nameOfBitwiseANDFunction = null;
                break;
            }
            case 3: {
                this.existsBitwiseAND = true;
                this.existsBitwiseANDOperator = true;
                this.nameOfBitwiseANDFunction = null;
                break;
            }
            case 4: {
                this.existsBitwiseAND = false;
                this.existsBitwiseANDOperator = false;
                this.nameOfBitwiseANDFunction = null;
                break;
            }
            case 5: {
                this.existsBitwiseAND = false;
                this.existsBitwiseANDOperator = false;
                this.nameOfBitwiseANDFunction = null;
                break;
            }
            case 6: {
                this.existsBitwiseAND = false;
                this.existsBitwiseANDOperator = false;
                this.nameOfBitwiseANDFunction = null;
                break;
            }
            case 7: {
                this.existsBitwiseAND = true;
                this.existsBitwiseANDOperator = true;
                this.nameOfBitwiseANDFunction = null;
                break;
            }
            case 8: {
                this.existsBitwiseAND = true;
                this.existsBitwiseANDOperator = false;
                this.nameOfBitwiseANDFunction = "BITAND";
                break;
            }
            case 9: {
                this.existsBitwiseAND = false;
                this.existsBitwiseANDOperator = false;
                this.nameOfBitwiseANDFunction = null;
                break;
            }
            case 10: {
                this.existsBitwiseAND = true;
                this.existsBitwiseANDOperator = false;
                this.nameOfBitwiseANDFunction = "BITAND";
            }
        }
    }

    public void save(ConnectionHandler conh) throws SQLException {
        DatabaseProperties prop = new DatabaseProperties(conh);
        prop.setProperty("option.structureCompressionDisabled", "" + this.doNotCompressStructureField);
        DatabaseOptions.setCommitInterval(prop, this.commitInterval);
        DatabaseOptions.setPropertyTableIdentifier(prop);
    }

    private static boolean isDivisible(long a, int b) {
        return a / (long)b * (long)b == a;
    }

    public static boolean isValidRegistrationCode(long rCode) {
        if (!DatabaseOptions.isDivisible(rCode, 997)) {
            return false;
        }
        for (int i = 0; i >= 0; --i) {
            if (!DatabaseOptions.isDivisible(rCode, CODES_FOR_VERSIONS[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidClusterRegistrationCode(long rCode) {
        if (!DatabaseOptions.isDivisible(rCode, 991)) {
            return false;
        }
        for (int i = 0; i >= 0; --i) {
            if (!DatabaseOptions.isDivisible(rCode, CODES_FOR_VERSIONS[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidRegistrationCode(String rCodeString) {
        try {
            long rCode = Long.parseLong(rCodeString);
            return DatabaseOptions.isValidRegistrationCode(rCode);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidClusterRegistrationCode(String rCodeString) {
        try {
            long rCode = Long.parseLong(rCodeString);
            return DatabaseOptions.isValidClusterRegistrationCode(rCode);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidCartridgeRegistrationCode(String rCodeString) {
        return rCodeString.equals("fs56OC");
    }

    public static long getRegistrationCode(DatabaseProperties prop) {
        int result = 0;
        try {
            result = prop.getIntProperty("registration.code");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result == Integer.MIN_VALUE) {
            result = 0;
        }
        return result;
    }

    public static int getCommitInterval(DatabaseProperties prop) throws SQLException {
        int result = 50;
        try {
            result = prop.getIntProperty("option.commitInterval");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result == Integer.MIN_VALUE) {
            result = 50;
        }
        return result;
    }

    public static void setCommitInterval(DatabaseProperties prop, int commitInterval) throws SQLException {
        ParallelStructTableUpdater.checkCommitInterval(commitInterval);
        prop.setProperty("option.commitInterval", Integer.toString(commitInterval));
    }

    public static void setPropertyTableIdentifier(DatabaseProperties prop) throws SQLException {
        prop.setProperty("propertytable.identifier", "PT_ID_" + CacheRegistrationUtil.generateRandomID());
    }

    public static long getClusterRegistrationCode(DatabaseProperties prop) {
        int result = 0;
        try {
            result = prop.getIntProperty("registration.code.cluster");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == Integer.MIN_VALUE) {
            result = 0;
        }
        return result;
    }

    public static String getCartridgeRegistrationCode(DatabaseProperties prop) {
        String result = null;
        try {
            result = prop.getProperty("registration.code.cartridge");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            result = "0";
        }
        return result;
    }

    public static boolean isStructureCompressionDisabled(DatabaseProperties prop) {
        try {
            String ps = prop.getProperty("option.structureCompressionDisabled");
            return ps != null && ps.equalsIgnoreCase("true");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getCategoryFromRegistrationCode(long registrationCode) {
        if (registrationCode == 0L || !DatabaseOptions.isValidRegistrationCode(registrationCode)) {
            return 0;
        }
        int category = 1;
        boolean found = false;
        while (!found && category < CODES_FOR_CATEGORIES.length) {
            if (DatabaseOptions.isDivisible(registrationCode, CODES_FOR_CATEGORIES[category])) {
                found = true;
                continue;
            }
            ++category;
        }
        return found ? category : 0;
    }

    public static int getMaxSearchCountFromRegistrationCode(long registrationCode) {
        int category = DatabaseOptions.getCategoryFromRegistrationCode(registrationCode);
        return SEARCH_COUNTS_FOR_CATEGORIES[category];
    }

    public static int getDBMSType(ConnectionHandler conh) {
        try {
            Connection con = conh.getConnection();
            if (con == null) {
                return -1;
            }
            return DatabaseOptions.getDBMSType(con);
        }
        catch (SQLException e) {
            return -1;
        }
    }

    public static int getDBMSType(Connection con) throws SQLException {
        return DatabaseOptions.getDBMSType(con.getMetaData());
    }

    public static int getDBMSType(DatabaseMetaData metadata) throws SQLException {
        String dbmsName = metadata.getDatabaseProductName().toUpperCase();
        if (dbmsName.startsWith("HXSQL")) {
            dbmsName = "HSQL";
        }
        for (int i = 1; i < DBMSNAMES.length; ++i) {
            if (!dbmsName.startsWith(DBMSNAMES[i])) continue;
            return i;
        }
        throw new SQLException("Unknown or not supported database type: " + dbmsName);
    }

    public static Map<String, Integer> getLocalTypes(Connection con) throws SQLException {
        TreeMap<String, Integer> typeList = new TreeMap<String, Integer>();
        TypeConverter tc = new TypeConverter(con);
        for (DataType dt : tc.getLocalTypes()) {
            String type = dt.getLocalType();
            if (type == null) continue;
            typeList.put(type.toUpperCase(), dt.getCode());
        }
        return typeList;
    }

    public static boolean usesForeignKey(int dbmsType) {
        return dbmsType == 1 || dbmsType == 6 || dbmsType == 2 || dbmsType == 7 || dbmsType == 5;
    }

    public static boolean isSubselectSupported(Connection con) throws SQLException {
        boolean result = con.getMetaData().supportsSubqueriesInIns();
        return result;
    }

    public static void setFetchSize(Statement stmt, int fetchSize, int rdbms) {
        block2: {
            try {
                stmt.setFetchSize(fetchSize);
            }
            catch (Throwable e) {
                if (rdbms != 7) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    public static String getTimestamp(int dbms) {
        if (dbms == 1) {
            return "SYSDATE";
        }
        if (dbms == 3) {
            return "NOW()";
        }
        if (dbms == 4) {
            return "NOW()";
        }
        if (dbms == 2) {
            return "GETDATE()";
        }
        if (dbms == 5) {
            return "CURRENT_TIMESTAMP";
        }
        if (dbms == 6) {
            return "CURRENT_TIMESTAMP";
        }
        if (dbms == 8) {
            return "NOW()";
        }
        if (dbms == 7) {
            return "NOW()";
        }
        if (dbms == 9) {
            return "CURRENT_TIMESTAMP";
        }
        if (dbms == 10) {
            return "CURRENT_TIMESTAMP";
        }
        return "NOW()";
    }
}

