/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.CTColumnPropUtil;
import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.TableNames;
import chemaxon.jchem.db.TableTypeConstants;
import chemaxon.jchem.db.sql.TypeConverter;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatabaseProperties
implements TableTypeConstants {
    private static final Logger logger = Logger.getLogger(DatabaseProperties.class.getName());
    public static final String DEFAULT_PROPERTY_TABLE = "JChemProperties";
    public static final String NAME_COLUMN = "prop_name";
    public static final String VALUE_COLUMN = "prop_value";
    public static final String VALUE_COLUMN_EXT = "prop_value_ext";
    static final int COLUMN_LENGTH = 200;
    public static final String MD_PROPERTY_PREFIX = "MD";
    public static final String PROP_READONLY_DATABASE_NAME = "database.isreadonly";
    Connection con;
    private String propertyTableName = null;
    int dbmsType;
    private PreparedStatement readerPreparedStatement;
    private boolean usePreparedStatement = false;
    boolean indexTable = false;

    @Deprecated
    public DatabaseProperties(ConnectionHandler conh) throws SQLException {
        this(conh, false);
    }

    public DatabaseProperties(ConnectionHandler conh, boolean indexTable) throws SQLException {
        this.con = conh.getConnection();
        this.propertyTableName = conh.getPropertyTable();
        this.indexTable = indexTable;
        this.dbmsType = DatabaseOptions.getDBMSType(this.con);
    }

    void setConnectionHandler(ConnectionHandler ch) {
        this.con = ch.getConnection();
        this.propertyTableName = ch.getPropertyTable();
    }

    private PreparedStatement getReaderPreparedStatement() throws SQLException {
        if (this.readerPreparedStatement == null) {
            String sql = "SELECT prop_value , prop_value_ext FROM " + this.propertyTableName + " WHERE " + NAME_COLUMN + " = '?'";
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(String.format("sql=%s", sql));
            }
            this.readerPreparedStatement = this.con.prepareStatement(sql);
        }
        return this.readerPreparedStatement;
    }

    private String getReaderSQL(String name) {
        String sql = "SELECT prop_value , prop_value_ext FROM " + this.propertyTableName + " WHERE " + NAME_COLUMN + " = '" + name + "'";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        return sql;
    }

    public String getProperty(String name) throws SQLException {
        return this.getProperty(name, new boolean[1]);
    }

    private boolean propertyExists(String name) throws SQLException {
        boolean[] exists = new boolean[1];
        this.getProperty(name, exists);
        return exists[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProperty(String name, boolean[] exists) throws SQLException {
        String value = null;
        Statement stmt = null;
        try {
            ResultSet rs = null;
            try {
                if (this.usePreparedStatement) {
                    PreparedStatement pstmt = this.getReaderPreparedStatement();
                    stmt = pstmt;
                    pstmt.setString(1, name);
                    rs = pstmt.executeQuery();
                } else {
                    stmt = this.con.createStatement();
                    rs = stmt.executeQuery(this.getReaderSQL(name));
                }
                exists[0] = false;
                if (rs.next()) {
                    exists[0] = true;
                    value = rs.getString(1);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            if (value == null) {
                value = this.getExtendedProperty(name);
            }
        }
        finally {
            if (stmt != null && !this.usePreparedStatement) {
                stmt.close();
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(String.format("[%s]: returning %s", name, value));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExtendedProperty(String name) throws SQLException {
        String value = null;
        String sql = "SELECT prop_value_ext FROM " + this.propertyTableName + " WHERE " + NAME_COLUMN + " = '" + name + "'";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            try {
                byte[] data;
                if (rs.next() && (data = DatabaseTools.readBytes(rs, 1)) != null) {
                    try {
                        value = new String(data, "ASCII");
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return value;
    }

    public int getIntProperty(String name) throws SQLException {
        String s = this.getProperty(name);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("ERROR: Cannot parse integer property \"" + name + "\" in property table");
            }
        }
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(String name, String value) throws SQLException {
        if (value == null) {
            this.deleteProperty(name);
            return;
        }
        boolean extended = false;
        if (value.length() > 200) {
            extended = true;
        }
        String sql = "INSERT INTO " + this.propertyTableName + " (" + NAME_COLUMN + ", " + VALUE_COLUMN;
        sql = extended ? sql + ", prop_value_ext) VALUES (?,?,?)" : sql + " ) VALUES (?,?)";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        PreparedStatement pstmt = this.con.prepareStatement(sql);
        try {
            block11: {
                pstmt.setString(1, name);
                if (extended) {
                    pstmt.setNull(2, 12);
                    try {
                        if (this.dbmsType == 7) {
                            pstmt.setBytes(3, value.getBytes("ASCII"));
                            break block11;
                        }
                        pstmt.setBinaryStream(3, (InputStream)new ByteArrayInputStream(value.getBytes()), value.length());
                    }
                    catch (UnsupportedEncodingException e) {
                        if (logger.isLoggable(Level.SEVERE)) {
                            logger.severe(e.toString());
                        }
                        break block11;
                    }
                }
                pstmt.setString(2, value);
            }
            pstmt.execute();
        }
        finally {
            pstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperty(String name, String value) throws SQLException {
        if (value == null) {
            this.deleteProperty(name);
            return;
        }
        boolean extended = false;
        if (value.length() > 200) {
            extended = true;
        }
        String sql = "UPDATE " + this.propertyTableName + " SET " + VALUE_COLUMN + "=? ";
        if (extended) {
            sql = sql + ", prop_value_ext=?";
        }
        sql = sql + " WHERE prop_name = '" + name + "'";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        PreparedStatement pstmt = this.con.prepareStatement(sql);
        try {
            if (extended) {
                pstmt.setString(1, null);
                try {
                    pstmt.setBytes(2, value.getBytes("ASCII"));
                }
                catch (UnsupportedEncodingException e) {}
            } else {
                pstmt.setString(1, value);
            }
            pstmt.executeUpdate();
        }
        finally {
            pstmt.close();
        }
    }

    public void setProperty(String name, String value) throws SQLException {
        if (value == null) {
            this.deleteProperty(name);
        } else if (!this.propertyExists(name)) {
            this.addProperty(name, value);
        } else {
            this.updateProperty(name, value);
        }
    }

    public void setDuplicateFilteringOption(String tableName, boolean value) throws SQLException {
        String propertyValue = String.valueOf(value);
        this.setTableProperty(tableName, "duplicateFiltering", propertyValue);
    }

    public void setAbsoluteStereoOption(String tableName, boolean value) throws SQLException {
        String propertyValue = String.valueOf(value);
        this.setTableProperty(tableName, "absoluteStereo", propertyValue);
    }

    public void setTautomerDuplicateFilteringOption(String tableName, boolean value) throws SQLException {
        String propertyValue = String.valueOf(value);
        this.setTableProperty(tableName, "tautomerDuplicateFiltering", propertyValue);
    }

    public void setStandardizerConfigOption(String tableName, String value) throws SQLException {
        this.setTableProperty(tableName, "standardizerConfig", value);
    }

    public void setTableProperty(String tableName, String propName, String propValue) throws SQLException {
        this.setProperty(this.tablePrefix(tableName) + "." + propName, propValue);
    }

    public String getTableProperty(String tableName, String propName) throws SQLException {
        return this.getProperty(this.tablePrefix(tableName) + "." + propName);
    }

    public int getTableIntProperty(String tableName, String propName) throws IllegalArgumentException, NumberFormatException, SQLException {
        String strValue = this.getProperty(this.tablePrefix(tableName) + "." + propName);
        if (strValue == null) {
            throw new IllegalArgumentException(String.format("Property \"%s\" is not found for table \"%s\".", propName, tableName));
        }
        try {
            return Integer.parseInt(strValue);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("Integer property \"%s\" of table \"%s\" cannot be parsed.", propName, tableName));
        }
    }

    public void deleteTableProperty(String tableName, String propName) throws SQLException {
        this.deleteProperty(this.tablePrefix(tableName) + "." + propName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTableProperties(String tableName) throws SQLException {
        String tableNameWithSchema = TableInfo.getTableNameWithSchema(this.con, tableName);
        String sql = "DELETE FROM " + this.propertyTableName + " WHERE " + NAME_COLUMN + " LIKE " + "'%table." + tableNameWithSchema + ".%'";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        Statement stmt = this.con.createStatement();
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
        sql = "DELETE FROM " + this.propertyTableName + " WHERE " + NAME_COLUMN + " LIKE " + "'update." + tableNameWithSchema + ".%'";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        stmt = this.con.createStatement();
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
    }

    public void setMDTableProperty(String tableName, String descrName, String propName, String propValue) throws SQLException {
        this.setProperty(this.tablePrefix(tableName) + "." + MD_PROPERTY_PREFIX + "." + descrName + "." + propName, propValue);
    }

    public String getMDTableProperty(String tableName, String descrName, String propName) throws SQLException {
        return this.getProperty(this.tablePrefix(tableName) + "." + MD_PROPERTY_PREFIX + "." + descrName + "." + propName);
    }

    public void deleteMDTableProperty(String tableName, String descrName, String propName) throws SQLException {
        this.deleteProperty(this.tablePrefix(tableName) + "." + MD_PROPERTY_PREFIX + "." + descrName + "." + propName);
    }

    public long incrementProperty(String name) throws SQLException {
        long value = 0L;
        String s = this.getProperty(name);
        if (s == null) {
            this.addProperty(name, "1");
            value = 1L;
        } else {
            value = Long.parseLong(s) + 1L;
            this.updateProperty(name, Long.toString(value));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProperty(String name) throws SQLException {
        String sql = "DELETE FROM " + this.propertyTableName + " WHERE " + NAME_COLUMN + " = " + "'" + name + "'";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        Statement stmt = this.con.createStatement();
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
    }

    private static String createCreateStatement(ConnectionHandler conh, boolean constraintNeeded, int mySqlTableType) throws SQLException {
        TypeConverter tc = new TypeConverter(conh.getConnection());
        String propertyTableName = conh.getPropertyTable();
        int dbmsType = DatabaseOptions.getDBMSType(conh.getConnection());
        String typeName = tc.getLocalTypeByCode(-4);
        if (dbmsType == 6) {
            typeName = typeName + "(1M)";
        }
        String sql = "CREATE TABLE " + propertyTableName + "(\n" + "\t" + NAME_COLUMN + " " + tc.getLocalTypeByCode(12) + "(" + 200 + ") NOT NULL " + (constraintNeeded ? "CONSTRAINT Constraint_" + propertyTableName + "_PK " : "") + "PRIMARY KEY,\n" + "\t" + VALUE_COLUMN + " " + tc.getLocalTypeByCode(12) + "(" + 200 + "), " + VALUE_COLUMN_EXT + " " + typeName;
        sql = sql + ")";
        if (dbmsType == 3 && mySqlTableType != 0) {
            sql = sql + " ENGINE=";
            switch (mySqlTableType) {
                case 1: {
                    sql = sql + "INNODB;";
                    break;
                }
                case 2: {
                    sql = sql + "MyISAM;";
                    break;
                }
                default: {
                    throw new IllegalStateException("MySQL table type " + mySqlTableType + " is not supported");
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        return sql;
    }

    public static boolean propertyTableExists(ConnectionHandler conh) {
        try {
            return TableNames.isTable(conh.getConnection(), conh.getPropertyTable());
        }
        catch (SQLException e) {
            logger.throwing("DatabaseProperties", "propertyTableExists", e);
            return false;
        }
    }

    public static void createPropertyTable(ConnectionHandler conh) throws SQLException {
        DatabaseProperties.createPropertyTable(conh, 0);
    }

    public static void createPropertyTable(ConnectionHandler conh, int mySqlTableType) throws SQLException {
        Connection con = conh.getConnection();
        DatabaseOptions dbOptions = new DatabaseOptions(conh);
        boolean constraintNeeded = dbOptions.constraintNeededForPrimaryKey;
        String sql = DatabaseProperties.createCreateStatement(conh, constraintNeeded, mySqlTableType);
        Statement stmt = con.createStatement();
        try {
            stmt.executeUpdate(sql);
        }
        catch (SQLException e1) {
            System.err.println("Error executing statement:\n" + sql);
            e1.fillInStackTrace();
            throw e1;
        }
        finally {
            stmt.close();
        }
        dbOptions.save(conh);
        TableInfo.createCacheRegistrationTableWithProperty(conh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> getStructureTableNames() throws SQLException {
        Vector<String> names = new Vector<String>();
        String start = this.indexTable ? "idxtable." : "table.";
        String end = ".fingerprint.numberOfBits";
        String sql = "SELECT prop_name FROM " + this.propertyTableName + " WHERE " + NAME_COLUMN + " LIKE " + "'" + start + "%" + end + "'";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            try {
                while (rs.next()) {
                    String nameColumn = rs.getString(1);
                    nameColumn = nameColumn.trim();
                    String name = nameColumn.substring(start.length(), nameColumn.length() - end.length());
                    names.addElement(name);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(String.format("Structure tables: %s", names));
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMolecularDescriptors(String tableName) throws SQLException {
        String propsPrefix = this.tablePrefix(tableName) + ".MD.";
        String postFix = ".Type";
        String sql = "SELECT prop_name FROM " + this.propertyTableName + " WHERE " + NAME_COLUMN + " LIKE " + "'" + propsPrefix + "%" + postFix + "'";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        Vector<String> mdNames = new Vector<String>();
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            try {
                while (rs.next()) {
                    String nameColumn = rs.getString(1);
                    String name = nameColumn.substring(propsPrefix.length(), nameColumn.length() - postFix.length());
                    mdNames.add(name);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        String[] names = new String[mdNames.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)mdNames.get(i);
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMolecularDescriptorDefined() throws SQLException {
        String prop = "%table.%.MD.%.Type";
        String sql = "SELECT prop_name FROM " + this.propertyTableName + " WHERE " + NAME_COLUMN + " LIKE " + "'" + prop + "'";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        Statement stmt = this.con.createStatement();
        try {
            boolean bl;
            ResultSet rs = stmt.executeQuery(sql);
            try {
                bl = rs.next();
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return bl;
        }
        finally {
            stmt.close();
        }
    }

    private void jchemTablesOnly() {
        if (this.indexTable) {
            throw new UnsupportedOperationException("This operation doesn't support JChem Cartridge index tables.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMDConfigs(String tableName, String descriptorName) throws SQLException {
        String propsPrefix = this.tablePrefix(tableName) + ".MD." + descriptorName + ".CONF.";
        String sql = "SELECT prop_name FROM " + this.propertyTableName + " WHERE " + NAME_COLUMN + " LIKE " + "'" + propsPrefix + "%'" + " ORDER BY " + NAME_COLUMN;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        Vector<String> mdConfigs = new Vector<String>();
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            try {
                while (rs.next()) {
                    String nameColumn = rs.getString(1);
                    String name = nameColumn.substring(propsPrefix.length());
                    mdConfigs.add(name);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        String[] configs = new String[mdConfigs.size()];
        for (int i = 0; i < configs.length; ++i) {
            configs[i] = (String)mdConfigs.get(i);
        }
        return configs;
    }

    String tablePrefix(String tableName) throws SQLException {
        return (this.indexTable ? "idxtable." : "table.") + TableInfo.getTableNameWithSchema(this.con, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteMDProperties(String tableName, String descriptorID) throws SQLException {
        String prefix = this.tablePrefix(tableName) + ".MD." + descriptorID + ".";
        String sql = "DELETE  FROM " + this.propertyTableName + " WHERE " + NAME_COLUMN + " LIKE " + "'" + prefix + "%'";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        Statement stmt = this.con.createStatement();
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getSynthesisNames() throws SQLException {
        this.jchemTablesOnly();
        String propsPrefix = "synthesis.";
        String postFix = ".Settings";
        String sql = "SELECT prop_name FROM " + this.propertyTableName + " WHERE " + NAME_COLUMN + " LIKE " + "'" + propsPrefix + "%" + postFix + "'";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        ArrayList<String> sNames = new ArrayList<String>();
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            try {
                while (rs.next()) {
                    String nameColumn = rs.getString(1);
                    String name = nameColumn.substring(propsPrefix.length(), nameColumn.length() - postFix.length());
                    sNames.add(name);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        String[] names = new String[sNames.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)sNames.get(i);
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteSynthesisProperties(String synthesisName) throws SQLException {
        String prefix = "synthesis." + synthesisName + ".";
        String sql = "DELETE  FROM " + this.propertyTableName + " WHERE " + NAME_COLUMN + " LIKE " + "'" + prefix + "%'";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        Statement stmt = this.con.createStatement();
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
    }

    public boolean isUsePreparedStatement() {
        return this.usePreparedStatement;
    }

    public void setUsePreparedStatement(boolean usePreparedStatement) {
        this.usePreparedStatement = usePreparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getChemTermColumns(String tableName) throws SQLException {
        String tableNameWithSchema = TableInfo.getTableNameWithSchema(this.con, tableName);
        String propsPrefix = CTColumnPropUtil.getChemTermColumnPropNamePfx(tableNameWithSchema, this.indexTable);
        String sql = "SELECT prop_name FROM " + this.propertyTableName + " WHERE " + NAME_COLUMN + " LIKE " + "'" + propsPrefix + "%'";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        Vector<String> ctColNames = new Vector<String>();
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            try {
                while (rs.next()) {
                    String propName = rs.getString(1);
                    int lastDotPos = propName.lastIndexOf(46);
                    String colName = propName.substring(lastDotPos + 1);
                    ctColNames.add(colName.toUpperCase());
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return ctColNames.toArray(new String[ctColNames.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChemTermColumnDefined() throws SQLException {
        String prop = "%table.%.chemTermColumn.%";
        String sql = "SELECT prop_name FROM " + this.propertyTableName + " WHERE " + NAME_COLUMN + " LIKE " + "'" + prop + "'";
        Statement stmt = this.con.createStatement();
        try {
            boolean bl;
            ResultSet rs = stmt.executeQuery(sql);
            try {
                bl = rs.next();
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return bl;
        }
        finally {
            stmt.close();
        }
    }

    public void setChemTermForColumn(String tableName, String columnName, String expression) throws SQLException {
        String tableNameWithSchema = TableInfo.getTableNameWithSchema(this.con, tableName);
        String name = CTColumnPropUtil.getChemTermColumnPropName(tableNameWithSchema, this.indexTable, columnName);
        String value = expression;
        this.setProperty(name, value);
    }

    public String getChemTermForColumn(String tableName, String columnName) throws SQLException {
        String tableNameWithSchema = TableInfo.getTableNameWithSchema(this.con, tableName);
        return this.getProperty(CTColumnPropUtil.getChemTermColumnPropName(tableNameWithSchema, this.indexTable, columnName));
    }

    public void deleteChemTermForColumn(String tableName, String columnName) throws SQLException {
        String tableNameWithSchema = TableInfo.getTableNameWithSchema(this.con, tableName);
        this.deleteProperty(CTColumnPropUtil.getChemTermColumnPropName(tableNameWithSchema, this.indexTable, columnName));
    }

    public int getTableType(String tableName) throws SQLException {
        int mode = this.getIntProperty(this.tablePrefix(tableName) + "." + "tableType");
        if (mode == Integer.MIN_VALUE) {
            mode = 2;
        }
        return mode;
    }

    public String setCacheRegistrationTableName() throws SQLException {
        String tableName = this.propertyTableName.indexOf(46) == -1 ? TableInfo.getTableNameWithSchema(this.con, this.propertyTableName) : this.propertyTableName;
        String cacheRegTableName = tableName + "_CR";
        this.setProperty("cache.registration_table", cacheRegTableName);
        return cacheRegTableName;
    }

    public String getCacheRegistrationTableName() throws SQLException {
        return this.getProperty("cache.registration_table");
    }

    public boolean isTautomerDuplicateFilteringEnabled(String tableName) throws SQLException {
        int tableType = this.getTableType(tableName);
        if (tableType == 4 || tableType == 3) {
            return false;
        }
        String prop = this.getProperty(this.tablePrefix(tableName) + "." + "tautomerDuplicateFiltering");
        return prop != null && prop.trim().equalsIgnoreCase("true");
    }

    public boolean isGenericTautomerProtectsChirality(String tableName) throws SQLException {
        String prop = this.getProperty(this.tablePrefix(tableName) + "." + "genericTautomerProtectsChirality");
        return prop == null || prop.trim().equalsIgnoreCase("true");
    }

    public boolean isSetSwitchOffAllProtectionsForTDF(String tableName) throws SQLException {
        String prop = this.getProperty(this.tablePrefix(tableName) + "." + "switchOffAllProtections");
        return prop != null && prop.trim().equalsIgnoreCase("true");
    }

    public boolean isDatabaseReadonly() throws SQLException {
        String prop = this.getProperty(PROP_READONLY_DATABASE_NAME);
        return prop != null && !prop.trim().equalsIgnoreCase("false");
    }

    public void close() throws SQLException {
        if (this.readerPreparedStatement != null) {
            this.readerPreparedStatement.close();
        }
    }

    public String[] getFingerprintParams(String tableName) throws SQLException {
        String[] fpParams = new String[3];
        String prefix = this.tablePrefix(tableName) + ".";
        fpParams[0] = this.getProperty(prefix + "fingerprint.numberOfBits");
        fpParams[1] = this.getProperty(prefix + "fingerprint.numberOfOnes");
        fpParams[2] = this.getProperty(prefix + "fingerprint.numberOfEdges");
        return fpParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getTableProperties(String tableName) throws SQLException {
        HashMap<String, String> tableProps = new HashMap<String, String>();
        String prefix = this.tablePrefix(tableName) + ".";
        String sql = "SELECT prop_name, prop_value FROM " + this.propertyTableName + " WHERE " + NAME_COLUMN + " LIKE " + "'" + prefix + "%'";
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            try {
                while (rs.next()) {
                    tableProps.put(rs.getString(1).substring(prefix.length()), rs.getString(2));
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return tableProps;
    }

    public boolean isDuplicateFilteringOption(String tableName) throws SQLException {
        String prop = this.getProperty(this.tablePrefix(tableName) + "." + "duplicateFiltering");
        return prop != null && prop.equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder getAllProperties() throws SQLException {
        StringBuilder sb = new StringBuilder("\n===============Content of JChem property table ======================\n");
        String sql = "SELECT prop_name FROM " + this.propertyTableName + " ORDER BY " + NAME_COLUMN;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("sql=%s", sql));
        }
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            try {
                while (rs.next()) {
                    String propertyName = rs.getString(1);
                    sb.append(propertyName).append("\n\t").append(this.getProperty(propertyName)).append("\n");
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return sb;
    }

    static Vector<String> getExistingTables(ConnectionHandler ch) throws SQLException {
        DatabaseProperties dbProps = new DatabaseProperties(ch, false);
        Vector<String> names = dbProps.getStructureTableNames();
        Vector<String> tables = new Vector<String>();
        Enumeration<String> e = names.elements();
        while (e.hasMoreElements()) {
            tables.add(e.nextElement());
        }
        dbProps.indexTable = true;
        names = dbProps.getStructureTableNames();
        e = names.elements();
        while (e.hasMoreElements()) {
            tables.add(e.nextElement());
        }
        return tables;
    }

    public static String getCacheRegistrationTableName(ConnectionHandler conh) throws SQLException {
        DatabaseProperties dp = new DatabaseProperties(conh, false);
        String cacheRegisterTableName = dp.getCacheRegistrationTableName();
        return cacheRegisterTableName;
    }
}

