/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.sql.TypeConverter;
import chemaxon.jchem.file.FieldData;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class FieldInfo {
    private String name;
    private int type;
    private String typeName;
    private String otherName;
    private Object value;
    private boolean chemTermBased;
    public static final String idFieldName = "cd_id";
    public static final String structureFieldName = "cd_structure";
    public static final String markushFieldName = "cd_markush";
    public static final String fpFieldPrefix = "cd_fp";
    public static final String smilesFieldName = "cd_smiles";
    public static final String smartsFieldName = "cd_smarts";
    public static final String formulaFieldName = "cd_formula";
    public static final String sortableFormulaFieldName = "cd_sortable_formula";
    public static final String molWeightFieldName = "cd_molweight";
    public static final String hashFieldName = "cd_hash";
    public static final String flagsFieldName = "cd_flags";
    public static final String dateFieldName = "cd_timestamp";
    public static final String preCalculatedFieldName = "cd_pre_calculated";
    public static final String descriptorDataFieldName = "md_data";
    public static final String notConnected = "[Not connected]";
    public static final String autoIncrement = "[Auto incrementing]";
    public static final String molNameField = "[Molecule name]";
    public static final String otherNameForStructureField = "[Structure]";
    public static final String otherNameForFingerprint = "[Fingerprint]";
    public static final String otherNameForSmilesField = "[Smiles]";
    public static final String otherNameForFormulaField = "[Formula]";
    public static final String otherNameForSortableFormulaField = "[Sortable formula]";
    public static final String otherNameForMolWeightField = "[Molweight]";
    public static final String otherNameForHashField = "[Hash code]";
    public static final String otherNameForFlagsField = "[Flags]";
    public static final String otherNameForDateField = "[Timestamp]";
    public static final String otherNameForPrecalculatedField = "[Is precalculated]";
    public static final int FORMULA_LENGTH = 100;
    public static final int SORTABLE_FORMULA_LENGTH = 255;
    public static final int SORTABLE_FORMULA_LENGTH_ORACLE = 500;
    public static final int FLAGS_LENGTH = 20;

    private static List<String> getReservedColumnNames() {
        ArrayList<String> list = new ArrayList<String>();
        Field[] fields = FieldInfo.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int modifiers = field.getModifiers();
            String fieldName = field.getName();
            if (!Modifier.isPublic(modifiers) || !Modifier.isFinal(modifiers) || !Modifier.isStatic(modifiers) || !field.getType().equals(String.class) || !fieldName.endsWith("FieldName") && !fieldName.startsWith("otherNameFor")) continue;
            try {
                list.add(((String)field.get(null)).toUpperCase());
                continue;
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("Error while trying to discover reserved column names: " + iae.getMessage());
            }
        }
        return list;
    }

    public static boolean isReservedColumnName(String name) {
        name = name.toUpperCase();
        return FieldInfo.getReservedColumnNames().contains(name) || name.startsWith("CD_FP");
    }

    public FieldInfo(String name, int type, String typeName) {
        this.name = name.toUpperCase();
        this.type = type;
        this.typeName = typeName;
        this.otherName = null;
        this.value = null;
    }

    public FieldInfo(String name, int type, String typeName, String otherName) {
        this.name = name.toUpperCase();
        this.type = type;
        this.typeName = typeName;
        this.otherName = otherName;
        this.value = null;
    }

    public final boolean equals(Object other) {
        if (other.getClass().getName().equals("String")) {
            return ((String)other).equals(this.name);
        }
        if (other.getClass().getName().equals(this.getClass().getName())) {
            return ((FieldData)other).getName().equals(this.name);
        }
        return false;
    }

    public final String getName() {
        return this.name;
    }

    public final String getOtherName() {
        return this.otherName;
    }

    public final int getType() {
        return this.type;
    }

    public final String getTypeName() {
        return this.typeName;
    }

    public final Object getValue() {
        return this.value;
    }

    public final boolean isAutoIncremented() {
        return this.otherName.equals(autoIncrement);
    }

    public final boolean isConnected() {
        return !this.otherName.equals(notConnected);
    }

    public final boolean isMolName() {
        return this.otherName.equals(molNameField);
    }

    public final boolean isFingerprint() {
        return this.name.toLowerCase().startsWith(fpFieldPrefix);
    }

    public final boolean isId() {
        return this.name.toLowerCase().equals(idFieldName);
    }

    public final boolean isStructure() {
        return this.name.toLowerCase().equals(structureFieldName);
    }

    public final boolean isSmiles() {
        return this.name.toLowerCase().equals(smilesFieldName);
    }

    public final boolean isFormula() {
        return this.name.toLowerCase().equals(formulaFieldName);
    }

    public final boolean isSortableFormula() {
        return this.name.toLowerCase().equals(sortableFormulaFieldName);
    }

    public final boolean isMolWeight() {
        return this.name.toLowerCase().equals(molWeightFieldName);
    }

    public final boolean isHash() {
        return this.name.toLowerCase().equals(hashFieldName);
    }

    public final boolean isFlags() {
        return this.name.toLowerCase().equals(flagsFieldName);
    }

    public final boolean isDate() {
        return this.name.toLowerCase().equals(dateFieldName);
    }

    public final boolean isPrecalculated() {
        return this.name.toLowerCase().equals(preCalculatedFieldName);
    }

    public final void setOtherName(String name) {
        this.otherName = name;
    }

    public final void setValue(Object value) {
        this.value = value;
    }

    public final void setValue(String value, int sqlType) throws SQLException {
        this.value = TypeConverter.convert(value, sqlType);
    }

    public String toString() {
        return this.getName();
    }

    public synchronized boolean isChemTermBased() {
        return this.chemTermBased;
    }

    public synchronized void setChemTermBased(boolean chemTermBased) {
        this.chemTermBased = chemTermBased;
    }
}

