/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.FieldInfo;
import chemaxon.jchem.db.ParallelStructTableUpdater;
import chemaxon.jchem.db.PropertyNotSetException;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.file.FileInfo;
import chemaxon.jchem.file.ImportFileHandler;
import chemaxon.jchem.file.MolRecord;
import chemaxon.jchem.file.ProgressWriter;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.IntArray;
import chemaxon.util.concurrent.InputProducer;
import chemaxon.util.concurrent.util.ConcurrentIteratorAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileToSQLHandler {
    private static Log log = LogFactory.getLog(FileToSQLHandler.class);
    ConnectionHandler conh;
    Connection con;
    String tableName;
    String lineSeparator;
    boolean autoIncImport;
    private final ParallelStructTableUpdater pstu = new ParallelStructTableUpdater();
    public static final String CD_SMILES_FORMAT = "cxsmiles";
    private PrintStream infoStream = null;

    public FileToSQLHandler(ConnectionHandler conh, String tableName) {
        this.conh = conh;
        this.con = conh.getConnection();
        this.tableName = tableName;
    }

    public void setInfoStream(PrintStream st) {
        this.infoStream = st;
    }

    private ImportFileHandler createImportFileHandler(InputStream is, TableInfo tableInfo, String fileName) throws IOException {
        Vector<String> legalFieldNames = new Vector<String>(10);
        Enumeration<FieldInfo> e = tableInfo.elements();
        while (e.hasMoreElements()) {
            FieldInfo fieldInfo = e.nextElement();
            if (!fieldInfo.isConnected() || fieldInfo.isChemTermBased()) continue;
            legalFieldNames.addElement(fieldInfo.getOtherName());
        }
        return new ImportFileHandler(is, legalFieldNames, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importFile(InputStream is, ProgressWriter pw, DatabaseOptions dbOptions, TableInfo tableInfo, int format2, FileInfo fileInfo, boolean isHaltAtError, int duplicateFilteringOption, boolean setChiralFlag, boolean allowEmptyStructures, boolean printDuplicates, boolean printNonDuplicates, PrintStream os, boolean doNotImport, boolean storeDuplicates, boolean storeImported, String nameField) throws SQLException, IOException, PropertyNotSetException, ExecutionException {
        boolean flipAutoCommit;
        ImportFileHandler ifh = this.createImportFileHandler(is, tableInfo, fileInfo.getFileName());
        FileMolSource molSource = new FileMolSource(ifh);
        this.pstu.setInfoStream(this.infoStream);
        int commitInterval = this.getCommitInterval();
        boolean bl = flipAutoCommit = this.conh.getConnection().getAutoCommit() && commitInterval > 1;
        if (flipAutoCommit) {
            this.conh.getConnection().setAutoCommit(false);
        }
        try {
            this.pstu.setCommitInterval(commitInterval);
            this.pstu.importFile(this.conh, this.tableName, molSource, pw, tableInfo, isHaltAtError, duplicateFilteringOption, setChiralFlag, allowEmptyStructures, printDuplicates, printNonDuplicates, os, fileInfo, doNotImport, storeDuplicates, storeImported, nameField, -1);
        }
        finally {
            if (flipAutoCommit) {
                this.conh.getConnection().commit();
                this.conh.getConnection().setAutoCommit(true);
            }
        }
        return this.pstu.getImported();
    }

    private int getCommitInterval() throws SQLException {
        DatabaseProperties dbProps = new DatabaseProperties(this.conh, false);
        return DatabaseOptions.getCommitInterval(dbProps);
    }

    public void stop() {
        this.pstu.cancel();
    }

    public ArrayList<Integer> getDuplicateIDs() {
        return this.pstu.getDuplicateIDs();
    }

    public IntArray getImportedIDs() {
        return this.pstu.getImportedIDs();
    }

    public int getDuplicates() {
        return this.pstu.getDuplicates();
    }

    public int getEmpty() {
        return this.pstu.getEmpty();
    }

    public int getProcessed() {
        return this.pstu.getProcessed();
    }

    public int getImported() {
        return this.pstu.getImported();
    }

    private class FileMolSource
    extends ConcurrentIteratorAdapter
    implements InputProducer {
        private final ImportFileHandler ifh;

        public FileMolSource(ImportFileHandler ifh) {
            this.ifh = ifh;
        }

        @Override
        protected Object removeNext() throws InterruptedException, ExecutionException {
            try {
                MolRecord next = this.ifh.getRecord();
                if (next == null) {
                    return POISON;
                }
                return next;
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"error", (Throwable)e);
                }
                return POISON;
            }
        }
    }
}

