/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.FileToSQLHandler;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.Transfer;
import chemaxon.jchem.db.TransferException;
import chemaxon.jchem.file.FileInfo;
import chemaxon.jchem.file.ImportFileHandler;
import chemaxon.jchem.file.ProgressWriter;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.util.Compression;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.IntArray;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class Importer
extends Thread
implements Transfer {
    private static final Logger logger = Logger.getLogger(Importer.class.getName());
    private static final int LINE_LIMIT = 2000000000;
    private FileToSQLHandler handler = null;
    private int format;
    private BufferedInputStream bis;
    private DatabaseOptions dbOptions;
    private TableInfo tableInfo;
    private FileInfo fileInfo;
    private ConnectionHandler conh = null;
    private Object input = null;
    private String tablename = null;
    private String connections = null;
    private int linesToCheck = 500;
    private ProgressWriter pwriter = null;
    private boolean haltOnError = false;
    private int duplicateFilteringOption = 0;
    private boolean emptyAllowed = true;
    private boolean setChiralFlag = false;
    private boolean initialized = false;
    private int skip = 0;
    private boolean finished = false;
    private int structCount = 0;
    private int importedNumber = 0;
    private int duplicates = 0;
    private int empties = 0;
    private volatile String errorMessage = "";
    private volatile Throwable errorCause = null;
    boolean printDuplicates = false;
    boolean printNonDuplicates = false;
    PrintStream os = System.out;
    boolean doNotImport = false;
    boolean storeDuplicates = false;
    boolean storeImported = false;
    private String nameFieldInDB = "";
    private PrintStream infoStream = null;

    public void setConnectionHandler(ConnectionHandler conh) {
        this.conh = conh;
    }

    public ConnectionHandler getConnectionHandler() {
        return this.conh;
    }

    public void setInput(File inputFile) {
        this.input = inputFile;
    }

    public void setInput(InputStream is) {
        this.input = is;
    }

    public void setInput(String fileName) {
        this.input = new File(fileName);
    }

    public Object getInput() {
        return this.input;
    }

    public void setTableName(String tname) {
        this.tablename = tname;
    }

    public String getTableName() {
        return this.tablename;
    }

    @Deprecated
    public void setConnections(String connections) {
        this.setFieldConnections(connections);
    }

    public void setFieldConnections(String connections) {
        this.connections = connections;
    }

    @Deprecated
    public String getConnections() {
        return this.getFieldConnections();
    }

    public String getFieldConnections() {
        return this.connections;
    }

    public void setLinesToCheck(int linesToCheck) {
        this.linesToCheck = linesToCheck;
    }

    public int getLinesToCheck() {
        return this.linesToCheck;
    }

    public void setProgressWriter(ProgressWriter pwriter) {
        this.pwriter = pwriter;
    }

    public ProgressWriter getProgressWriter() {
        return this.pwriter;
    }

    public void setHaltOnError(boolean b) {
        this.haltOnError = b;
    }

    public boolean isHaltOnError() {
        return this.haltOnError;
    }

    @Deprecated
    public void setDuplicateImportAllowed(boolean b) {
        this.duplicateFilteringOption = b ? 2 : 1;
    }

    public void setDuplicateImportAllowed(int duplicateFilteringOption) {
        this.duplicateFilteringOption = duplicateFilteringOption;
    }

    public boolean isDuplicateImportAllowed() {
        if (this.duplicateFilteringOption != 0) {
            return this.duplicateFilteringOption == 2;
        }
        if (this.conh == null) {
            throw new NullPointerException("Connection handler not specified.");
        }
        if (this.tablename == null) {
            throw new NullPointerException("Structure table not specified.");
        }
        try {
            DatabaseProperties dbProp = new DatabaseProperties(this.conh, false);
            return !dbProp.isDuplicateFilteringOption(this.tablename);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Table option could not be determined.", e);
        }
    }

    public void setEmptyStructuresAllowed(boolean b) {
        this.emptyAllowed = b;
    }

    public boolean getEmptyStructuresAllowed() {
        return this.emptyAllowed;
    }

    public void setSetChiralFlag(boolean setChiralFlag) {
        this.setChiralFlag = setChiralFlag;
    }

    public boolean getSetChiralFlag() {
        return this.setChiralFlag;
    }

    public void setNameFieldInDB(String fieldName) {
        this.nameFieldInDB = fieldName;
    }

    public String getNameFieldInDB() {
        return this.nameFieldInDB;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Throwable getErrorCause() {
        return this.errorCause;
    }

    public int getStructCount() {
        return this.structCount;
    }

    public int getImportedNumber() {
        return this.importedNumber;
    }

    public int getDuplicates() {
        return this.duplicates;
    }

    public int getEmptyStructures() {
        return this.empties;
    }

    public String getNote() {
        return this.pwriter.getNote();
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public int getSkip() {
        return this.skip;
    }

    public long getProgress() {
        if (this.pwriter != null) {
            return this.pwriter.getProgress();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.errorCause != null) {
            logger.warning("Error during DB import previously found: " + this.errorCause + " - " + this.errorCause.getMessage());
        }
        try {
            if (!this.initialized) {
                this.init();
            }
            if (this.skip > 0) {
                this.skip(this.skip);
            }
            this.importMols();
        }
        catch (Throwable e) {
            logger.warning("Error during DB import: " + e + ": " + e.getMessage());
            if (this.errorCause != null) {
                logger.warning("Previous error will be overwritten: " + this.errorCause + " - " + this.errorCause.getMessage());
            }
            this.errorCause = e;
            this.errorMessage = e.getMessage();
        }
        finally {
            this.finished = true;
        }
    }

    public void setInfoStream(PrintStream st) {
        this.infoStream = st;
    }

    public void setOutputOptions(boolean printDuplicates, boolean printNonDuplicates, OutputStream os, boolean doNotImport) {
        this.printDuplicates = printDuplicates;
        this.printNonDuplicates = printNonDuplicates;
        this.doNotImport = doNotImport;
        if (os != null) {
            this.os = new PrintStream(new BufferedOutputStream(os));
        }
    }

    public void setStoreDuplicates(boolean value) {
        this.storeDuplicates = value;
    }

    public void setStoreImportedIDs(boolean value) {
        this.storeImported = value;
    }

    public ArrayList<Integer> getDuplicateIDs() {
        return this.handler.getDuplicateIDs();
    }

    public IntArray getImportedIDs() {
        return this.handler.getImportedIDs();
    }

    public int importMols() throws TransferException {
        if (!this.initialized) {
            this.init();
        }
        if (this.pwriter == null) {
            this.pwriter = new ProgressWriter("", 1L, 10000000L);
        }
        try {
            this.handler.setInfoStream(this.infoStream);
            int n = this.handler.importFile(this.bis, this.pwriter, this.dbOptions, this.tableInfo, this.format, this.fileInfo, this.haltOnError, this.duplicateFilteringOption, this.setChiralFlag, this.emptyAllowed, this.printDuplicates, this.printNonDuplicates, this.os, this.doNotImport, this.storeDuplicates, this.storeImported, this.nameFieldInDB);
            return n;
        }
        catch (Exception e) {
            logger.throwing("Importer", "importMols", e);
            throw new TransferException("Unexpected error during DB import: " + e.getMessage(), e);
        }
        finally {
            this.importedNumber = this.handler.getImported();
            this.structCount = this.handler.getProcessed();
            this.duplicates = this.handler.getDuplicates();
            this.empties = this.handler.getEmpty();
            try {
                this.bis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void cancel() {
        if (this.handler != null) {
            this.handler.stop();
        }
        if (this.errorCause != null) {
            logger.warning("Previous error will be overwritten due to cancellation: " + this.errorCause + " - " + this.errorCause.getMessage());
        }
        this.errorMessage = "Import cancelled.";
        this.errorCause = null;
    }

    public void skip(int offset) throws TransferException {
        if (!this.initialized) {
            this.init();
        }
        if (this.format == 5) {
            this.skipRDF(offset);
            return;
        }
        int[][] se = new int[][]{{77, 32, 32, 69, 78, 68}, {36, 36, 36, 36}, {0}, {0}};
        int[] target = se[this.format - 1];
        int[] intBuf = new int[target.length];
        int ch = 0;
        int count = 0;
        try {
            while (count < offset) {
                ch = this.bis.read();
                if (ch == -1) {
                    System.err.println("Cannot skip " + offset + " structures.");
                    throw new IOException();
                }
                if (FileInfo.isSmilesFormat(this.format) || this.format == 4) {
                    Importer.skipLine(this.bis);
                    ++count;
                    continue;
                }
                for (int i = 0; i < intBuf.length - 1; ++i) {
                    intBuf[i] = intBuf[i + 1];
                }
                intBuf[intBuf.length - 1] = ch;
                boolean match = true;
                for (int i = 0; i < target.length; ++i) {
                    if (target[i] == intBuf[i]) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                ++count;
                for (int x = 0; x < intBuf.length; ++x) {
                    intBuf[x] = 0;
                }
            }
            if (!FileInfo.isSmilesFormat(this.format) && this.format != 4) {
                Importer.skipLine(this.bis);
            }
        }
        catch (Exception e) {
            logger.throwing("Importer", "skip", e);
            throw new TransferException("Unexpected error during DB import skipping molecules: " + e.getMessage(), e);
        }
    }

    private void skipRDF(int offset) throws TransferException {
        if (offset == -23423423) {
            throw new TransferException("dummy exception");
        }
        System.err.println("Warning: molecule skipping is not implemented for RDF yet. Not skipping any molecules.");
    }

    public void init() throws TransferException {
        this.initialized = true;
        String error = null;
        if (this.conh == null) {
            error = "ConectionHandler not specified.";
        }
        if (this.tablename == null) {
            error = "Name of table not specified.";
        }
        if (this.input == null) {
            error = "Input not specified.";
        }
        if (error != null) {
            throw new TransferException(error);
        }
        try {
            boolean autoConnect;
            if (this.connections == null) {
                autoConnect = true;
                this.connections = "";
            } else {
                autoConnect = false;
            }
            this.tablename = TableInfo.getTableNameWithSchema(this.conh.getConnection(), this.tablename);
            this.getFileInfo();
            this.format = this.fileInfo.getFormat();
            Properties props = new Properties();
            StringTokenizer pairs = new StringTokenizer(this.connections, ";");
            Vector<String> dataFields = new Vector<String>();
            while (pairs.hasMoreTokens()) {
                String pair = pairs.nextToken();
                StringTokenizer st = new StringTokenizer(pair, "=");
                String tableField = st.nextToken().trim().toUpperCase();
                String dataField = st.nextToken().trim().toUpperCase();
                if (!this.fileInfo.fieldNames.contains(dataField)) continue;
                props.put("import.ConnectFields.Field." + tableField, dataField);
                dataFields.add(dataField);
            }
            this.tableInfo = TableInfo.getTableInfo(this.conh, props, this.tablename);
            if (autoConnect) {
                this.tableInfo.autoConnectFieldsForImport(this.fileInfo.fieldNames, props);
            } else {
                this.tableInfo.connectFieldsForImport(dataFields, props, false);
            }
            this.handler = new FileToSQLHandler(this.conh, this.tablename);
            this.dbOptions = DatabaseOptions.getFromDatabase(this.conh);
            if (this.input instanceof File) {
                InputStream is = new FileInputStream((File)this.input);
                is = Compression.decompressIfNeeded(is);
                this.bis = new BufferedInputStream(is);
            }
        }
        catch (Exception e) {
            logger.throwing("Importer", "init", e);
            throw new TransferException("Unexpected error during Importer initialization: " + e.getMessage(), e);
        }
    }

    private void getFileInfo() throws IOException, MRecordParseException {
        ProgressWriter pwriter = new ProgressWriter("", 1L, 10000000L);
        if (this.input instanceof InputStream) {
            InputStream is = (InputStream)this.input;
            is = Compression.decompressIfNeeded(is);
            this.bis = new BufferedInputStream(is);
            if (this.linesToCheck > 2000000000 || this.linesToCheck == 0) {
                System.err.println("Warning: check limit is 2000000000 lines for stream.");
                this.linesToCheck = 2000000000;
            }
            this.bis.mark(Integer.MAX_VALUE);
            this.fileInfo = ImportFileHandler.collectFileInfo(this.bis, pwriter, this.linesToCheck);
            this.bis.reset();
        } else {
            File file = (File)this.input;
            InputStream is = new FileInputStream(file);
            String path = (is = Compression.decompressIfNeeded(is)) instanceof GZIPInputStream ? null : file.getPath();
            this.bis = new BufferedInputStream(is);
            this.fileInfo = ImportFileHandler.collectFileInfo(this.bis, pwriter, this.linesToCheck, path);
        }
    }

    private static void skipLine(BufferedInputStream is) throws IOException {
        int ch;
        do {
            if ((ch = is.read()) == -1) {
                throw new IOException();
            }
            if (ch != 10) continue;
            return;
        } while (ch != 13);
        is.mark(10);
        ch = is.read();
        if (ch == 10) {
            return;
        }
        is.reset();
    }

    public Vector<String> getFieldNames() throws TransferException, IOException {
        if (!this.initialized) {
            this.init();
        }
        return this.fileInfo.fieldNames;
    }

    public static Vector<String> getFieldNames(InputStream is, int linesToCheck) throws IOException, MRecordParseException {
        is = Compression.decompressIfNeeded(is);
        BufferedInputStream bis = new BufferedInputStream(is);
        ProgressWriter pwriter = new ProgressWriter("", 1L, 10000000L);
        FileInfo fileInfo = ImportFileHandler.collectFileInfo(bis, pwriter, linesToCheck);
        is.close();
        return fileInfo.fieldNames;
    }
}

