/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.agent.ObjectSizeInfo;
import chemaxon.agent.SizeInfoFactory;
import chemaxon.clustering.chemistry.Fingerprint;
import chemaxon.common.util.FloatVector;
import chemaxon.common.util.IntVector;
import chemaxon.descriptors.InHouseDefaultParser;
import chemaxon.descriptors.MDDBReader;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDReaderException;
import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MetricsType;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.RFParameters;
import chemaxon.descriptors.ReactionFingerprint;
import chemaxon.descriptors.SimilarityCalculator;
import chemaxon.descriptors.SimilarityCalculatorFactory;
import chemaxon.descriptors.SimilarityException;
import chemaxon.enumeration.ExpansionUtil;
import chemaxon.enumeration.MolEnumerator;
import chemaxon.enumeration.SearchEnumerator;
import chemaxon.enumeration.homology.HomologyConversionUtil;
import chemaxon.enumeration.supergraph.MarkushAromata;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.enumeration.supergraph.SupergraphException;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.db.CacheFactory;
import chemaxon.jchem.db.CachePool;
import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.FingerprintHandler;
import chemaxon.jchem.db.JChemCache;
import chemaxon.jchem.db.JChemObserver;
import chemaxon.jchem.db.JChemObserverImpl;
import chemaxon.jchem.db.MDTableHandler;
import chemaxon.jchem.db.MaxSearchFrequencyExceededException;
import chemaxon.jchem.db.Monitor;
import chemaxon.jchem.db.PropertyNotSetException;
import chemaxon.jchem.db.RegenerationChecker;
import chemaxon.jchem.db.ScreenedHandler;
import chemaxon.jchem.db.ScreenedQueueHandler;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.TableTypeConstants;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.db.cdmarkush.CDMarkushFromDB;
import chemaxon.jchem.db.cdmarkush.CDMarkushHandlerCache;
import chemaxon.jchem.db.sql.TypeConverter;
import chemaxon.jchem.db.status.IncidentsObserver;
import chemaxon.jchem.db.status.incidentsets.JCSIncidents;
import chemaxon.jchem.db.status.observers.JCSObserver;
import chemaxon.jchem.db.status.observers.LogObserver;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.jep.ChemJEP;
import chemaxon.jep.Evaluator;
import chemaxon.jep.context.MolContext;
import chemaxon.jep.util.SubstitutionUtil;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.io.formats.smiles.CxsmilesImport;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.reaction.Standardizer;
import chemaxon.reaction.StandardizerException;
import chemaxon.sss.SearchConstants;
import chemaxon.sss.formula.FormulaSearch;
import chemaxon.sss.screen.CombinedFingerprint;
import chemaxon.sss.screen.HashCode;
import chemaxon.sss.screen.Similarity;
import chemaxon.sss.screen.handler.ScreenHandlerBytes;
import chemaxon.sss.screen.handler.UnsupportedMoleculeException;
import chemaxon.sss.screen.options.DefaultScreenOptions;
import chemaxon.sss.search.DataSgroupComparator;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.sss.search.MatchCountOptions;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.RgDecompResults;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchOptions;
import chemaxon.sss.search.SearchUtil;
import chemaxon.sss.search.TautomerUtil;
import chemaxon.sss.search.options.HaltOnErrorOption;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.util.BinaryDataUtil;
import chemaxon.util.BlockingIntArrayQueue;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import chemaxon.util.Dumper;
import chemaxon.util.ErrorHandler;
import chemaxon.util.EventCounter;
import chemaxon.util.FloatIntQuickSort;
import chemaxon.util.HitColoringAndAlignmentOptions;
import chemaxon.util.HitDisplayTool;
import chemaxon.util.Misc;
import chemaxon.util.MolHandler;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.StringTokenizer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JChemSearch
extends ErrorHandler
implements Serializable,
SearchConstants,
TableTypeConstants,
Licensable {
    private static final int BEFORE_ENUM_SCREEN_LIMIT = 4;
    private static final Logger infoLogger = Logger.getLogger(JChemSearch.class.getName() + ".stats");
    private final JCSIncidents incidents;
    private final JChemObserverImpl jchemObserverImpl;
    private static final Log log = LogFactory.getLog(JChemSearch.class);
    public static final int NO_RESULT_TABLE = 0;
    public static final int CREATE_OR_REPLACE_RESULT_TABLE = 1;
    public static final int APPEND_TO_RESULT_TABLE = 2;
    public static final int NO_ORDERING = 0;
    public static final int ORDERING_BY_ID = 1;
    public static final int ORDERING_BY_ID_OR_SIMILARITY = 2;
    public static final int ORDERING_BY_FILTER_ID_LIST = 3;
    static EventCounter eventCounter = null;
    static int peakSearchNum = 0;
    private static CachePool cachePool = new CachePool();
    byte[] fingerprint;
    int[] fingerprintInInts;
    int[] fingerprintNoRings;
    private boolean querySetAsFingerprint;
    CombinedFingerprint cofp = null;
    int order = 2;
    int numberOfBits;
    int numberOfOnes;
    int numberOfEdges;
    int fpCount;
    int cfpCount;
    int structuralFPCount;
    int batchSize = 500;
    boolean emptyQuery = true;
    boolean isMarkushQuery = false;
    boolean hashCodeScreeningForFull = false;
    Boolean prevEmptyQuery = null;
    boolean reactionTable = false;
    ReactionFingerprint reactionFingerprint = null;
    boolean existsBitwiseAND = true;
    boolean existsBitwiseANDOperator = true;
    String nameOfBitwiseANDFunction = null;
    int[] columnCountsAtScreenening;
    boolean isScreening;
    boolean isBitwiseScreening;
    boolean isBitwiseScreeningLocally;
    boolean isBitwiseScreeningLocallyUsingCache;
    boolean isSimilarityCheckingFromCache;
    boolean isHashScreening;
    JChemCache sCache = null;
    private boolean isScreenedContainsIndices = false;
    ScreenedHandler screenedHandler;
    int hits = 0;
    int currentId = -1;
    String message = "";
    boolean maxResultCountReached = false;
    boolean maxTimeReached = false;
    volatile boolean stopped = true;
    volatile boolean stopRequested = false;
    IntVector resultVector = null;
    IntVector finalResultVector = null;
    FloatVector dissimVector = null;
    IntVector screenedVector;
    IntVector beforeEnumScreenedVector;
    static final int GENERAL_PACKAGE_SIZE = 25;
    static final int MARKUSH_PACKAGE_SIZE = 1;
    private final BlockingIntArrayQueue progressiveReturnArray = new BlockingIntArrayQueue();
    long startTime = 0L;
    boolean searchUsingOriginalTarget = false;
    StringBuilder infoToErrBuf = new StringBuilder();
    String queryCxsmarts = "";
    long screenAndAbasStartTime = 0L;
    Monitor screenMonitor = new Monitor();
    int screenedCount = 0;
    long searchTime = 0L;
    long cachingTime = 0L;
    long firstHitTime = 0L;
    long filterQueryTime = 0L;
    boolean cacheLoaded = false;
    boolean cacheUpdated = false;
    private Connection con;
    private SearchThread searchThread;
    private boolean tableInitialized = false;
    private boolean tableNameInitialized = false;
    private boolean connectionInitialized = false;
    private boolean queryInitialized = false;
    private boolean filterInitialized = false;
    private boolean chemTermFilterInitialized = false;
    private boolean chemTermColumnsInitialized = false;
    private PreparedStatement rowReaderPreparedStatement = null;
    private String rowReaderSQL = null;
    private FormulaSearch formulaSearch = null;
    private IntVector filterVector = null;
    private boolean orderByFilter = false;
    private DatabaseProperties dbProp = null;
    private int queryMode;
    private boolean queryModeBoolean;
    private final JChemSearchOptions searchOptions = new JChemSearchOptions(2);
    private JChemSearchOptions publicSearchOptions = new JChemSearchOptions(2);
    private String whereClause = null;
    private int rdbms;
    private String modifiedfFilterExpression = null;
    private String[] substitutedCTColumns = null;
    private final String filterConfigFile;
    private boolean cartridgeMode = false;
    private String cartridgeIndexedTable;
    private String cartridgeIndexedColumn;
    private IntVector nonHits = null;
    private int hash;
    private final HashCode hc = new HashCode();
    private String cacheError;
    private int maxCacheSize = -1;
    private int minNonCachedMemory = -1;
    private double cacheExpirationTime = 0.0;
    private String prevTimeStamp = null;
    private String prevTableName = null;
    private String timeStamp = null;
    private int timeout = 0;
    private volatile long lastCheck = 0L;
    private IntVector allDissimID = null;
    private FloatVector allDissimDissim = null;
    private static final int DEFAULT_THREADS = 16;
    private int threadsCount = 16;
    private SimilarityThread[] simThread;
    private ABASThread[] thread;
    MolSearch[] molSearch;
    private Evaluator[] evaluator;
    private ChemJEP[] jep;
    private MolContext[] context;
    private Standardizer[] standardizer;
    private IntVector[] simScreened;
    private FloatVector[] simDissimVector;
    private int threadPriority;
    private PreparedStatement pstmtForSmilesRead;
    private boolean usePreparedStatements;
    private PreparedStatement pstmtForScreening;
    private String pstmtSQLForScreening;
    private boolean queryIsStructuralKey;
    private boolean isEnumeratedSearch;
    private long regCode;
    private int enumeratedFeatures;
    private int enumCount;
    private boolean everyTargetIsHit;
    private boolean noScreenReturnAll;
    private boolean chemicalTermsSubstitution;
    private static final String SUBSTITUTED_CT_FIELD_PROPERY_PREFIX = "detected_CT_column_";
    private boolean absStereoMode;
    int[] results;
    float[] dissimilarityResults;
    private String queryStructure;
    private Molecule queryMolecule;
    private Molecule queryMol;
    private Molecule originalQuery;
    private String structureTable;
    private int tableType;
    private boolean tautomerDuplicateSearch;
    private boolean tautomerDupSearchUsesOrigQuery;
    private boolean tautomerDuplicateSearchTable;
    private boolean genericTautomerProtectsChirality;
    private boolean switchOffAllProtectionsForTDF;
    private boolean markushTable;
    private int[] filterIDList;
    private int[] origFilterIdList;
    private int[] filterIDNotList;
    private boolean filterIDListSorted;
    private boolean filterIDNotListSorted;
    private final String filterTable = "";
    private final boolean deleteFilterTableWhenReady = false;
    private String resultTable;
    private int resultTableMode;
    private boolean infoToStdError;
    private boolean firstEnumeratedStructure;
    private ConnectionHandler connectionHandler;
    private boolean standardizationDisabled;
    Integer preCalculatedHashCode;
    Molecule preCalculatedGenericTautomer;
    byte[] preCalculatedSmiles;
    boolean preCalculatedSmilesSet;
    byte[] smiles;
    public static final int RUN_MODE_SYNCH_COMPLETE = 0;
    public static final int RUN_MODE_ASYNCH_COMPLETE = 1;
    public static final int RUN_MODE_ASYNCH_PROGRESSIVE = 2;
    private int runMode;
    private String licenseEnvironment;
    private boolean stopRecorded;
    private static CDMarkushHandlerCache markushHandlerCache = new CDMarkushHandlerCache(CDMarkushHandlerCache.ThreadSafety.SYNCHRONIZED, CDMarkushHandlerCache.CacheBehavior.CACHEFIRST);

    public JChemSearch() {
        this((IncidentsObserver<JCSIncidents>)new LogObserver(log, JCSIncidents.class), null);
    }

    public JChemSearch(String indexedTable, String indexedColumn) {
        this(indexedTable, indexedColumn, (IncidentsObserver<JCSIncidents>)new LogObserver(log, JCSIncidents.class));
    }

    public JChemSearch(IncidentsObserver<JCSIncidents> observer) {
        this(observer, null);
    }

    public JChemSearch(String indexedTable, String indexedColumn, IncidentsObserver<JCSIncidents> observer) {
        this(observer, null);
        this.cartridgeMode = true;
        this.cartridgeIndexedTable = indexedTable;
        this.cartridgeIndexedColumn = indexedColumn;
    }

    JChemSearch(JChemObserver jchemObserver) {
        this((IncidentsObserver<JCSIncidents>)new LogObserver(log, JCSIncidents.class), jchemObserver);
    }

    JChemSearch(IncidentsObserver<JCSIncidents> observer, JChemObserver jchemObserver) {
        this.filterConfigFile = null;
        try {
            this.threadsCount = Runtime.getRuntime().availableProcessors();
        }
        catch (NoSuchMethodError e) {
            log.error((Object)"At getting threads count: ", (Throwable)e);
        }
        if (this.threadsCount == 1) {
            this.threadsCount = 2;
        }
        this.simThread = null;
        this.thread = null;
        this.molSearch = null;
        this.evaluator = null;
        this.jep = null;
        this.context = null;
        this.standardizer = null;
        this.simScreened = null;
        this.simDissimVector = null;
        this.threadPriority = 1;
        this.pstmtForSmilesRead = null;
        this.usePreparedStatements = false;
        this.pstmtForScreening = null;
        this.pstmtSQLForScreening = null;
        this.regCode = 0L;
        this.enumeratedFeatures = 1;
        this.enumCount = 0;
        this.everyTargetIsHit = false;
        this.noScreenReturnAll = false;
        this.chemicalTermsSubstitution = false;
        this.absStereoMode = false;
        this.results = null;
        this.dissimilarityResults = null;
        this.queryStructure = null;
        this.queryMolecule = null;
        this.queryMol = null;
        this.originalQuery = null;
        this.structureTable = "";
        this.tableType = 0;
        this.tautomerDuplicateSearch = false;
        this.tautomerDupSearchUsesOrigQuery = false;
        this.tautomerDuplicateSearchTable = false;
        this.genericTautomerProtectsChirality = false;
        this.switchOffAllProtectionsForTDF = false;
        this.markushTable = false;
        this.filterIDList = null;
        this.origFilterIdList = null;
        this.filterIDNotList = null;
        this.filterIDListSorted = false;
        this.filterIDNotListSorted = false;
        this.filterTable = "";
        this.deleteFilterTableWhenReady = false;
        this.resultTable = "";
        this.resultTableMode = 0;
        this.infoToStdError = false;
        this.firstEnumeratedStructure = true;
        this.standardizationDisabled = false;
        this.preCalculatedSmiles = null;
        this.smiles = null;
        this.runMode = 0;
        this.licenseEnvironment = "";
        if (observer == null) {
            throw new IllegalArgumentException("IncidentsObserver cannot be null.");
        }
        this.incidents = (JCSIncidents)observer.getIncidentsSet();
        this.jchemObserverImpl = JChemObserverImpl.create(jchemObserver);
        if (log.isDebugEnabled()) {
            log.debug((Object)("\n===================Java System Properties=====================\n" + System.getProperties().toString() + "\nAvailable processorsfor JVM: " + Runtime.getRuntime().availableProcessors() + "\nFree mem: " + Runtime.getRuntime().freeMemory() + "\nMax mem: " + Runtime.getRuntime().maxMemory() + "\nTotal mem: " + Runtime.getRuntime().totalMemory() + JChemSearch.marvinVersionToString() + JChemSearch.jchemVersionToString()));
        }
    }

    static String marvinVersionToString() {
        return "\n================Marvin Version Information=====================\nMarvin Main Version: " + chemaxon.marvin.version.VersionInfo.MARVIN_MAJOR_VERSION + "\nMarvin Version: " + chemaxon.marvin.version.VersionInfo.MARVIN_VERSION + "\nMarvin Revision Number: " + chemaxon.marvin.version.VersionInfo.MARVIN_REVISION_NUMBER + "\nMarvin build date/time: " + chemaxon.marvin.version.VersionInfo.buildDate() + " " + chemaxon.marvin.version.VersionInfo.buildDateTime();
    }

    static String jchemVersionToString() {
        return "\n================JChem Version information======================\nJChem Main Version: " + VersionInfo.JCHEM_MAIN_VERSION + "\nJChem Version: " + VersionInfo.JCHEM_VERSION + "\nJChem Revision Number: " + VersionInfo.JCHEM_REVISION_NUMBER + "\nJChem Table Version: " + VersionInfo.JCHEM_TABLE_VERSION;
    }

    public static JCSObserver createJCSObserver() {
        return new JCSObserver();
    }

    public String getQueryStructure() {
        return this.queryStructure;
    }

    public void setQueryStructure(String queryStructure) {
        this.queryMolecule = null;
        this.queryStructure = queryStructure;
        if (this.queryStructure != null && this.queryStructure.equals("")) {
            this.queryStructure = null;
        }
        this.queryInitialized = false;
        this.querySetAsFingerprint = false;
    }

    public void setQueryStructure(Molecule queryMol) {
        this.queryMolecule = queryMol;
        this.queryStructure = null;
        this.queryInitialized = false;
        this.querySetAsFingerprint = false;
    }

    public void setQueryFingerprint(int[] queryFp) {
        this.querySetAsFingerprint = true;
        this.fingerprintInInts = queryFp;
        this.fingerprintNoRings = queryFp;
        this.emptyQuery = false;
        this.queryInitialized = true;
    }

    public String getStructureTable() {
        return this.structureTable;
    }

    public void setStructureTable(String structureTable) {
        this.structureTable = structureTable;
        this.tableInitialized = false;
        this.tableNameInitialized = false;
        this.chemTermColumnsInitialized = false;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    public String getCacheError() {
        return this.cacheError;
    }

    public static Hashtable<String, Long> getCachedTables() {
        return cachePool.getCachedTables(true);
    }

    public void setFilterIDList(int[] ids) {
        this.filterIDList = ids;
        if (ids != null) {
            this.origFilterIdList = (int[])this.filterIDList.clone();
            this.filterIDListSorted = false;
        }
    }

    public void setFilterIDNotList(int[] ids) {
        this.filterIDNotList = ids;
        this.filterIDNotListSorted = false;
    }

    public static DissimilarityMetrics getDissimilarityMetrics(ConnectionHandler ch, String tableName) throws SQLException {
        tableName = TableInfo.getTableNameWithSchema(ch.getConnection(), tableName);
        DatabaseProperties dbProp = new DatabaseProperties(ch, false);
        int tableType = dbProp.getTableType(tableName);
        DissimilarityMetrics result = new DissimilarityMetrics();
        if (tableType == 1) {
            ReactionFingerprint rfp = new ReactionFingerprint();
            result.metricNames = rfp.getDissimilarityMetrics();
            result.defaultMetricIndex = rfp.getDefaultMetricIndex();
            result.defaultDissimilarityMetricThresholds = rfp.getDefaultDissimilarityMetricThresholds();
            result.name = rfp.getName();
            result.numOfParam = rfp.getDissimilarityMetricsParamNum();
            result.paramNames = rfp.getDissimilarityMetricsParamNames();
            result.paramRanges = rfp.getDissimilarityMetricsParamRanges();
            result.paramDefault = rfp.getDissimilarityMetricsParamDefault();
            result.paramHelp = rfp.getDissimilarityMetricsParamHelp();
        } else if (tableType == 0 || tableType == 2) {
            result = JChemSearch.getMetricsFromMetricsType();
        } else {
            return null;
        }
        return result;
    }

    private static DissimilarityMetrics getMetricsFromMetricsType() {
        MetricsType[] metrics2 = MetricsType.values();
        int metricNum = metrics2.length - 1;
        String[] metricNames = new String[metricNum];
        int[] numOfParams = new int[metricNum];
        String[] paramNames = new String[metricNum];
        String[] paramRanges = new String[metricNum];
        String[] paramDefault = new String[metricNum];
        float[] defaultDissimilarityMetricThresholds = new float[metricNum];
        String[] paramHelp = new String[metricNum];
        for (int i = metricNum - 1; i >= 0; --i) {
            MetricsType mt = metrics2[i];
            metricNames[i] = mt.toString();
            String paramStr = mt.getSimpleParamString();
            String[] paramStrV = paramStr.split(":");
            if (paramStrV.length != 6) {
                throw new IllegalArgumentException("Bad number of parameter description entries for metric:" + metricNames[i]);
            }
            try {
                numOfParams[i] = Integer.parseInt(paramStrV[0]);
                defaultDissimilarityMetricThresholds[i] = Float.parseFloat(paramStrV[4]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bad number format in the parameter description of metric: " + metricNames[i], e);
            }
            paramNames[i] = paramStrV[1];
            paramRanges[i] = paramStrV[2];
            paramDefault[i] = paramStrV[3];
            paramHelp[i] = paramStrV[5];
        }
        DissimilarityMetrics result = new DissimilarityMetrics();
        result.name = "Chemical Hashed Fingerprint";
        result.defaultMetricIndex = 0;
        result.metricNames = metricNames;
        result.numOfParam = numOfParams;
        result.paramNames = paramNames;
        result.paramRanges = paramRanges;
        result.paramDefault = paramDefault;
        result.defaultDissimilarityMetricThresholds = defaultDissimilarityMetricThresholds;
        result.paramHelp = paramHelp;
        return result;
    }

    public boolean isInfoToStdError() {
        return this.infoToStdError;
    }

    public void setInfoToStdError(boolean infoToStdError) {
        this.infoToStdError = infoToStdError;
    }

    public ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    public void setConnectionHandler(ConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
        this.con = connectionHandler.getConnection();
        this.connectionInitialized = false;
    }

    public Connection getConnection() {
        return this.connectionHandler.getConnection();
    }

    public int getRunMode() {
        return this.runMode;
    }

    public void setRunMode(int runMode) {
        if (this.runMode != runMode) {
            this.runMode = runMode;
        }
    }

    public void setSearchOptions(JChemSearchOptions options) {
        this.publicSearchOptions = new JChemSearchOptions(2);
        options.clonecopy(this.publicSearchOptions);
    }

    public JChemSearchOptions getSearchOptions() {
        return this.publicSearchOptions;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getResultTable() {
        return this.resultTable;
    }

    public void setResultTable(String resultTable) {
        this.resultTable = resultTable;
    }

    public int getResultTableMode() {
        return this.resultTableMode;
    }

    public void setResultTableMode(int resultTableMode) {
        this.resultTableMode = resultTableMode;
    }

    public void setMaxCacheSize(int maxCacheSizeMB) {
        this.maxCacheSize = maxCacheSizeMB;
    }

    public void setMinNonCachedMemory(int minNonCachedMemoryMB) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("minNonCachedMemory set to " + minNonCachedMemoryMB));
        }
        this.minNonCachedMemory = minNonCachedMemoryMB;
    }

    public void setCacheExpirationTime(double hours) {
        this.cacheExpirationTime = hours;
    }

    public void setNumberOfProcessingThreads(int threads) {
        if (threads > 0) {
            this.threadsCount = threads;
        } else {
            try {
                this.threadsCount = Runtime.getRuntime().availableProcessors();
            }
            catch (NoSuchMethodError e) {
                this.threadsCount = 16;
            }
        }
        if (this.threadsCount == 1) {
            this.threadsCount = 2;
        }
        this.thread = null;
    }

    public int getNumberOfProcessingThreads() {
        return this.threadsCount;
    }

    public void setThreadPriority(int priority) {
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException("Priority out of range : " + priority);
        }
        this.threadPriority = priority;
    }

    public int getResult(int index) {
        return this.results == null ? -1 : this.results[index];
    }

    public int[] getResults() {
        return this.results;
    }

    public void cleanResults() {
        this.finalResultVector = null;
        this.resultVector = null;
        this.results = null;
    }

    public float getDissimilarity(int index) {
        return this.dissimilarityResults[index];
    }

    public float[] getDissimilarity() {
        return this.dissimilarityResults;
    }

    public String getProgressMessage() {
        return this.message;
    }

    public int getCurrentId() {
        return this.currentId;
    }

    public boolean isMaxResultCountReached() {
        return this.maxResultCountReached;
    }

    public boolean isMaxTimeReached() {
        return this.maxTimeReached;
    }

    public int getResultCount() {
        return this.hits;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isRunning() {
        this.lastCheck = System.currentTimeMillis();
        return !this.stopped;
    }

    public void setRunning(boolean run) throws SQLException, MolFormatException, IOException, DatabaseSearchException, PropertyNotSetException {
        if (!run && this.isRunning()) {
            this.exception = null;
            if (this.searchThread != null) {
                this.stopRequested = true;
            }
        } else if (run && !this.isRunning()) {
            this.stopped = false;
            this.stopRequested = false;
            this.exception = null;
            if (this.connectionHandler == null) {
                throw new DatabaseSearchException("Connection is not set properly");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n=======================Search Options======================\n" + this.searchOptions + "\n=================Connection handler Properties=============\n" + this.connectionHandler));
            }
            if (this.runMode == 0) {
                this.search();
            } else {
                if (this.runMode == 2) {
                    this.progressiveReturnArray.start();
                }
                this.searchThread = new SearchThread();
                this.searchThread.setPriority(this.threadPriority);
                this.searchThread.start();
            }
        }
    }

    public void run() throws SQLException, MolFormatException, IOException, DatabaseSearchException, PropertyNotSetException {
        this.setRunning(true);
    }

    public static void clearCache() {
        cachePool.clear();
    }

    public int getScreenedCount() {
        return this.getScreenedCountTotal();
    }

    public int getScreenedCountUnique() {
        return this.screenedHandler.getUniqueScreenedCount();
    }

    public int getScreenedCountTotal() {
        return this.screenedHandler.getTotalScreenedCount();
    }

    public int[] getScreenedResults() {
        return this.screenedHandler.getUniqueScreened().toArray();
    }

    public long getScreeningTime() {
        return this.screenMonitor.getTotalTime();
    }

    public long getFirstHitTime() {
        return this.firstHitTime;
    }

    void setStandardizationDisabled(boolean disabled) {
        this.standardizationDisabled = disabled;
    }

    void setPreCalculatedHashCode(int hashCode) {
        this.preCalculatedHashCode = hashCode;
    }

    void setPreCalculatedGenericTautomer(Molecule mol) {
        this.preCalculatedGenericTautomer = mol;
    }

    void setPreCalculatedSmiles(String smi) {
        block2: {
            try {
                this.preCalculatedSmiles = smi != null ? smi.getBytes("ASCII") : null;
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.preCalculatedSmilesSet = true;
    }

    public long getSearchTime() {
        if (this.stopped) {
            return this.searchTime;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    public long getCacheLoadTime() throws IllegalStateException {
        String cacheHashKey;
        try {
            cacheHashKey = this.getCacheHashKey();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Cache was not loaded yet");
        }
        JChemCache cache = cachePool.getCache(cacheHashKey);
        if (cache != null) {
            return this.cachingTime;
        }
        throw new IllegalStateException("Cache was not loaded yet");
    }

    public double getCacheSizeEstimate() throws IllegalStateException {
        String cacheHashKey;
        try {
            cacheHashKey = this.getCacheHashKey();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Cache was not loaded yet");
        }
        JChemCache cache = cachePool.getCache(cacheHashKey);
        if (cache != null) {
            return this.toMB(cache.getSize());
        }
        throw new IllegalStateException("Cache was not loaded yet");
    }

    public double getCacheSize() throws IllegalStateException {
        String cacheHashKey;
        try {
            cacheHashKey = this.getCacheHashKey();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Cache was not loaded yet");
        }
        JChemCache cache = cachePool.getCache(cacheHashKey);
        SizeInfoFactory sf = new SizeInfoFactory();
        ObjectSizeInfo osi = sf.getBestImplementationUCanget();
        if (cache != null) {
            return this.toMB(osi.deepSizeOf((Object)cache));
        }
        throw new IllegalStateException("Cache was not loaded yet");
    }

    public boolean isTargetMarkush() {
        return this.markushTable;
    }

    public int getEnumerationCount() {
        return this.enumCount > 0 ? this.enumCount : 1;
    }

    private void initSearchOptions() {
        if (!Misc.isEqual(this.publicSearchOptions.getFilterQuery(), this.searchOptions.getFilterQuery())) {
            this.filterInitialized = false;
        }
        if (!Misc.isEqual(this.publicSearchOptions.getChemTermsFilter(), this.searchOptions.getChemTermsFilter())) {
            this.chemTermFilterInitialized = false;
            this.chemTermColumnsInitialized = false;
        }
        if (!Misc.isEqual(this.publicSearchOptions.getChemTermsFilterConfig(), this.searchOptions.getChemTermsFilterConfig())) {
            this.chemTermFilterInitialized = false;
        }
        if (this.querySetAsFingerprint && this.publicSearchOptions.getSearchType() != 3) {
            throw new IllegalArgumentException("With the query is set as fingerprint, only similarity search is accepted");
        }
        if (this.publicSearchOptions.getSearchType() != this.searchOptions.getSearchType()) {
            this.connectionInitialized = false;
            this.queryInitialized = this.querySetAsFingerprint;
            this.chemTermFilterInitialized = false;
        }
        if (this.publicSearchOptions.getTautomerSearch() != this.searchOptions.getTautomerSearch()) {
            this.queryInitialized = false;
        }
        this.publicSearchOptions.clonecopy(this.searchOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search() throws SQLException, MolFormatException, IOException, DatabaseSearchException, PropertyNotSetException {
        this.initSearchOptions();
        this.stopRequested = false;
        this.stopped = false;
        this.startTime = System.currentTimeMillis();
        this.screenMonitor.reset();
        this.cachingTime = 0L;
        this.firstHitTime = 0L;
        this.filterQueryTime = 0L;
        this.screenedCount = 0;
        this.hits = 0;
        this.results = null;
        this.dissimilarityResults = null;
        this.maxResultCountReached = false;
        this.maxTimeReached = false;
        try {
            if (!this.queryInitialized) {
                this.readQuery();
            }
            this.search1();
            if (this.resultTableMode != 0) {
                this.generateResultTable();
            }
        }
        finally {
            this.stopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generateResultTable() throws SQLException {
        boolean exists = this.existsResultTable();
        if (exists) {
            if (this.resultTableMode == 1) {
                this.dropResultTable();
                this.createResultTable();
            }
        } else {
            this.createResultTable();
        }
        String sql = "INSERT INTO " + this.resultTable + " (" + "cd_id" + (this.searchOptions.getSearchType() == 3 ? ", similarity " : "") + ") VALUES (?" + (this.searchOptions.getSearchType() == 3 ? ",?" : "") + ")";
        boolean prevAutoCommit = this.con.getAutoCommit();
        try {
            if (prevAutoCommit && this.rdbms != 7) {
                this.con.setAutoCommit(false);
            }
            PreparedStatement pstmt = this.con.prepareStatement(sql);
            try {
                for (int i = 0; i < this.getResultCount(); ++i) {
                    pstmt.setInt(1, this.results[i]);
                    if (this.searchOptions.getSearchType() == 3) {
                        pstmt.setFloat(2, this.dissimilarityResults[i]);
                    }
                    pstmt.executeUpdate();
                }
                if (prevAutoCommit && this.rdbms != 7) {
                    this.con.commit();
                }
            }
            finally {
                pstmt.close();
            }
        }
        finally {
            if (prevAutoCommit && this.rdbms != 7) {
                this.con.setAutoCommit(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createResultTable() throws SQLException {
        TypeConverter tc = new TypeConverter(this.con);
        String sql = "CREATE ";
        if (this.rdbms == 8) {
            sql = sql + "CACHED ";
        }
        sql = sql + " TABLE " + this.resultTable + " (" + "cd_id" + " " + tc.getLocalTypeByCode(4) + " NOT NULL PRIMARY KEY";
        if (this.searchOptions.getSearchType() == 3) {
            sql = sql + ", similarity " + tc.getLocalTypeByCode(6) + " NOT NULL";
        }
        sql = sql + ")";
        Statement stmt = this.con.createStatement();
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
        if (this.searchOptions.getSearchType() == 3) {
            sql = "CREATE INDEX " + this.resultTable + "_fp ON " + this.resultTable + " (similarity, " + "cd_id" + ")";
            stmt = this.con.createStatement();
            try {
                stmt.executeUpdate(sql);
            }
            finally {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search1() throws SQLException, MolFormatException, IOException, DatabaseSearchException, PropertyNotSetException {
        this.init();
        this.checkLicense();
        this.lastCheck = System.currentTimeMillis();
        this.cacheLoaded = false;
        this.cacheUpdated = false;
        try {
            ((OracleConnection)this.con).setDefaultRowPrefetch(100);
        }
        catch (NoClassDefFoundError e1) {
        }
        catch (Exception e2) {
            // empty catch block
        }
        int searchType = this.searchOptions.getSearchType();
        if (this.infoToStdError || infoLogger.isLoggable(Level.FINE) || log.isDebugEnabled()) {
            this.infoToErrBuf.append("\n").append(new Date()).append("\n");
            String searchTypeName = this.searchOptions.getSearchType() == 3 && this.searchOptions.getDescriptorName() != null ? "MD " : "";
            searchTypeName = searchTypeName + SEARCH_MODE_NAMES[searchType];
            this.infoToErrBuf.append("Search mode: ").append(searchTypeName).append("\n");
            this.infoToErrBuf.append("Structure table: ").append(this.structureTable).append("" == null || "".length() == 0 ? "" : "  Filter table: ").append("\n");
            if (this.queryCxsmarts != null && this.queryCxsmarts.length() > 0) {
                this.infoToErrBuf.append("Query: ").append(this.queryCxsmarts).append("\n");
            }
        }
        this.screenedHandler = new ScreenedHandler();
        this.hits = 0;
        this.exception = null;
        this.stopped = false;
        if (this.emptyQuery && this.searchOptions.getSearchType() == 5) {
            this.results = new int[0];
            this.searchTime = System.currentTimeMillis() - this.startTime;
            this.screenMonitor.reset();
            this.printSearchInfo();
            return;
        }
        int maxResultCount = this.searchOptions.getMaxResultCount();
        int predictedSize = maxResultCount == 0 ? 10000 : maxResultCount;
        this.finalResultVector = new IntVector(predictedSize);
        FloatVector floatVector = this.dissimVector = this.searchOptions.getSearchType() == 3 ? new FloatVector(predictedSize) : null;
        if (this.searchOptions.getSearchType() == 3) {
            this.allDissimID = new IntVector(predictedSize);
            this.allDissimDissim = new FloatVector(predictedSize);
        }
        IntVector allIDs = null;
        if (this.emptyQuery) {
            this.setProgressMessage("Collecting id numbers.");
        } else {
            this.setProgressMessage("Collecting fingerprints.");
        }
        try {
            FloatIntQuickSort fqs;
            this.loadCache();
            if (this.cacheLoaded || this.cacheUpdated) {
                try {
                    if (this.sCache != null && this.sCache.getFails() != null) {
                        for (Map.Entry<Integer, Exception> entry : this.sCache.getFails().entrySet()) {
                            this.handleStructureLoadingError(entry.getKey(), entry.getValue());
                        }
                    }
                }
                catch (Exception e) {
                    throw new DatabaseSearchException(e);
                }
            }
            this.checkTimeout();
            if (this.sCache != null) {
                this.sCache.addSearcher(this);
            }
            if (this.searchOptions.getSearchType() == 3 && this.searchOptions.getDescriptorName() != null) {
                this.initQuery();
                this.screenMD();
                if (this.searchOptions.getSearchType() == 3) {
                    fqs = new FloatIntQuickSort(1, this.dissimVector.elementData, this.finalResultVector.elementData);
                    fqs.qsort(0, this.hits - 1);
                }
                this.hits = this.finalResultVector.size();
            } else {
                if (this.searchOptions.isReturnsNonHits()) {
                    allIDs = this.searchOptions.getFilterQuery() != null && this.searchOptions.getFilterQuery().length() > 0 ? this.filterVector : this.getAllIDs();
                    if (this.filterIDList != null || this.filterIDNotList != null) {
                        allIDs = this.filterScreened(allIDs, this.filterIDList, this.filterIDNotList);
                    }
                }
                this.beforeEnumScreenedVector = null;
                this.nonHits = null;
                if (!this.isEnumeratedSearch) {
                    this.searchCore();
                    if (this.searchOptions.getSearchType() == 3 && !this.searchOptions.isReturnsNonHits()) {
                        fqs = new FloatIntQuickSort(1, this.dissimVector.elementData, this.resultVector.elementData);
                        fqs.qsort(0, this.hits - 1);
                    }
                    this.finalResultVector = this.resultVector;
                } else {
                    this.enumeratedSearch();
                }
                this.retrieveFinalizedIDs(this.finalResultVector);
            }
            this.checkTimeout();
            boolean idOrdered = false;
            if (this.searchOptions.isReturnsNonHits()) {
                this.finalResultVector.sort();
                idOrdered = true;
                IntVector tempResultVector = new IntVector();
                if (searchType == 3) {
                    allIDs = this.allDissimID;
                    this.dissimVector = new FloatVector();
                }
                for (int x = 0; x < allIDs.size(); ++x) {
                    int id = allIDs.get(x);
                    if (this.finalResultVector.indexOfWithBinarySearch(id) != -1) continue;
                    tempResultVector.addElement(id);
                    if (searchType == 3) {
                        float dissim = this.allDissimDissim.elementAt(x);
                        this.dissimVector.addElement(dissim);
                    }
                    if (maxResultCount == 0 || searchType == 3 || tempResultVector.size() < maxResultCount) continue;
                    this.maxResultCountReached = true;
                    break;
                }
                this.finalResultVector = tempResultVector;
                this.hits = this.finalResultVector.size();
            }
            this.checkTimeout();
            if (this.order != 0 && this.order != 3 && !this.orderByFilter) {
                if (this.order == 2 && searchType == 3) {
                    FloatIntQuickSort fqs2 = new FloatIntQuickSort(1, this.dissimVector.elementData, this.finalResultVector.elementData);
                    fqs2.qsort(0, this.hits - 1);
                } else if (!idOrdered) {
                    this.finalResultVector.sort();
                }
            }
            if (this.orderByFilter) {
                if (this.dissimilarityResults == null) {
                    this.finalResultVector = this.filterScreened(this.finalResultVector, this.filterVector);
                } else {
                    this.sortResultsToFilterWithDissim();
                }
            } else if (this.order == 3) {
                this.finalResultVector = this.sortResultsWithFilterCdIds(this.finalResultVector, this.origFilterIdList);
                this.hits = this.finalResultVector.size();
            }
            if (maxResultCount != 0 && this.hits >= maxResultCount) {
                this.maxResultCountReached = true;
            }
            if (this.maxResultCountReached) {
                this.finalResultVector.setSize(maxResultCount);
                if (searchType == 3) {
                    this.dissimVector.setSize(maxResultCount);
                }
                this.hits = this.finalResultVector.size();
            }
            this.results = this.finalResultVector.toArray();
            this.dissimilarityResults = this.dissimVector == null ? null : this.dissimVector.toArray();
        }
        finally {
            this.searchTime = System.currentTimeMillis() - this.startTime - this.cachingTime;
            if (searchType == 3) {
                this.screenMonitor.setTotalTime(this.searchTime);
            }
            this.printSearchInfo();
            if (this.sCache != null) {
                this.sCache.removeSearcher(this);
            }
            this.sCache = null;
            this.setProgressMessage("Searching finished.");
        }
    }

    private void searchCore() throws SQLException, DatabaseSearchException, IOException {
        this.initQuery();
        this.getCandidates();
        this.resultVector = new IntVector();
        int searchType = this.searchOptions.getSearchType();
        if ((this.noScreenReturnAll || this.isSimilarityCheckingFromCache) && this.searchOptions.getChemTermsFilter() == null && this.formulaSearch == null) {
            this.hits = this.screenedVector.size();
            this.resultVector = this.screenedVector;
        } else {
            if (searchType == 3) {
                this.setProgressMessage("Similarity search.");
            } else {
                this.setProgressMessage("Comprehensive  search.");
            }
            IntVector noSmiles = new IntVector(1000);
            if (this.sCache == null || this.searchUsingOriginalTarget) {
                this.searchInDB(this.screenedVector, noSmiles, this.searchUsingOriginalTarget);
            } else {
                this.searchInCache(noSmiles);
            }
            if (noSmiles.size() > 0) {
                this.isSimilarityCheckingFromCache = false;
                this.searchInDB(noSmiles, null, true);
            }
        }
    }

    private void printSearchInfo() {
        if (!(this.infoToStdError || infoLogger.isLoggable(Level.FINE) || log.isDebugEnabled())) {
            return;
        }
        this.infoToErrBuf.append("Total screened: ").append(this.screenedHandler.getTotalScreenedCount()).append("\n").append("Unique screened: ").append(this.screenedHandler.getUniqueScreenedCount()).append("\n").append("Hits: ").append(this.hits).append("\n");
        if ((this.cachingTime != 0L && this.cacheLoaded || this.cacheUpdated) && this.sCache != null) {
            if (this.cacheUpdated && this.cacheLoaded) {
                this.infoToErrBuf.append("Cache reload: ");
            } else if (this.cacheUpdated) {
                this.infoToErrBuf.append("Cache update: ");
            } else {
                this.infoToErrBuf.append("Cache loading: ");
            }
            this.infoToErrBuf.append(this.cachingTime).append(" ms\n");
            this.infoToErrBuf.append("Cache size (this table / total): ").append(this.toMB(this.sCache.getSize())).append(" / ").append(this.toMB(cachePool.getTotalCacheSize())).append(" MBytes\n");
            SizeInfoFactory sf = new SizeInfoFactory();
            ObjectSizeInfo osi = sf.getBestImplementationUCanget();
            this.infoToErrBuf.append("Instrumented cache size: ").append(this.toMB(osi.deepSizeOf((Object)this.sCache))).append(" MBytes\n");
        }
        if (this.filterQueryTime != 0L) {
            this.infoToErrBuf.append("Filter query SQL executed in: ").append(this.filterQueryTime).append(" ms\n");
        }
        this.infoToErrBuf.append("Total time: ").append(this.searchTime).append(" ms  Screening: ").append(this.screenMonitor.getTotalTime()).append(" ms\n");
        this.infoToErrBuf.append("Processing threads: ").append(this.threadsCount).append("\n");
        if (eventCounter != null) {
            int searchNum = eventCounter.getNumberOfSearchesForCurrentPeriod();
            if (searchNum > peakSearchNum) {
                peakSearchNum = searchNum;
            }
            String maxString = eventCounter.getMaxEventCount() == Integer.MAX_VALUE ? "Unlimited" : eventCounter.getMaxEventCount() + "";
            this.infoToErrBuf.append("Current / peak / maximum searches per minute: ").append(searchNum).append(" / ").append(peakSearchNum).append(" / ").append(maxString).append("\n");
        }
        if (this.infoToErrBuf.length() > 0) {
            if (infoLogger.isLoggable(Level.FINE)) {
                infoLogger.fine(this.infoToErrBuf.toString());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n===================infoToErrBuf=====================\n" + this.infoToErrBuf.toString()));
            }
            if (this.infoToStdError) {
                JChemSearch.writeToStdErr(this.infoToErrBuf);
            }
            this.infoToErrBuf.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCache() throws DatabaseSearchException, SQLException {
        int searchType = this.searchOptions.getSearchType();
        if (searchType != 5 && (searchType != 3 || this.searchOptions.getDescriptorName() == null || this.searchOptions.getChemTermsFilter() != null)) {
            String msg;
            long cacheStart = System.currentTimeMillis();
            cachePool.setMemSize(this.maxCacheSize, this.minNonCachedMemory);
            cachePool.setExpirationTime(this.cacheExpirationTime);
            String cacheHashKey = this.getCacheHashKey();
            CachePool cachePool = JChemSearch.cachePool;
            synchronized (cachePool) {
                JChemCache cache = JChemSearch.cachePool.getCache(cacheHashKey);
                if (cache != null && !TableInfo.checkTimeStamp(cache.getTimeStamp(), this.timeStamp)) {
                    JChemSearch.cachePool.cacheHash.remove(this.structureTable);
                    cache = null;
                }
                if (cache == null) {
                    cache = CacheFactory.createCache(this.connectionHandler, this.structureTable, cacheHashKey, 0, 1000, this.cartridgeMode, JChemSearch.cachePool, this.timeStamp, this.jchemObserverImpl);
                    JChemSearch.cachePool.put(cacheHashKey, cache);
                }
                this.sCache = cache;
            }
            try {
                this.setProgressMessage("Loading cache");
                int status = this.sCache.loadCache(this.connectionHandler, this.searchOptions.isCacheRegistrationNeeded());
                if ((status & 1) > 0) {
                    this.cacheLoaded = true;
                }
                if ((status & 2) > 0) {
                    this.cacheUpdated = true;
                }
                if ((status & 4) > 0) {
                    this.cacheError = (status & 8) > 0 ? "Table \"" + this.structureTable + "\" " + "could not fit into structure cache (out of memory).\n" + "Please visit " + "http://www.chemaxon.com/jchem/doc/admin/Performance.html#cacheSize and" + "\nhttp://www.chemaxon.com/jchem/javaFAQ.html#outofmemory\n" : "Unknown error during loading table \"" + this.structureTable + "\" into strutcure cache.";
                    msg = "ERROR: " + this.cacheError;
                    throw new DatabaseSearchException(msg);
                }
                this.setProgressMessage("");
            }
            catch (OutOfMemoryError e) {
                msg = "\nERROR: JChem has run out of memory when trying to cache chemical hashed fingerprint information.\nPlease visit http://www.chemaxon.com/jchem/doc/admin/Performance.html#cacheSize and\nhttp://www.chemaxon.com/jchem/javaFAQ.html#outofmemory\n";
                if (log.isErrorEnabled()) {
                    log.error((Object)"error", (Throwable)e);
                    log.error((Object)msg);
                }
                throw new DatabaseSearchException(msg);
            }
            this.cachingTime = System.currentTimeMillis() - cacheStart;
        }
    }

    private String getCacheHashKey() throws SQLException {
        String propertyTableIdentifier = this.dbProp.getProperty("propertytable.identifier");
        String cacheHashKey = propertyTableIdentifier == null ? this.structureTable : propertyTableIdentifier + "." + this.structureTable;
        return cacheHashKey;
    }

    private double toMB(long size) {
        return (double)Math.round((double)size / 1024.0 / 1024.0 * 100.0) / 100.0;
    }

    void setProgressMessage(String message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)message);
        }
        this.message = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropResultTable() throws SQLException {
        String sql = "DROP  TABLE " + this.resultTable;
        Statement stmt = this.con.createStatement();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dropping table with sql: " + sql));
        }
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsResultTable() throws SQLException {
        boolean success = true;
        Statement stmt = this.con.createStatement();
        try {
            String sql = "SELECT cd_id FROM " + this.resultTable + " WHERE 1=2";
            if (log.isDebugEnabled()) {
                log.debug((Object)("check if result table has the field: " + sql));
            }
            ResultSet rs = stmt.executeQuery(sql);
            rs.close();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            success = false;
        }
        finally {
            stmt.close();
        }
        return success;
    }

    private void initEnumeratedSearch() {
        boolean exactQueryAtomMatching = this.searchOptions.isExactQueryAtomMatching();
        boolean exactBondMatching = this.searchOptions.isExactBondMatching();
        this.enumeratedFeatures = SearchUtil.getEnumerationOption(exactQueryAtomMatching, exactBondMatching, this.searchOptions.getTautomerSearch() == 1 && !this.tautomerDuplicateSearch, this.searchOptions.getVagueBondLevel(), this.searchOptions.isOptimizeQueries());
        if (this.searchOptions.getSearchType() != 2) {
            this.enumeratedFeatures &= 0xFFFFBFFF;
        }
        try {
            SearchUtil.cacheAromatizationMethod(this.queryMol, this.searchOptions, this.standardizer[0]);
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
        this.isEnumeratedSearch = this.canBeEnumeratedSearch();
    }

    private boolean canBeEnumeratedSearch() {
        if (this.emptyQuery) {
            return false;
        }
        if (this.searchOptions.getSearchType() == 3 || this.searchOptions.getSearchType() == 6) {
            return false;
        }
        if (this.tautomerDuplicateSearch || this.searchOptions.isExactQueryAtomMatching() || this.searchOptions.isExactBondMatching()) {
            return false;
        }
        return this.searchOptions.isOptimizeQueries() && SearchEnumerator.isEnumerable(this.queryMol, 56) || SearchEnumerator.isEnumerable(this.queryMol, this.enumeratedFeatures);
    }

    private void initTable() throws PropertyNotSetException, SQLException, DatabaseSearchException {
        int regen;
        this.checkIfTableSettingsAreStillValid();
        if (this.tableInitialized) {
            return;
        }
        if (this.structureTable == null) {
            throw new PropertyNotSetException("Structure table name is missing.");
        }
        if (this.structureTable.length() == 0) {
            throw new PropertyNotSetException("Structure table name is empty string");
        }
        this.structureTable = TableInfo.getTableNameWithSchema(this.con, this.structureTable);
        this.numberOfBits = FingerprintHandler.getNumberOfBits(this.connectionHandler, this.structureTable, this.cartridgeMode);
        if (this.numberOfBits == Integer.MIN_VALUE) {
            throw new DatabaseSearchException("No fingerprint information for " + this.structureTable + "\n" + " Run \"jcman -t\" or check the JChemProperties table " + "for structure tables");
        }
        int searchType = this.searchOptions.getSearchType();
        this.tableType = this.dbProp.getTableType(this.structureTable);
        this.checkNoScreenReturnAll();
        this.tautomerDuplicateSearchTable = this.dbProp.isTautomerDuplicateFilteringEnabled(this.structureTable);
        boolean bl = this.tautomerDuplicateSearch = searchType == 5 && this.tautomerDuplicateSearchTable;
        if (this.tautomerDuplicateSearch) {
            this.genericTautomerProtectsChirality = this.dbProp.isGenericTautomerProtectsChirality(this.structureTable);
            this.switchOffAllProtectionsForTDF = this.dbProp.isSetSwitchOffAllProtectionsForTDF(this.structureTable);
            int tautomerSearch = this.searchOptions.getTautomerSearch();
            this.tautomerDupSearchUsesOrigQuery = tautomerSearch != 2 && tautomerSearch != 1;
        } else {
            this.genericTautomerProtectsChirality = false;
            this.switchOffAllProtectionsForTDF = false;
        }
        this.searchUsingOriginalTarget |= this.tautomerDuplicateSearch;
        boolean bl2 = this.markushTable = this.tableType == 3;
        if (log.isDebugEnabled()) {
            log.debug((Object)("structureTable=" + this.structureTable + ", cartridgeMode=" + this.cartridgeMode + " tableType=" + this.tableType + ", noScreenReturnAll=" + this.noScreenReturnAll + ", tautomerDuplicateSearchTable=" + this.tautomerDuplicateSearchTable + ", searchUsingOriginalTarget=" + this.searchUsingOriginalTarget + ", markushTable=" + this.markushTable));
        }
        try {
            this.standardizer = TableInfo.getStandardizers(this.connectionHandler, this.structureTable, this.cartridgeMode, this.threadsCount);
        }
        catch (StandardizerException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            throw new DatabaseSearchException("Invalid standardizer configuration");
        }
        this.cfpCount = BinaryDataUtil.translateBitCountToIntCount(this.numberOfBits);
        this.structuralFPCount = FingerprintHandler.getNumberOfStructuralFPColumns(this.connectionHandler, this.structureTable, this.cartridgeMode);
        this.fpCount = this.cfpCount + this.structuralFPCount;
        this.numberOfOnes = FingerprintHandler.getNumberOfOnes(this.connectionHandler, this.structureTable, this.cartridgeMode);
        this.numberOfEdges = FingerprintHandler.getNumberOfEdges(this.connectionHandler, this.structureTable, this.cartridgeMode);
        this.reactionTable = this.dbProp.getTableType(this.structureTable) == 1;
        int fpInts = this.reactionTable ? this.cfpCount / 4 : this.cfpCount;
        String keys = FingerprintHandler.getStructuralKeys(this.connectionHandler, this.structureTable, this.cartridgeMode);
        try {
            this.standardizer[0].setActiveGroup("query");
            this.standardizer[0].addInactiveTasks("removeexplicith");
            this.cofp = new CombinedFingerprint(this.structuralFPCount, keys, this.standardizer[0], fpInts, this.numberOfEdges, this.numberOfOnes);
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            this.cofp = null;
        }
        catch (StandardizerException e) {
            throw new DatabaseSearchException(e);
        }
        if (this.reactionTable) {
            this.reactionFingerprint = new ReactionFingerprint();
            RFParameters params = new RFParameters();
            params.setBitCount(this.numberOfOnes);
            params.setBondCount(this.numberOfEdges);
            params.setLength(this.numberOfBits);
            this.reactionFingerprint.setParameters(params);
        }
        if ((regen = RegenerationChecker.isRegenerationNeeded(this.structureTable, new DatabaseProperties(this.connectionHandler, this.cartridgeMode))) == 1) {
            throw new DatabaseSearchException("The structure table contains obsolete data. Please recalculate the table.");
        }
        if (regen == 2) {
            throw new DatabaseSearchException("The structure table contains newer data version that this program version can handle. Please use a later version.");
        }
        this.absStereoMode = false;
        int absoluteStereo = this.searchOptions.getAbsoluteStereo();
        this.absStereoMode = absoluteStereo == 2 ? true : (absoluteStereo == 1 ? false : TableInfo.isAbsoluteStereo(this.connectionHandler, this.structureTable, this.cartridgeMode));
        this.searchOptions.setDirty(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("cfpCount=" + this.cfpCount + ", structuralFPCount=" + this.structuralFPCount + ", fpCount=" + this.fpCount + ", numberOfOnes=" + this.numberOfOnes + ", numberOfEdges=" + this.numberOfEdges + ", reactionTable=" + this.reactionTable + ", keys=" + keys + ", absStereoMode=" + this.absStereoMode));
        }
        this.sCache = null;
        this.tableInitialized = true;
    }

    private void checkNoScreenReturnAll() {
        int searchType = this.searchOptions.getSearchType();
        this.noScreenReturnAll = this.emptyQuery && searchType != 4 && searchType != 5;
        this.noScreenReturnAll &= searchType != 6 || this.tableType == 4;
        this.everyTargetIsHit = this.noScreenReturnAll && this.searchOptions.getChemTermsFilter() == null;
    }

    private void initConnection() throws SQLException {
        if (this.connectionInitialized) {
            return;
        }
        this.dbProp = new DatabaseProperties(this.connectionHandler, this.cartridgeMode);
        if (log.isDebugEnabled()) {
            log.debug((Object)this.dbProp.getAllProperties());
        }
        if (this.searchOptions.getSearchType() != 5) {
            DatabaseOptions dbOptions = new DatabaseOptions(this.connectionHandler);
            this.existsBitwiseAND = dbOptions.existsBitwiseAND;
            this.existsBitwiseANDOperator = dbOptions.existsBitwiseANDOperator;
            this.nameOfBitwiseANDFunction = dbOptions.nameOfBitwiseANDFunction;
        }
        this.rdbms = DatabaseOptions.getDBMSType(this.con);
        this.connectionInitialized = true;
    }

    private void initFilter() throws SQLException {
        if (this.filterInitialized) {
            return;
        }
        this.whereClause = null;
        String filterQuery = this.searchOptions.getFilterQuery();
        if (filterQuery == null || filterQuery.length() == 0) {
            this.filterVector = null;
            this.orderByFilter = false;
            this.filterInitialized = true;
            return;
        }
        this.orderByFilter = filterQuery.toUpperCase().indexOf("ORDER") != -1;
        this.fillFilter();
        this.filterInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillFilter() throws SQLException {
        long filterStart = System.currentTimeMillis();
        this.filterVector = new IntVector();
        Statement stmt = this.con.createStatement();
        try {
            DatabaseOptions.setFetchSize(stmt, 2000, this.rdbms);
            ResultSet rs = stmt.executeQuery(this.searchOptions.getFilterQuery());
            try {
                while (rs.next()) {
                    this.filterVector.addElement(rs.getInt(1));
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        this.filterQueryTime = System.currentTimeMillis() - filterStart;
        if (this.filterQueryTime == 0L) {
            ++this.filterQueryTime;
        }
    }

    public RgDecompResults getHitsAsRgDecomp(int[] hits, int attachmentType) throws SearchException, MolFormatException, SQLException {
        Molecule[] targets = this.fetchHitsAsMolecules(hits, null, null, null, false);
        RgDecompResults rgdr = new RgDecompResults(this.originalQuery, targets, this.searchOptions, attachmentType, hits);
        rgdr.run();
        return rgdr;
    }

    public Molecule[] getHitsAsMolecules(int[] idList, HitColoringAndAlignmentOptions options, ArrayList dataFieldNames, ArrayList dataFieldValues) throws SQLException, IOException, SearchException, SupergraphException, PropertyNotSetException, DatabaseSearchException {
        ArrayList<Molecule> molecules = new ArrayList<Molecule>();
        ArrayList<byte[]> sources = new ArrayList<byte[]>();
        HitDisplayTool colorUtil = this.getHitsAsHitDisplayTool(idList, options, dataFieldNames, dataFieldValues, molecules, sources);
        ArrayList<Molecule> hitsTmp = new ArrayList<Molecule>();
        int n = molecules.size();
        for (int x = 0; x < n; ++x) {
            if (molecules.get(x) == null) {
                hitsTmp.add(null);
                continue;
            }
            colorUtil.setMoleculeMarkushSourceTarget((Molecule)molecules.get(x), (byte[])sources.get(x));
            Molecule[] currentHits = colorUtil.getHits(-1);
            hitsTmp.add(currentHits.length == 0 ? null : currentHits[0]);
        }
        return hitsTmp.toArray(new Molecule[0]);
    }

    public HitDisplayTool getHitsAsHitDisplayTool(int[] idList, HitColoringAndAlignmentOptions options, ArrayList dataFieldNames, ArrayList dataFieldValues, List<Molecule> molecules, List<byte[]> sources) throws SQLException, IOException, SearchException, SupergraphException, PropertyNotSetException, DatabaseSearchException {
        boolean descriptorSimilarity;
        int searchType = this.searchOptions.getSearchType();
        boolean bl = descriptorSimilarity = searchType == 3 && this.searchOptions.getDescriptorName() != null;
        if (descriptorSimilarity) {
            options.coloring = false;
            options.alignmentMode = 0;
            return this.getDummyHitDisplayToolForTargets(this.getDescriptorHits(idList, options, dataFieldNames, dataFieldValues), molecules, sources);
        }
        if (options == null || this.searchOptions.isReturnsNonHits() || this.emptyQuery) {
            return this.getDummyHitDisplayToolForTargets(this.fetchHitsAsMolecules(idList, dataFieldNames, dataFieldValues, null, false), molecules, sources);
        }
        int idListLength = idList.length;
        boolean[] isMarkush = new boolean[idListLength];
        byte[][] sourcesArray = this.fetchSources(idList, dataFieldNames, dataFieldValues, isMarkush, true);
        MolSearchOptions msOptions = new MolSearchOptions(2);
        this.searchOptions.clonecopy(msOptions);
        if (this.markushTable) {
            msOptions.setMarkushEnabled(true);
        }
        HitDisplayTool colorUtil = new HitDisplayTool(options, msOptions, this.standardizer[0], this.originalQuery);
        for (int x = 0; x < idListLength; ++x) {
            if (sourcesArray[x] == null) {
                molecules.add(null);
                sources.add(null);
                continue;
            }
            Molecule dbMol = JChemSearch.getMolecule(sourcesArray[x], isMarkush[x]);
            this.addSimilarityValuesAsProperties(dbMol, idList[x]);
            molecules.add(dbMol);
            sources.add(isMarkush[x] ? sourcesArray[x] : null);
        }
        return colorUtil;
    }

    private HitDisplayTool getDummyHitDisplayToolForTargets(Molecule[] hits, List<Molecule> molecules, List<byte[]> sources) {
        HitColoringAndAlignmentOptions options = new HitColoringAndAlignmentOptions();
        options.coloring = false;
        options.alignmentMode = 0;
        HitDisplayTool result = new HitDisplayTool(options, new MolSearchOptions(2), null, null);
        for (int i = 0; i < hits.length; ++i) {
            Molecule h = hits[i];
            molecules.add(h);
            sources.add(null);
        }
        return result;
    }

    private void addSimilarityValuesAsProperties(Molecule dbMol, int id) {
        if (this.searchOptions.getSearchType() == 3) {
            int resultVIndex = this.resultVector.indexOf(id);
            if (resultVIndex == -1) {
                return;
            }
            float dissim = this.dissimVector.elementAt(resultVIndex);
            dbMol.setProperty("dissimilarity", Float.toString(dissim));
        }
    }

    private Molecule[] getDescriptorHits(int[] hitIndexes, HitColoringAndAlignmentOptions options, ArrayList dataFieldNames, ArrayList dataFieldValues) throws SQLException, MolFormatException {
        Molecule[] molecules = this.fetchHitsAsMolecules(hitIndexes, dataFieldNames, dataFieldValues, null, false);
        if (options == null || !options.coloring) {
            return molecules;
        }
        MDTableHandler mdth = new MDTableHandler(this.connectionHandler, this.structureTable);
        MolecularDescriptor descriptor = mdth.createMD(this.searchOptions.getDescriptorName());
        MolecularDescriptor queryDesc = mdth.createMD(this.searchOptions.getDescriptorName());
        if (this.searchOptions.getDescriptorConfig() != null) {
            queryDesc.setScreeningConfiguration(this.searchOptions.getDescriptorConfig());
        }
        Color[] atomSetColors = descriptor.getAtomSetColors();
        for (int i = 0; i < molecules.length; ++i) {
            int[] setIndexes;
            Molecule mol = molecules[i];
            MDocument doc = new MDocument(mol);
            if (atomSetColors != null) {
                for (int x = 0; x < 64; ++x) {
                    Color color = atomSetColors[x];
                    if (color == null) continue;
                    doc.setAtomSetRGB(x, color.getRGB());
                }
            }
            if ((setIndexes = descriptor.getAtomSetIndexes(mol)) == null) continue;
            for (int x = 0; x < setIndexes.length; ++x) {
                int index = setIndexes[x];
                mol.getAtom(x).setSetSeq(index);
            }
        }
        return molecules;
    }

    private Molecule[] fetchHitsAsMolecules(int[] idList, ArrayList dataFieldNames, ArrayList dataFieldValues, boolean[] isMarkush, boolean getSupergraph) throws SQLException, MolFormatException {
        byte[][] sources = this.fetchSources(idList, dataFieldNames, dataFieldValues, isMarkush, getSupergraph);
        int count = sources.length;
        Molecule[] mols = new Molecule[count];
        for (int x = 0; x < count; ++x) {
            byte[] source = sources[x];
            if (source == null) continue;
            mols[x] = JChemSearch.getMolecule(source, isMarkush != null ? isMarkush[x] : false);
        }
        return mols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[][] fetchSources(int[] idList, ArrayList dataFieldNames, ArrayList dataFieldValues, boolean[] isMarkush, boolean getSupergraph) throws SQLException {
        int dataFieldCount = dataFieldNames == null ? 0 : dataFieldNames.size();
        StringBuilder sql = new StringBuilder("SELECT ");
        if (this.cartridgeMode) {
            sql.append(this.cartridgeIndexedTable).append(".").append(this.cartridgeIndexedColumn);
        } else {
            sql.append(this.structureTable).append(".cd_structure");
        }
        if (this.markushTable) {
            sql.append(",").append(this.structureTable).append(".cd_flags, ").append(this.structureTable).append(".cd_markush");
        }
        if (!this.cartridgeMode) {
            for (int x = 0; x < dataFieldCount; ++x) {
                sql.append(",");
                sql.append(dataFieldNames.get(x));
            }
        }
        sql.append(" from ");
        sql.append(this.structureTable);
        if (this.cartridgeMode) {
            sql.append(",");
            sql.append(this.cartridgeIndexedTable);
        }
        sql.append(" WHERE ").append(this.structureTable).append(".cd_id = ?");
        if (this.cartridgeMode) {
            sql.append(" AND ").append(this.cartridgeIndexedTable).append(".ROWID = ").append(this.structureTable).append(".RID");
        }
        PreparedStatement pstmt = this.con.prepareStatement(sql.toString());
        byte[] source = null;
        int count = idList.length;
        byte[][] result = new byte[count][];
        try {
            for (int x = 0; x < count; ++x) {
                int id = idList[x];
                pstmt.setInt(1, id);
                ResultSet rs = pstmt.executeQuery();
                try {
                    if (rs.next()) {
                        String flags;
                        source = DatabaseTools.readBytes(rs, 1);
                        if (this.markushTable && (flags = rs.getString(2)) != null && flags.indexOf(109) != -1) {
                            if (isMarkush != null) {
                                isMarkush[x] = true;
                            }
                            if (getSupergraph) {
                                source = DatabaseTools.readBytes(rs, 3);
                            }
                        }
                        int offset = this.markushTable ? 4 : 2;
                        Object[] resultsToReturn = new Object[dataFieldCount];
                        for (int y = 0; y < dataFieldCount; ++y) {
                            resultsToReturn[y] = rs.getObject(offset + y);
                        }
                        if (dataFieldValues != null) {
                            dataFieldValues.add(resultsToReturn);
                        }
                        result[x] = source;
                        continue;
                    }
                    result[x] = null;
                    dataFieldValues.add(null);
                    continue;
                }
                finally {
                    rs.close();
                }
            }
        }
        finally {
            pstmt.close();
        }
        return result;
    }

    public void setRegCode(long code) {
        this.regCode = code;
    }

    private void readQuery() throws MolFormatException {
        block14: {
            int searchType = this.searchOptions.getSearchType();
            if (this.queryMode == 0) {
                this.queryModeBoolean = searchType != 5 && searchType != 3 && searchType != 6 && this.searchOptions.getTautomerSearch() != 1;
            } else if (this.queryMode == 1) {
                this.queryModeBoolean = false;
            } else if (this.queryMode == 2) {
                this.queryModeBoolean = true;
            }
            if (this.queryMolecule != null) {
                this.queryMol = (Molecule)this.queryMolecule.clone();
            } else if (this.queryStructure != null) {
                MolHandler mh = new MolHandler();
                mh.setQueryMode(this.queryModeBoolean);
                mh.setMolecule(this.queryStructure);
                this.queryMol = mh.getMolecule();
            } else {
                this.queryMol = new Molecule();
            }
            this.emptyQuery = this.queryMol.getAtomCount() == 0;
            this.originalQuery = (Molecule)this.queryMol.clone();
            if (this.infoToStdError || infoLogger.isLoggable(Level.FINE)) {
                try {
                    if (!this.emptyQuery) {
                        this.queryCxsmarts = MolExporter.exportToFormat(this.queryMol, "cxsmarts");
                        break block14;
                    }
                    this.queryCxsmarts = "<Empty query>";
                }
                catch (Exception e) {
                    this.queryCxsmarts = "<Cannot display query in CXSMARTS format>";
                }
            } else {
                this.queryCxsmarts = null;
            }
        }
    }

    private void initQuery() throws DatabaseSearchException {
        if (this.queryInitialized) {
            return;
        }
        this.queryMol.setPropertyObject("AROMATIZATION_METHOD", null);
        this.isMarkushQuery = this.emptyQuery ? false : Supergraph.isMarkushMolecule(this.queryMol);
        this.hashCodeScreeningForFull = false;
        int searchType = this.searchOptions.getSearchType();
        boolean bl = this.hashCodeScreeningForFull = this.tableType != 3 && !this.tautomerDuplicateSearchTable && searchType == 4 && JChemSearch.hashCodeApplicable(this.queryMol);
        if (!this.emptyQuery) {
            if (this.searchOptions.isUndefinedRAtomMatchingGroup() && this.tableType == 3 && SearchUtil.hasUndefinedRAtom(this.queryMol)) {
                throw new IllegalArgumentException("Undefined R-atom matching group is not supported for Markush tables. Please choose any atom option for undefined R-atom matching.");
            }
            if (!this.standardizationDisabled && !this.isEnumeratedSearch && this.searchOptions.getDescriptorName() == null) {
                if (this.isMarkushQuery && searchType == 5) {
                    MarkushAromata ma = new MarkushAromata();
                    ma.aromatize(this.queryMol);
                } else {
                    if (this.tableType == 4 && searchType != 5) {
                        this.standardizer[0].setActiveGroup("target");
                    } else {
                        this.standardizer[0].setActiveGroup("query");
                        try {
                            this.standardizer[0].addInactiveTasks("removeexplicith");
                        }
                        catch (StandardizerException e) {
                            throw new DatabaseSearchException(e);
                        }
                    }
                    try {
                        this.standardizer[0].standardize(this.queryMol);
                    }
                    catch (SearchException e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)e);
                        }
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        if (this.tautomerDuplicateSearch && !this.tautomerDupSearchUsesOrigQuery) {
            this.queryMol = this.getGenericTautomerOfQuery();
        }
        if (searchType != 1 && !this.noScreenReturnAll) {
            this.molSearch[0].setQuery(this.queryMol);
            for (int x = 1; x < this.threadsCount; ++x) {
                this.molSearch[x].setQuery((Molecule)this.queryMol.clone());
            }
        }
        if (!this.tautomerDuplicateSearch) {
            this.getFingerprint(this.queryMol);
        }
        if (searchType == 5 || this.hashCodeScreeningForFull) {
            if (this.tautomerDuplicateSearch || !TableInfo.isFPusedinHashCode(this.tableType)) {
                Molecule molToScreen = this.queryMol;
                if (this.tableType == 3) {
                    molToScreen = molToScreen.cloneMolecule();
                    HomologyConversionUtil.deconvertHomologies(molToScreen, true);
                }
                this.hash = this.tautomerDupSearchUsesOrigQuery ? this.hc.getHashCode(this.calcGenericTautomer(molToScreen)) : this.hc.getHashCode(molToScreen);
            } else {
                this.hash = this.getHashCode(this.queryMol, this.fingerprintInInts);
            }
        }
        if (searchType == 5) {
            this.smiles = this.getSmiles(this.queryMol);
        }
        this.queryInitialized = true;
    }

    private Molecule getGenericTautomerOfQuery() throws DatabaseSearchException {
        if (this.preCalculatedGenericTautomer != null) {
            Molecule tautomer = this.preCalculatedGenericTautomer;
            this.preCalculatedGenericTautomer = null;
            if (this.searchOptions.getIsotopeMatching() == 2) {
                TautomerUtil.removeIsotopeInfoFromGenericTautomer(tautomer);
            }
            return tautomer;
        }
        return this.calcGenericTautomer(this.queryMol);
    }

    private Molecule calcGenericTautomer(Molecule mol) throws DatabaseSearchException {
        Molecule ret = null;
        try {
            ret = TautomerUtil.createGenericTautomer(mol, this.genericTautomerProtectsChirality, this.switchOffAllProtectionsForTDF, this.searchOptions.getIsotopeMatching() == 2);
        }
        catch (PluginException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            throw new DatabaseSearchException(e);
        }
        return ret;
    }

    private void initThreads() {
        if (this.thread == null) {
            this.thread = new ABASThread[this.threadsCount];
            this.molSearch = new MolSearch[this.threadsCount];
            boolean implicitLicenseForMolSearch = this.licenseEnvironment.equals("InstantJChemLicenseEnvironment");
            for (int x = 0; x < this.threadsCount; ++x) {
                this.molSearch[x] = new MolSearch();
                if (!implicitLicenseForMolSearch) continue;
                this.molSearch[x].setLicenseEnvironment("StructureSearchForInternalMolSearchLicenseEnvironment");
            }
            this.searchOptions.setDirty(true);
        }
    }

    private void initSearchers() {
        if (this.searchOptions.isDirty()) {
            MolSearchOptions mso = new MolSearchOptions(2);
            this.searchOptions.clonecopy(mso);
            mso.setVagueBondLevel(1);
            mso.setTautomerSearch(0);
            mso.setHitIncludesRNodes(true);
            mso.setQueryAbsoluteStereo(this.absStereoMode);
            mso.setTargetAbsoluteStereo(this.absStereoMode);
            mso.setMarkushEnabled(this.markushTable);
            if (this.tautomerDuplicateSearch && !this.tautomerDupSearchUsesOrigQuery) {
                mso.addUserComparator(new DataSgroupComparator(2, "BEC"));
            }
            for (int x = 0; x < this.molSearch.length; ++x) {
                this.molSearch[x].setSearchOptions(mso);
            }
            this.searchOptions.setDirty(false);
        }
    }

    private void initTableName() throws SQLException {
        if (!this.tableNameInitialized) {
            this.structureTable = TableInfo.getTableNameWithSchema(this.con, this.structureTable);
            this.tableNameInitialized = true;
        }
    }

    private void checkIfTableSettingsAreStillValid() throws SQLException {
        this.timeStamp = TableInfo.getTableValidityTimestamp(this.dbProp, this.structureTable);
        if (this.tableSettingsInvalid()) {
            this.tableInitialized = false;
        }
        this.prevTableName = this.structureTable;
    }

    void init() throws SQLException, DatabaseSearchException, MolFormatException, IOException, PropertyNotSetException {
        this.initThreads();
        this.initConnection();
        this.initTableName();
        this.initTable();
        this.initEnumeratedSearch();
        this.initSearchers();
        this.checkAllowedOptions();
        this.initFilter();
        this.initFormulaSearch();
        this.initChemTermColumns();
        this.getRowReaderSQL();
        this.selectStereoModel();
        this.initImplHMatching();
        if (this.filterIDList != null && !this.filterIDListSorted) {
            Arrays.sort(this.filterIDList);
            this.filterIDListSorted = true;
        }
        if (this.filterIDNotList != null && !this.filterIDNotListSorted) {
            Arrays.sort(this.filterIDNotList);
            this.filterIDNotListSorted = true;
        }
        this.initChemTermFilter();
        int[] v = new int[]{this.fpCount / 2 > 0 ? this.fpCount / 2 : 1};
        this.columnCountsAtScreenening = v;
    }

    private void selectStereoModel() {
        MolSearchOptions searchOptionsToSet = this.molSearch[0].getSearchOptions();
        SearchUtil.selectStereoModel(this.searchOptions, searchOptionsToSet, this.tableType, this.tableType == 3);
        for (int x = 0; x < this.molSearch.length; ++x) {
            this.molSearch[x].setSearchOptions((SearchOptions)searchOptionsToSet);
        }
    }

    private void initImplHMatching() {
        int mode = this.searchOptions.getImplicitHMatching();
        if (mode == 3) {
            if (this.tableType == 4 && this.searchOptions.getSearchType() == 5) {
                mode = 2;
            }
        } else if (mode == 0) {
            mode = this.tableType == 4 && this.searchOptions.getSearchType() == 5 ? 2 : 1;
        }
        MolSearchOptions mso = this.molSearch[0].getSearchOptions();
        mso.setImplicitHMatching(mode);
        for (int x = 0; x < this.molSearch.length; ++x) {
            this.molSearch[x].setSearchOptions(mso);
        }
    }

    private void initFormulaSearch() {
        if (this.searchOptions.getFormulaSearchType() != 0 && this.searchOptions.getFormulaSearchQuery() != null && !this.searchOptions.getFormulaSearchQuery().equals("")) {
            this.formulaSearch = new FormulaSearch();
            this.formulaSearch.setQuery(this.searchOptions.getFormulaSearchQuery());
            this.formulaSearch.setSearchType(this.searchOptions.getFormulaSearchType());
        }
    }

    private void initChemTermColumns() throws SQLException {
        if (this.chemTermColumnsInitialized) {
            return;
        }
        this.chemTermFilterInitialized = false;
        this.modifiedfFilterExpression = null;
        this.chemicalTermsSubstitution = false;
        String filterExpression = this.searchOptions.getChemTermsFilter();
        if (filterExpression == null) {
            return;
        }
        if (this.searchOptions.getChemTermsFilterConfig() != null) {
            return;
        }
        String[] ctColNames = this.dbProp.getChemTermColumns(this.structureTable);
        int colCount = ctColNames.length;
        if (colCount == 0) {
            return;
        }
        String[] expressions = new String[colCount];
        for (int i = 0; i < colCount; ++i) {
            expressions[i] = this.dbProp.getChemTermForColumn(this.structureTable, ctColNames[i]);
        }
        SubstitutionUtil su = new SubstitutionUtil();
        su.setExpression(filterExpression);
        su.setSubExpressions(expressions);
        su.evaluate();
        this.modifiedfFilterExpression = su.getModifiedExpression(SUBSTITUTED_CT_FIELD_PROPERY_PREFIX);
        if (this.modifiedfFilterExpression == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("modifiedfFilterExpression: " + this.modifiedfFilterExpression));
        }
        this.chemicalTermsSubstitution = true;
        int[] usedColumns = su.getUsedColumns();
        int count = usedColumns.length;
        this.substitutedCTColumns = new String[count];
        for (int x = 0; x < count; ++x) {
            this.substitutedCTColumns[x] = ctColNames[usedColumns[x]];
        }
        this.chemTermColumnsInitialized = true;
    }

    private void getRowReaderSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        if (this.substitutedCTColumns != null) {
            for (int x = 0; x < this.substitutedCTColumns.length; ++x) {
                if (x > 0) {
                    sql.append(",");
                }
                sql.append(this.substitutedCTColumns[x]);
            }
        }
        sql.append(" FROM ");
        sql.append(this.structureTable);
        sql.append(" WHERE cd_id=?");
        this.rowReaderSQL = sql.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("rowReaderSQL at init: " + this.rowReaderSQL));
        }
    }

    private void initChemTermFilter() throws DatabaseSearchException {
        if (this.prevEmptyQuery != null && this.prevEmptyQuery != this.emptyQuery) {
            this.chemTermFilterInitialized = false;
        }
        this.prevEmptyQuery = this.emptyQuery;
        if (this.chemTermFilterInitialized) {
            return;
        }
        try {
            if (this.emptyQuery || this.searchOptions.getSearchType() == 3) {
                this.initChemTermFilterForEvaluators();
            } else {
                this.setChemTermFilterForMolSearches();
            }
        }
        catch (ParseException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            throw new DatabaseSearchException(e.getMessage());
        }
        catch (SearchException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            throw new DatabaseSearchException(e.getMessage());
        }
        this.chemTermFilterInitialized = true;
    }

    private void setChemTermFilterForMolSearches() throws SearchException {
        for (int x = 0; x < this.threadsCount; ++x) {
            String filterLocal = this.modifiedfFilterExpression == null ? this.searchOptions.getChemTermsFilter() : this.modifiedfFilterExpression;
            this.molSearch[x].setFilter(filterLocal);
            File config = null;
            if (this.filterConfigFile != null && this.filterConfigFile.length() > 0) {
                config = new File(this.filterConfigFile);
            }
            this.standardizer[x].setActiveGroup("query");
            this.standardizer[x].setInactiveTasks("removeexplicith");
            this.molSearch[x].setFilterConfig(config);
            this.molSearch[x].setStandardizer(this.standardizer[x], false, false);
        }
    }

    private void initChemTermFilterForEvaluators() throws ParseException {
        String filterExpression = this.searchOptions.getChemTermsFilter();
        if (filterExpression != null) {
            int x;
            String filterLocal;
            String string = filterLocal = this.modifiedfFilterExpression == null ? filterExpression : this.modifiedfFilterExpression;
            if (this.evaluator == null) {
                this.evaluator = new Evaluator[this.threadsCount];
                this.context = new MolContext[this.threadsCount];
                this.jep = new ChemJEP[this.threadsCount];
                for (x = 0; x < this.threadsCount; ++x) {
                    this.evaluator[x] = new Evaluator(this.searchOptions.getChemTermsFilterConfig(), (chemaxon.jep.Standardizer)this.standardizer[x]);
                    this.context[x] = new MolContext();
                }
            }
            for (x = 0; x < this.threadsCount; ++x) {
                this.jep[x] = this.evaluator[x].compile(filterLocal, MolContext.class);
            }
        }
    }

    private boolean tableSettingsInvalid() {
        boolean result = false;
        result = this.prevTableName != null && this.prevTableName.equals(this.structureTable) ? !TableInfo.checkTimeStamp(this.prevTimeStamp, this.timeStamp) : false;
        this.prevTimeStamp = this.timeStamp;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntVector getAllIDs() throws SQLException {
        if (this.searchOptions.getSearchType() == 3) {
            return this.allDissimID;
        }
        if (this.sCache != null) {
            return this.sCache.getAllIDs();
        }
        IntVector vector = new IntVector();
        String sql = "SELECT cd_id FROM " + this.structureTable;
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            try {
                while (rs.next()) {
                    vector.addElement(rs.getInt(1));
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return vector;
    }

    final void getFingerprint(Molecule mol) {
        block5: {
            this.queryIsStructuralKey = false;
            if (this.searchOptions.getSearchType() == 5 && this.tableType == 3) {
                return;
            }
            if (this.preCalculatedHashCode == null) {
                boolean checkForStructuralKey = !this.isEnumeratedSearch && !this.isMarkushQuery;
                boolean mustFragmentForScreen = (!this.searchOptions.isPerfectSearchType() || TableInfo.hasOnlyMustFragmentForScreen(this.tableType)) && !this.searchOptions.isSuperstructureSearch();
                Molecule molToScreen = mustFragmentForScreen ? SearchUtil.getMustFragment(mol) : mol;
                int[][] fingerprints = this.cofp.getCombinedFingerprints(molToScreen, this.queryStructure, this.queryModeBoolean, checkForStructuralKey, true, this.tableType != 3);
                this.queryIsStructuralKey = this.cofp.queryIsKey();
                this.fingerprintInInts = fingerprints[1];
                this.fingerprintNoRings = fingerprints[0];
                this.fingerprint = BinaryDataUtil.getFingerprintInBytes(this.fingerprintInInts);
                if (this.reactionTable && this.searchOptions.getSearchType() == 3) {
                    try {
                        this.reactionFingerprint.generate(this.queryMol);
                    }
                    catch (MDGeneratorException e) {
                        if (!log.isErrorEnabled()) break block5;
                        log.error((Object)e);
                    }
                }
            }
        }
    }

    final void getEnumeratedFingerprint(Molecule mol) {
        int[] enumFp = new int[this.fpCount];
        if (this.searchOptions.getSearchType() != 6) {
            Arrays.fill(enumFp, -1);
        }
        MolEnumerator enumerator = SearchEnumerator.createMarkushEnumerator(6201, mol);
        while (enumerator.hasMoreElements()) {
            Molecule eMol = enumerator.nextElement();
            int[] singleFP = this.cofp.getCombinedFingerprint(new MolHandler(eMol), null, false, false);
            for (int y = 0; y < this.fpCount; ++y) {
                if (this.searchOptions.getSearchType() != 6) {
                    int n = y;
                    enumFp[n] = enumFp[n] & singleFP[y];
                    continue;
                }
                int n = y;
                enumFp[n] = enumFp[n] | singleFP[y];
            }
        }
        this.fingerprintInInts = enumFp;
        this.fingerprint = BinaryDataUtil.getFingerprintInBytes(this.fingerprintInInts);
    }

    final int getHashCode(Molecule mol, int[] fp) {
        if (this.preCalculatedHashCode != null) {
            int hashCode = this.preCalculatedHashCode;
            this.preCalculatedHashCode = null;
            return hashCode;
        }
        return this.hc.getHashCode(mol, fp);
    }

    private final byte[] getSmiles(Molecule mol) {
        if (this.preCalculatedSmilesSet) {
            this.preCalculatedSmilesSet = false;
            return this.preCalculatedSmiles;
        }
        if (this.isMarkushQuery) {
            return null;
        }
        String smi = UpdateHandler.getSmiles(mol);
        if (smi == null) {
            return null;
        }
        try {
            return smi.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            assert (false);
            return null;
        }
    }

    void getCandidates() throws SQLException, DatabaseSearchException {
        int predictedSize;
        this.isScreenedContainsIndices = false;
        this.screenMonitor.start();
        int searchType = this.searchOptions.getSearchType();
        this.isScreening = searchType != 0 && searchType != 3;
        this.isHashScreening = this.isScreening && (searchType == 5 || this.hashCodeScreeningForFull);
        this.isBitwiseScreening = this.isScreening && searchType != 5 && !this.hashCodeScreeningForFull;
        this.isBitwiseScreeningLocally = this.isBitwiseScreening && (!this.existsBitwiseAND || this.sCache != null);
        this.isBitwiseScreeningLocallyUsingCache = (this.isBitwiseScreening || this.hashCodeScreeningForFull) && this.sCache != null;
        this.isSimilarityCheckingFromCache = searchType == 3 && this.sCache != null && this.fpCount == this.sCache.getFPColumnCount();
        int maxResultCount = this.searchOptions.getMaxResultCount();
        int n = searchType == 3 ? 10000 : (predictedSize = maxResultCount == 0 ? 10000 : 2 * maxResultCount);
        if (this.sCache != null && this.noScreenReturnAll && this.filterVector == null) {
            this.fillScreenedVectorWithCandidateIndices();
        } else if (this.noScreenReturnAll && this.filterVector != null) {
            this.fillScreenedVectorWithFilterIndices();
        } else {
            boolean matchCountIncludesZero = false;
            if (this.searchOptions.getMatchCountOptions() != null) {
                matchCountIncludesZero = this.searchOptions.getMatchCountOptions().isMatchCountIncludesZero();
            }
            if (this.nonHits == null) {
                this.nonHits = matchCountIncludesZero ? new IntVector() : null;
            }
            this.screenedVector = new IntVector(predictedSize);
            if (this.isHashScreening) {
                this.getScreenedInBatch(1, this.fpCount, null, -1, -1, this.filterVector, this.screenedVector);
            } else if (this.isBitwiseScreeningLocallyUsingCache) {
                if (this.filterVector == null) {
                    this.fillScreenedVectorWithCandidateIndices();
                } else {
                    this.fillScreenedVectorWithFilterIndices();
                }
            } else if (this.isSimilarityCheckingFromCache) {
                this.checkSimilarityFromCache(this.screenedVector);
            } else if (this.isBitwiseScreeningLocally) {
                int firstColumn = 0;
                int columnCount = this.columnCountsAtScreenening[0];
                this.getScreenedInBatch(firstColumn, columnCount, null, -1, 0, this.filterVector, this.screenedVector);
                for (int i = 1; i < this.columnCountsAtScreenening.length; ++i) {
                    int sizeOfNextPiece;
                    IntVector oldScreenedVector = this.screenedVector;
                    this.screenedVector = new IntVector(predictedSize);
                    firstColumn += columnCount;
                    columnCount = this.columnCountsAtScreenening[i];
                    for (int nextIndexInOldVector = 0; nextIndexInOldVector < oldScreenedVector.size(); nextIndexInOldVector += sizeOfNextPiece) {
                        int sizeAhead = oldScreenedVector.size() - nextIndexInOldVector;
                        sizeOfNextPiece = sizeAhead > this.batchSize ? this.batchSize : sizeAhead;
                        this.getScreenedInBatch(firstColumn, columnCount, oldScreenedVector, nextIndexInOldVector, sizeOfNextPiece, this.filterVector, this.screenedVector);
                    }
                }
            } else {
                this.getScreenedInBatch(1, this.fpCount, null, -1, -1, this.filterVector, this.screenedVector);
            }
            if (this.nonHits != null) {
                this.nonHits.sort();
            }
        }
        if ("" != null && "".length() > 0 && (this.sCache != null || this.emptyQuery)) {
            this.retrieveFinalizedIDs(this.screenedVector);
            this.isScreenedContainsIndices = false;
            this.screenedVector = this.filterScreened(this.screenedVector, "");
        }
        if (this.filterIDList != null || this.filterIDNotList != null) {
            this.retrieveFinalizedIDs(this.screenedVector);
            this.isScreenedContainsIndices = false;
            this.screenedVector = this.filterScreened(this.screenedVector, this.filterIDList, this.filterIDNotList);
        }
        if (this.filterVector != null && this.sCache == null) {
            this.retrieveFinalizedIDs(this.screenedVector);
            this.isScreenedContainsIndices = false;
            this.screenedVector = this.filterScreened(this.screenedVector, this.filterVector);
        }
        if (this.isEnumeratedSearch) {
            if (this.firstEnumeratedStructure) {
                this.firstEnumeratedStructure = false;
            } else {
                IntVector newScreenedVector = new IntVector(this.screenedVector.size());
                int count = this.screenedVector.size();
                int identifier = -1;
                for (int x = 0; x < count; ++x) {
                    identifier = this.screenedVector.get(x);
                    if (this.finalResultVector.indexOfWithBinarySearch(identifier) != -1) continue;
                    newScreenedVector.addElement(identifier);
                }
                this.screenedVector = newScreenedVector;
            }
        }
        if (searchType != 3) {
            this.screenMonitor.stop();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("screenedVector: " + this.screenedVector.toString()));
        }
    }

    private IntVector getIntersectedScreenedVector(IntVector candidatesVector, IntVector beforeEnumVector) {
        int afterEnumValue;
        IntVector newNonHits = new IntVector();
        IntVector newScreenedVector = new IntVector();
        IntVector beforeEnumVectorClone = beforeEnumVector.cloneIntVector();
        candidatesVector.sort();
        if (!this.isScreenedContainsIndices) {
            this.sCache.convertIndicesToID(beforeEnumVectorClone);
        }
        beforeEnumVectorClone.sort();
        int afterEnumSize = candidatesVector.size();
        int beforeEnumSize = beforeEnumVectorClone.size();
        int afterEnumIndex = 0;
        int beforeEnumIndex = 0;
        while (afterEnumIndex < afterEnumSize && beforeEnumIndex < beforeEnumSize) {
            int beforeEnumValue;
            afterEnumValue = candidatesVector.get(afterEnumIndex);
            if (afterEnumValue < (beforeEnumValue = beforeEnumVectorClone.get(beforeEnumIndex))) {
                if (this.isScreenedContainsIndices) {
                    afterEnumValue = this.sCache.getID(afterEnumValue);
                }
                if (this.nonHits != null && this.nonHits.indexOfWithBinarySearch(afterEnumValue) == -1 && newNonHits.indexOfWithBinarySearch(afterEnumValue) == -1) {
                    newNonHits.add(afterEnumValue);
                }
                ++afterEnumIndex;
                continue;
            }
            if (afterEnumValue > beforeEnumValue) {
                ++beforeEnumIndex;
                continue;
            }
            newScreenedVector.add(afterEnumValue);
            ++afterEnumIndex;
            ++beforeEnumIndex;
        }
        if (afterEnumIndex < afterEnumSize) {
            afterEnumValue = candidatesVector.get(afterEnumIndex);
            if (this.isScreenedContainsIndices) {
                afterEnumValue = this.sCache.getID(afterEnumValue);
            }
            if (this.nonHits != null && this.nonHits.indexOfWithBinarySearch(afterEnumValue) == -1 && newNonHits.indexOfWithBinarySearch(afterEnumValue) == -1) {
                newNonHits.add(afterEnumValue);
            }
            ++afterEnumIndex;
        }
        if (this.nonHits != null) {
            this.nonHits.addAll(newNonHits);
        }
        return newScreenedVector;
    }

    private void fillScreenedVectorWithFilterIndices() {
        if (this.beforeEnumScreenedVector != null) {
            this.screenedVector = this.beforeEnumScreenedVector;
        } else {
            this.screenedVector = new IntVector(this.filterVector.size());
            this.screenedVector.addAll(this.filterVector);
            this.sCache.convertIDsToIndices(this.screenedVector);
        }
        this.isScreenedContainsIndices = true;
    }

    private void fillScreenedVectorWithCandidateIndices() {
        this.screenedVector = this.beforeEnumScreenedVector != null ? this.beforeEnumScreenedVector : this.sCache.getAllIndices();
        this.isScreenedContainsIndices = true;
    }

    private void retrieveFinalizedIDs(IntVector list) {
        if (this.isScreenedContainsIndices) {
            this.sCache.convertIndicesToID(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getScreenedInBatch(int firstColumn, int columnCount, IntVector oldScreenedVector, int nextIndexInOldVector, int sizeOfNextPiece, IntVector filterVector, IntVector screenedVector) throws SQLException, DatabaseSearchException {
        String ft;
        int searchType = this.searchOptions.getSearchType();
        String filterTableLocal = ft = "" == null || "".length() > 0 ? "" : null;
        StringBuilder sb = new StringBuilder(64);
        sb.append("SELECT ");
        sb.append(this.structureTable);
        sb.append(".");
        sb.append("cd_id");
        if (this.isBitwiseScreeningLocally) {
            for (int i = firstColumn; i < firstColumn + columnCount; ++i) {
                sb.append(", ");
                sb.append(this.structureTable);
                sb.append(".");
                sb.append("cd_fp");
                sb.append(i + 1);
            }
        }
        sb.append("\nFROM ");
        sb.append(filterTableLocal == null || this.sCache != null ? "" : filterTableLocal + ", ");
        sb.append(this.structureTable);
        boolean thereIsCondition = false;
        if (!this.everyTargetIsHit) {
            if (filterTableLocal != null && this.sCache == null) {
                sb.append(" WHERE\n");
                thereIsCondition = true;
                sb.append(filterTableLocal);
                sb.append(".");
                sb.append("cd_id");
                sb.append("=");
                sb.append(this.structureTable);
                sb.append(".");
                sb.append("cd_id");
            }
            if (this.isScreening) {
                if (this.isBitwiseScreeningLocally) {
                    if (firstColumn > 0) {
                        if (!thereIsCondition) {
                            sb.append(" WHERE\n");
                        } else {
                            sb.append(" AND\n");
                        }
                        thereIsCondition = true;
                        sb.append(this.structureTable);
                        sb.append(".");
                        sb.append("cd_id");
                        sb.append(" IN (");
                        sb.append(oldScreenedVector.get(nextIndexInOldVector));
                        int last = nextIndexInOldVector + sizeOfNextPiece - 1;
                        for (int i = nextIndexInOldVector + 1; i <= last; ++i) {
                            sb.append(",");
                            sb.append(oldScreenedVector.get(i));
                        }
                        sb.append(")");
                    }
                } else {
                    if (!thereIsCondition) {
                        sb.append(" WHERE\n");
                    } else {
                        sb.append(" AND\n");
                    }
                    thereIsCondition = true;
                    if (this.isHashScreening) {
                        sb.append("\n\t");
                        sb.append(this.structureTable);
                        sb.append(".");
                        sb.append("cd_hash");
                        sb.append("=?");
                    } else {
                        for (int i = 1; i <= this.fpCount; ++i) {
                            if (i > 1) {
                                sb.append(" AND ");
                            }
                            if (this.existsBitwiseANDOperator) {
                                sb.append("\n\t(");
                                sb.append(this.structureTable);
                                sb.append(".");
                                sb.append("cd_fp");
                                sb.append(i);
                                sb.append(" & ?) = ");
                                if (this.rdbms != 3) {
                                    if (searchType == 6) {
                                        sb.append("cd_fp").append(i);
                                        continue;
                                    }
                                    sb.append("?");
                                    continue;
                                }
                                if (searchType == 6) {
                                    sb.append("(cd_fp").append(i).append(" | 0)");
                                    continue;
                                }
                                sb.append("(? | 0)");
                                continue;
                            }
                            int part = this.fingerprintInInts[i - 1];
                            sb.append("\n\t");
                            sb.append(this.nameOfBitwiseANDFunction);
                            sb.append("(");
                            sb.append(this.structureTable);
                            sb.append(".");
                            sb.append("cd_fp");
                            sb.append(i);
                            if (searchType == 6) {
                                sb.append(",").append(part).append(") = cd_fp").append(i);
                                continue;
                            }
                            sb.append(",").append(part).append(") = ").append(part);
                        }
                    }
                }
            }
        }
        if (this.whereClause != null && this.whereClause.length() > 0) {
            if (!thereIsCondition) {
                sb.append(" WHERE ");
            } else {
                sb.append(" AND ");
            }
            sb.append(this.whereClause);
        }
        sb.append("\n");
        String sql = sb.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("in getScreenedInBatch sql: " + sql));
        }
        PreparedStatement pstmt = null;
        if (this.usePreparedStatements && this.pstmtForScreening != null && this.pstmtSQLForScreening.equals(sql)) {
            pstmt = this.pstmtForScreening;
        } else {
            pstmt = this.con.prepareStatement(sql);
            DatabaseOptions.setFetchSize(pstmt, 2000, this.rdbms);
            this.pstmtForScreening = pstmt;
            this.pstmtSQLForScreening = sql;
        }
        if (!this.everyTargetIsHit) {
            if (searchType == 5 || this.hashCodeScreeningForFull) {
                pstmt.setInt(1, this.hash);
            } else if (this.isScreening && !this.emptyQuery && !this.isBitwiseScreeningLocally && this.existsBitwiseANDOperator) {
                int j = 1;
                for (int i = 0; i < this.fpCount; ++i) {
                    int part = this.fingerprintInInts[i];
                    pstmt.setInt(j++, part);
                    if (searchType == 6) continue;
                    pstmt.setInt(j++, part);
                }
            }
        }
        if (searchType == 1 || this.emptyQuery) {
            pstmt.setMaxRows(this.searchOptions.getMaxResultCount());
        }
        ResultSet rs = pstmt.executeQuery();
        try {
            int id;
            if (filterVector != null) {
                filterVector.sort();
            }
            if (this.isBitwiseScreeningLocally) {
                while (!this.stopRequested && rs.next()) {
                    id = rs.getInt(1);
                    if (filterVector != null && filterVector.indexOfWithBinarySearch(id) == -1 || !this.dbFPMatchesQueryFP(rs, 2, firstColumn, columnCount)) continue;
                    screenedVector.addElement(id);
                }
            } else {
                while (!this.stopRequested && rs.next()) {
                    id = rs.getInt(1);
                    if (filterVector != null && filterVector.indexOfWithBinarySearch(id) == -1) continue;
                    screenedVector.addElement(id);
                }
            }
        }
        finally {
            rs.close();
            if (!this.usePreparedStatements) {
                pstmt.close();
            }
        }
    }

    final boolean dbFPMatchesQueryFP(ResultSet rs, int fpStartInRS, int firstColumn, int columnCount) throws SQLException {
        for (int i = 0; i < columnCount; ++i) {
            int dbCol = rs.getInt(fpStartInRS + i);
            int queryCol = this.fingerprintInInts[firstColumn + i];
            int expectedResult = 0;
            expectedResult = this.searchOptions.getSearchType() == 6 ? dbCol : queryCol;
            if ((dbCol & queryCol) == expectedResult) continue;
            return false;
        }
        return true;
    }

    private void screenMD() throws SQLException, DatabaseSearchException {
        try {
            this.setProgressMessage("Molecular Descriptor screening");
            this.hits = 0;
            MDTableHandler mdth = new MDTableHandler(this.connectionHandler, this.structureTable, this.cartridgeMode);
            MolecularDescriptor queryDesc = mdth.createMD(this.searchOptions.getDescriptorName());
            if (this.searchOptions.getDescriptorConfig() != null) {
                queryDesc.setScreeningConfiguration(this.searchOptions.getDescriptorConfig());
            }
            Molecule mol = this.queryMol;
            queryDesc.generate(mol);
            if (log.isDebugEnabled()) {
                String s = queryDesc.toString();
                log.debug((Object)("query " + s + "..."));
            }
            MDDBReader reader = new MDDBReader(this.structureTable, this.connectionHandler, new String[]{this.searchOptions.getDescriptorName()}, this.searchOptions.getFilterQuery(), this.filterIDList, this.cartridgeMode);
            reader.setGenerateId(false);
            reader.setCloneResult(false);
            this.maxTimeReached = false;
            MDSet mdSet = null;
            while ((mdSet = reader.next()) != null && !this.maxTimeReached) {
                long maxTime;
                float dissim = queryDesc.getDissimilarity(mdSet.getDescriptor(0), 0);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("dissim= " + dissim + ", sim=" + (1.0f - dissim)));
                }
                boolean hit = dissim <= this.searchOptions.getDissimilarityThreshold();
                int id = mdSet.getId();
                if (hit && this.searchOptions.getChemTermsFilter() != null) {
                    hit &= this.checkFilter(reader.getLastID());
                }
                if (hit) {
                    this.finalResultVector.addElement(id);
                    this.dissimVector.addElement(dissim);
                    ++this.hits;
                    int maxResultCount = this.searchOptions.getMaxResultCount();
                    boolean bl = this.maxResultCountReached = maxResultCount != 0 && this.hits >= maxResultCount && !this.searchOptions.isReturnsNonHits();
                    if (this.maxResultCountReached) break;
                }
                if (this.searchOptions.isReturnsNonHits()) {
                    this.allDissimID.addElement(id);
                    this.allDissimDissim.addElement(dissim);
                }
                if ((maxTime = this.searchOptions.getMaxTime()) <= 0L) continue;
                long timePassed = System.currentTimeMillis() - this.startTime;
                this.maxTimeReached = maxTime != 0L && timePassed >= maxTime;
            }
            reader.close();
            this.setProgressMessage("");
        }
        catch (MDGeneratorException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error", (Throwable)e);
            }
            throw new DatabaseSearchException(e.getMessage(), e);
        }
        catch (MDReaderException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error", (Throwable)e);
            }
            throw new DatabaseSearchException(e.getMessage(), e);
        }
        catch (SearchException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error", (Throwable)e);
            }
            throw new DatabaseSearchException(e.getMessage(), e);
        }
        finally {
            if (this.pstmtForSmilesRead != null) {
                this.pstmtForSmilesRead.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFilter(int id) throws SQLException, SearchException, DatabaseSearchException {
        Molecule mol;
        boolean isSmiles;
        String dbMolString;
        block24: {
            dbMolString = null;
            isSmiles = true;
            if (this.sCache != null) {
                byte[] data;
                int idx = this.sCache.findID(id);
                if (idx != -1 && (data = this.sCache.getStructureStringInBytes(idx)) != null) {
                    try {
                        dbMolString = new String(data, "ASCII");
                    }
                    catch (UnsupportedEncodingException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)e);
                        }
                    }
                }
            } else {
                if (this.pstmtForSmilesRead == null) {
                    String sql = "select cd_smiles from " + this.structureTable + " where cd_id = ?";
                    this.pstmtForSmilesRead = this.con.prepareStatement(sql);
                }
                this.pstmtForSmilesRead.setInt(1, id);
                ResultSet rs = this.pstmtForSmilesRead.executeQuery();
                try {
                    if (rs.next()) {
                        dbMolString = rs.getString(1);
                    }
                }
                finally {
                    rs.close();
                }
            }
            if (dbMolString == null) {
                String sql = "select cd_structure from " + this.structureTable + " where cd_id = " + id;
                Statement stmt = this.con.createStatement();
                try {
                    ResultSet rs = stmt.executeQuery(sql);
                    try {
                        block25: {
                            byte[] data;
                            if (!rs.next() || (data = DatabaseTools.readBytes(rs, 1)) == null) break block24;
                            try {
                                dbMolString = new String(data, "ASCII");
                            }
                            catch (UnsupportedEncodingException e) {
                                if (!log.isDebugEnabled()) break block25;
                                log.debug((Object)e);
                            }
                        }
                        isSmiles = false;
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    stmt.close();
                }
            }
        }
        if (dbMolString == null) {
            return false;
        }
        try {
            mol = MolImporter.importMol(dbMolString);
        }
        catch (IOException e) {
            return false;
        }
        return this.isMatching(mol, 0, isSmiles, id, null);
    }

    private void searchInDB(IntVector screened, IntVector noSmiles, boolean searchUsingOriginalTarget) throws SQLException, MolFormatException, IOException, DatabaseSearchException {
        RgMolecule dbMol = new RgMolecule();
        this.retrieveBatchAndSearch(searchUsingOriginalTarget, screened, noSmiles, dbMol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveBatchAndSearch(boolean searchUsingOriginalTarget, IntVector screened, IntVector noSmiles, Molecule dbMol) throws SQLException, UnsupportedEncodingException, DatabaseSearchException {
        int searchType = this.searchOptions.getSearchType();
        String filterExpression = this.searchOptions.getChemTermsFilter();
        String sql = this.createSqlForBatchReading(searchUsingOriginalTarget);
        PreparedStatement pstmt = this.con.prepareStatement(sql);
        CxsmilesImport cxsmi = new CxsmilesImport();
        int count = 0;
        byte[] targetAsBytes = null;
        try {
            int screenedCountLocal = screened.size();
            block14: for (int i = 0; !this.maxResultCountReached && !this.maxTimeReached && i < screenedCountLocal; ++i) {
                if (noSmiles != null) {
                    this.screenedHandler.incTotalScreenedCount(1);
                }
                int id = screened.elementData[i];
                pstmt.setInt(1, id);
                ResultSet rs = pstmt.executeQuery();
                try {
                    while (!this.stopRequested && rs.next()) {
                        long maxTime;
                        int idRs;
                        this.currentId = -1;
                        if (count++ % 100 == 0) {
                            this.checkTimeout();
                        }
                        this.currentId = idRs = rs.getInt(1);
                        boolean found = true;
                        int offset = 1;
                        String chiralFlag = null;
                        if (searchType != 3 || filterExpression != null) {
                            targetAsBytes = DatabaseTools.readBytes(rs, 2);
                            if (targetAsBytes == null && !searchUsingOriginalTarget) {
                                noSmiles.addElement(idRs);
                                continue;
                            }
                            if (!searchUsingOriginalTarget) {
                                offset = 2;
                            } else {
                                offset = 3;
                                chiralFlag = !this.cartridgeMode ? rs.getString(3) : null;
                            }
                        }
                        float dissimilarity = 0.0f;
                        if (searchType == 3) {
                            boolean hit;
                            double similarity = this.getSimilarityFromRS(rs, offset);
                            dissimilarity = 1.0f - (float)similarity;
                            boolean bl = hit = dissimilarity <= this.searchOptions.getDissimilarityThreshold();
                            if (!hit) {
                                found = false;
                            }
                            if (this.searchOptions.isReturnsNonHits()) {
                                this.allDissimID.addElement(idRs);
                                this.allDissimDissim.addElement(dissimilarity);
                            }
                        }
                        if (searchType != 3 || filterExpression != null) {
                            try {
                                if (!searchUsingOriginalTarget) {
                                    if (searchType == 5 && this.smiles != null && Arrays.equals(targetAsBytes, this.smiles)) {
                                        found &= true;
                                    } else {
                                        String strData;
                                        boolean enumeratedSmarts = false;
                                        if (this.markushTable) {
                                            dbMol = searchType == 5 ? JChemSearch.getMolecule(targetAsBytes, true) : markushHandlerCache.parseWithCompatibleHandler(targetAsBytes).getSupergraph();
                                        } else if (this.tableType == 4) {
                                            enumeratedSmarts = true;
                                        } else {
                                            strData = new String(targetAsBytes, "ASCII");
                                            cxsmi.readMol(strData, dbMol);
                                        }
                                        if (!enumeratedSmarts) {
                                            found &= this.isMatching(dbMol, 0, true, idRs, null);
                                        } else {
                                            strData = new String(targetAsBytes, "ASCII");
                                            found &= this.isMatchingEnumQueryTable(strData, 0, true, idRs, null);
                                        }
                                    }
                                } else {
                                    dbMol = MolImporter.importMol(targetAsBytes);
                                    if (chiralFlag != null && chiralFlag.indexOf(99) != -1) {
                                        dbMol.setAbsStereo(true);
                                    }
                                    boolean enumerate = this.tableType == 4;
                                    found &= this.isMatching(dbMol, 0, false, idRs, null, enumerate);
                                }
                            }
                            catch (Exception e) {
                                try {
                                    this.handleQTCError(this.queryMol != null ? this.exportToMrv(this.queryMol) : "", e, id, count);
                                }
                                catch (Exception ex) {
                                    throw new DatabaseSearchException("An error occured for structure with cd_id: " + id, ex);
                                }
                                found = false;
                            }
                        }
                        if (found) {
                            if (this.isScreenedContainsIndices) {
                                this.addHit(this.sCache.findID(idRs), idRs);
                            } else {
                                this.addHit(idRs);
                            }
                            if (searchType == 3) {
                                this.dissimVector.addElement(dissimilarity);
                            }
                        }
                        if ((maxTime = this.searchOptions.getMaxTime()) > 0L) {
                            long timePassed = System.currentTimeMillis() - this.startTime;
                            boolean bl = this.maxTimeReached = maxTime != 0L && timePassed >= maxTime;
                        }
                        if (!this.maxResultCountReached && !this.maxTimeReached || searchType == 3) continue;
                        continue block14;
                    }
                    continue;
                }
                catch (SQLException e) {
                    try {
                        this.handleUnexpectedError(e);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new DatabaseSearchException("An error occured for structure with cd_id: " + id, ex);
                    }
                }
                finally {
                    rs.close();
                }
            }
        }
        finally {
            pstmt.close();
        }
    }

    private boolean isMatchingEnumQueryTable(String dbString, int thread, boolean standardized, int cd_id, ArrayList<Object> ctData) throws SearchException, MolFormatException, DatabaseSearchException {
        StringTokenizer st = new StringTokenizer(dbString, JChemCache.SMARTS_SEPARATOR);
        while (st.hasMoreTokens()) {
            String smarts = st.nextToken();
            Molecule dbMol = new MolHandler(smarts, true).getMolecule();
            if (!this.isMatching(dbMol, thread, standardized, cd_id, ctData)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatching(Molecule dbMol, int thread, boolean standardized, int cd_id, ArrayList<Object> ctData, boolean enumerateDBMol) throws SearchException, DatabaseSearchException {
        int enumerationOption;
        int n = enumerateDBMol ? SearchUtil.getEnumerationOption(this.searchOptions.isExactQueryAtomMatching(), this.searchOptions.isExactBondMatching(), this.searchOptions.getTautomerSearch() == 1, 0) : (enumerationOption = 0);
        if (enumerationOption == 0) {
            return this.isMatching(dbMol, thread, standardized, cd_id, ctData);
        }
        SearchEnumerator enumerator = new SearchEnumerator(enumerationOption, dbMol);
        while (enumerator.hasMoreElements()) {
            Molecule enumeratedQuery = enumerator.nextElement();
            if (!this.isMatching(enumeratedQuery, thread, false, cd_id, ctData)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMatching(Molecule dbMol, int thread, boolean standardized, int cd_id, ArrayList<Object> ctData) throws SearchException, DatabaseSearchException {
        if (dbMol.getAtomCount() == 0 && !this.emptyQuery) {
            return false;
        }
        boolean match = false;
        if (this.formulaSearch != null) {
            FormulaSearch formulaSearch = this.formulaSearch;
            synchronized (formulaSearch) {
                this.formulaSearch.setTarget(dbMol.getFormula());
                if (!this.formulaSearch.isMatching()) {
                    return false;
                }
                if (this.emptyQuery) {
                    return true;
                }
            }
        }
        if (this.chemicalTermsSubstitution && ctData != null) {
            for (int x = 0; x < ctData.size(); ++x) {
                Object data = ctData.get(x);
                if (data == null) {
                    return false;
                }
                String key = SUBSTITUTED_CT_FIELD_PROPERY_PREFIX + x;
                dbMol.setPropertyObject(key, data);
            }
        }
        if (!standardized) {
            boolean optionals = true;
            if (this.tableType == 4) {
                optionals = false;
            }
            TableInfo.standardize(dbMol, this.standardizer[thread], optionals);
        }
        this.standardizer[thread].setActiveGroup("query");
        this.standardizer[thread].setInactiveTasks("removeexplicith");
        if (this.tautomerDuplicateSearch) {
            this.molSearch[thread].setOrigTargetMayBeMarkush(ExpansionUtil.isMarkushMolecule(dbMol));
            if (!this.tautomerDupSearchUsesOrigQuery) {
                dbMol = this.calcGenericTautomer(dbMol);
            }
        }
        if ((this.emptyQuery || this.searchOptions.getSearchType() == 3) && this.searchOptions.getChemTermsFilter() != null) {
            this.context[thread].setMolecule(dbMol);
            try {
                match = this.jep[thread].evaluate_boolean(this.context[thread]);
            }
            catch (ParseException e) {
                throw new SearchException("Error evalutaing Chemical Terms Expression for strucutre " + cd_id, e);
            }
        } else {
            String matchCountRelation;
            this.molSearch[thread].setTarget(dbMol);
            MatchCountOptions matchCountOptions = this.searchOptions.getMatchCountOptions();
            String string = matchCountRelation = matchCountOptions != null ? matchCountOptions.getMatchCountRelation() : null;
            if (matchCountRelation == null) {
                match = this.molSearch[thread].isMatching();
            } else if (matchCountOptions.getMode() == 0) {
                int matchCountLowLimit = matchCountOptions.getMatchCountLowLimit();
                boolean matchCountLowLimitInclusive = matchCountOptions.isMatchCountLowLimitInclusive();
                int matchCountHighLimit = matchCountOptions.getMatchCountHighLimit();
                boolean matchCountHighLimitInclusive = matchCountOptions.isMatchCountHighLimitInclusive();
                match = this.molSearch[thread].isMatchCountBetween(matchCountLowLimit, matchCountLowLimitInclusive, matchCountHighLimit, matchCountHighLimitInclusive);
            } else {
                int matchCountHitLimit = matchCountOptions.getMatchCounthitLimit();
                match = this.molSearch[thread].isMatchCountInRelation(matchCountRelation, matchCountHitLimit);
            }
        }
        if (this.markushTable) {
            this.molSearch[thread].setTarget(null);
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchInCache(IntVector noSmiles) throws DatabaseSearchException, SQLException {
        if (this.chemicalTermsSubstitution) {
            this.rowReaderPreparedStatement = this.con.prepareStatement(this.rowReaderSQL);
            if (log.isDebugEnabled()) {
                log.debug((Object)("chemicalTermsSubstitution=true\nprepared statement:" + this.rowReaderSQL));
            }
        }
        this.startABASThreads(this.screenedVector, noSmiles);
        boolean interrupted = false;
        for (int x = 0; x < this.threadsCount; ++x) {
            ABASThread aBASThread = this.thread[x];
            synchronized (aBASThread) {
                try {
                    if (interrupted) {
                        this.thread[x].halt();
                    }
                    this.thread[x].join();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    Thread.currentThread().interrupt();
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Current thread interrupted", (Throwable)e);
                    }
                    this.thread[x].halt();
                }
                continue;
            }
        }
        this.getOriginalDissimilarityValues();
        if (this.chemicalTermsSubstitution) {
            this.rowReaderPreparedStatement.close();
        }
        if (this.runMode == 0 && this.exception != null) {
            throw new DatabaseSearchException(this.exception);
        }
    }

    private void getOriginalDissimilarityValues() {
        if (this.dissimVector == null || this.dissimVector.size() < this.screenedVector.size()) {
            return;
        }
        FloatVector newDissim = new FloatVector();
        for (int i = 0; i < this.resultVector.size(); ++i) {
            newDissim.addElement(this.dissimVector.elementAt(this.screenedVector.indexOf(this.resultVector.get(i))));
        }
        this.dissimVector = newDissim;
    }

    private void checkMaxTime() {
        long maxTime = this.searchOptions.getMaxTime();
        if (maxTime > 0L) {
            long timePassed = new Date().getTime() - this.startTime;
            this.maxTimeReached = maxTime != 0L && timePassed >= maxTime;
        }
    }

    private void addHit(int identifier) {
        this.addHit(identifier, identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHit(int identifier, int cd_id) {
        if (this.firstHitTime == 0L) {
            this.firstHitTime = System.currentTimeMillis() - this.screenAndAbasStartTime;
        }
        int maxResultCount = this.searchOptions.getMaxResultCount();
        BlockingIntArrayQueue blockingIntArrayQueue = this.progressiveReturnArray;
        synchronized (blockingIntArrayQueue) {
            if (maxResultCount != 0 && !this.searchOptions.isReturnsNonHits()) {
                if (this.hits == maxResultCount) {
                    return;
                }
                this.maxResultCountReached = this.hits == maxResultCount - 1;
            }
            ++this.hits;
            if (this.runMode == 2) {
                this.progressiveReturnArray.add(cd_id);
            }
            this.resultVector.addElement(identifier);
        }
    }

    private void startABASThreads(IntVector screenedCandidate, IntVector noSmiles) {
        int packageSize = this.markushTable ? 1 : 25;
        ScreenedQueueHandler screenedQueueHandler = new ScreenedQueueHandler(this.threadsCount, screenedCandidate.size(), packageSize);
        int priority = Thread.currentThread().getPriority();
        for (int threadNum = 0; threadNum < this.threadsCount; ++threadNum) {
            ABASThread at;
            this.thread[threadNum] = at = new ABASThread(threadNum, priority, screenedCandidate, screenedQueueHandler, noSmiles, this.fingerprintInInts, this.fingerprintNoRings, this.hashCodeScreeningForFull);
        }
        this.screenAndAbasStartTime = System.currentTimeMillis();
        for (int threadnum = this.threadsCount - 1; threadnum >= 0; --threadnum) {
            this.thread[threadnum].start();
        }
    }

    private void startSimilarityThreads(int count) {
        int x;
        int initialCapacity = Math.min(count / this.threadsCount, 10000 / this.threadsCount) + 1;
        int step = count / this.threadsCount;
        if (step * this.threadsCount != count) {
            ++step;
        }
        for (x = 0; x < this.threadsCount; ++x) {
            SimilarityThread st = new SimilarityThread();
            st.setPriority(Thread.currentThread().getPriority());
            this.simThread[x] = st;
            this.simScreened[x] = st.screened = new IntVector(initialCapacity);
            this.simDissimVector[x] = st.dissimVector = new FloatVector(initialCapacity);
            st.canRun = true;
            st.counter = step * x;
            st.limit = Math.min(count, step * (x + 1));
        }
        for (x = 0; x < this.threadsCount; ++x) {
            this.simThread[x].start();
        }
    }

    private static synchronized void writeToStdErr(StringBuilder sb) {
        System.err.println(sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSimilarityFromCache(IntVector screenedVector) {
        int x;
        int count = 0;
        count = this.filterVector != null ? this.filterVector.size() : this.sCache.getStructureCount();
        this.simScreened = new IntVector[this.threadsCount];
        this.simDissimVector = new FloatVector[this.threadsCount];
        this.simThread = new SimilarityThread[this.threadsCount];
        this.startSimilarityThreads(count);
        boolean interrupted = false;
        for (x = 0; x < this.threadsCount; ++x) {
            SimilarityThread similarityThread = this.simThread[x];
            synchronized (similarityThread) {
                block10: {
                    try {
                        if (interrupted) {
                            this.simThread[x].halt();
                        }
                        this.simThread[x].join();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        Thread.currentThread().interrupt();
                        this.simThread[x].halt();
                        if (!log.isInfoEnabled()) break block10;
                        log.info((Object)"Current thread is interrupted", (Throwable)e);
                    }
                }
                continue;
            }
        }
        for (x = 0; x < this.threadsCount; ++x) {
            screenedVector.addAll(this.simScreened[x]);
            this.dissimVector.addAll(this.simDissimVector[x]);
            this.simScreened[x] = null;
            this.simDissimVector[x] = null;
        }
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.dissimVector.size(); ++i) {
                sb.append(this.dissimVector.elementAt(i));
                sb.append("\t");
            }
            log.debug((Object)("Screened vector: " + Dumper.dumpIntArray(screenedVector.toArray()) + "\n Dissimilarity: " + sb.toString()));
        }
    }

    private String getMetricStringWithParameters() {
        String metric = this.searchOptions.getDissimilarityMetric();
        String param = this.searchOptions.getDissimilarityMetricParameters();
        if (param == null || param.length() == 0) {
            return metric;
        }
        String separator = param.charAt(0) == SimilarityCalculatorFactory.SEPARATOR.charAt(0) ? "" : SimilarityCalculatorFactory.SEPARATOR;
        return metric + separator + param;
    }

    private double getSimilarityFromRS(ResultSet rs, int offset) throws SQLException {
        int[] ints = new int[this.cfpCount];
        for (int i = 0; i < this.cfpCount; ++i) {
            ints[i] = rs.getInt(i + offset + 1);
        }
        byte[] bytes = BinaryDataUtil.getFingerprintInBytes(ints);
        return Similarity.getTanimoto(bytes, this.fingerprint, 4 * this.cfpCount);
    }

    String createSqlForBatchReading(boolean searchUsingOriginalTarget) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("SELECT ");
        sb.append(this.structureTable).append(".cd_id");
        String filterExpression = this.searchOptions.getChemTermsFilter();
        if (!(this.searchOptions.getSearchType() == 1 || this.emptyQuery && filterExpression == null || this.isSimilarityCheckingFromCache)) {
            if (this.searchOptions.getSearchType() != 3 || filterExpression != null) {
                sb.append(",");
                if (!searchUsingOriginalTarget) {
                    sb.append(this.structureTable);
                    sb.append(".");
                    if (this.markushTable) {
                        sb.append("cd_markush");
                    } else if (this.tableType == 4) {
                        sb.append("cd_smarts");
                    } else {
                        sb.append("cd_smiles");
                    }
                } else if (!this.cartridgeMode) {
                    sb.append("cd_structure");
                    sb.append(",");
                    sb.append("cd_flags");
                } else {
                    sb.append(this.cartridgeIndexedTable).append(".").append(this.cartridgeIndexedColumn);
                }
            }
            if (this.searchOptions.getSearchType() == 3) {
                for (int i = 0; i < this.cfpCount; ++i) {
                    sb.append(",");
                    sb.append(this.structureTable).append(".");
                    sb.append("cd_fp");
                    sb.append(i + 1);
                }
            }
        }
        sb.append("\nFROM ");
        sb.append(this.structureTable);
        if (this.cartridgeMode) {
            sb.append(",").append(this.cartridgeIndexedTable);
        }
        sb.append("\nWHERE ");
        if (this.cartridgeMode) {
            sb.append(this.cartridgeIndexedTable).append(".ROWID=").append(this.structureTable).append(".RID AND ");
        }
        sb.append(this.structureTable).append(".");
        sb.append("cd_id");
        sb.append(" = ?");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returning " + sb.toString() + "..."));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IntVector filterScreened(IntVector screenedVector, String filterTable) throws SQLException {
        int screened = screenedVector.size();
        if (screened == 0) {
            return new IntVector();
        }
        Statement stmt = this.con.createStatement();
        IntVector newVector = new IntVector(screened);
        screenedVector.sort();
        try {
            ResultSet rs = stmt.executeQuery("SELECT cd_id FROM " + filterTable);
            try {
                while (rs.next()) {
                    int id = rs.getInt(1);
                    int index = screenedVector.indexOfWithBinarySearch(id);
                    if (index == -1) continue;
                    newVector.addElement(id);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return newVector;
    }

    IntVector filterScreened(IntVector screenedVector, IntVector filter) throws SQLException {
        int filterSize = filter.size();
        if (filterSize == 0) {
            return new IntVector();
        }
        int screened = screenedVector.size();
        if (screened == 0) {
            return new IntVector();
        }
        IntVector newVector = new IntVector(Math.min(screened, filterSize));
        screenedVector.sort();
        for (int x = 0; x < filterSize; ++x) {
            int id = filter.get(x);
            int index = screenedVector.indexOfWithBinarySearch(id);
            if (index == -1) continue;
            newVector.addElement(id);
        }
        return newVector;
    }

    IntVector sortResultsWithFilterCdIds(IntVector resultVector, int[] filter) throws SQLException {
        resultVector.sort();
        int nrOfResults = resultVector.size();
        int filterSize = filter.length;
        IntVector newVector = new IntVector(nrOfResults);
        for (int x = 0; x < filterSize; ++x) {
            int id = filter[x];
            int index = resultVector.indexOfWithBinarySearch(id);
            if (index == -1) continue;
            newVector.addElement(id);
        }
        return newVector;
    }

    void sortResultsToFilterWithDissim() throws SQLException {
        int filterSize = this.filterVector.size();
        IntVector newVector = new IntVector(Math.min(filterSize, this.finalResultVector.size()));
        FloatVector newDissim = new FloatVector(Math.min(filterSize, this.dissimVector.size()));
        this.finalResultVector.sortWithFloatVector(this.dissimVector);
        for (int x = 0; x < filterSize; ++x) {
            int id = this.filterVector.get(x);
            int index = this.finalResultVector.indexOfWithBinarySearch(id);
            if (index == -1) continue;
            newVector.addElement(id);
            newDissim.addElement(this.dissimVector.elementAt(index));
        }
        this.finalResultVector = newVector;
        this.dissimVector = newDissim;
    }

    IntVector filterScreened(IntVector screenedVector, int[] whiteList, int[] blackList) {
        boolean isBlackListNotNull;
        boolean isWhiteListNotNull = whiteList != null;
        boolean bl = isBlackListNotNull = blackList != null;
        if (isWhiteListNotNull && whiteList.length == 0) {
            return new IntVector();
        }
        int screenedSize = screenedVector.size();
        if (screenedSize == 0) {
            return new IntVector();
        }
        IntVector newVector = isWhiteListNotNull ? new IntVector(Math.min(screenedSize, whiteList.length)) : new IntVector(screenedSize);
        boolean isDissimVectorNotNull = this.dissimVector != null;
        FloatVector newDissim = isDissimVectorNotNull ? new FloatVector(this.dissimVector.size()) : null;
        for (int x = 0; x < screenedSize; ++x) {
            int id = screenedVector.get(x);
            if (isWhiteListNotNull && Arrays.binarySearch(whiteList, id) < 0 || isBlackListNotNull && Arrays.binarySearch(blackList, id) >= 0) continue;
            newVector.addElement(id);
            if (!isDissimVectorNotNull) continue;
            newDissim.addElement(this.dissimVector.elementAt(x));
        }
        if (newDissim != null) {
            this.dissimVector = newDissim;
        }
        return newVector;
    }

    void cacheStructures(JChemCache cache) throws SQLException {
        this.sCache = cache;
    }

    private void checkTimeout() throws DatabaseSearchException {
        if (this.timeout <= 0 || this.runMode == 0) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastCheck > (long)(1000 * this.timeout)) {
            throw new DatabaseSearchException("Search timed out. Timeout value: " + this.timeout + " seconds");
        }
    }

    private static boolean hashCodeApplicable(Molecule mol) {
        int atomCount = mol.getAtomCount();
        for (int x = 0; x < atomCount; ++x) {
            MolAtom atom = mol.getAtom(x);
            int atomType = atom.getAtno();
            if (atomType <= 109 && atomType != 0) continue;
            return false;
        }
        int bondCount = mol.getBondCount();
        for (int x = 0; x < bondCount; ++x) {
            MolBond bond = mol.getBond(x);
            int bondType = bond.getType();
            if (bondType <= 4 && bondType != 0) continue;
            return false;
        }
        return true;
    }

    void setUsePreparedStatements(boolean value) {
        this.usePreparedStatements = value;
    }

    void close() throws SQLException {
        if (this.pstmtForScreening != null) {
            this.pstmtForScreening.close();
        }
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("JChem Base", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    private void checkLicense() throws MaxSearchFrequencyExceededException, LicenseException {
        if (this.searchOptions.getSearchType() == 5 || this.everyTargetIsHit) {
            return;
        }
        if (eventCounter == null) {
            eventCounter = new EventCounter(60000L);
            if (this.regCode != 0L) {
                eventCounter.setMaxEventCount(DatabaseOptions.getMaxSearchCountFromRegistrationCode(this.regCode));
            }
        }
        if (this.regCode == 0L) {
            int maxEventCount;
            if (this.isLicensed()) {
                maxEventCount = LicenseHandler.getInstance().getJChemSearchPerMin(this.licenseEnvironment);
            } else {
                long registrationCode = DatabaseOptions.getRegistrationCode(this.dbProp);
                maxEventCount = DatabaseOptions.getMaxSearchCountFromRegistrationCode(registrationCode);
            }
            eventCounter.setMaxEventCount(maxEventCount);
        }
        if (!eventCounter.addWithCheck()) {
            System.err.println("Too many searches in the last minute.");
            System.err.println("If needed, plase contact sales@chemaxon.com");
            System.err.println("for a license key that allows more searches");
            System.err.println("per minute");
            throw new MaxSearchFrequencyExceededException();
        }
    }

    private void enumeratedSearch() throws SQLException, IOException, DatabaseSearchException {
        SearchEnumerator enumerator = new SearchEnumerator(this.enumeratedFeatures, this.queryMol);
        this.setStoringNonEnumIfNeeded(enumerator);
        enumerator.setMarkushSearch(this.markushTable);
        ArrayList<Molecule> enumerates = new ArrayList<Molecule>();
        while (enumerator.hasMoreElements()) {
            Molecule enumerate = enumerator.nextElement();
            try {
                this.standardizeQuery(enumerate);
            }
            catch (SearchException e) {
                throw new DatabaseSearchException(e);
            }
            this.removeQueryBonds(enumerate);
            enumerates.add(enumerate);
        }
        this.doBeforeEnumScreening(enumerates);
        this.firstEnumeratedStructure = true;
        this.enumCount = 0;
        for (Molecule enumQuery : enumerates) {
            ++this.enumCount;
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.enumCount + ". enumerated query in JChemSearch: " + this.exportToCxsmarts(enumQuery)));
            }
            this.queryMol = enumQuery;
            this.queryInitialized = false;
            this.searchCore();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Screened count: " + this.screenedHandler.getLatestScreenedCount()));
            }
            this.finalResultVector.addAll(this.resultVector);
            this.finalResultVector.sort();
        }
    }

    private void doBeforeEnumScreening(ArrayList<Molecule> enumerates) {
        int searchType;
        if (enumerates.size() >= 4 && ((searchType = this.searchOptions.getSearchType()) == 2 || searchType == 4 || searchType == 7) && this.sCache != null) {
            this.screenMonitor.start();
            int[][] fpIntersection = this.getFingerprintIntersection(enumerates);
            byte[] queryDescr = this.getDescriptorIntersection(enumerates);
            if (this.searchOptions.getMatchCountOptions() != null && this.searchOptions.getMatchCountOptions().isMatchCountIncludesZero()) {
                this.nonHits = new IntVector();
            }
            this.beforeEnumScreenedVector = this.filterVector == null ? this.sCache.getBeforeEnumScreened(fpIntersection[1], fpIntersection[0], queryDescr, this.searchOptions, this.sCache.getAllIndices(), true, this.nonHits) : this.sCache.getBeforeEnumScreened(fpIntersection[1], fpIntersection[0], queryDescr, this.searchOptions, this.filterVector, false, this.nonHits);
            this.screenMonitor.stop();
        }
    }

    private byte[] getDescriptorIntersection(ArrayList<Molecule> enumerates) {
        byte[] queryDescr;
        block7: {
            queryDescr = null;
            ScreenHandlerBytes shb = null;
            if (this.sCache.getScreenHandler() != null) {
                shb = this.sCache.getScreenHandler().getBytesHandler();
            }
            if (shb != null) {
                try {
                    DefaultScreenOptions screenOptions = new DefaultScreenOptions(this.searchOptions);
                    queryDescr = shb.generateQueryDescriptor(enumerates.get(0), screenOptions);
                    int n = enumerates.size();
                    for (int i = 1; i < n; ++i) {
                        shb.intersect(queryDescr, shb.generateQueryDescriptor(enumerates.get(i), screenOptions));
                    }
                }
                catch (UnsupportedMoleculeException e) {
                    queryDescr = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Unsupported query molecule", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    queryDescr = null;
                    if (!log.isWarnEnabled()) break block7;
                    log.warn((Object)"Unexpected error during query descriptor creation", (Throwable)e);
                }
            }
        }
        return queryDescr;
    }

    private int[][] getFingerprintIntersection(ArrayList<Molecule> enumerates) {
        int[][] fpIntersection = new int[2][];
        boolean first = true;
        for (Molecule enumQuery : enumerates) {
            this.getFingerprint(enumQuery);
            if (first) {
                first = false;
                fpIntersection[0] = this.fingerprintNoRings;
                fpIntersection[1] = this.fingerprintInInts;
                continue;
            }
            for (int i = 0; i < fpIntersection[0].length; ++i) {
                int[] nArray = fpIntersection[0];
                int n = i;
                nArray[n] = nArray[n] & this.fingerprintNoRings[i];
                int[] nArray2 = fpIntersection[1];
                int n2 = i;
                nArray2[n2] = nArray2[n2] & this.fingerprintInInts[i];
            }
        }
        return fpIntersection;
    }

    private String exportToCxsmarts(Molecule enumQuery) {
        try {
            return MolExporter.exportToFormat(enumQuery, "cxsmarts");
        }
        catch (IOException e) {
            return "Exception was thrown during cxsmarts conversion: " + e.getMessage() + "\n" + "Trying to export in mrv format.\n" + this.exportToMrv(enumQuery);
        }
    }

    private String exportToMrv(Molecule enumQuery) {
        try {
            return MolExporter.exportToFormat(enumQuery, "mrv");
        }
        catch (IOException e) {
            return "WARNING:\nStructure cannot be exported to MRV format!\n" + e.getMessage();
        }
    }

    private void setStoringNonEnumIfNeeded(SearchEnumerator enumerator) {
        if (this.searchOptions.getVagueBondLevel() >= 2 && this.searchOptions.getCheckSpHyb()) {
            enumerator.setOrigNeeded(true);
        }
    }

    private void standardizeNonEnum(Molecule mol) throws SearchException {
        if (mol.getPropertyObject("nonEnumeratedMol") != null) {
            Molecule nonEnum = (Molecule)mol.getPropertyObject("nonEnumeratedMol");
            if (this.standardizer[0] != null) {
                nonEnum = this.standardizer[0].standardize(nonEnum);
            } else {
                nonEnum.aromatize();
            }
            mol.setPropertyObject("nonEnumeratedMol", nonEnum);
        }
    }

    private void removeQueryBonds(Molecule query) {
        for (int i = query.getBondCount() - 1; i >= 0; --i) {
            MolBond mb = query.getBond(i);
            String qs = mb.getQuerystr();
            if (qs == null || !qs.equals("NONAROMATIC")) continue;
            mb = new MolBond(mb.getAtom1(), mb.getAtom2(), mb.getFlags());
            query.removeBond(i);
            query.add(mb);
        }
    }

    private void standardizeQuery(Molecule mol) throws SearchException {
        if (this.standardizer[0] != null) {
            if (this.tableType == 4 && this.searchOptions.getSearchType() != 5) {
                this.standardizer[0].setActiveGroup("target");
            } else {
                this.standardizer[0].setActiveGroup("query");
                this.standardizer[0].setInactiveTasks("removeexplicith");
            }
            this.standardizer[0].standardize(mol);
        } else {
            mol.aromatize();
        }
        this.standardizeNonEnum(mol);
    }

    private void checkAllowedOptions() {
        int searchType = this.searchOptions.getSearchType();
        if (this.runMode == 2) {
            if (searchType == 3) {
                throw new IllegalArgumentException("Progressive return of hits is not supported with similarity search.");
            }
            if (searchType == 1) {
                throw new IllegalArgumentException("Progressive return of hits is not supported with screening-only structure search.");
            }
            if (this.order != 0) {
                throw new IllegalArgumentException("Progressive return of hits is supported only with the NO_ORDERING ordering type. Current orderType=" + this.order);
            }
            if (this.searchOptions.isReturnsNonHits()) {
                throw new IllegalArgumentException("Progressive return of hits does not currently support returning non-hits");
            }
        }
        if (this.tableType == 4 && !this.emptyQuery) {
            if (searchType == 3) {
                throw new IllegalArgumentException("SIMILARITY search is not allowed on query table: \"" + this.structureTable + "\"");
            }
            if (searchType == 2) {
                throw new IllegalArgumentException("SUBSTRUCTURE search is not allowed on query table: \"" + this.structureTable + "\"");
            }
            if (this.searchOptions.getTautomerSearch() == 1) {
                throw new IllegalArgumentException("Tautomer search is not allowed on query table: \"" + this.structureTable + "\"");
            }
        }
        if (this.tableType == 3) {
            if (searchType == 6) {
                throw new IllegalArgumentException("SUPERSTRUCTURE search is not allowed on Markush table: \"" + this.structureTable + "\"");
            }
            if (searchType == 3) {
                throw new IllegalArgumentException("SIMILARITY search is not allowed on Markush table: \"" + this.structureTable + "\"");
            }
            if (this.searchOptions.getChemTermsFilter() != null) {
                throw new IllegalArgumentException("Chemical Terms filtering is not allowed on Markush table: \"" + this.structureTable + "\"");
            }
        }
        if (!this.tautomerDuplicateSearchTable && (this.searchOptions.getTautomerSearch() == 1 || this.searchOptions.isTautomerDuplicateFiltering()) && searchType == 5) {
            throw new IllegalArgumentException("Tables created without tautomer duplicate filtering (\"" + this.structureTable + "\")" + " do not support duplicate search with --tautomer or " + "--tdf option. " + "Please change your table settings to using tautomer filtering" + "(eg. using jcman GUI:  File -> Table options -> " + "'Duplicate search uses tautomers') " + "and recalculate your table for the most accurate " + "tautomer duplication control.");
        }
    }

    public boolean hasMoreHits() throws InterruptedException {
        if (log.isDebugEnabled() && this.stopped && !this.stopRecorded) {
            log.debug((Object)"ABASThreads stopped; all hits known.");
            this.stopRecorded = true;
        }
        return this.progressiveReturnArray.hasMoreHits();
    }

    public int getNextHit() throws InterruptedException {
        return this.progressiveReturnArray.getNextHit();
    }

    public int[] getAvailableNewHits(int arraySize) throws InterruptedException, DatabaseSearchException {
        return this.progressiveReturnArray.getAvailableNewHits(arraySize);
    }

    public void waitUntilSearchComplete() throws InterruptedException {
        this.progressiveReturnArray.waitUntilSearchComplete();
    }

    private static Molecule getMolecule(byte[] source, boolean isMarkush) throws MolFormatException, ServiceConfigurationError {
        if (isMarkush) {
            try {
                return markushHandlerCache.parseWithCompatibleHandler(source).getMarkush();
            }
            catch (IllegalArgumentException e) {
                throw new MolFormatException("Could not read markush from byte array.", e);
            }
        }
        try {
            return new MolHandler(source).getMolecule();
        }
        catch (IOException e) {
            throw new MolFormatException("Could not read molecule from byte array.", e);
        }
    }

    private void handleUnexpectedError(Exception e) throws Exception {
        this.incidents.getUnexpectedExceptionIncident().report(e);
        if (this.searchOptions.getHaltOnError() == HaltOnErrorOption.YES || this.searchOptions.getHaltOnError() == HaltOnErrorOption.DEFAULT && !this.markushTable) {
            throw e;
        }
    }

    private void handleQTCError(String message, Exception e, int id, int idx) throws Exception {
        if (log.isErrorEnabled()) {
            log.error((Object)message);
            log.error((Object)e);
        }
        this.incidents.getQTCErrorIncident().report(message, e, id, idx);
        if (this.searchOptions.getHaltOnError() == HaltOnErrorOption.YES || this.searchOptions.getHaltOnError() == HaltOnErrorOption.DEFAULT && !this.markushTable) {
            throw e;
        }
    }

    private void handleStructureLoadingError(int id, Exception e) throws Exception {
        this.incidents.getStructureLoadErrorIncident().report(id, e);
        if (this.searchOptions.getHaltOnError() == HaltOnErrorOption.YES || this.searchOptions.getHaltOnError() == HaltOnErrorOption.DEFAULT && !this.markushTable) {
            throw e;
        }
    }

    public static class DissimilarityMetrics {
        public String name = null;
        public String[] metricNames = null;
        public int[] numOfParam = null;
        public String[] paramNames = null;
        public String[] paramRanges = null;
        public String[] paramDefault = null;
        public float[] defaultDissimilarityMetricThresholds;
        public String[] paramHelp = null;
        public int defaultMetricIndex = 0;
    }

    private class SearchThread
    extends Thread {
        private SearchThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                JChemSearch.this.search();
            }
            catch (Throwable e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)e);
                }
                JChemSearch.this.exception = e;
                JChemSearch.this.setProgressMessage("An error occured during query.");
                JChemSearch.this.stopped = true;
                JChemSearch.this.progressiveReturnArray.setError(e);
            }
            finally {
                JChemSearch.this.progressiveReturnArray.stop();
            }
        }
    }

    private final class SimilarityThread
    extends Thread {
        public volatile boolean canRun = true;
        public IntVector screened = null;
        public FloatVector dissimVector = null;
        public int counter = 0;
        public int limit = 0;

        private SimilarityThread() {
        }

        private int getNextIndex(int[] cd_id) {
            int idx = 0;
            int id = -1;
            do {
                ++this.counter;
                if (idx < this.limit) continue;
                return -1;
            } while (JChemSearch.this.filterVector != null ? (idx = JChemSearch.this.sCache.findID(id = JChemSearch.this.filterVector.get(idx))) == -1 : (id = JChemSearch.this.sCache.getID(idx)) == -1);
            cd_id[0] = id;
            if (log.isTraceEnabled()) {
                log.trace((Object)("getNextIndex in SimilarityThread cd_id:" + id + " idx: " + idx));
            }
            return idx;
        }

        public void halt() {
            this.canRun = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Similarity thread halt is requested.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Similarity thread starts running.");
            }
            boolean stopOthers = false;
            int id = 0;
            int idx = 0;
            int count = 0;
            int[] cd_id = new int[1];
            try {
                int[] fp_int = new int[JChemSearch.this.fpCount];
                byte[] fp_bytes = new byte[4 * JChemSearch.this.fpCount];
                SimilarityCalculator<int[]> simCalc = null;
                String metricStr = JChemSearch.this.searchOptions.getDissimilarityMetric();
                int metricIndex = 0;
                if (JChemSearch.this.reactionTable) {
                    metricIndex = JChemSearch.this.reactionFingerprint.getDefaultMetricIndex();
                    if (metricStr != null) {
                        metricIndex = JChemSearch.this.reactionFingerprint.getMetricIndex(metricStr);
                    }
                } else if (metricStr != null) {
                    try {
                        metricStr = JChemSearch.this.getMetricStringWithParameters();
                        simCalc = SimilarityCalculatorFactory.create(metricStr, 0, JChemSearch.this.cfpCount);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("cfpCount=" + JChemSearch.this.cfpCount + ", query fingerprint length=" + JChemSearch.this.fingerprintInInts.length + "; " + InHouseDefaultParser.intArray2String(JChemSearch.this.fingerprintInInts)));
                        }
                        simCalc.setQueryFingerprint(JChemSearch.this.fingerprintInInts);
                    }
                    catch (java.text.ParseException e) {
                        throw new IllegalArgumentException(e);
                    }
                    catch (SimilarityException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                double threshold = JChemSearch.this.searchOptions.getDissimilarityThreshold();
                boolean dissimilarityThresholdExcluded = JChemSearch.this.searchOptions.isDissimilarityThresholdExcluded();
                String chemTermsFilter = JChemSearch.this.searchOptions.getChemTermsFilter();
                boolean returnsNonHits = JChemSearch.this.searchOptions.isReturnsNonHits();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("threshold=" + threshold + ", dissimilarityThresholdExcluded=" + dissimilarityThresholdExcluded + ", returnNonHits=" + returnsNonHits));
                }
                while (this.canRun && !JChemSearch.this.stopRequested && !JChemSearch.this.maxTimeReached) {
                    boolean hit;
                    if (++count % 100 == 0) {
                        JChemSearch.this.checkTimeout();
                    }
                    float dissimilarity = 0.0f;
                    idx = this.getNextIndex(cd_id);
                    if (idx == -1) {
                        break;
                    }
                    id = cd_id[0];
                    if (JChemSearch.this.reactionTable) {
                        byte[] r_fp = new byte[JChemSearch.this.cfpCount * 4];
                        JChemSearch.this.sCache.getSimilarityDescritporInBytes(idx, fp_bytes);
                        System.arraycopy(fp_bytes, 0, r_fp, 0, JChemSearch.this.cfpCount * 4);
                        ReactionFingerprint databaseRFP = new ReactionFingerprint();
                        databaseRFP.setParameters(JChemSearch.this.reactionFingerprint.getParameters());
                        databaseRFP.fromData(r_fp);
                        dissimilarity = JChemSearch.this.reactionFingerprint.getDissimilarity(databaseRFP, metricIndex);
                    } else {
                        JChemSearch.this.sCache.getSimilarityDescriptor(idx, fp_int);
                        double similarity = 0.0;
                        if (simCalc == null) {
                            int ac = 0;
                            int oc = 0;
                            for (int i = 0; i < JChemSearch.this.cfpCount; ++i) {
                                int a = fp_int[i] & JChemSearch.this.fingerprintInInts[i];
                                int o = fp_int[i] | JChemSearch.this.fingerprintInInts[i];
                                ac += Fingerprint.BITCOUNT_16_BIT[a >> 16 & 0xFFFF] + Fingerprint.BITCOUNT_16_BIT[a & 0xFFFF];
                                oc += Fingerprint.BITCOUNT_16_BIT[o >> 16 & 0xFFFF] + Fingerprint.BITCOUNT_16_BIT[o & 0xFFFF];
                            }
                            similarity = oc == 0 ? 1.0 : (double)ac / (double)oc;
                            dissimilarity = 1.0f - (float)similarity;
                        } else {
                            try {
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("target: " + InHouseDefaultParser.intArray2String(fp_int)));
                                }
                                dissimilarity = simCalc.getDissimilarity(fp_int);
                            }
                            catch (SimilarityException e) {
                                throw new IllegalArgumentException("Not compatible query and target fingerprint data.", e);
                            }
                        }
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("cd_id=" + id + ", dissimilarity=" + dissimilarity));
                    }
                    if (dissimilarityThresholdExcluded) {
                        hit = (double)dissimilarity < threshold;
                    } else {
                        boolean bl = hit = (double)dissimilarity <= threshold;
                    }
                    if (returnsNonHits) {
                        IntVector intVector = JChemSearch.this.allDissimID;
                        synchronized (intVector) {
                            JChemSearch.this.allDissimID.addElement(id);
                            JChemSearch.this.allDissimDissim.addElement(dissimilarity);
                        }
                    }
                    if (!hit) continue;
                    this.screened.addElement(id);
                    if (returnsNonHits) continue;
                    this.dissimVector.addElement(dissimilarity);
                }
            }
            catch (Throwable e) {
                JChemSearch.this.exception = e;
                JChemSearch.this.setProgressMessage("An error occured during Similarity calculation.");
                stopOthers = true;
            }
            finally {
                if (JChemSearch.this.stopRequested || JChemSearch.this.maxTimeReached || JChemSearch.this.maxResultCountReached) {
                    stopOthers = true;
                }
                if (stopOthers) {
                    for (int x = 0; x < JChemSearch.this.simThread.length; ++x) {
                        JChemSearch.this.simThread[x].halt();
                    }
                }
            }
        }
    }

    private final class ABASThread
    extends Thread {
        private volatile boolean canRun;
        private final int threadNum;
        private Molecule dbMol = null;
        private final CxsmilesImport cxsmis;
        private IntVector screenedCandidate = null;
        private ScreenedQueueHandler sqh = null;
        private IntVector noSmiles = null;
        private int[] fp;
        private int[] fp_noRing;
        private boolean forFullSearch;
        private ArrayBlockingQueue<int[]> screened = null;
        private int screenIndex = 0;
        private int[] screenedBatch = null;
        private final int[] poison;

        public ABASThread(int threadNum, int priority, IntVector screenedCandidate, ScreenedQueueHandler sqh, IntVector noSmiles, int[] fingerprintInInts, int[] fingerprintNoRings, boolean hashCodeScreeningForFull) {
            this.threadNum = threadNum;
            this.screenedCandidate = screenedCandidate;
            this.sqh = sqh;
            this.noSmiles = noSmiles;
            this.fp = fingerprintInInts;
            this.fp_noRing = fingerprintNoRings;
            this.forFullSearch = hashCodeScreeningForFull;
            this.screened = sqh.getScreenedQueue();
            this.poison = sqh.getPoison();
            this.cxsmis = new CxsmilesImport();
            this.cxsmis.setOptions("c");
            this.setPriority(priority);
            this.canRun = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getNextIndex(int[] cd_id, ArrayList chemTermData) throws SQLException, InterruptedException {
            if (this.screenedBatch == null || this.screenIndex >= this.screenedBatch.length) {
                this.screenedBatch = this.screened.take();
                this.screenIndex = 0;
            }
            if (this.screenedBatch == this.poison) {
                return -1;
            }
            if (this.screenedBatch.length == 0) {
                ++this.screenIndex;
                cd_id[0] = -1;
                return 0;
            }
            cd_id[0] = this.screenedBatch[this.screenIndex++];
            int idx = this.screenedBatch[this.screenIndex++];
            if (log.isTraceEnabled()) {
                log.trace((Object)"getNextIndex in ABASThread");
                log.trace((Object)("cd_id[0] " + cd_id[0]));
                log.trace((Object)("idx: " + idx));
            }
            if (JChemSearch.this.chemicalTermsSubstitution) {
                try {
                    JChemSearch jChemSearch = JChemSearch.this;
                    synchronized (jChemSearch) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"chemicalTermsSubstitution is requested in ABAS thread");
                            log.trace((Object)("sql statement: " + JChemSearch.this.rowReaderSQL));
                            log.trace((Object)("usin cd_id on the first place: " + cd_id[0]));
                        }
                        JChemSearch.this.rowReaderPreparedStatement.setInt(1, cd_id[0]);
                        ResultSet rs = JChemSearch.this.rowReaderPreparedStatement.executeQuery();
                        boolean found = rs.next();
                        if (found && JChemSearch.this.substitutedCTColumns != null) {
                            for (int x = 0; x < JChemSearch.this.substitutedCTColumns.length; ++x) {
                                chemTermData.add(rs.getObject(x + 1));
                            }
                        }
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    try {
                        JChemSearch.this.handleUnexpectedError(e);
                        if (log.isErrorEnabled()) {
                            log.error((Object)e);
                        }
                    }
                    catch (Exception ex) {
                        throw e;
                    }
                }
            }
            return idx;
        }

        public void halt() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Abas thread halt is requested.");
            }
            this.canRun = false;
            JChemSearch.this.molSearch[this.threadNum].stop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Start of ABAS#" + this.threadNum + ": " + (System.currentTimeMillis() - JChemSearch.this.startTime)));
            }
            int count = 0;
            int id = 0;
            boolean stopOthers = false;
            boolean matchCountIncludesZero = false;
            int sType = JChemSearch.this.searchOptions.getSearchType();
            CDMarkushHandlerCache markushHandlerCache = JChemSearch.this.markushTable ? new CDMarkushHandlerCache(CDMarkushHandlerCache.ThreadSafety.SYNCHRONIZED, CDMarkushHandlerCache.CacheBehavior.CACHEFIRST) : null;
            boolean isABASNotNeeded = (sType == 1 || JChemSearch.this.queryIsStructuralKey && sType == 2) && JChemSearch.this.searchOptions.getChemTermsFilter() == null && JChemSearch.this.formulaSearch == null;
            try {
                if (JChemSearch.this.searchOptions.getMatchCountOptions() != null) {
                    matchCountIncludesZero = JChemSearch.this.searchOptions.getMatchCountOptions().isMatchCountIncludesZero();
                }
                int[] cd_id = new int[1];
                int hitIdentifierInList = -1;
                if (this.threadNum == 0) {
                    JChemSearch.this.screenedHandler.setValid(true);
                    JChemSearch.this.screenMonitor.start();
                    try {
                        if (!this.screenedCandidate.isEmpty() || JChemSearch.this.markushTable) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Table found, launching screen:");
                                log.debug((Object)(JChemSearch.this.markushTable ? "Markush screen" : "Structure screen"));
                            }
                            JChemSearch.this.sCache.putScreenedToQueue(this.fp, this.fp_noRing, JChemSearch.this.molSearch[this.threadNum].getQuery(), JChemSearch.this.searchOptions, this.forFullSearch, this.screenedCandidate, JChemSearch.this.isScreenedContainsIndices, JChemSearch.this.nonHits, this.sqh);
                        }
                    }
                    catch (DatabaseSearchException dbse) {
                        JChemSearch.this.handleUnexpectedError(dbse);
                    }
                    finally {
                        JChemSearch.this.screenMonitor.stop();
                        this.sqh.close();
                        JChemSearch.this.screenedHandler.addUniqueScreened(this.sqh.getScreenedIDs());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("End of screening in ABAS#" + this.threadNum + ": " + (System.currentTimeMillis() - JChemSearch.this.startTime)));
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Screen completed");
                }
                while (this.canRun && !JChemSearch.this.stopRequested && !JChemSearch.this.maxTimeReached && !JChemSearch.this.maxResultCountReached) {
                    ArrayList ctData;
                    int idx;
                    if (++count % 100 == 0) {
                        JChemSearch.this.checkTimeout();
                    }
                    if ((idx = this.getNextIndex(cd_id, ctData = JChemSearch.this.chemicalTermsSubstitution ? new ArrayList() : null)) == -1) {
                        break;
                    }
                    if (cd_id[0] == -1) continue;
                    JChemSearch.this.currentId = id = cd_id[0];
                    int n = hitIdentifierInList = JChemSearch.this.isScreenedContainsIndices ? idx : id;
                    if (isABASNotNeeded || matchCountIncludesZero && JChemSearch.this.nonHits.indexOfWithBinarySearch(hitIdentifierInList) != -1) {
                        JChemSearch.this.addHit(hitIdentifierInList, id);
                        continue;
                    }
                    try {
                        String dbMolString = JChemSearch.this.sCache.getStructureString(idx);
                        boolean enumeration = false;
                        if (dbMolString != null && !"".equals(dbMolString)) {
                            if (JChemSearch.this.tableType == 4) {
                                if (dbMolString.indexOf(JChemCache.SMARTS_SEPARATOR) != -1) {
                                    enumeration = true;
                                } else {
                                    this.dbMol = MolImporter.importMol(dbMolString, "cxsmarts:c");
                                }
                            } else {
                                this.dbMol = new RgMolecule();
                                this.dbMol.setValenceCheckState(MoleculeGraph.ValenceCheckState.AMBIGUOUS_AROMATIC_ATOMS_IGNORED);
                                this.cxsmis.readMol(dbMolString, this.dbMol);
                            }
                        } else if (JChemSearch.this.markushTable) {
                            byte[] markush = JChemSearch.this.sCache.getStructureStringInBytes(idx);
                            if (markush != null) {
                                if (markushHandlerCache == null) {
                                    throw new IllegalStateException("Internal error in markush table handling");
                                }
                                CDMarkushFromDB markushFromDB = markushHandlerCache.parseWithCompatibleHandler(markush);
                                if (!markushFromDB.isSearchable()) {
                                    infoLogger.warning("Structure with ID " + id + " is not searchable.");
                                    throw new IllegalArgumentException("Structure is not searchable.");
                                }
                                this.dbMol = markushFromDB.getSupergraph();
                            } else {
                                infoLogger.warning("cd_markush is null in Markush table,\nstructure with ID " + id + " will be retrieved from cd_structure.");
                                this.retrieveLater(id);
                                continue;
                            }
                            markush = null;
                        } else {
                            this.retrieveLater(id);
                            continue;
                        }
                        boolean matching = false;
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("Thread %d performs search", this.threadNum));
                        }
                        matching = enumeration ? JChemSearch.this.isMatchingEnumQueryTable(dbMolString, this.threadNum, true, id, ctData) : JChemSearch.this.isMatching(this.dbMol, this.threadNum, true, id, ctData);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("Thread %d search done", this.threadNum));
                        }
                        if (matching) {
                            JChemSearch.this.addHit(hitIdentifierInList, id);
                        }
                        if (!JChemSearch.this.markushTable) continue;
                        this.dbMol = new RgMolecule();
                        dbMolString = null;
                    }
                    catch (Exception e) {
                        Molecule qMol = JChemSearch.this.molSearch[this.threadNum].getQuery();
                        JChemSearch.this.handleQTCError(qMol != null ? JChemSearch.this.exportToMrv(qMol) : "", e, id, idx);
                    }
                    finally {
                        JChemSearch.this.checkMaxTime();
                    }
                }
            }
            catch (Throwable e) {
                JChemSearch.this.exception = e;
                JChemSearch.this.setProgressMessage("An error occured during ABAS");
                stopOthers = true;
                log.error((Object)("Error during ABAS in table \"" + JChemSearch.this.structureTable + "\" for cd_id: " + id), e);
            }
            finally {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("End of ABAS in thread: " + this.threadNum + " time: " + (System.currentTimeMillis() - JChemSearch.this.startTime)));
                }
                if (JChemSearch.this.stopRequested || JChemSearch.this.maxTimeReached || JChemSearch.this.maxResultCountReached) {
                    stopOthers = true;
                }
                if (stopOthers) {
                    for (int x = 0; x < JChemSearch.this.thread.length; ++x) {
                        JChemSearch.this.thread[x].halt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void retrieveLater(int id) {
            IntVector intVector = this.noSmiles;
            synchronized (intVector) {
                this.noSmiles.addElement(id);
            }
        }
    }
}

