/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.descriptors.MDDBWriter;
import chemaxon.descriptors.MDWriterException;
import chemaxon.jchem.db.DBUtil;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.RegenerationChecker;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.file.ProgressWriter;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import chemaxon.util.MolHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class MDRegenerator {
    private final ConnectionHandler conh;
    private final ProgressWriter pw;
    private final MDDBWriter writer;
    private final DatabaseProperties dbProp;
    public boolean wasError = false;

    public MDRegenerator(ConnectionHandler conh, ProgressWriter pw) throws SQLException {
        this.conh = conh;
        this.pw = pw;
        this.writer = new MDDBWriter();
        this.writer.setConnectionHandler(conh);
        this.writer.setUpdateMode(true);
        this.dbProp = new DatabaseProperties(conh);
    }

    public MDRegenerator(ConnectionHandler conh) throws SQLException {
        this(conh, null);
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (MDWriterException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String strucTableName, String descriptor) throws SQLException {
        if (!this.checkDescriptor(strucTableName, descriptor)) {
            throw new SQLException("Descriptor '" + descriptor + "' is not found " + "for structure table '" + strucTableName + "'.");
        }
        String sql = "";
        if (this.dbProp.dbmsType == 3 || this.dbProp.dbmsType == 7) {
            sql = "SELECT cd_id, cd_structure FROM " + strucTableName + " WHERE cd_id > ? ORDER BY cd_id LIMIT 1";
        } else if (this.dbProp.dbmsType == 1) {
            sql = "SELECT cd_id, cd_structure FROM (SELECT cd_id, cd_structure FROM " + strucTableName + " WHERE cd_id > ?) WHERE rownum <= 1 ORDER BY cd_id";
        } else if (this.dbProp.dbmsType == 2 || this.dbProp.dbmsType == 4) {
            sql = "SELECT TOP 1 cd_id, cd_structure FROM " + strucTableName + " WHERE cd_id > ? ORDER BY cd_id";
        } else if (this.dbProp.dbmsType == 9) {
            sql = "SELECT cd_id, cd_structure FROM (SELECT ROW_NUMBER() OVER() AS rownum, cd_id, cd_structure FROM " + strucTableName + " WHERE cd_id > ?) AS tmp WHERE rownum <= 1 ORDER BY cd_id";
        } else {
            throw new SQLException("Operation is not supported for this database");
        }
        int id = 0;
        String[] mdNames = new String[]{descriptor};
        this.writer.setMDNames(mdNames);
        this.writer.setStructureTable(strucTableName);
        if (this.pw != null) {
            this.pw.reset();
            this.pw.setMaximum(DBUtil.getRowCount(this.conh.getConnection(), strucTableName));
        }
        try {
            PreparedStatement pstmt = this.conh.getConnection().prepareStatement(sql);
            try {
                while (this.pw == null || !this.pw.isCanceled()) {
                    pstmt.setInt(1, id);
                    ResultSet rs = pstmt.executeQuery();
                    try {
                        if (rs.next()) {
                            id = rs.getInt(1);
                            byte[] structure = DatabaseTools.readBytes(rs, 2);
                            rs.close();
                            if (this.pw != null) {
                                this.pw.setProgress(id);
                                this.pw.setNote("Descriptor name: " + descriptor + "     ID: " + id);
                            }
                            try {
                                this.writer.put(new MolHandler(structure).getMolecule(), id);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                this.pw.log(0, "Error at molecule with cd_id: " + id, e);
                                this.wasError = true;
                            }
                            continue;
                        }
                        break;
                    }
                    finally {
                        rs.close();
                    }
                }
            }
            finally {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.wasError = true;
        }
    }

    public void run(String strucTableName) throws SQLException {
        Vector<String> tables = this.dbProp.getStructureTableNames();
        String tableNameWithSchema = TableInfo.getTableNameWithSchema(this.conh.getConnection(), strucTableName);
        boolean found = false;
        for (int i = 0; i < tables.size(); ++i) {
            if (!tableNameWithSchema.equalsIgnoreCase(tables.elementAt(i))) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new SQLException("Table '" + tableNameWithSchema + "' is not found.");
        }
        String[] descriptors = this.dbProp.getMolecularDescriptors(tableNameWithSchema);
        for (int i = 0; i < descriptors.length; ++i) {
            this.run(tableNameWithSchema, descriptors[i]);
        }
        if (this.pw == null || !this.pw.isCanceled()) {
            this.dbProp.setTableProperty(tableNameWithSchema, "mdVersion", Integer.toString(RegenerationChecker.deduceTableVersion(tableNameWithSchema, this.dbProp, 3)));
        }
    }

    public void run() throws SQLException {
        Vector<String> tables = this.dbProp.getStructureTableNames();
        for (int i = 0; i < tables.size(); ++i) {
            this.run(tables.get(i));
        }
    }

    private boolean checkDescriptor(String strucTableName, String descriptor) throws SQLException {
        String[] descriptors = this.dbProp.getMolecularDescriptors(strucTableName);
        boolean descFound = false;
        for (int i = 0; i < descriptors.length; ++i) {
            if (!descriptors[i].equalsIgnoreCase(descriptor)) continue;
            descFound = true;
            break;
        }
        return descFound;
    }
}

