/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.descriptors.MDDBWriter;
import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MDWriterException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.sql.TypeConverter;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class MDTableHandler {
    public static final String MD_PROPERTY_TYPE = "Type";
    public static final String MD_PROPERTY_SETTINGS = "Settings";
    public static final String MD_PROPERTY_COMMENT = "Comment";
    public static final String MD_PROPERTY_UPDATE = "UpdateOnInsert";
    public static final String MD_PROPERTY_CONF_PREFIX = "CONF";
    private final ConnectionHandler conh;
    private final Connection con;
    private final String strucTableName;
    private final DatabaseProperties dbProp;

    public MDTableHandler(ConnectionHandler conh, String strucTableName) throws SQLException {
        this(conh, strucTableName, false);
    }

    public MDTableHandler(ConnectionHandler conh, String tableName, boolean indexTable) throws SQLException {
        this.conh = conh;
        this.con = conh.getConnection();
        this.strucTableName = TableInfo.getTableNameWithSchema(this.con, tableName);
        this.dbProp = new DatabaseProperties(conh, indexTable);
        Vector<String> tableNames = this.dbProp.getStructureTableNames();
        Vector<String> tableNamesWithUpperCase = new Vector<String>();
        for (int k = 0; k < tableNames.size(); ++k) {
            tableNamesWithUpperCase.add(tableNames.elementAt(k).toUpperCase());
        }
        if (!tableNamesWithUpperCase.contains(this.strucTableName.toUpperCase())) {
            throw new SQLException("Error: Table \"" + this.strucTableName + "\" is not " + "defined in property table \"" + conh.getPropertyTable() + "\".");
        }
    }

    public static String getMDTableName(String strucTableName, String descriptorName) {
        return strucTableName + "_MD_" + descriptorName;
    }

    public void createMDTable(String descriptorName, String descType, String descSettings, String descComment) throws SQLException {
        this.createMDTable(descriptorName, descType, descSettings, descComment, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMDTable(String descriptorName, String descType, String descSettings, String descComment, boolean updateOnInsert) throws SQLException {
        String tableName = MDTableHandler.getMDTableName(this.strucTableName, descriptorName);
        DatabaseOptions dbOptions = new DatabaseOptions(this.conh);
        int dbmsType = DatabaseOptions.getDBMSType(this.conh);
        int maxOracleDescNameLength = 26 - TableInfo.getTableNameWithoutSchema(this.strucTableName).length();
        if ((dbmsType == 1 || dbmsType == 10) && descriptorName.length() > maxOracleDescNameLength) {
            throw new IllegalArgumentException("Descriptor name is too long. The maximum allowed length is " + maxOracleDescNameLength + ".");
        }
        String size = "";
        if (dbmsType == 10) {
            throw new IllegalArgumentException("JChem does not support the table creation for Composite databases");
        }
        if (dbmsType == 6) {
            size = "(1M)";
        }
        TypeConverter tc = new TypeConverter(this.con);
        String idType = tc.getLocalTypeByCode(4);
        boolean constraintNeeded = dbOptions.constraintNeededForPrimaryKey;
        String sql = "CREATE ";
        if (dbmsType == 8) {
            sql = sql + "CACHED ";
        }
        sql = sql + " TABLE " + tableName + " ( CD_ID " + idType + " NOT NULL ";
        if (constraintNeeded) {
            sql = sql + "CONSTRAINT Costraint_" + tableName + "_PK ";
        }
        sql = sql + "PRIMARY KEY";
        if (DatabaseOptions.usesForeignKey(dbmsType)) {
            sql = sql + " REFERENCES " + this.strucTableName + "(cd_id)" + " ON DELETE CASCADE";
        }
        sql = sql + ", MD_DATA ";
        sql = dbmsType == 1 ? sql + tc.getLocalTypeByCode(2004) : sql + tc.getLocalTypeByCode(-4) + size;
        sql = sql + " NOT NULL)";
        Statement stmt = this.con.createStatement();
        try {
            stmt.execute(sql);
        }
        finally {
            stmt.close();
        }
        try {
            this.dbProp.setMDTableProperty(this.strucTableName, descriptorName, MD_PROPERTY_SETTINGS, descSettings);
            this.dbProp.setMDTableProperty(this.strucTableName, descriptorName, MD_PROPERTY_TYPE, descType);
            this.dbProp.setMDTableProperty(this.strucTableName, descriptorName, MD_PROPERTY_COMMENT, descComment);
            this.dbProp.setMDTableProperty(this.strucTableName, descriptorName, MD_PROPERTY_UPDATE, Boolean.toString(updateOnInsert));
        }
        catch (SQLException e) {
            try {
                this.deleteMDTable(descriptorName);
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMDTable(String descriptorName) throws SQLException {
        int dbmsType = DatabaseOptions.getDBMSType(this.conh);
        if (dbmsType == 10) {
            throw new IllegalArgumentException("JChem does not support the table creation for Composite databases");
        }
        this.dbProp.deleteMDProperties(this.strucTableName, descriptorName);
        String tableName = MDTableHandler.getMDTableName(this.strucTableName, descriptorName);
        String sql = "DROP TABLE " + tableName;
        Statement stmt = this.conh.getConnection().createStatement();
        try {
            stmt.execute(sql);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMDTableValid(String descriptorName) throws SQLException {
        int strucMax = -1;
        int mdMax = -1;
        String mdTableName = null;
        Statement stmt = this.con.createStatement();
        try {
            String sql = "SELECT MAX(cd_id) FROM " + this.strucTableName;
            ResultSet rs = stmt.executeQuery(sql);
            try {
                if (rs.next()) {
                    strucMax = rs.getInt(1);
                }
                mdTableName = MDTableHandler.getMDTableName(this.strucTableName, descriptorName);
                sql = "SELECT MAX(cd_id) FROM " + mdTableName;
                rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    mdMax = rs.getInt(1);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        if (strucMax == mdMax) {
            return true;
        }
        if (strucMax < mdMax) {
            throw new SQLException("Molecular Descriptor table " + mdTableName + " contains some " + "rows without pair in structure table " + this.strucTableName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMDTableValidByAllIDs(String descriptorName) throws SQLException {
        Statement stmt = this.con.createStatement();
        try {
            String sql = "SELECT cd_id FROM " + this.strucTableName + " ORDER BY cd_id";
            LinkedList<Integer> strucIDs = new LinkedList<Integer>();
            ResultSet rs = stmt.executeQuery(sql);
            try {
                while (rs.next()) {
                    int id = rs.getInt(1);
                    strucIDs.add(id);
                }
            }
            finally {
                rs.close();
            }
            String tableName = MDTableHandler.getMDTableName(this.strucTableName, descriptorName);
            sql = "SELECT cd_id FROM " + tableName;
            rs = stmt.executeQuery(sql);
            try {
                while (rs.next()) {
                    int mdid = rs.getInt(1);
                    boolean found = false;
                    for (int x = 0; x < strucIDs.size(); ++x) {
                        int id = (Integer)strucIDs.get(x);
                        if (id == mdid) {
                            found = true;
                            strucIDs.remove(x);
                            break;
                        }
                        if (id > mdid) break;
                    }
                    if (found) continue;
                    throw new SQLException("Molecular Descriptor table " + tableName + " contains some " + "rows without pair in structure table " + this.strucTableName);
                }
            }
            finally {
                rs.close();
            }
            if (strucIDs.size() > 0) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            stmt.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incRegenerateDescriptorTable(String descriptorName) throws SQLException {
        MDDBWriter writer = new MDDBWriter();
        writer.setConnectionHandler(this.conh);
        writer.setStructureTable(this.strucTableName);
        String[] mdNames = new String[]{descriptorName};
        writer.setMDNames(mdNames);
        List idList = this.getMissingMDRows(this.strucTableName, descriptorName);
        String sql = "SELECT cd_structure FROM " + this.strucTableName + " WHERE cd_id=?";
        PreparedStatement pstmt = this.con.prepareStatement(sql);
        try {
            try {
                for (int x = 0; x < idList.size(); ++x) {
                    int id = (Integer)idList.get(x);
                    pstmt.setInt(1, id);
                    byte[] data = null;
                    ResultSet rs = pstmt.executeQuery();
                    try {
                        if (!rs.next()) {
                            rs.close();
                            continue;
                        }
                        data = DatabaseTools.readBytes(rs, 1);
                    }
                    finally {
                        rs.close();
                    }
                    Molecule mol = null;
                    try {
                        mol = MolImporter.importMol(data);
                    }
                    catch (MolFormatException e) {
                        e.printStackTrace();
                    }
                    writer.put(mol, id);
                }
                writer.close();
            }
            catch (MDWriterException e) {
                e.printStackTrace();
            }
        }
        finally {
            pstmt.close();
        }
    }

    public String[] getMolecularDescriptors() throws SQLException {
        return this.dbProp.getMolecularDescriptors(this.strucTableName);
    }

    public String[] getMDConfigs(String descriptorName) throws SQLException {
        return this.dbProp.getMDConfigs(this.strucTableName, descriptorName);
    }

    public String getMDConfig(String mdName, String configName) throws SQLException {
        return this.dbProp.getMDTableProperty(this.strucTableName, mdName, "CONF." + configName);
    }

    public void setMDConfig(String mdName, String configName, String config) throws SQLException {
        this.dbProp.setMDTableProperty(this.strucTableName, mdName, "CONF." + configName, config);
    }

    public void deleteMDConfig(String mdName, String configName) throws SQLException {
        this.dbProp.deleteMDTableProperty(this.strucTableName, mdName, "CONF." + configName);
    }

    public String getMDSettings(String mdName) throws SQLException {
        return this.dbProp.getMDTableProperty(this.strucTableName, mdName, MD_PROPERTY_SETTINGS);
    }

    public String getMDType(String mdName) throws SQLException {
        return this.dbProp.getMDTableProperty(this.strucTableName, mdName, MD_PROPERTY_TYPE);
    }

    public String getMDComment(String mdName) throws SQLException {
        return this.dbProp.getMDTableProperty(this.strucTableName, mdName, MD_PROPERTY_COMMENT);
    }

    public boolean getMDUpdateOnInsert(String mdName) throws SQLException {
        String prop = this.dbProp.getMDTableProperty(this.strucTableName, mdName, MD_PROPERTY_UPDATE);
        return "true".equalsIgnoreCase(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getMissingMDRows(String strucTableName, String descriptorName) throws SQLException {
        LinkedList<Integer> strucIDs = new LinkedList<Integer>();
        String mdTableName = MDTableHandler.getMDTableName(strucTableName, descriptorName);
        Connection con = this.conh.getConnection();
        Statement stmt = con.createStatement();
        try {
            boolean subSelect = DatabaseOptions.isSubselectSupported(con);
            String sql = null;
            sql = subSelect ? "SELECT cd_id FROM " + strucTableName + " WHERE cd_id NOT IN (SELECT cd_id from " + mdTableName + ")" : "SELECT cd_id FROM " + strucTableName + " ORDER BY cd_id";
            ResultSet rs = stmt.executeQuery(sql);
            try {
                while (rs.next()) {
                    int id = rs.getInt(1);
                    strucIDs.add(id);
                }
            }
            finally {
                rs.close();
            }
            if (subSelect) {
                LinkedList<Integer> id = strucIDs;
                return id;
            }
            sql = "SELECT cd_id FROM " + mdTableName;
            rs = stmt.executeQuery(sql);
            try {
                block11: while (rs.next()) {
                    int mdid = rs.getInt(1);
                    for (int x = 0; x < strucIDs.size(); ++x) {
                        int id = (Integer)strucIDs.get(x);
                        if (id == mdid) {
                            strucIDs.remove(x);
                            continue block11;
                        }
                        if (id > mdid) continue block11;
                    }
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return strucIDs;
    }

    public MDSet createMDSet(String[] mdNames) throws SQLException {
        int descriptorCount = mdNames.length;
        MDSet mdSet = new MDSet(descriptorCount);
        for (int x = 0; x < descriptorCount; ++x) {
            MolecularDescriptor descriptor = this.createMD(mdNames[x]);
            mdSet.setDescriptor(x, descriptor);
        }
        return mdSet;
    }

    public MolecularDescriptor createMD(String mdName) throws SQLException {
        String type = this.getMDType(mdName);
        if (type == null) {
            throw new IllegalArgumentException("The descriptor \"" + mdName + "\" is not defined for " + "table: \"" + this.strucTableName + "\"");
        }
        String settings = this.getMDSettings(mdName);
        MolecularDescriptor descriptor = MolecularDescriptor.newInstance(type);
        descriptor.setParameters(settings);
        return descriptor;
    }

    public String[] getMDTables() throws SQLException {
        String[] descriptors = this.getMolecularDescriptors();
        String[] mdTables = new String[descriptors.length];
        for (int x = 0; x < descriptors.length; ++x) {
            mdTables[x] = MDTableHandler.getMDTableName(this.strucTableName, descriptors[x]);
        }
        return mdTables;
    }
}

