/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.descriptors.GenerateMD;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDSet;
import chemaxon.jchem.file.ProgressWriter;
import chemaxon.util.ConnectionHandler;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

public class MDUtilities {
    private ConnectionHandler conh;
    private String tableName;

    public MDUtilities(ConnectionHandler conh, String tableName) throws MDGeneratorException, SQLException {
        this.conh = conh;
        this.tableName = tableName;
    }

    private GenerateMD getGenerator() throws MDGeneratorException, SQLException {
        GenerateMD generator = new GenerateMD(1);
        generator.setConnectionHandler(this.conh);
        generator.setStructureTableName(this.tableName);
        return generator;
    }

    public GeneratorThread getThreadForAddingDescriptor(String componentType, String descrName, String configFilePath, ProgressWriter pw) throws MDGeneratorException, SQLException {
        String[] compTypes = new String[]{componentType};
        File[] paramFiles = new File[]{new File(configFilePath)};
        MDSet mdSet = MDSet.newInstance(compTypes, paramFiles);
        GenerateMD generator = this.getGenerator();
        generator.setDescriptor(descrName, mdSet.getDescriptor(0).getShortName(), mdSet.getDescriptor(0).getParameters(), "");
        generator.init();
        return new GeneratorThread(generator, pw);
    }

    public void removeDescriptor(String descrName) throws MDGeneratorException, SQLException {
        GenerateMD generator = this.getGenerator();
        generator.deleteMDTable(descrName);
    }

    public void addConfiguration(String descrName, String configName, String configFilePath) throws MDGeneratorException, SQLException, IOException {
        GenerateMD generator = this.getGenerator();
        generator.addMDConfig(descrName, configName, new File(configFilePath));
    }

    public void removeConfiguration(String descrName, String configName) throws MDGeneratorException, SQLException {
        GenerateMD generator = this.getGenerator();
        generator.deleteMDConfig(descrName, configName);
    }

    public class GeneratorThread
    extends Thread {
        public GenerateMD generator;
        public volatile boolean isRunning = false;
        public boolean wasError = false;
        public ProgressWriter pw;

        public GeneratorThread(GenerateMD generator, ProgressWriter pw) {
            this.generator = generator;
            this.pw = pw;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.isRunning = true;
            try {
                this.generator.run();
            }
            catch (MDGeneratorException e) {
                e.printStackTrace();
                this.wasError = true;
                if (this.pw != null) {
                    this.pw.log(0, "Error occured during Molecular Descriptor generation", e);
                }
            }
            finally {
                this.isRunning = false;
            }
        }
    }
}

