/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.common.util.IntVector;
import chemaxon.descriptors.MarkushDescriptor;
import chemaxon.descriptors.MarkushDescriptorParameters;
import chemaxon.jchem.db.CachePool;
import chemaxon.jchem.db.CacheRegistrationUtil;
import chemaxon.jchem.db.CacheType;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.JChemCache;
import chemaxon.jchem.db.JChemObserverImpl;
import chemaxon.jchem.db.MDTableHandler;
import chemaxon.jchem.db.MarkushTableInfo;
import chemaxon.jchem.db.ScreenedQueueHandler;
import chemaxon.jchem.db.TableInfo;
import chemaxon.sss.screen.handler.ScreenHandler;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

abstract class MarkushCacheBase
extends JChemCache {
    protected byte[][] markushData;
    String[] markushDescriptorNames = MarkushTableInfo.getMarkushDescriptorNames();
    String[] markushDescriptorTables;
    MarkushDescriptorParameters[] markushDescriptorParameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarkushCacheBase(ConnectionHandler conh, String tableName, String cacheHashKey, int initialCapacity, boolean indexTable, CachePool cachePool, String timeStamp, JChemObserverImpl jcoImpl) throws SQLException {
        super(conh, tableName, cacheHashKey, TableInfo.getLogTableName(tableName), CacheRegistrationUtil.getCacheID(), initialCapacity, cachePool, timeStamp, indexTable, jcoImpl);
        this.cacheType = CacheType.MARKUSH;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Cache " + tableName + " start gathering Markush descriptor information");
        }
        int descLength = this.markushDescriptorNames.length;
        this.markushDescriptorTables = new String[descLength];
        this.markushDescriptorParameters = new MarkushDescriptorParameters[descLength];
        for (int descIndex = 0; descIndex < descLength; ++descIndex) {
            this.markushDescriptorTables[descIndex] = MDTableHandler.getMDTableName(tableName, this.markushDescriptorNames[descIndex]);
            this.markushDescriptorParameters[descIndex] = new MarkushDescriptorParameters(this.dbProp.getMDTableProperty(tableName, this.markushDescriptorNames[descIndex], "Settings"));
            Statement stmt = null;
            try {
                stmt = this.con.createStatement();
                stmt.execute("SELECT * FROM " + this.markushDescriptorTables[descIndex] + " WHERE 1 = 0");
                continue;
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, e.getMessage());
                }
                this.markushDescriptorTables = new String[0];
                this.markushDescriptorNames = new String[0];
                descLength = 0;
                continue;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Cache " + tableName + " finished gathering Markush descriptor information");
        }
    }

    @Override
    protected final void putScreenedToQueue0(int[] fp, int[] fp_noRing, Molecule query, JChemSearchOptions searchOptions, boolean forFullSearch, IntVector candidates, boolean isIndices, ScreenedQueueHandler sqh, IntVector nonHits) throws DatabaseSearchException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Cache " + this.tableName + " start screening Markush structures");
        }
        if (!searchOptions.isMarkushScreeningEnabled() || searchOptions.getSearchType() == 8 || searchOptions.getSearchType() == 3) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Markush screening disabled");
            }
            this.acceptAllScreenCandidates(candidates, isIndices, sqh, false);
            return;
        }
        this.putMarkushScreenedToQueue(fp, fp_noRing, query, searchOptions, searchOptions.getSearchType() == 6, forFullSearch, candidates, isIndices, sqh, nonHits);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Cache " + this.tableName + " finished screening Markush structures");
            logger.finer("Cache " + this.tableName + " " + sqh.getScreenedCount() + " structures passed the screening process");
        }
    }

    @Override
    public IntVector getBeforeEnumScreened(int[] fp, int[] fpNoRing, byte[] queryDescr, JChemSearchOptions searchOptions, IntVector candidates, boolean isIndices, IntVector nonHits) {
        return null;
    }

    protected abstract void putMarkushScreenedToQueue(int[] var1, int[] var2, Molecule var3, JChemSearchOptions var4, boolean var5, boolean var6, IntVector var7, boolean var8, ScreenedQueueHandler var9, IntVector var10) throws DatabaseSearchException;

    @Override
    public String getStructureString(int index) {
        return "";
    }

    @Override
    public byte[] getStructureStringInBytes(int index) {
        return this.markushData[index];
    }

    @Override
    public ScreenHandler getScreenHandler() {
        return null;
    }

    @Override
    protected void ensureCapacity(int newCapacity) {
        super.ensureCapacity(newCapacity);
        if (this.markushData.length < this.cd_id.length) {
            byte[][] newMarkushData = new byte[this.cd_id.length][];
            System.arraycopy(this.markushData, 0, newMarkushData, 0, this.markushData.length);
            this.markushData = newMarkushData;
        }
    }

    @Override
    protected void resetCache() {
        super.resetCache();
        this.markushData = new byte[this.initialCapacity][];
    }

    protected MarkushDescriptor createMarkushDescriptor(int descIndex) {
        return new MarkushDescriptor(this.markushDescriptorParameters[descIndex]);
    }

    @Override
    protected void swap(int i1, int i2) {
        super.swap(i1, i2);
        byte[] mtmp = this.markushData[i1];
        this.markushData[i1] = this.markushData[i2];
        this.markushData[i2] = mtmp;
    }
}

