/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.common.util.IntVector;
import chemaxon.descriptors.MarkushDescriptor;
import chemaxon.jchem.db.CachePool;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.JChemObserverImpl;
import chemaxon.jchem.db.MarkushFPCacheBase;
import chemaxon.jchem.db.ScreenedQueueHandler;
import chemaxon.sss.screen.DefaultMarkushScreenOptions;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.sss.search.options.HomologyTranslationOption;
import chemaxon.sss.search.options.MarkushScreeningType;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import java.sql.SQLException;
import java.util.logging.Level;

final class MarkushFPObjectCache
extends MarkushFPCacheBase {
    private MarkushDescriptor[][] markushDescriptors;

    public MarkushFPObjectCache(ConnectionHandler conh, String tableName, String cacheHashKey, int columnsToCache, int initialCapacity, boolean indexTable, CachePool cachePool, String timeStamp, JChemObserverImpl jcoImpl) throws SQLException, DatabaseSearchException {
        super(conh, tableName, cacheHashKey, columnsToCache, initialCapacity, indexTable, cachePool, timeStamp, jcoImpl);
        this.resetCache();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("\nMarkush(fingerprint, raw data) cache created.\n** Cache ID: " + this.cacheID + "\n** Table name: " + tableName + "\n** Logtable name: " + this.logTableName + "\n** Cache hash key: " + cacheHashKey);
        }
    }

    @Override
    protected void putMarkushScreenedToQueue(int[] fp, int[] fp_noRing, Molecule query, JChemSearchOptions searchOptions, IntVector candidates, boolean isIndices, ScreenedQueueHandler sqh, IntVector nonHits) throws DatabaseSearchException {
        int descLength = this.markushDescriptorNames.length;
        MarkushDescriptor[] queryDesc = new MarkushDescriptor[descLength];
        for (int descIndex = 0; descIndex < descLength; ++descIndex) {
            try {
                queryDesc[descIndex] = this.createMarkushDescriptor(descIndex);
                DefaultMarkushScreenOptions screenOptions = new DefaultMarkushScreenOptions(searchOptions);
                queryDesc[descIndex].generateQueryDescriptor(query, screenOptions);
                continue;
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("Error in first phase of Markush screening: " + e.getMessage());
                }
                this.acceptAllScreenCandidates(candidates, true, sqh, false);
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("Markush screening finished");
                }
                throw new DatabaseSearchException(e);
            }
        }
        boolean notScreenedIsNeeded = nonHits != null;
        boolean useFingerprints = searchOptions.getHomologyBroadTranslation() == HomologyTranslationOption.NONE && searchOptions.getHomologyNarrowTranslation() == HomologyTranslationOption.NONE;
        useFingerprints &= searchOptions.getMarkushScreeningType(MarkushScreeningType.FINGERPRINT);
        boolean useAtomstat = searchOptions.getMarkushScreeningType(MarkushScreeningType.ATOMSTAT);
        int size = candidates.size();
        for (int i = 0; i < size; ++i) {
            int index = this.getIndex(candidates.get(i), isIndices);
            boolean match = true;
            if (useFingerprints) {
                match = this.acceptMarkushTarget(index, fp, fp_noRing, searchOptions.getSearchType() == 6);
            }
            if (useAtomstat) {
                for (int descIndex = 0; descIndex < descLength && match; ++descIndex) {
                    if (this.markushDescriptors[index][descIndex] == null) continue;
                    match = queryDesc[descIndex].acceptTarget(this.markushDescriptors[index][descIndex]);
                }
            }
            if (!match) {
                if (!notScreenedIsNeeded) continue;
                nonHits.addElement(this.cd_id[index]);
                continue;
            }
            sqh.put(this.cd_id[index], index, false);
        }
    }

    @Override
    protected boolean addStructure(int cd_id, int[] intFP, boolean noRingsInFP, byte[] markushData, byte[][] markushDescriptorData) {
        if (this.itemCount % 2000 == 0 && !this.cachePool.freeMemoryIfNecessary(this)) {
            return false;
        }
        this.ensureCapacity(this.itemCount + 1);
        this.cd_id[this.itemCount] = cd_id;
        this.noRingInfoInFP.set(this.itemCount, noRingsInFP);
        this.addData(intFP);
        this.blockIndex[this.itemCount] = this.block;
        this.positionInBlock[this.itemCount] = (short)(this.pos - this.fpColumnCount);
        this.markushData[this.itemCount] = markushData;
        int descLength = markushDescriptorData.length;
        MarkushDescriptor[] markushDescriptors = new MarkushDescriptor[descLength];
        for (int descIndex = 0; descIndex < descLength; ++descIndex) {
            if (markushDescriptorData[descIndex] != null) {
                markushDescriptors[descIndex] = this.createMarkushDescriptor(descIndex);
                markushDescriptors[descIndex].fromData(markushDescriptorData[descIndex]);
                continue;
            }
            markushDescriptors[descIndex] = null;
        }
        this.markushDescriptors[this.itemCount] = markushDescriptors;
        ++this.itemCount;
        return true;
    }

    @Override
    protected void ensureCapacity(int newCapacity) {
        super.ensureCapacity(newCapacity);
        if (this.markushDescriptors.length < this.cd_id.length) {
            MarkushDescriptor[][] newMarkushDescriptors = new MarkushDescriptor[this.cd_id.length][];
            System.arraycopy(this.markushDescriptors, 0, newMarkushDescriptors, 0, this.markushDescriptors.length);
            this.markushDescriptors = newMarkushDescriptors;
        }
    }

    @Override
    protected void resetCache() {
        super.resetCache();
        this.markushDescriptors = new MarkushDescriptor[this.initialCapacity][];
    }

    @Override
    public long getSize() {
        long result = 0L;
        if (this.data != null) {
            result += (long)this.data.length * 4L + 16L;
            result += (long)this.data.length * 32768L * 4L + 16L;
        }
        if (this.cd_id != null) {
            result += (long)this.cd_id.length * 4L + 16L;
        }
        if (this.noRingInfoInFP != null) {
            result += (long)(this.noRingInfoInFP.size() / 8 + 8);
        }
        if (this.blockIndex != null) {
            result += (long)this.blockIndex.length * 4L + 16L;
        }
        if (this.positionInBlock != null) {
            result += (long)this.positionInBlock.length * 2L + 16L;
        }
        if (this.markushData != null) {
            result += (long)this.markushData.length * 4L + 16L;
            for (int x = 0; x < this.markushData.length; ++x) {
                byte[] markush = this.markushData[x];
                if (markush == null) continue;
                result += (long)(markush.length + 16);
            }
        }
        if (this.markushDescriptors != null) {
            result += (long)this.markushDescriptors.length * 4L + 16L;
            for (int i = 0; i < this.itemCount; ++i) {
                result += (long)(this.markushDescriptors[i].length * 4 + 16);
                for (int j = 0; j < this.markushDescriptors[i].length; ++j) {
                    if (this.markushDescriptors[i][j] == null) continue;
                    result += (long)(this.markushDescriptors[i][j].getDataSize() + 100);
                }
            }
        }
        return result;
    }

    @Override
    protected void swap(int i1, int i2) {
        super.swap(i1, i2);
        MarkushDescriptor[] dtmp = this.markushDescriptors[i1];
        this.markushDescriptors[i1] = this.markushDescriptors[i2];
        this.markushDescriptors[i2] = dtmp;
    }
}

