/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.common.util.IntVector;
import chemaxon.jchem.db.CachePool;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.JChemObserverImpl;
import chemaxon.jchem.db.MarkushCacheBase;
import chemaxon.jchem.db.ScreenedQueueHandler;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.sss.search.options.MarkushScreeningType;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;

abstract class MarkushNoFPCacheBase
extends MarkushCacheBase {
    public MarkushNoFPCacheBase(ConnectionHandler conh, String tableName, String cacheHashKey, int initialCapacity, boolean indexTable, CachePool cachePool, String timeStamp, JChemObserverImpl jcoImpl) throws SQLException {
        super(conh, tableName, cacheHashKey, initialCapacity, indexTable, cachePool, timeStamp, jcoImpl);
    }

    @Override
    protected String getSQLSelectionString() {
        int i;
        StringBuffer sb = new StringBuffer("SELECT ");
        sb.append("a.");
        sb.append("cd_id");
        int descLength = this.markushDescriptorTables.length;
        sb.append(",");
        sb.append(" a.");
        sb.append("cd_markush");
        for (i = 0; i < descLength; ++i) {
            sb.append(", a" + i + "." + "md_data");
        }
        sb.append(" FROM ");
        for (i = 0; i < descLength; ++i) {
            sb.append("(");
        }
        sb.append(this.tableName);
        sb.append(" a");
        for (i = 0; i < descLength; ++i) {
            sb.append(" LEFT OUTER JOIN ");
            sb.append(this.markushDescriptorTables[i]);
            sb.append(" a" + i);
            sb.append(" ON a.cd_id = a" + i);
            sb.append(".cd_id");
            sb.append(")");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("SQL selection string: " + sb.toString());
        }
        return sb.toString();
    }

    @Override
    public final void putMarkushScreenedToQueue(int[] fp, int[] fp_noRing, Molecule query, JChemSearchOptions searchOptions, boolean isSuperstructure, boolean isFullSearch, IntVector candidates, boolean isIndices, ScreenedQueueHandler sqh, IntVector nonHits) throws DatabaseSearchException {
        if (searchOptions.getMarkushScreeningType(MarkushScreeningType.ATOMSTAT)) {
            this.putMarkushScreenedToQueue(query, searchOptions, candidates, isIndices, nonHits, sqh);
        } else {
            this.acceptAllScreenCandidates(candidates, isIndices, sqh, false);
        }
    }

    @Override
    protected boolean processResultSet(ResultSet rs) {
        int columnIndex = 1;
        int cd_id = -1;
        try {
            cd_id = rs.getInt(columnIndex++);
            byte[] markushData = DatabaseTools.readBytes(rs, columnIndex++);
            byte[][] markushDescriptorData = new byte[this.markushDescriptorTables.length][];
            for (int i = 0; i < this.markushDescriptorTables.length; ++i) {
                markushDescriptorData[i] = rs.getBytes(columnIndex++);
            }
            return this.addStructure(cd_id, markushData, markushDescriptorData);
        }
        catch (Exception e) {
            if (cd_id != -1) {
                this.fails.put(cd_id, e);
            }
            return true;
        }
    }

    @Override
    public void getSimilarityDescriptor(int index, int[] fp) {
        throw new UnsupportedOperationException("Current Markush cache implementation does not contain similarity descriptor data");
    }

    @Override
    public void getSimilarityDescritporInBytes(int index, byte[] fp) {
        throw new UnsupportedOperationException("Current Markush cache implementation does not contain similarity descriptor data");
    }

    @Override
    public int getFPColumnCount() {
        return 0;
    }

    protected abstract boolean addStructure(int var1, byte[] var2, byte[][] var3) throws SQLException;

    protected abstract void putMarkushScreenedToQueue(Molecule var1, JChemSearchOptions var2, IntVector var3, boolean var4, IntVector var5, ScreenedQueueHandler var6) throws DatabaseSearchException;
}

