/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.common.util.IntVector;
import chemaxon.descriptors.MarkushDescriptor;
import chemaxon.jchem.db.CachePool;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.JChemObserverImpl;
import chemaxon.jchem.db.MarkushNoFPCacheBase;
import chemaxon.jchem.db.ScreenedQueueHandler;
import chemaxon.sss.screen.DefaultMarkushScreenOptions;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import java.sql.SQLException;
import java.util.logging.Level;

final class MarkushNoFPDataCache
extends MarkushNoFPCacheBase {
    private byte[][][] markushDescriptorData;

    public MarkushNoFPDataCache(ConnectionHandler conh, String tableName, String cacheHashKey, int initialCapacity, boolean indexTable, CachePool cachePool, String timeStamp, JChemObserverImpl jcoImpl) throws SQLException {
        super(conh, tableName, cacheHashKey, initialCapacity, indexTable, cachePool, timeStamp, jcoImpl);
        this.resetCache();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("\nMarkush(no fingerprint, raw data) cache created.\n** Cache ID: " + this.cacheID + "\n** Table name: " + tableName + "\n** Logtable name: " + this.logTableName + "\n** Cache hash key: " + cacheHashKey);
        }
    }

    @Override
    protected void ensureCapacity(int newCapacity) {
        super.ensureCapacity(newCapacity);
        if (this.markushDescriptorData.length < this.cd_id.length) {
            byte[][][] newMarkushDescriptorData = new byte[this.cd_id.length][][];
            System.arraycopy(this.markushDescriptorData, 0, newMarkushDescriptorData, 0, this.markushDescriptorData.length);
            this.markushDescriptorData = newMarkushDescriptorData;
        }
    }

    @Override
    protected boolean addStructure(int cd_id, byte[] markushData, byte[][] markushDescriptorData) {
        if (this.itemCount % 2000 == 0 && !this.cachePool.freeMemoryIfNecessary(this)) {
            return false;
        }
        this.ensureCapacity(this.itemCount + 1);
        this.cd_id[this.itemCount] = cd_id;
        this.markushData[this.itemCount] = markushData;
        this.markushDescriptorData[this.itemCount] = markushDescriptorData;
        ++this.itemCount;
        return true;
    }

    @Override
    public final void putMarkushScreenedToQueue(Molecule query, JChemSearchOptions searchOptions, IntVector candidates, boolean isIndices, IntVector nonHits, ScreenedQueueHandler sqh) throws DatabaseSearchException {
        int descLength = this.markushDescriptorNames.length;
        MarkushDescriptor[] queryDesc = new MarkushDescriptor[descLength];
        for (int descIndex = 0; descIndex < descLength; ++descIndex) {
            try {
                queryDesc[descIndex] = this.createMarkushDescriptor(descIndex);
                DefaultMarkushScreenOptions screenOptions = new DefaultMarkushScreenOptions(searchOptions);
                queryDesc[descIndex].generateQueryDescriptor(query, screenOptions);
                continue;
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("Error in first phase of Markush screening: " + e.getMessage());
                }
                this.acceptAllScreenCandidates(candidates, isIndices, sqh, false);
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("Markush screening finished");
                }
                throw new DatabaseSearchException(e);
            }
        }
        boolean notScreenedIsNeeded = nonHits != null;
        MarkushDescriptor[] targetDescriptors = new MarkushDescriptor[descLength];
        for (int descIndex = 0; descIndex < descLength; ++descIndex) {
            try {
                targetDescriptors[descIndex] = this.createMarkushDescriptor(descIndex);
                continue;
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Error while creating " + this.markushDescriptorNames[descIndex] + "markush descriptor for target: " + e.getMessage());
                }
                this.acceptAllScreenCandidates(candidates, isIndices, sqh, false);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Markush screening finished");
                }
                return;
            }
        }
        int size = candidates.size();
        for (int i = 0; i < size; ++i) {
            int index = this.getIndex(candidates.get(i), isIndices);
            if (index == -1) continue;
            boolean match = true;
            for (int descIndex = 0; descIndex < descLength && match; ++descIndex) {
                if (this.markushDescriptorData[index][descIndex] == null) continue;
                targetDescriptors[descIndex].fromData(this.markushDescriptorData[index][descIndex]);
                match = queryDesc[descIndex].acceptTarget(targetDescriptors[descIndex]);
            }
            if (!match) {
                if (!notScreenedIsNeeded) continue;
                nonHits.addElement(this.cd_id[index]);
                continue;
            }
            sqh.put(this.cd_id[index], index, false);
        }
    }

    @Override
    protected void resetCache() {
        super.resetCache();
        this.markushDescriptorData = new byte[this.initialCapacity][][];
    }

    @Override
    public long getSize() {
        long result = 0L;
        if (this.cd_id != null) {
            result += (long)this.cd_id.length * 4L + 16L;
        }
        if (this.markushData != null) {
            result += (long)this.markushData.length * 4L + 16L;
            for (int x = 0; x < this.markushData.length; ++x) {
                byte[] markush = this.markushData[x];
                if (markush == null) continue;
                result += (long)(markush.length + 16);
            }
        }
        if (this.markushDescriptorData != null) {
            result += (long)this.markushDescriptorData.length * 4L + 16L;
            for (int i = 0; i < this.itemCount; ++i) {
                result += (long)(this.markushDescriptorData[i].length * 4 + 16);
                for (int j = 0; j < this.markushDescriptorData[i].length; ++j) {
                    if (this.markushDescriptorData[i][j] == null) continue;
                    result += (long)(this.markushDescriptorData[i][j].length + 16);
                }
            }
        }
        return result;
    }

    @Override
    protected void swap(int i1, int i2) {
        super.swap(i1, i2);
        byte[][] dtmp = this.markushDescriptorData[i1];
        this.markushDescriptorData[i1] = this.markushDescriptorData[i2];
        this.markushDescriptorData[i2] = dtmp;
    }
}

