/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.descriptors.MarkushDescriptor;
import chemaxon.descriptors.MarkushDescriptorParameters;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.jchem.db.MDTableHandler;
import chemaxon.util.ConnectionHandler;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MarkushTableInfo {
    private static final Log log;
    private static final MDTableInfo[] MARKUSH_DESCRIPTOR_TABLES;

    public static String[] getMarkushDescriptorNames() {
        String[] names = new String[MARKUSH_DESCRIPTOR_TABLES.length];
        int i = 0;
        for (MDTableInfo info : MARKUSH_DESCRIPTOR_TABLES) {
            names[i++] = info.name;
        }
        return names;
    }

    private static boolean compareStrings(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }

    private static boolean checkDescriptorConfig(MDTableInfo mdti, MDTableHandler tableHandler) throws SQLException {
        return MarkushTableInfo.compareStrings(mdti.getTypeAsString(), tableHandler.getMDType(mdti.name)) && MarkushTableInfo.compareStrings(mdti.settings, tableHandler.getMDSettings(mdti.name));
    }

    static boolean checkMarkushDescriptorTables(ConnectionHandler ch, String tableName) throws SQLException {
        MDTableHandler tableHandler = new MDTableHandler(ch, tableName);
        for (MDTableInfo ti : MARKUSH_DESCRIPTOR_TABLES) {
            if (tableHandler.getMDType(ti.name) == null) {
                return false;
            }
            if (MarkushTableInfo.checkDescriptorConfig(ti, tableHandler)) continue;
            return false;
        }
        return true;
    }

    static void upgradeMarkushDescriptorTables(ConnectionHandler ch, String tableName) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Upgrading internal markush descriptor tables of \"" + tableName + "\""));
        }
        MDTableHandler tableHandler = new MDTableHandler(ch, tableName);
        for (MDTableInfo ti : MARKUSH_DESCRIPTOR_TABLES) {
            if (tableHandler.getMDType(ti.name) != null) {
                if (MarkushTableInfo.checkDescriptorConfig(ti, tableHandler)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Descriptor table \"" + ti.name + "\" of type \"" + ti.type + "\" already exists and need not be upgraded"));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Descriptor table \"" + ti.name + "\" already exists, " + "but it should be upgraded"));
                    log.debug((Object)("Deleting descriptor table \"" + ti.name + "\""));
                }
                tableHandler.deleteMDTable(ti.name);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating descriptor table \"" + ti.name + "\" " + "of type \"" + ti.type + "\" " + "with comment \"" + ti.comment + "\""));
            }
            tableHandler.createMDTable(ti.name, ti.getTypeAsString(), ti.settings, ti.comment, true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Generating descriptors to table \"" + ti.name + "\""));
            }
            tableHandler.incRegenerateDescriptorTable(ti.name);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Internal markush descriptor tables of \"" + tableName + "\" " + "have been upgraded successfully"));
        }
    }

    static {
        ServiceLoader<RetrieveMDTableInfo> loader;
        Iterator<RetrieveMDTableInfo> it;
        log = LogFactory.getLog(MarkushTableInfo.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill MARKUSH_DESCRIPTOR_TABLES; load service: " + RetrieveMDTableInfo.class.getName()));
        }
        if (!(it = (loader = ServiceLoader.load(RetrieveMDTableInfo.class)).iterator()).hasNext() || it == null) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)"No service found to load markush descriptor tables info.");
            }
            throw new ServiceConfigurationError("No implementation found for " + RetrieveMDTableInfo.class.getName());
        }
        RetrieveMDTableInfo service = it.next();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service found: " + service.getClass().getName()));
        }
        if ((MARKUSH_DESCRIPTOR_TABLES = service.getMDTableInfoArray()) == null) {
            throw new ServiceConfigurationError("Table info is null");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Tables:");
            for (MDTableInfo i : MARKUSH_DESCRIPTOR_TABLES) {
                log.trace((Object)("Table " + i + ":"));
                log.trace((Object)i.toString());
            }
        }
    }

    public static final class DefaultConfigSingleTable
    implements RetrieveMDTableInfo {
        @Override
        public MDTableInfo[] getMDTableInfoArray() throws ServiceConfigurationError {
            return new MDTableInfo[]{new MDTableInfo("MSCR", MarkushDescriptor.class, new MarkushDescriptorParameters().getDefaultDocumentFrame(), "Internal markush descriptor table")};
        }
    }

    static interface RetrieveMDTableInfo {
        public MDTableInfo[] getMDTableInfoArray() throws ServiceConfigurationError;
    }

    protected static class MDTableInfo {
        public final String name;
        public final Class<? extends MolecularDescriptor> type;
        public final String settings;
        public final String comment;

        public MDTableInfo(String name, Class<? extends MolecularDescriptor> type, String settings, String comment) {
            this.name = name.toUpperCase();
            this.type = type;
            this.settings = settings;
            this.comment = comment;
        }

        public String getTypeAsString() {
            return this.type.getName();
        }

        public String toString() {
            return "MDTableInfo { name: " + this.name + " type: " + this.type.getName() + " comment: " + this.comment + " settings: " + this.settings + " }";
        }
    }
}

